/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbPackageName;
import com.intellij.protobuf.lang.psi.PbSimpleField;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PbSymbolLookupElement
extends LookupElement {
    private final PbSymbol symbol;
    private final String name;
    private final Icon icon;
    private JBColor highlightColor = null;

    public PbSymbolLookupElement(PbSymbol symbol) {
        this(symbol, symbol.getName(), symbol.getIcon(0));
    }

    private PbSymbolLookupElement(PbSymbol symbol, String name, Icon icon) {
        this.symbol = symbol;
        this.name = name;
        this.icon = icon;
    }

    public static PbSymbolLookupElement forGroupDefinitionAsField(PbGroupDefinition group, OptionOccurrenceTracker.Occurrence occurrence) {
        PbSymbolLookupElement element = new PbSymbolLookupElement(group);
        PbSimpleField generatedField = group.getGeneratedField();
        if (generatedField != null && occurrence != null && !occurrence.canFieldBeUsed(generatedField)) {
            element.setRedHighlight();
        }
        return element;
    }

    public static PbSymbolLookupElement withUnusableFieldHighlight(PbSymbol symbol, OptionOccurrenceTracker.Occurrence occurrence) {
        PbSymbolLookupElement element = new PbSymbolLookupElement(symbol);
        if (symbol instanceof PbField && occurrence != null && !occurrence.canFieldBeUsed((PbField)symbol)) {
            element.setRedHighlight();
        }
        return element;
    }

    public static PbSymbolLookupElement withUnmergeableFieldHighlight(PbSymbol symbol, OptionOccurrenceTracker.Occurrence occurrence) {
        PbSymbolLookupElement element = new PbSymbolLookupElement(symbol);
        if (symbol instanceof PbField && occurrence != null && !occurrence.canFieldBeUsedOrMerged((PbField)symbol)) {
            element.setRedHighlight();
        }
        return element;
    }

    private void setRedHighlight() {
        this.highlightColor = JBColor.RED;
    }

    @NotNull
    public String getLookupString() {
        Object object = this.symbol instanceof PbPackageName ? this.name + "." : this.name;
        if (object == null) {
            PbSymbolLookupElement.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    public Object getObject() {
        PbSymbol pbSymbol = this.symbol;
        if (pbSymbol == null) {
            PbSymbolLookupElement.$$$reportNull$$$0(1);
        }
        return pbSymbol;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PbSymbolLookupElement)) {
            return false;
        }
        PbSymbolLookupElement otherSymbol = (PbSymbolLookupElement)((Object)other);
        return Objects.equals(this.name, otherSymbol.name) && Objects.equals(this.icon, otherSymbol.icon);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.icon);
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        String typeText;
        if (presentation == null) {
            PbSymbolLookupElement.$$$reportNull$$$0(2);
        }
        presentation.setItemText(this.name);
        presentation.setIcon(this.icon);
        if (this.symbol instanceof PbField && (typeText = PbSymbolLookupElement.getTypeTextForField((PbField)this.symbol)) != null) {
            presentation.setTypeText(typeText);
        }
        if (this.highlightColor != null) {
            presentation.setItemTextForeground((Color)this.highlightColor);
        }
    }

    public void handleInsert(@NotNull InsertionContext insertionContext) {
        if (insertionContext == null) {
            PbSymbolLookupElement.$$$reportNull$$$0(3);
        }
        if (this.symbol instanceof PbPackageName) {
            AutoPopupController.getInstance((Project)insertionContext.getProject()).scheduleAutoPopup(insertionContext.getEditor());
        }
    }

    private static String getTypeTextForField(PbField field) {
        if (field instanceof PbMapField) {
            PbMapField mapField = (PbMapField)field;
            PbTypeName keyType = mapField.getKeyType();
            PbTypeName valueType = mapField.getValueType();
            if (keyType != null && valueType != null) {
                return String.format("map<%s, %s>", keyType.getShortName(), valueType.getShortName());
            }
            return "map<>";
        }
        PbTypeName typeName = field.getTypeName();
        if (typeName != null) {
            return typeName.getShortName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/PbSymbolLookupElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/PbSymbolLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

