/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.PbCompositeModificationTracker;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbStatementOwner;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolContributor;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PbPsiImplUtil {
    @Nullable
    public static PbStatementOwner getStatementOwner(PbStatement element) {
        return (PbStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PbStatementOwner.class);
    }

    @Nullable
    public static PbSymbolOwner getSymbolOwner(PsiElement element) {
        return PbPsiUtil.getSymbolOwner(element);
    }

    @Nullable
    public static PbOptionOwner getOptionOwner(PsiElement element) {
        return (PbOptionOwner)PsiTreeUtil.getContextOfType((PsiElement)element, PbOptionOwner.class, (boolean)true);
    }

    @NotNull
    public static List<PbStatement> getStatements(PbElement parent) {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parent, PbStatement.class);
        if (list == null) {
            PbPsiImplUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static QualifiedName getQualifiedName(PbSymbol element) {
        return (QualifiedName)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)PbPsiImplUtil.calculateQualifiedName(element), (Object[])new Object[]{PbCompositeModificationTracker.byElement(element)}));
    }

    @Nullable
    private static QualifiedName calculateQualifiedName(PbSymbol element) {
        String name = element.getName();
        if (name == null) {
            return null;
        }
        PbSymbolOwner parent = element.getSymbolOwner();
        if (parent == null) {
            return null;
        }
        QualifiedName scope = parent.getChildScope();
        if (scope == null) {
            return null;
        }
        return scope.append(name);
    }

    @NotNull
    public static TextRange getTextRangeNoQuotes(PsiElement element) {
        TextRange range = element.getTextRange();
        String text = element.getText();
        if (!text.startsWith("\"") && !text.startsWith("'")) {
            TextRange textRange = range;
            if (textRange == null) {
                PbPsiImplUtil.$$$reportNull$$$0(1);
            }
            return textRange;
        }
        char endQuote = text.charAt(0);
        int endOffset = text.charAt(text.length() - 1) == endQuote ? 1 : 0;
        int start = range.getStartOffset() + 1;
        int end = range.getEndOffset() - endOffset;
        if (end < start) {
            end = start;
        }
        TextRange textRange = TextRange.create((int)start, (int)end);
        if (textRange == null) {
            PbPsiImplUtil.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public static Map<String, Collection<PbSymbol>> getCachedSymbolMap(PbStatementOwner owner) {
        return ((ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create(PbPsiImplUtil.computeSymbolMap(owner, PbSymbol.class), (Object[])new Object[]{PbCompositeModificationTracker.byElement(owner)}))).asMap();
    }

    public static ImmutableMultimap<String, PbEnumValue> getCachedEnumValueMap(PbStatementOwner owner) {
        return (ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create(PbPsiImplUtil.computeSymbolMap(owner, PbEnumValue.class), (Object[])new Object[]{PbCompositeModificationTracker.byElement(owner)}));
    }

    private static <T extends PbSymbol> ImmutableMultimap<String, T> computeSymbolMap(PbStatementOwner owner, Class<T> typeClass) {
        List<PbStatement> statements = owner.getStatements();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PbStatement statement : statements) {
            PbSymbol symbol;
            String name;
            if (typeClass.isInstance(statement) && (name = (symbol = (PbSymbol)typeClass.cast(statement)).getName()) != null) {
                builder.put((Object)name, (Object)symbol);
            }
            if (statement instanceof PbSymbolContributor) {
                PbSymbolContributor contributor = (PbSymbolContributor)((Object)statement);
                for (PbSymbol sibling : contributor.getAdditionalSiblings()) {
                    String name2;
                    if (!typeClass.isInstance(sibling) || (name2 = sibling.getName()) == null) continue;
                    builder.put((Object)name2, (Object)((PbSymbol)typeClass.cast(sibling)));
                }
            }
            if (!(statement instanceof PbStatementOwner) || statement instanceof PbSymbolOwner) continue;
            builder.putAll(PbPsiImplUtil.computeSymbolMap((PbStatementOwner)((Object)statement), typeClass));
        }
        return builder.build();
    }

    private PbPsiImplUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/lang/psi/util/PbPsiImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRangeNoQuotes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

