/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.protobuf.lang.psi.PbNamedElement;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.impl.PbStatementBase;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PbNamedElementBase
extends PbStatementBase
implements PbNamedElement {
    PbNamedElementBase(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public QualifiedName getQualifiedName() {
        return PbPsiImplUtil.getQualifiedName(this);
    }

    @Override
    @Nullable
    public PbSymbolOwner getSymbolOwner() {
        return PbPsiImplUtil.getSymbolOwner(this);
    }

    @Nullable
    public String getName() {
        PsiElement name = this.getNameIdentifier();
        if (name != null) {
            return name.getText();
        }
        return super.getName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement identifier;
        if (name == null) {
            PbNamedElementBase.$$$reportNull$$$0(0);
        }
        if ((identifier = this.getNameIdentifier()) == null) {
            throw new IncorrectOperationException();
        }
        ASTNode node = identifier.getNode();
        if (node instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(name);
            return this;
        }
        throw new IncorrectOperationException();
    }

    public int getTextOffset() {
        PsiElement name = this.getNameIdentifier();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        final PbNamedElementBase element = this;
        return new ItemPresentation(){

            public String getPresentableText() {
                return element.getPresentableText();
            }

            @Nullable
            public String getLocationString() {
                QualifiedName qualifiedName;
                PbSymbolOwner owner = PbNamedElementBase.this.getSymbolOwner();
                if (owner != null && (qualifiedName = owner.getChildScope()) != null) {
                    return qualifiedName.toString();
                }
                return null;
            }

            public Icon getIcon(boolean unused) {
                return element.getIcon(0);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/protobuf/lang/psi/impl/PbNamedElementBase", "setName"));
    }
}

