/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.gutter;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.ide.gutter.PbCodeImplementationSearcher;
import com.intellij.protobuf.ide.gutter.PbGeneratedCodeConverter;
import com.intellij.protobuf.jvm.PbJavaFindUsagesHandlerFactory;
import com.intellij.protobuf.jvm.PbJavaGotoDeclarationHandler;
import com.intellij.protobuf.jvm.gutter.PbJavaImplementationSearcher$handleMessageImplementations$;
import com.intellij.protobuf.jvm.gutter.PbJavaImplementationSearcher$handleModel$;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbServiceDefinition;
import com.intellij.protobuf.lang.psi.PbServiceMethod;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.stub.PbSearchParameters;
import com.intellij.protobuf.lang.stub.ProtoFileAccessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\r\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\r\u001a\u00020\u0006H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00052\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00052\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J \u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001e\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006("}, d2={"Lcom/intellij/protobuf/jvm/gutter/PbJavaImplementationSearcher;", "Lcom/intellij/protobuf/ide/gutter/PbCodeImplementationSearcher;", "<init>", "()V", "findImplementationsForProtoElement", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiElement;", "pbElement", "Lcom/intellij/protobuf/lang/psi/PbElement;", "converters", "", "Lcom/intellij/protobuf/ide/gutter/PbGeneratedCodeConverter;", "findDeclarationsForCodeElement", "psiElement", "handleServiceImplementations", "Lcom/intellij/psi/PsiClass;", "serviceDefinition", "Lcom/intellij/protobuf/lang/psi/PbServiceDefinition;", "handleMethodImplementations", "Lcom/intellij/psi/PsiMethod;", "methodDefinition", "Lcom/intellij/protobuf/lang/psi/PbServiceMethod;", "handleMessageImplementations", "messageDefinition", "Lcom/intellij/protobuf/lang/psi/PbMessageDefinition;", "handleModel", "handleService", "psiClass", "handleMethod", "psiMethod", "effectiveServiceFqn", "", "protoNamesForClass", "protoNamesForMethod", "generatedBaseClass", "findGeneratedServiceSuperclass", "classWithSuitableSuperSearcher", "Lcom/intellij/util/CommonProcessors$FindFirstProcessor;", "hasServiceSuperclass", "", "intellij.protoeditor.jvm"})
@SourceDebugExtension(value={"SMAP\nPbJavaImplementationSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbJavaImplementationSearcher.kt\ncom/intellij/protobuf/jvm/gutter/PbJavaImplementationSearcher\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n66#2,2:148\n66#2,2:150\n477#3:152\n477#3:153\n30#4,2:154\n30#4,2:156\n19#5:158\n295#6,2:159\n1563#6:161\n1634#6,3:162\n1761#6,3:165\n*S KotlinDebug\n*F\n+ 1 PbJavaImplementationSearcher.kt\ncom/intellij/protobuf/jvm/gutter/PbJavaImplementationSearcher\n*L\n57#1:148,2\n65#1:150,2\n68#1:152\n75#1:153\n80#1:154,2\n89#1:156,2\n94#1:158\n96#1:159,2\n141#1:161\n141#1:162,3\n143#1:165,3\n*E\n"})
public final class PbJavaImplementationSearcher
implements PbCodeImplementationSearcher {
    @Override
    @NotNull
    public Sequence<PsiElement> findImplementationsForProtoElement(@NotNull PbElement pbElement, @NotNull Collection<? extends PbGeneratedCodeConverter> converters) {
        Intrinsics.checkNotNullParameter((Object)pbElement, (String)"pbElement");
        Intrinsics.checkNotNullParameter(converters, (String)"converters");
        PbElement pbElement2 = pbElement;
        return pbElement2 instanceof PbServiceDefinition ? this.handleServiceImplementations((PbServiceDefinition)pbElement, converters) : (pbElement2 instanceof PbServiceMethod ? this.handleMethodImplementations((PbServiceMethod)pbElement, converters) : (pbElement2 instanceof PbMessageDefinition ? this.handleMessageImplementations((PbMessageDefinition)pbElement) : SequencesKt.emptySequence()));
    }

    @Override
    @NotNull
    public Sequence<PbElement> findDeclarationsForCodeElement(@NotNull PsiElement psiElement, @NotNull Collection<? extends PbGeneratedCodeConverter> converters) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(converters, (String)"converters");
        return psiElement instanceof PsiClass && this.hasServiceSuperclass((PsiClass)psiElement, converters) ? this.handleService((PsiClass)psiElement, converters) : (psiElement instanceof PsiClass ? this.handleModel(psiElement) : (psiElement instanceof PsiMethod ? this.handleMethod((PsiMethod)psiElement, converters) : SequencesKt.emptySequence()));
    }

    private final Sequence<PsiClass> handleServiceImplementations(PbServiceDefinition serviceDefinition, Collection<? extends PbGeneratedCodeConverter> converters) {
        String string = this.effectiveServiceFqn(serviceDefinition);
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String serviceFqn = string;
        Project project = serviceDefinition.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)converters), arg_0 -> PbJavaImplementationSearcher.handleServiceImplementations$lambda$0(serviceFqn, arg_0)), arg_0 -> PbJavaImplementationSearcher.handleServiceImplementations$lambda$1(project2, arg_0)), PbJavaImplementationSearcher::handleServiceImplementations$lambda$2);
    }

    private final Sequence<PsiMethod> handleMethodImplementations(PbServiceMethod methodDefinition, Collection<? extends PbGeneratedCodeConverter> converters) {
        PsiElement $this$parentOfType_u24default$iv = methodDefinition;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PbServiceDefinition pbServiceDefinition = (PbServiceDefinition)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PbServiceDefinition.class, (boolean)true);
        if (pbServiceDefinition == null) {
            return SequencesKt.emptySequence();
        }
        PbServiceDefinition serviceDefinition = pbServiceDefinition;
        String string = methodDefinition.getName();
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String methodName = string;
        return SequencesKt.filter((Sequence)SequencesKt.flatMap(this.handleServiceImplementations(serviceDefinition, converters), PbJavaImplementationSearcher::handleMethodImplementations$lambda$3), arg_0 -> PbJavaImplementationSearcher.handleMethodImplementations$lambda$4(methodName, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<PsiClass> handleMessageImplementations(PbMessageDefinition messageDefinition) {
        void $this$filterIsInstance$iv;
        PsiElement $this$parentOfType_u24default$iv = messageDefinition;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PbFile pbFile = (PbFile)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PbFile.class, (boolean)true);
        if (pbFile == null) {
            return SequencesKt.emptySequence();
        }
        PbFile pbFile2 = pbFile;
        PbJavaFindUsagesHandlerFactory.ProtoToJavaConverter dispatcher = new PbJavaFindUsagesHandlerFactory.ProtoToJavaConverter(pbFile2);
        messageDefinition.accept(dispatcher);
        Object[] objectArray = dispatcher.getResults();
        Object object = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        $this$parentOfType_u24default$iv = object;
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)handleMessageImplementations$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return sequence;
    }

    private final Sequence<PbElement> handleModel(PsiElement psiElement) {
        Object[] objectArray = PbJavaGotoDeclarationHandler.findProtoDeclarationForResolvedJavaElement(psiElement);
        Sequence sequence = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        Sequence $this$filterIsInstance$iv = sequence;
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)handleModel$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return sequence2;
    }

    private final Sequence<PbElement> handleService(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        PsiClass psiClass2 = this.findGeneratedServiceSuperclass(psiClass, converters);
        if (psiClass2 == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass generatedBaseClass = psiClass2;
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProtoFileAccessor protoFileAccessor = (ProtoFileAccessor)object;
        return SequencesKt.flatMap(this.protoNamesForClass(generatedBaseClass, converters), arg_0 -> PbJavaImplementationSearcher.handleService$lambda$5(protoFileAccessor, arg_0));
    }

    private final Sequence<PbElement> handleMethod(PsiMethod psiMethod, Collection<? extends PbGeneratedCodeConverter> converters) {
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass containingClass = psiClass;
        PsiClass psiClass2 = this.findGeneratedServiceSuperclass(containingClass, converters);
        if (psiClass2 == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass generatedBaseClass = psiClass2;
        Sequence<String> protoNamesForMethod = this.protoNamesForMethod(psiMethod, generatedBaseClass, converters);
        Project project = psiMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProtoFileAccessor protoFileAccessor = (ProtoFileAccessor)object;
        return SequencesKt.flatMap(protoNamesForMethod, arg_0 -> PbJavaImplementationSearcher.handleMethod$lambda$6(protoFileAccessor, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final String effectiveServiceFqn(PbServiceDefinition serviceDefinition) {
        Object object;
        PbStringValue pbStringValue;
        String javaPackageOrNull;
        Object v3;
        block6: {
            void $this$firstOrNull$iv;
            PsiFile $this$asSafely$iv = serviceDefinition.getContainingFile();
            boolean $i$f$asSafely22 = false;
            PsiFile psiFile = $this$asSafely$iv;
            if (!(psiFile instanceof PbFile)) {
                psiFile = null;
            }
            PbFile pbFile = (PbFile)psiFile;
            if (pbFile == null) {
                return null;
            }
            PbFile pbFile2 = pbFile;
            List list = pbFile2.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptions(...)");
            Iterable $i$f$asSafely22 = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PbOptionExpression it = (PbOptionExpression)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionName().getText(), (Object)"java_package")) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        PbOptionExpression pbOptionExpression = v3;
        String string = javaPackageOrNull = pbOptionExpression != null && (pbStringValue = pbOptionExpression.getStringValue()) != null ? pbStringValue.getAsString() : null;
        if (javaPackageOrNull == null) {
            QualifiedName qualifiedName = serviceDefinition.getQualifiedName();
            object = qualifiedName != null ? qualifiedName.toString() : null;
        } else {
            String string2 = serviceDefinition.getName();
            if (string2 == null) {
                string2 = "";
            }
            object = javaPackageOrNull + "." + string2;
        }
        return object;
    }

    private final Sequence<String> protoNamesForClass(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        String string = psiClass.getQualifiedName();
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String qualifiedName = string;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)converters), arg_0 -> PbJavaImplementationSearcher.protoNamesForClass$lambda$8(qualifiedName, arg_0));
    }

    private final Sequence<String> protoNamesForMethod(PsiMethod psiMethod, PsiClass generatedBaseClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        String string = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        return SequencesKt.map(this.protoNamesForClass(generatedBaseClass, converters), arg_0 -> PbJavaImplementationSearcher.protoNamesForMethod$lambda$9(methodName, arg_0));
    }

    private final PsiClass findGeneratedServiceSuperclass(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        CommonProcessors.FindFirstProcessor<PsiClass> searchProcessor = this.classWithSuitableSuperSearcher(converters);
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, (Processor)((Processor)searchProcessor));
        return (PsiClass)searchProcessor.getFoundValue();
    }

    private final CommonProcessors.FindFirstProcessor<PsiClass> classWithSuitableSuperSearcher(Collection<? extends PbGeneratedCodeConverter> converters) {
        return (CommonProcessors.FindFirstProcessor)new CommonProcessors.FindFirstProcessor<PsiClass>(converters){
            final /* synthetic */ Collection<PbGeneratedCodeConverter> $converters;
            {
                this.$converters = $converters;
            }

            protected boolean accept(PsiClass psiClass) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
                    Iterable $this$any$iv = this.$converters;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PbGeneratedCodeConverter it = (PbGeneratedCodeConverter)element$iv;
                            boolean bl2 = false;
                            if (!this.checkJavaClassHierarchy(psiClass, it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean checkJavaClassHierarchy(PsiClass psiClass, PbGeneratedCodeConverter converter) {
                PsiClass bindableServiceClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(converter.generatedFileNameHint(), psiClass.getResolveScope());
                return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)bindableServiceClass, (boolean)false);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasServiceSuperclass(PsiClass psiClass, Collection<? extends PbGeneratedCodeConverter> converters) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = converters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PbGeneratedCodeConverter pbGeneratedCodeConverter = (PbGeneratedCodeConverter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(p0.generatedFileNameHint());
            }
            Iterable $this$any$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String handleServiceImplementations$lambda$0(String $serviceFqn, PbGeneratedCodeConverter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        return converter.protoToCodeEntityName($serviceFqn);
    }

    private static final PsiClass handleServiceImplementations$lambda$1(Project $project, String maybeExistingCodeEntity) {
        Intrinsics.checkNotNullParameter((Object)maybeExistingCodeEntity, (String)"maybeExistingCodeEntity");
        return JavaPsiFacade.getInstance((Project)$project).findClass(maybeExistingCodeEntity, GlobalSearchScope.projectScope((Project)$project));
    }

    private static final Iterable handleServiceImplementations$lambda$2(PsiClass baseClass) {
        Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
        return ClassInheritorsSearch.search((PsiClass)baseClass).asIterable();
    }

    private static final Sequence handleMethodImplementations$lambda$3(PsiClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiMethod[] psiMethodArray = it.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        return ArraysKt.asSequence((Object[])psiMethodArray);
    }

    private static final boolean handleMethodImplementations$lambda$4(String $methodName, PsiMethod it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)$methodName);
    }

    private static final Sequence handleService$lambda$5(ProtoFileAccessor $protoFileAccessor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $protoFileAccessor.findServicesByFqn(it, PbSearchParameters.CONTAINS);
    }

    private static final Sequence handleMethod$lambda$6(ProtoFileAccessor $protoFileAccessor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $protoFileAccessor.findAllMethodsWithFqnPrefix(it);
    }

    private static final String protoNamesForClass$lambda$8(String $qualifiedName, PbGeneratedCodeConverter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.codeEntityNameToProtoName($qualifiedName);
    }

    private static final String protoNamesForMethod$lambda$9(String $methodName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + "." + $methodName;
    }
}

