/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.lang.makefile.MakefileFileType;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.UtilsKt;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\u0015H\u0014J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "filenameField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "targetCompletionProvider", "Lcom/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider;", "targetField", "Lcom/intellij/ui/TextFieldWithAutoCompletion;", "", "kotlin.jvm.PlatformType", "argumentsField", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "workingDirectoryField", "environmentVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "panel$delegate", "Lkotlin/Lazy;", "updateTargetCompletion", "", "filename", "createEditor", "applyEditorTo", "configuration", "resetEditorFrom", "createComponentWithMacroBrowse", "Ljavax/swing/JComponent;", "textAccessor", "intellij.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileRunConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileRunConfigurationEditor.kt\ncom/jetbrains/lang/makefile/MakefileRunConfigurationEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1#2:111\n1563#3:112\n1634#3,3:113\n*S KotlinDebug\n*F\n+ 1 MakefileRunConfigurationEditor.kt\ncom/jetbrains/lang/makefile/MakefileRunConfigurationEditor\n*L\n66#1:112\n66#1:113,3\n*E\n"})
public final class MakefileRunConfigurationEditor
extends SettingsEditor<MakefileRunConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final TextFieldWithBrowseButton filenameField;
    @NotNull
    private final TextFieldWithAutoCompletion.StringsCompletionProvider targetCompletionProvider;
    @NotNull
    private final TextFieldWithAutoCompletion<String> targetField;
    @NotNull
    private final ExpandableTextField argumentsField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirectoryField;
    @NotNull
    private final EnvironmentVariablesComponent environmentVarsComponent;
    @NotNull
    private final Lazy panel$delegate;

    /*
     * WARNING - void declaration
     */
    public MakefileRunConfigurationEditor(@NotNull Project project) {
        void $this$environmentVarsComponent_u24lambda_u241;
        ExpandableTextField $this$argumentsField_u24lambda_u240;
        ExpandableTextField expandableTextField;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.filenameField = new TextFieldWithBrowseButton();
        this.targetCompletionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)CollectionsKt.emptyList(), UtilsKt.getMakefileTargetIcon());
        this.targetField = new TextFieldWithAutoCompletion(this.project, (TextFieldWithAutoCompletionListProvider)this.targetCompletionProvider, true, "");
        ExpandableTextField expandableTextField2 = expandableTextField = new ExpandableTextField();
        MakefileRunConfigurationEditor makefileRunConfigurationEditor = this;
        boolean bl = false;
        $this$argumentsField_u24lambda_u240.setColumns(0);
        makefileRunConfigurationEditor.argumentsField = expandableTextField;
        this.workingDirectoryField = new TextFieldWithBrowseButton();
        $this$argumentsField_u24lambda_u240 = expandableTextField = new EnvironmentVariablesComponent();
        makefileRunConfigurationEditor = this;
        boolean bl2 = false;
        $this$environmentVarsComponent_u24lambda_u241.remove((Component)$this$environmentVarsComponent_u24lambda_u241.getLabel());
        makefileRunConfigurationEditor.environmentVarsComponent = expandableTextField;
        this.panel$delegate = LazyKt.lazy(() -> MakefileRunConfigurationEditor.panel_delegate$lambda$2(this));
        this.filenameField.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.singleFile().withFileFilter(arg_0 -> MakefileRunConfigurationEditor._init_$lambda$4(MakefileRunConfigurationEditor::_init_$lambda$3, arg_0)).withTitle(MakefileLangBundle.message("file.chooser.title", new Object[0])).withDescription(MakefileLangBundle.message("file.chooser.description", new Object[0])));
        this.filenameField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = filenameField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.updateTargetCompletion(string);
            }
        });
        this.workingDirectoryField.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(MakefileLangBundle.message("working.directory.file.chooser", new Object[0])).withDescription(MakefileLangBundle.message("working.directory.file.chooser.description", new Object[0])));
    }

    private final JPanel getPanel() {
        Lazy lazy = this.panel$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JPanel)object;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTargetCompletion(@NotNull String filename) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filename);
        if (file != null && (psiFile = PsiManager.getInstance((Project)this.project).findFile(file)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<MakefileTarget> iterable = UtilsKt.findTargets(psiFile);
            TextFieldWithAutoCompletion.StringsCompletionProvider stringsCompletionProvider = this.targetCompletionProvider;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MakefileTarget makefileTarget = (MakefileTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            stringsCompletionProvider.setItems((Collection)((List)destination$iv$iv));
            return;
        }
        this.targetCompletionProvider.setItems((Collection)CollectionsKt.emptyList());
    }

    @NotNull
    protected JPanel createEditor() {
        return this.getPanel();
    }

    protected void applyEditorTo(@NotNull MakefileRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String string = this.filenameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        configuration.setFilename(string);
        String string2 = this.targetField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        configuration.setTarget(string2);
        String string3 = this.workingDirectoryField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        configuration.setWorkingDirectory(string3);
        EnvironmentVariablesData environmentVariablesData = this.environmentVarsComponent.getEnvData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getEnvData(...)");
        configuration.setEnvironmentVariables(environmentVariablesData);
        String string4 = this.argumentsField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        configuration.setArguments(string4);
    }

    protected void resetEditorFrom(@NotNull MakefileRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        this.filenameField.setText(configuration.getFilename());
        this.targetField.setText(configuration.getTarget());
        this.workingDirectoryField.setText(configuration.getWorkingDirectory());
        this.environmentVarsComponent.setEnvData(configuration.getEnvironmentVariables());
        this.argumentsField.setText(configuration.getArguments());
        this.updateTargetCompletion(configuration.getFilename());
    }

    private final JComponent createComponentWithMacroBrowse(TextFieldWithBrowseButton textAccessor) {
        JPanel jPanel;
        FixedSizeButton button = new FixedSizeButton((JComponent)textAccessor);
        button.setIcon(AllIcons.Actions.ListFiles);
        button.addActionListener(arg_0 -> MakefileRunConfigurationEditor.createComponentWithMacroBrowse$lambda$8(button, textAccessor, arg_0));
        JPanel $this$createComponentWithMacroBrowse_u24lambda_u249 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createComponentWithMacroBrowse_u24lambda_u249.add((Component)textAccessor, "Center");
        $this$createComponentWithMacroBrowse_u24lambda_u249.add((Component)button, "East");
        return jPanel;
    }

    private static final JPanel panel_delegate$lambda$2(MakefileRunConfigurationEditor this$0) {
        return FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.filename.label", new Object[0]), (JComponent)this$0.filenameField).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.target.label", new Object[0]), (JComponent)this$0.targetField).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.arguments.label", new Object[0]), (JComponent)this$0.argumentsField).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.working.directory.label", new Object[0]), this$0.createComponentWithMacroBrowse(this$0.workingDirectoryField)).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.environment.label", new Object[0]), (JComponent)this$0.environmentVarsComponent).getPanel();
    }

    private static final boolean _init_$lambda$3(VirtualFile file) {
        return FileTypeManager.getInstance().isFileOfType(file, (FileType)MakefileFileType.INSTANCE);
    }

    private static final boolean _init_$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createComponentWithMacroBrowse$lambda$8$lambda$6(TextFieldWithBrowseButton $textAccessor, String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        $textAccessor.setText("$" + item + "$");
        return Unit.INSTANCE;
    }

    private static final void createComponentWithMacroBrowse$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createComponentWithMacroBrowse$lambda$8(FixedSizeButton $button, TextFieldWithBrowseButton $textAccessor, ActionEvent it) {
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        Set set = PathMacros.getInstance().getUserMacroNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getUserMacroNames(...)");
        jBPopupFactory.createPopupChooserBuilder(CollectionsKt.toList((Iterable)set)).setItemChosenCallback(arg_0 -> MakefileRunConfigurationEditor.createComponentWithMacroBrowse$lambda$8$lambda$7(arg_0 -> MakefileRunConfigurationEditor.createComponentWithMacroBrowse$lambda$8$lambda$6($textAccessor, arg_0), arg_0)).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)$button);
    }
}

