/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 87198798179788L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1922796900 + -((char)-22951), 1922796900 + (char)-15746, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1922796900 + -((char)-22950), 1922796900 + (char)-11152, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 100053497065407L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.E();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-2061075750 - -4952, 2061075750 - 22860, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-2061075750 - -4953, 2061075750 - 15218, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-2061075750 - -4954, -2061075750 - -((char)-32507), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 75902165085790L;
                Object object = this.lock;
                n2 = SshAgentIpcService.E();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22166, 1502979690 + (char)-29808, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22163, 1502979690 + (char)-18851, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22164, -1502979690 + -((char)-14260), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22161, -1502979690 + -((char)-14194), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22162, 1502979690 + (char)-26506, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22159, -1502979690 + -((char)-29695), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22161, -1502979690 + -((char)-14194), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1502979690 + (char)-22160, 1502979690 + (char)-20149, (int)l2));
            if (ActionTimestamp.z() == null) {
                SshAgentIpcService.z(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 86805407768650L;
                    n3 = SshAgentIpcService.E();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 125474592730399L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            n2 = SshAgentIpcService.z();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24868, -1418177400 - -18838, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24869, -1418177400 - -25465, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24870, 1418177400 - 12302, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24868, -1418177400 - -18838, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24871, 1418177400 - 21303, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24868, -1418177400 - -18838, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24840, -1418177400 - -((char)-27125), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24841, 1418177400 - 23912, (int)l2) + ErrorToolsKt.prettyHRESULT(n3)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24870, 1418177400 - 12302, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24868, -1418177400 - -18838, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24864, -1418177400 - -32193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1418177400 - (char)-24842, 1418177400 - 28511, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 45492436502879L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(142866300 + (char)-28624, -142866300 + -((char)-27925), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 83390743960453L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-341044140 + -16093, 341044140 + 8261, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "!\u000b\u00ef\u00da3\u00c0E\u00ffQnZk\u009d<;\u0018{\u00fd\u0094\u0014\u00afS>\u00d7\u0012\u00a3\u001c\u0016\u00f8U\u00aa\u00d8A\u00b3ab\u00ddtG\u00c7";
                        var4_3 = "!\u000b\u00ef\u00da3\u00c0E\u00ffQnZk\u009d<;\u0018{\u00fd\u0094\u0014\u00afS>\u00d7\u0012\u00a3\u001c\u0016\u00f8U\u00aa\u00d8A\u00b3ab\u00ddtG\u00c7".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 90;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 104;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 104;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 39;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 37;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 126;
                                        break;
                                    }
                                    default: {
                                        v11 = 64;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xEF3) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 213;
                            case 1 -> 75;
                            case 2 -> 171;
                            case 3 -> 83;
                            case 4 -> 191;
                            case 5 -> 119;
                            case 6 -> 2;
                            case 7 -> 139;
                            case 8 -> 236;
                            case 9 -> 188;
                            case 10 -> 157;
                            case 11 -> 53;
                            case 12 -> 240;
                            case 13 -> 101;
                            case 14 -> 205;
                            case 15 -> 39;
                            case 16 -> 42;
                            case 17 -> 74;
                            case 18 -> 92;
                            case 19 -> 26;
                            case 20 -> 12;
                            case 21 -> 31;
                            case 22 -> 150;
                            case 23 -> 197;
                            case 24 -> 73;
                            case 25 -> 112;
                            case 26 -> 254;
                            case 27 -> 165;
                            case 28 -> 25;
                            case 29 -> 245;
                            case 30 -> 189;
                            case 31 -> 44;
                            case 32 -> 63;
                            case 33 -> 180;
                            case 34 -> 113;
                            case 35 -> 167;
                            case 36 -> 224;
                            case 37 -> 138;
                            case 38 -> 68;
                            case 39 -> 186;
                            case 40 -> 104;
                            case 41 -> 232;
                            case 42 -> 161;
                            case 43 -> 169;
                            case 44 -> 142;
                            case 45 -> 100;
                            case 46 -> 208;
                            case 47 -> 212;
                            case 48 -> 145;
                            case 49 -> 94;
                            case 50 -> 206;
                            case 51 -> 11;
                            case 52 -> 173;
                            case 53 -> 116;
                            case 54 -> 98;
                            case 55 -> 95;
                            case 56 -> 56;
                            case 57 -> 6;
                            case 58 -> 214;
                            case 59 -> 141;
                            case 60 -> 223;
                            case 61 -> 239;
                            case 62 -> 93;
                            case 63 -> 230;
                            case 64 -> 251;
                            case 65 -> 215;
                            case 66 -> 201;
                            case 67 -> 66;
                            case 68 -> 149;
                            case 69 -> 184;
                            case 70 -> 190;
                            case 71 -> 76;
                            case 72 -> 160;
                            case 73 -> 8;
                            case 74 -> 200;
                            case 75 -> 21;
                            case 76 -> 84;
                            case 77 -> 238;
                            case 78 -> 187;
                            case 79 -> 174;
                            case 80 -> 172;
                            case 81 -> 24;
                            case 82 -> 176;
                            case 83 -> 29;
                            case 84 -> 226;
                            case 85 -> 15;
                            case 86 -> 179;
                            case 87 -> 164;
                            case 88 -> 5;
                            case 89 -> 231;
                            case 90 -> 111;
                            case 91 -> 103;
                            case 92 -> 40;
                            case 93 -> 234;
                            case 94 -> 219;
                            case 95 -> 30;
                            case 96 -> 248;
                            case 97 -> 108;
                            case 98 -> 242;
                            case 99 -> 196;
                            case 100 -> 69;
                            case 101 -> 57;
                            case 102 -> 86;
                            case 103 -> 163;
                            case 104 -> 1;
                            case 105 -> 241;
                            case 106 -> 130;
                            case 107 -> 178;
                            case 108 -> 89;
                            case 109 -> 105;
                            case 110 -> 124;
                            case 111 -> 140;
                            case 112 -> 43;
                            case 113 -> 37;
                            case 114 -> 27;
                            case 115 -> 216;
                            case 116 -> 38;
                            case 117 -> 210;
                            case 118 -> 10;
                            case 119 -> 28;
                            case 120 -> 154;
                            case 121 -> 3;
                            case 122 -> 65;
                            case 123 -> 106;
                            case 124 -> 229;
                            case 125 -> 96;
                            case 126 -> 19;
                            case 127 -> 88;
                            case 128 -> 18;
                            case 129 -> 222;
                            case 130 -> 125;
                            case 131 -> 209;
                            case 132 -> 136;
                            case 133 -> 225;
                            case 134 -> 202;
                            case 135 -> 128;
                            case 136 -> 55;
                            case 137 -> 36;
                            case 138 -> 61;
                            case 139 -> 91;
                            case 140 -> 166;
                            case 141 -> 122;
                            case 142 -> 132;
                            case 143 -> 193;
                            case 144 -> 203;
                            case 145 -> 156;
                            case 146 -> 134;
                            case 147 -> 127;
                            case 148 -> 9;
                            case 149 -> 45;
                            case 150 -> 218;
                            case 151 -> 168;
                            case 152 -> 181;
                            case 153 -> 129;
                            case 154 -> 247;
                            case 155 -> 82;
                            case 156 -> 252;
                            case 157 -> 159;
                            case 158 -> 71;
                            case 159 -> 131;
                            case 160 -> 148;
                            case 161 -> 158;
                            case 162 -> 249;
                            case 163 -> 34;
                            case 164 -> 235;
                            case 165 -> 48;
                            case 166 -> 182;
                            case 167 -> 244;
                            case 168 -> 52;
                            case 169 -> 175;
                            case 170 -> 220;
                            case 171 -> 41;
                            case 172 -> 237;
                            case 173 -> 4;
                            case 174 -> 217;
                            case 175 -> 147;
                            case 176 -> 7;
                            case 177 -> 183;
                            case 178 -> 243;
                            case 179 -> 117;
                            case 180 -> 137;
                            case 181 -> 59;
                            case 182 -> 194;
                            case 183 -> 77;
                            case 184 -> 20;
                            case 185 -> 97;
                            case 186 -> 255;
                            case 187 -> 207;
                            case 188 -> 123;
                            case 189 -> 13;
                            case 190 -> 120;
                            case 191 -> 211;
                            case 192 -> 146;
                            case 193 -> 46;
                            case 194 -> 107;
                            case 195 -> 32;
                            case 196 -> 133;
                            case 197 -> 228;
                            case 198 -> 204;
                            case 199 -> 192;
                            case 200 -> 72;
                            case 201 -> 102;
                            case 202 -> 177;
                            case 203 -> 78;
                            case 204 -> 0;
                            case 205 -> 195;
                            case 206 -> 50;
                            case 207 -> 233;
                            case 208 -> 70;
                            case 209 -> 170;
                            case 210 -> 151;
                            case 211 -> 47;
                            case 212 -> 118;
                            case 213 -> 58;
                            case 214 -> 60;
                            case 215 -> 162;
                            case 216 -> 153;
                            case 217 -> 144;
                            case 218 -> 110;
                            case 219 -> 54;
                            case 220 -> 155;
                            case 221 -> 80;
                            case 222 -> 126;
                            case 223 -> 199;
                            case 224 -> 115;
                            case 225 -> 87;
                            case 226 -> 135;
                            case 227 -> 62;
                            case 228 -> 17;
                            case 229 -> 246;
                            case 230 -> 250;
                            case 231 -> 114;
                            case 232 -> 99;
                            case 233 -> 22;
                            case 234 -> 253;
                            case 235 -> 49;
                            case 236 -> 109;
                            case 237 -> 33;
                            case 238 -> 185;
                            case 239 -> 227;
                            case 240 -> 143;
                            case 241 -> 16;
                            case 242 -> 51;
                            case 243 -> 23;
                            case 244 -> 221;
                            case 245 -> 35;
                            case 246 -> 198;
                            case 247 -> 64;
                            case 248 -> 79;
                            case 249 -> 152;
                            case 250 -> 85;
                            case 251 -> 67;
                            case 252 -> 81;
                            case 253 -> 90;
                            case 254 -> 121;
                            default -> 14;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.z(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 88771932513962L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.E();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-746574720 - -((char)-25943), 746574720 - 32213, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-746574720 - -((char)-25939), 746574720 - (char)-18044, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-746574720 - -((char)-25930), 746574720 - (char)-12492, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-746574720 - -((char)-25943), 746574720 - 32213, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-746574720 - -((char)-25939), 746574720 - (char)-18044, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-746574720 - -((char)-25935), -746574720 - -23539, (int)l3) + ErrorToolsKt.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 100516788043395L;
                        int n3 = SshAgentIpcService.z();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1668390030 + 17035, -1668390030 + -7084, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1668390030 + 17036, 1668390030 - 5975, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 4619335121063L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = SshAgentIpcService.E();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2049672660 + -24840, 2049672660 + 1490, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2049672660 + -24844, 2049672660 + 16925, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2049672660 + -24813, -2049672660 + -2246, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2049672660 + -24844, 2049672660 + 16925, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2049672660 + -24838, -2049672660 + -2906, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2049672660 + -24840, 2049672660 + 1490, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2049672660 + -24844, 2049672660 + 16925, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2049672660 + -24828, -2049672660 + -672, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2049672660 + -24840, 2049672660 + 1490, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2049672660 + -24844, 2049672660 + 16925, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2049672660 + -24827, -2049672660 - -1070, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2049672660 + -24840, 2049672660 + 1490, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-2049672660 + -24844, 2049672660 + 16925, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2049672660 + -24826, -2049672660 + -14553, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 129264031082639L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.z();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10676), 1599578280 + 31462, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10672), 1599578280 + (char)-18639, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10691), -1599578280 + -31601, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10692), -1599578280 + -((char)-31156), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10676), 1599578280 + 31462, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10672), 1599578280 + (char)-18639, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10693), -1599578280 + -((char)-22909), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10676), 1599578280 + 31462, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10672), 1599578280 + (char)-18639, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10694), 1599578280 + (char)-20168, (int)l2) + ErrorToolsKt.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10676), 1599578280 + 31462, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10672), 1599578280 + (char)-18639, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10695), 1599578280 + (char)-15184, (int)l2));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10676), 1599578280 + 31462, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10672), 1599578280 + (char)-18639, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10696), 1599578280 + 31342, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1599578280 + -((char)-10697), -1599578280 + -((char)-14230), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00f2\u0002\u00aa\u0012X\u001f\u00e1r\u00140\u00ce\u00cal\u00aaX\u0010\u0080\u00a9\u001fI\u00ed\u0017\u00f0\u00cc\u008a\u0096\u00f2\u00cd+\u0006\u00d5XNY\u00ae7\u0018\u00c9\u00ce\u0095\\\u00c3\u009b?8\u0084u\u00e3\u00d0$\u00a8\u00f8\u0003\u00b9\u00aa\u0006\u00bd\u00b9i\u0086#\tT!\u00b8\u0010\r\u008d\u00fe\u00b2\u0080\u0005Tg~\u00be\u00b2\bE\u00c1\\\u001b\u00d4\u0018vp\u0014\u0091>\u0086\u00e9N\u00e0\u00b9\u0000\u00f2\u00d2\u0089\u00e0E\u00f2='\u00ba\u0094\u00b1\u00a5\u0005\u0090\u0015\u00e6\u00f0\u00a1\u001e2\u00f3\u00a7H\u0014\u00ddg\u008a*7}\u001f\u00bbq\u00a9\\r\u00d0\u00ad\u0006`1\u00b1\u00e5\u001d\u0017\u00c9u\u00c3>\u00103\u009cc`\u00db\u00eah\u0095\u00b6fc\u00c8~\u00de\u00be6\t\u009fB\u0017m\u00ab\u0005\f<0\u0010\u00a1\u00041s\u0091\u0088!\u00d9\u009f\u00efF\u00f9\u00da\u00f8*\u00f2?|\u0084f\u00a6!\tD|?8\u009a\u0005\u00f8\u00c4\u00fc\u00d3\u001dD=Q\u00fc\u0089Y\u0094\u0010\u00d1e\u0019a\u00e5Q\u0099\u00ab\u0099\u00f9\u00e7\u0082\u00edP\u00bdp\u00d8pq\u0095~]\u00ed\u00cd\u0092\u00d1\u0086#\u008c,\u0005\u00eb\u0017\u00d7\u00edW`\u00e9\b\u00fb{\u008bL.\u00f2)-\f\u00d1\u00d7\u00de\u00c2\u0099A1\\\u00b4\u0017q\u00e2F\u00993\u00d7^\u00b8\u00d2\u0015.0U\u00ebn@\u00a1\u00f4Y\u00e0r\u00828\u0019\u00f6\u00e6I\u00d1A\u00ae\u0000\u00a7\u00ef\u00b3\u00e4\u00cb\u00807\u00e5\u0081\u00e0\u009b\u00d8\u009aa\u00a6\u00bd\u0091b\u0089\u0013\u00b0\u00b5\u0018\u00c8\u00f5\u00d3\u00e0\u00f5\u00ed}\u0081\u001c\u00ae7\u008a\u00b8VI \u008b\u00db\u0094\u001f\u008d6P\u00f0\u00ea\u00ca\u00b8h\u00d1k\u0002\u0094T\u001d_`\u00d7\u00bfd!\u0092U8\u00c2M#\u00d4?}\u0086\u00ea\u000bRJ\u00aeq\u00977\u00f0\u0092\u008c\u00c2|\u0015B)\u00ac\u001e\u00d0\u00b2\u00f4_2\u009bcA\u00c6\u000b\u0010\u00f4\u00c5\u00b9\u00fb\u0098W)P\u00d2\u00ebl\u009dYV\u001a\f%\u00b9]'.\u00af\u0003\u0096[\u0097\u001a\u001cJ/9\u00c0\u0015\u00b2\u0081\u009e\u00a5\u0014\u0093\u00c1\u00cb\u0010\u0001{aOA\u00a3\u0007\u001c\u00ffh\u00d3\u00c9\u00f3G\u0007_\u0011db\u00af*\u009d(D\u00f0%\t\u00f4\u009f\u008d\u00e5\u0007\r\u00f2nm\u00c9\u00a4|\u00f0\u0019\u00f5\u00111\u0015\u00e5\u0019\t\u00ad=\u00edXH\u00177Z4\u00fdS|V<T\u000f\u00d5\u00deY\u00e5\u0093n\u00c4\u0018[?\u00d8y\u0088\u007f\u0086\"\u00e6\u00d0=,GQ\r\u001bg\u0005\u00d4Y\u0089\u00a2\u001e\\K\u0099\u00a6\u0000\u00d0\t\u0016\u0001tF\u00e95\u00d1\u0001_\u0000\u0086J\u000e\u00a8J\u00f6wf<zR\u008cv\"P\u00dbP\u001b\u0010\\\u00e6\u00b0\u009fq\u00d0\u00a7\u008eO\u00efv2\u00a2OJ\u00c9\u00f1K\u0091V\u000f\u00b5gK\u00e7[\n\u009e\u00d1\u00f3\u0006)C\u00d5\u00cb\u0085\u00a0\u0018\u00f7R\u001a|\u0001T\"]\u00ce\u00d9%;\u00d2X\u00af4\u00a2?\u00f11yP\u000b\u00df)\u00bf^\u0016\u00fd\"k\u00a1\\\u00f2\u00edfD\u00d8\u0004\u00cf=\u00e4\u00e9\u0006\u0089\u0014(gy\u00bc\u008f\u00a0>\u008f\u000e\u008dw\u00d7\u0089\u0007\u00ddG\u00de\u00c8\u00b6S\t\u00f4\u008dz\u008a\f6\u00ae\u0001\u00d9";
                var4_3 = "\u00f2\u0002\u00aa\u0012X\u001f\u00e1r\u00140\u00ce\u00cal\u00aaX\u0010\u0080\u00a9\u001fI\u00ed\u0017\u00f0\u00cc\u008a\u0096\u00f2\u00cd+\u0006\u00d5XNY\u00ae7\u0018\u00c9\u00ce\u0095\\\u00c3\u009b?8\u0084u\u00e3\u00d0$\u00a8\u00f8\u0003\u00b9\u00aa\u0006\u00bd\u00b9i\u0086#\tT!\u00b8\u0010\r\u008d\u00fe\u00b2\u0080\u0005Tg~\u00be\u00b2\bE\u00c1\\\u001b\u00d4\u0018vp\u0014\u0091>\u0086\u00e9N\u00e0\u00b9\u0000\u00f2\u00d2\u0089\u00e0E\u00f2='\u00ba\u0094\u00b1\u00a5\u0005\u0090\u0015\u00e6\u00f0\u00a1\u001e2\u00f3\u00a7H\u0014\u00ddg\u008a*7}\u001f\u00bbq\u00a9\\r\u00d0\u00ad\u0006`1\u00b1\u00e5\u001d\u0017\u00c9u\u00c3>\u00103\u009cc`\u00db\u00eah\u0095\u00b6fc\u00c8~\u00de\u00be6\t\u009fB\u0017m\u00ab\u0005\f<0\u0010\u00a1\u00041s\u0091\u0088!\u00d9\u009f\u00efF\u00f9\u00da\u00f8*\u00f2?|\u0084f\u00a6!\tD|?8\u009a\u0005\u00f8\u00c4\u00fc\u00d3\u001dD=Q\u00fc\u0089Y\u0094\u0010\u00d1e\u0019a\u00e5Q\u0099\u00ab\u0099\u00f9\u00e7\u0082\u00edP\u00bdp\u00d8pq\u0095~]\u00ed\u00cd\u0092\u00d1\u0086#\u008c,\u0005\u00eb\u0017\u00d7\u00edW`\u00e9\b\u00fb{\u008bL.\u00f2)-\f\u00d1\u00d7\u00de\u00c2\u0099A1\\\u00b4\u0017q\u00e2F\u00993\u00d7^\u00b8\u00d2\u0015.0U\u00ebn@\u00a1\u00f4Y\u00e0r\u00828\u0019\u00f6\u00e6I\u00d1A\u00ae\u0000\u00a7\u00ef\u00b3\u00e4\u00cb\u00807\u00e5\u0081\u00e0\u009b\u00d8\u009aa\u00a6\u00bd\u0091b\u0089\u0013\u00b0\u00b5\u0018\u00c8\u00f5\u00d3\u00e0\u00f5\u00ed}\u0081\u001c\u00ae7\u008a\u00b8VI \u008b\u00db\u0094\u001f\u008d6P\u00f0\u00ea\u00ca\u00b8h\u00d1k\u0002\u0094T\u001d_`\u00d7\u00bfd!\u0092U8\u00c2M#\u00d4?}\u0086\u00ea\u000bRJ\u00aeq\u00977\u00f0\u0092\u008c\u00c2|\u0015B)\u00ac\u001e\u00d0\u00b2\u00f4_2\u009bcA\u00c6\u000b\u0010\u00f4\u00c5\u00b9\u00fb\u0098W)P\u00d2\u00ebl\u009dYV\u001a\f%\u00b9]'.\u00af\u0003\u0096[\u0097\u001a\u001cJ/9\u00c0\u0015\u00b2\u0081\u009e\u00a5\u0014\u0093\u00c1\u00cb\u0010\u0001{aOA\u00a3\u0007\u001c\u00ffh\u00d3\u00c9\u00f3G\u0007_\u0011db\u00af*\u009d(D\u00f0%\t\u00f4\u009f\u008d\u00e5\u0007\r\u00f2nm\u00c9\u00a4|\u00f0\u0019\u00f5\u00111\u0015\u00e5\u0019\t\u00ad=\u00edXH\u00177Z4\u00fdS|V<T\u000f\u00d5\u00deY\u00e5\u0093n\u00c4\u0018[?\u00d8y\u0088\u007f\u0086\"\u00e6\u00d0=,GQ\r\u001bg\u0005\u00d4Y\u0089\u00a2\u001e\\K\u0099\u00a6\u0000\u00d0\t\u0016\u0001tF\u00e95\u00d1\u0001_\u0000\u0086J\u000e\u00a8J\u00f6wf<zR\u008cv\"P\u00dbP\u001b\u0010\\\u00e6\u00b0\u009fq\u00d0\u00a7\u008eO\u00efv2\u00a2OJ\u00c9\u00f1K\u0091V\u000f\u00b5gK\u00e7[\n\u009e\u00d1\u00f3\u0006)C\u00d5\u00cb\u0085\u00a0\u0018\u00f7R\u001a|\u0001T\"]\u00ce\u00d9%;\u00d2X\u00af4\u00a2?\u00f11yP\u000b\u00df)\u00bf^\u0016\u00fd\"k\u00a1\\\u00f2\u00edfD\u00d8\u0004\u00cf=\u00e4\u00e9\u0006\u0089\u0014(gy\u00bc\u008f\u00a0>\u008f\u000e\u008dw\u00d7\u0089\u0007\u00ddG\u00de\u00c8\u00b6S\t\u00f4\u008dz\u008a\f6\u00ae\u0001\u00d9".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 15;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "kng\u0010\u00e7=\u00f2}s\"\u00bdVH\u00ad6\u00e30\u00d5'a\u008e\u00e1,u\u0095\u00f9\u00ff^\u001f\u0014\u00db\u0084\\\u00ce\u0093\u00e7\u00dc\u009c\u00dbw\u00ec\u000bH\u00c7\u00cc\u0087}\u00b8[\u0089";
                    var4_3 = "kng\u0010\u00e7=\u00f2}s\"\u00bdVH\u00ad6\u00e30\u00d5'a\u008e\u00e1,u\u0095\u00f9\u00ff^\u001f\u0014\u00db\u0084\\\u00ce\u0093\u00e7\u00dc\u009c\u00dbw\u00ec\u000bH\u00c7\u00cc\u0087}\u00b8[\u0089".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 33;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 89;
                            break;
                        }
                        case 1: {
                            v15 = 44;
                            break;
                        }
                        case 2: {
                            v15 = 63;
                            break;
                        }
                        case 3: {
                            v15 = 24;
                            break;
                        }
                        case 4: {
                            v15 = 42;
                            break;
                        }
                        case 5: {
                            v15 = 24;
                            break;
                        }
                        default: {
                            v15 = 111;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x218F) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 108;
                case 1 -> 165;
                case 2 -> 50;
                case 3 -> 111;
                case 4 -> 200;
                case 5 -> 117;
                case 6 -> 157;
                case 7 -> 177;
                case 8 -> 167;
                case 9 -> 58;
                case 10 -> 176;
                case 11 -> 85;
                case 12 -> 137;
                case 13 -> 123;
                case 14 -> 109;
                case 15 -> 41;
                case 16 -> 6;
                case 17 -> 230;
                case 18 -> 143;
                case 19 -> 112;
                case 20 -> 184;
                case 21 -> 110;
                case 22 -> 206;
                case 23 -> 133;
                case 24 -> 99;
                case 25 -> 95;
                case 26 -> 214;
                case 27 -> 232;
                case 28 -> 203;
                case 29 -> 104;
                case 30 -> 231;
                case 31 -> 53;
                case 32 -> 224;
                case 33 -> 234;
                case 34 -> 51;
                case 35 -> 18;
                case 36 -> 81;
                case 37 -> 10;
                case 38 -> 249;
                case 39 -> 158;
                case 40 -> 250;
                case 41 -> 197;
                case 42 -> 14;
                case 43 -> 45;
                case 44 -> 190;
                case 45 -> 103;
                case 46 -> 89;
                case 47 -> 47;
                case 48 -> 239;
                case 49 -> 246;
                case 50 -> 28;
                case 51 -> 57;
                case 52 -> 38;
                case 53 -> 75;
                case 54 -> 80;
                case 55 -> 195;
                case 56 -> 26;
                case 57 -> 77;
                case 58 -> 118;
                case 59 -> 64;
                case 60 -> 245;
                case 61 -> 211;
                case 62 -> 34;
                case 63 -> 192;
                case 64 -> 0;
                case 65 -> 139;
                case 66 -> 185;
                case 67 -> 217;
                case 68 -> 221;
                case 69 -> 20;
                case 70 -> 236;
                case 71 -> 198;
                case 72 -> 134;
                case 73 -> 78;
                case 74 -> 11;
                case 75 -> 141;
                case 76 -> 254;
                case 77 -> 169;
                case 78 -> 93;
                case 79 -> 216;
                case 80 -> 194;
                case 81 -> 145;
                case 82 -> 138;
                case 83 -> 124;
                case 84 -> 170;
                case 85 -> 94;
                case 86 -> 187;
                case 87 -> 252;
                case 88 -> 25;
                case 89 -> 100;
                case 90 -> 8;
                case 91 -> 32;
                case 92 -> 204;
                case 93 -> 87;
                case 94 -> 227;
                case 95 -> 213;
                case 96 -> 70;
                case 97 -> 251;
                case 98 -> 212;
                case 99 -> 37;
                case 100 -> 96;
                case 101 -> 201;
                case 102 -> 233;
                case 103 -> 27;
                case 104 -> 199;
                case 105 -> 208;
                case 106 -> 131;
                case 107 -> 39;
                case 108 -> 193;
                case 109 -> 29;
                case 110 -> 42;
                case 111 -> 180;
                case 112 -> 91;
                case 113 -> 56;
                case 114 -> 52;
                case 115 -> 205;
                case 116 -> 120;
                case 117 -> 24;
                case 118 -> 7;
                case 119 -> 79;
                case 120 -> 173;
                case 121 -> 247;
                case 122 -> 243;
                case 123 -> 82;
                case 124 -> 54;
                case 125 -> 86;
                case 126 -> 98;
                case 127 -> 40;
                case 128 -> 215;
                case 129 -> 67;
                case 130 -> 74;
                case 131 -> 114;
                case 132 -> 19;
                case 133 -> 166;
                case 134 -> 122;
                case 135 -> 161;
                case 136 -> 22;
                case 137 -> 68;
                case 138 -> 9;
                case 139 -> 162;
                case 140 -> 148;
                case 141 -> 33;
                case 142 -> 35;
                case 143 -> 171;
                case 144 -> 178;
                case 145 -> 43;
                case 146 -> 142;
                case 147 -> 229;
                case 148 -> 49;
                case 149 -> 2;
                case 150 -> 59;
                case 151 -> 36;
                case 152 -> 226;
                case 153 -> 31;
                case 154 -> 181;
                case 155 -> 255;
                case 156 -> 17;
                case 157 -> 88;
                case 158 -> 66;
                case 159 -> 76;
                case 160 -> 12;
                case 161 -> 191;
                case 162 -> 63;
                case 163 -> 119;
                case 164 -> 90;
                case 165 -> 238;
                case 166 -> 130;
                case 167 -> 129;
                case 168 -> 146;
                case 169 -> 175;
                case 170 -> 128;
                case 171 -> 219;
                case 172 -> 55;
                case 173 -> 222;
                case 174 -> 106;
                case 175 -> 116;
                case 176 -> 115;
                case 177 -> 154;
                case 178 -> 13;
                case 179 -> 83;
                case 180 -> 189;
                case 181 -> 15;
                case 182 -> 202;
                case 183 -> 5;
                case 184 -> 172;
                case 185 -> 210;
                case 186 -> 105;
                case 187 -> 228;
                case 188 -> 44;
                case 189 -> 186;
                case 190 -> 253;
                case 191 -> 220;
                case 192 -> 182;
                case 193 -> 207;
                case 194 -> 97;
                case 195 -> 223;
                case 196 -> 153;
                case 197 -> 244;
                case 198 -> 160;
                case 199 -> 144;
                case 200 -> 159;
                case 201 -> 248;
                case 202 -> 241;
                case 203 -> 168;
                case 204 -> 127;
                case 205 -> 149;
                case 206 -> 121;
                case 207 -> 151;
                case 208 -> 237;
                case 209 -> 62;
                case 210 -> 209;
                case 211 -> 73;
                case 212 -> 188;
                case 213 -> 136;
                case 214 -> 23;
                case 215 -> 125;
                case 216 -> 92;
                case 217 -> 72;
                case 218 -> 3;
                case 219 -> 46;
                case 220 -> 107;
                case 221 -> 140;
                case 222 -> 179;
                case 223 -> 60;
                case 224 -> 150;
                case 225 -> 225;
                case 226 -> 126;
                case 227 -> 101;
                case 228 -> 174;
                case 229 -> 240;
                case 230 -> 132;
                case 231 -> 84;
                case 232 -> 163;
                case 233 -> 156;
                case 234 -> 183;
                case 235 -> 196;
                case 236 -> 135;
                case 237 -> 242;
                case 238 -> 21;
                case 239 -> 65;
                case 240 -> 155;
                case 241 -> 69;
                case 242 -> 1;
                case 243 -> 164;
                case 244 -> 218;
                case 245 -> 30;
                case 246 -> 152;
                case 247 -> 113;
                case 248 -> 61;
                case 249 -> 4;
                case 250 -> 235;
                case 251 -> 147;
                case 252 -> 102;
                case 253 -> 71;
                case 254 -> 48;
                default -> 16;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 95927224355357L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-870173730 + -((char)-21304), 870173730 + 31668, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 34779910132048L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.z();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-735040560 + -3958, -735040560 - -18307, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-735040560 + -3959, -735040560 + -1041, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-735040560 + -3960, -735040560 + -2134, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0088W\u0001\u00d3\u00e9\u00a2\u001b\u00e9\u0010\u00db8\u009a\u009f \u0090\u00db\u00f6\u0090\u00ee\u00cc\u001d\u000e\u00a8\u009c\u00a8";
                    var4_3 = "\u0088W\u0001\u00d3\u00e9\u00a2\u001b\u00e9\u0010\u00db8\u009a\u009f \u0090\u00db\u00f6\u0090\u00ee\u00cc\u001d\u000e\u00a8\u009c\u00a8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 8;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "T\u00d4\u00c0\u00f9\u00fb5@\u0092U]\u009b\u00ab\u00ee`\u001b\u00ddu\u00e1\u0094\u0087\u0090\u009d0u\u00919\u00e3w\u001c\u00a1\u00e8F\u00baW|\u0016\u009d\u0091P\u00fb\u0014\u009c\u00f0\u0016k7x0\u0090\u008eb[\u00cf\u0004\u00bd/\u00c6\u00aa\u00b5";
                        var4_3 = "T\u00d4\u00c0\u00f9\u00fb5@\u0092U]\u009b\u00ab\u00ee`\u001b\u00ddu\u00e1\u0094\u0087\u0090\u009d0u\u00919\u00e3w\u001c\u00a1\u00e8F\u00baW|\u0016\u009d\u0091P\u00fb\u0014\u009c\u00f0\u0016k7x0\u0090\u008eb[\u00cf\u0004\u00bd/\u00c6\u00aa\u00b5".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 88;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 83;
                                break;
                            }
                            case 1: {
                                v15 = 83;
                                break;
                            }
                            case 2: {
                                v15 = 125;
                                break;
                            }
                            case 3: {
                                v15 = 123;
                                break;
                            }
                            case 4: {
                                v15 = 65;
                                break;
                            }
                            case 5: {
                                v15 = 22;
                                break;
                            }
                            default: {
                                v15 = 41;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4D0B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 168;
                    case 1 -> 8;
                    case 2 -> 226;
                    case 3 -> 203;
                    case 4 -> 211;
                    case 5 -> 243;
                    case 6 -> 137;
                    case 7 -> 29;
                    case 8 -> 26;
                    case 9 -> 61;
                    case 10 -> 183;
                    case 11 -> 103;
                    case 12 -> 214;
                    case 13 -> 116;
                    case 14 -> 236;
                    case 15 -> 252;
                    case 16 -> 3;
                    case 17 -> 109;
                    case 18 -> 163;
                    case 19 -> 51;
                    case 20 -> 23;
                    case 21 -> 180;
                    case 22 -> 48;
                    case 23 -> 120;
                    case 24 -> 202;
                    case 25 -> 228;
                    case 26 -> 167;
                    case 27 -> 207;
                    case 28 -> 22;
                    case 29 -> 161;
                    case 30 -> 205;
                    case 31 -> 19;
                    case 32 -> 170;
                    case 33 -> 198;
                    case 34 -> 76;
                    case 35 -> 223;
                    case 36 -> 11;
                    case 37 -> 153;
                    case 38 -> 6;
                    case 39 -> 174;
                    case 40 -> 151;
                    case 41 -> 83;
                    case 42 -> 245;
                    case 43 -> 190;
                    case 44 -> 145;
                    case 45 -> 92;
                    case 46 -> 212;
                    case 47 -> 99;
                    case 48 -> 179;
                    case 49 -> 209;
                    case 50 -> 39;
                    case 51 -> 16;
                    case 52 -> 36;
                    case 53 -> 154;
                    case 54 -> 106;
                    case 55 -> 72;
                    case 56 -> 98;
                    case 57 -> 112;
                    case 58 -> 158;
                    case 59 -> 165;
                    case 60 -> 105;
                    case 61 -> 73;
                    case 62 -> 135;
                    case 63 -> 7;
                    case 64 -> 13;
                    case 65 -> 150;
                    case 66 -> 114;
                    case 67 -> 85;
                    case 68 -> 177;
                    case 69 -> 35;
                    case 70 -> 55;
                    case 71 -> 127;
                    case 72 -> 176;
                    case 73 -> 104;
                    case 74 -> 131;
                    case 75 -> 185;
                    case 76 -> 217;
                    case 77 -> 232;
                    case 78 -> 201;
                    case 79 -> 69;
                    case 80 -> 129;
                    case 81 -> 54;
                    case 82 -> 10;
                    case 83 -> 247;
                    case 84 -> 173;
                    case 85 -> 144;
                    case 86 -> 101;
                    case 87 -> 93;
                    case 88 -> 126;
                    case 89 -> 218;
                    case 90 -> 119;
                    case 91 -> 15;
                    case 92 -> 189;
                    case 93 -> 152;
                    case 94 -> 113;
                    case 95 -> 192;
                    case 96 -> 70;
                    case 97 -> 149;
                    case 98 -> 118;
                    case 99 -> 187;
                    case 100 -> 231;
                    case 101 -> 18;
                    case 102 -> 68;
                    case 103 -> 239;
                    case 104 -> 157;
                    case 105 -> 156;
                    case 106 -> 97;
                    case 107 -> 38;
                    case 108 -> 122;
                    case 109 -> 81;
                    case 110 -> 56;
                    case 111 -> 45;
                    case 112 -> 140;
                    case 113 -> 233;
                    case 114 -> 79;
                    case 115 -> 200;
                    case 116 -> 133;
                    case 117 -> 64;
                    case 118 -> 254;
                    case 119 -> 50;
                    case 120 -> 9;
                    case 121 -> 25;
                    case 122 -> 237;
                    case 123 -> 235;
                    case 124 -> 199;
                    case 125 -> 46;
                    case 126 -> 244;
                    case 127 -> 65;
                    case 128 -> 28;
                    case 129 -> 225;
                    case 130 -> 100;
                    case 131 -> 196;
                    case 132 -> 128;
                    case 133 -> 206;
                    case 134 -> 115;
                    case 135 -> 0;
                    case 136 -> 21;
                    case 137 -> 166;
                    case 138 -> 108;
                    case 139 -> 160;
                    case 140 -> 178;
                    case 141 -> 84;
                    case 142 -> 221;
                    case 143 -> 182;
                    case 144 -> 197;
                    case 145 -> 14;
                    case 146 -> 44;
                    case 147 -> 250;
                    case 148 -> 52;
                    case 149 -> 132;
                    case 150 -> 74;
                    case 151 -> 82;
                    case 152 -> 94;
                    case 153 -> 171;
                    case 154 -> 71;
                    case 155 -> 162;
                    case 156 -> 60;
                    case 157 -> 210;
                    case 158 -> 67;
                    case 159 -> 148;
                    case 160 -> 102;
                    case 161 -> 230;
                    case 162 -> 37;
                    case 163 -> 146;
                    case 164 -> 224;
                    case 165 -> 241;
                    case 166 -> 172;
                    case 167 -> 20;
                    case 168 -> 41;
                    case 169 -> 195;
                    case 170 -> 216;
                    case 171 -> 96;
                    case 172 -> 215;
                    case 173 -> 249;
                    case 174 -> 248;
                    case 175 -> 139;
                    case 176 -> 141;
                    case 177 -> 27;
                    case 178 -> 143;
                    case 179 -> 246;
                    case 180 -> 240;
                    case 181 -> 136;
                    case 182 -> 222;
                    case 183 -> 77;
                    case 184 -> 181;
                    case 185 -> 238;
                    case 186 -> 43;
                    case 187 -> 117;
                    case 188 -> 42;
                    case 189 -> 110;
                    case 190 -> 204;
                    case 191 -> 87;
                    case 192 -> 188;
                    case 193 -> 111;
                    case 194 -> 208;
                    case 195 -> 193;
                    case 196 -> 62;
                    case 197 -> 90;
                    case 198 -> 123;
                    case 199 -> 17;
                    case 200 -> 242;
                    case 201 -> 75;
                    case 202 -> 80;
                    case 203 -> 251;
                    case 204 -> 124;
                    case 205 -> 147;
                    case 206 -> 255;
                    case 207 -> 186;
                    case 208 -> 164;
                    case 209 -> 2;
                    case 210 -> 5;
                    case 211 -> 40;
                    case 212 -> 234;
                    case 213 -> 159;
                    case 214 -> 134;
                    case 215 -> 191;
                    case 216 -> 12;
                    case 217 -> 227;
                    case 218 -> 58;
                    case 219 -> 33;
                    case 220 -> 63;
                    case 221 -> 95;
                    case 222 -> 32;
                    case 223 -> 53;
                    case 224 -> 89;
                    case 225 -> 4;
                    case 226 -> 47;
                    case 227 -> 220;
                    case 228 -> 78;
                    case 229 -> 34;
                    case 230 -> 86;
                    case 231 -> 194;
                    case 232 -> 219;
                    case 233 -> 49;
                    case 234 -> 142;
                    case 235 -> 175;
                    case 236 -> 130;
                    case 237 -> 59;
                    case 238 -> 1;
                    case 239 -> 24;
                    case 240 -> 121;
                    case 241 -> 66;
                    case 242 -> 169;
                    case 243 -> 91;
                    case 244 -> 30;
                    case 245 -> 213;
                    case 246 -> 107;
                    case 247 -> 155;
                    case 248 -> 31;
                    case 249 -> 253;
                    case 250 -> 138;
                    case 251 -> 57;
                    case 252 -> 125;
                    case 253 -> 229;
                    case 254 -> 88;
                    default -> 184;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 15436232766827L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0016PQ6(m$O\t\u0011ZB<e/9S\u001c";
                    var5_4 = "\u0016PQ6(m$O\t\u0011ZB<e/9S\u001c".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 21;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 104;
                                    break;
                                }
                                case 1: {
                                    v11 = 32;
                                    break;
                                }
                                case 2: {
                                    v11 = 54;
                                    break;
                                }
                                case 3: {
                                    v11 = 77;
                                    break;
                                }
                                case 4: {
                                    v11 = 88;
                                    break;
                                }
                                case 5: {
                                    v11 = 20;
                                    break;
                                }
                                default: {
                                    v11 = 2;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 115418542930203L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "f\u007flO\u001e\u001e(\u0004`a`U\nl~kU\u0012\u001c0F\u007fb\tl~kU\u0012\u001c0Ju\rkxvX\u0018\u0011*JrqR\u0019\u0018";
                    var5_4 = "f\u007flO\u001e\u001e(\u0004`a`U\nl~kU\u0012\u001c0F\u007fb\tl~kU\u0012\u001c0Ju\rkxvX\u0018\u0011*JrqR\u0019\u0018".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 73;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "SBUw!.\u001c\u0006SBUw-$";
                        var5_4 = "SBUw!.\u001c\u0006SBUw-$".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 118;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 102;
                                break;
                            }
                            case 1: {
                                v15 = 88;
                                break;
                            }
                            case 2: {
                                v15 = 76;
                                break;
                            }
                            case 3: {
                                v15 = 114;
                                break;
                            }
                            case 4: {
                                v15 = 62;
                                break;
                            }
                            case 5: {
                                v15 = 54;
                                break;
                            }
                            default: {
                                v15 = 13;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 93507375528990L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1642569240 - (char)-3561, 1642569240 - (char)-1731, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 75398651097857L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00a7\u0001\u00c9\u0010\u00b3\u0003m\u001c$\u0005\u0084\u008d\u008bE\u0018\rV\u0096\u00e7l`\u0018\\\u0094\u00a5-D\u00f8\u009a\u0010\"W\u00ae\u00bfv\u00f7\u00b5TQ\u00b19&\u00d3ki\u00dc\u0005\u0089\u0003*\u0094,3\u00e6W\u00d6i\u00aci\u00de\u0093A\u00b4\u00b0\u00af$\u000b\u00bb\u00cf4\u00b3\u00ec\u00d8\u0015Y\u00f2\u00bdi\u00d0Z-\u00ca\u00bb%\u00ee\f\u008b\u0081\u00ed\u00ee+\u008f\u0010@p\u0092\u00e2\u00023'\u001a\u00d7\u00c8-";
                    var4_3 = "\u00a7\u0001\u00c9\u0010\u00b3\u0003m\u001c$\u0005\u0084\u008d\u008bE\u0018\rV\u0096\u00e7l`\u0018\\\u0094\u00a5-D\u00f8\u009a\u0010\"W\u00ae\u00bfv\u00f7\u00b5TQ\u00b19&\u00d3ki\u00dc\u0005\u0089\u0003*\u0094,3\u00e6W\u00d6i\u00aci\u00de\u0093A\u00b4\u00b0\u00af$\u000b\u00bb\u00cf4\u00b3\u00ec\u00d8\u0015Y\u00f2\u00bdi\u00d0Z-\u00ca\u00bb%\u00ee\f\u008b\u0081\u00ed\u00ee+\u008f\u0010@p\u0092\u00e2\u00023'\u001a\u00d7\u00c8-".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 92;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u000f\u00cf\u00f2U\u0004S\u00029^\u00e5!U)\u00fc\u00cf\u00d7L\u00df\u00e7\u001f\u009a\u0093b\u009eqD\u007f\u00ce\u00bf\u00da/\"\u00d4\u00fb\u00f8\u0013\u00be{\b\u00ec\u00ccp\u00ec\u00a5\u00956\u001c\u00ac\u008c\u00d4\u00d0\u0012cW\u00dd{Q\u0011\\\u008e\u00e3m4\u00f8;'!\"W-\u0082\r\u00a7P2y/[_Q[\u00fd#\u00f0Jwj\u00c1\u00ach\u00c8l/";
                        var4_3 = "\u000f\u00cf\u00f2U\u0004S\u00029^\u00e5!U)\u00fc\u00cf\u00d7L\u00df\u00e7\u001f\u009a\u0093b\u009eqD\u007f\u00ce\u00bf\u00da/\"\u00d4\u00fb\u00f8\u0013\u00be{\b\u00ec\u00ccp\u00ec\u00a5\u00956\u001c\u00ac\u008c\u00d4\u00d0\u0012cW\u00dd{Q\u0011\\\u008e\u00e3m4\u00f8;'!\"W-\u0082\r\u00a7P2y/[_Q[\u00fd#\u00f0Jwj\u00c1\u00ach\u00c8l/".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 98;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 36;
                                break;
                            }
                            case 1: {
                                v15 = 107;
                                break;
                            }
                            case 2: {
                                v15 = 70;
                                break;
                            }
                            case 3: {
                                v15 = 111;
                                break;
                            }
                            case 4: {
                                v15 = 40;
                                break;
                            }
                            case 5: {
                                v15 = 41;
                                break;
                            }
                            default: {
                                v15 = 126;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x501F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 44;
                    case 1 -> 102;
                    case 2 -> 53;
                    case 3 -> 15;
                    case 4 -> 169;
                    case 5 -> 251;
                    case 6 -> 149;
                    case 7 -> 152;
                    case 8 -> 154;
                    case 9 -> 244;
                    case 10 -> 146;
                    case 11 -> 18;
                    case 12 -> 202;
                    case 13 -> 126;
                    case 14 -> 165;
                    case 15 -> 212;
                    case 16 -> 128;
                    case 17 -> 225;
                    case 18 -> 215;
                    case 19 -> 156;
                    case 20 -> 59;
                    case 21 -> 100;
                    case 22 -> 129;
                    case 23 -> 227;
                    case 24 -> 89;
                    case 25 -> 110;
                    case 26 -> 222;
                    case 27 -> 17;
                    case 28 -> 69;
                    case 29 -> 103;
                    case 30 -> 14;
                    case 31 -> 67;
                    case 32 -> 51;
                    case 33 -> 35;
                    case 34 -> 94;
                    case 35 -> 239;
                    case 36 -> 162;
                    case 37 -> 61;
                    case 38 -> 216;
                    case 39 -> 236;
                    case 40 -> 23;
                    case 41 -> 155;
                    case 42 -> 43;
                    case 43 -> 223;
                    case 44 -> 88;
                    case 45 -> 191;
                    case 46 -> 98;
                    case 47 -> 85;
                    case 48 -> 240;
                    case 49 -> 237;
                    case 50 -> 228;
                    case 51 -> 111;
                    case 52 -> 133;
                    case 53 -> 80;
                    case 54 -> 226;
                    case 55 -> 46;
                    case 56 -> 163;
                    case 57 -> 194;
                    case 58 -> 242;
                    case 59 -> 166;
                    case 60 -> 117;
                    case 61 -> 90;
                    case 62 -> 11;
                    case 63 -> 65;
                    case 64 -> 3;
                    case 65 -> 50;
                    case 66 -> 168;
                    case 67 -> 52;
                    case 68 -> 8;
                    case 69 -> 192;
                    case 70 -> 64;
                    case 71 -> 198;
                    case 72 -> 195;
                    case 73 -> 39;
                    case 74 -> 57;
                    case 75 -> 95;
                    case 76 -> 161;
                    case 77 -> 74;
                    case 78 -> 153;
                    case 79 -> 174;
                    case 80 -> 179;
                    case 81 -> 91;
                    case 82 -> 109;
                    case 83 -> 220;
                    case 84 -> 148;
                    case 85 -> 82;
                    case 86 -> 93;
                    case 87 -> 122;
                    case 88 -> 1;
                    case 89 -> 13;
                    case 90 -> 12;
                    case 91 -> 245;
                    case 92 -> 173;
                    case 93 -> 30;
                    case 94 -> 203;
                    case 95 -> 158;
                    case 96 -> 118;
                    case 97 -> 75;
                    case 98 -> 92;
                    case 99 -> 247;
                    case 100 -> 21;
                    case 101 -> 130;
                    case 102 -> 124;
                    case 103 -> 58;
                    case 104 -> 119;
                    case 105 -> 224;
                    case 106 -> 0;
                    case 107 -> 207;
                    case 108 -> 86;
                    case 109 -> 87;
                    case 110 -> 2;
                    case 111 -> 40;
                    case 112 -> 47;
                    case 113 -> 188;
                    case 114 -> 221;
                    case 115 -> 5;
                    case 116 -> 76;
                    case 117 -> 56;
                    case 118 -> 213;
                    case 119 -> 230;
                    case 120 -> 107;
                    case 121 -> 145;
                    case 122 -> 229;
                    case 123 -> 241;
                    case 124 -> 45;
                    case 125 -> 72;
                    case 126 -> 167;
                    case 127 -> 63;
                    case 128 -> 123;
                    case 129 -> 181;
                    case 130 -> 115;
                    case 131 -> 134;
                    case 132 -> 116;
                    case 133 -> 177;
                    case 134 -> 217;
                    case 135 -> 196;
                    case 136 -> 190;
                    case 137 -> 164;
                    case 138 -> 84;
                    case 139 -> 199;
                    case 140 -> 206;
                    case 141 -> 157;
                    case 142 -> 135;
                    case 143 -> 182;
                    case 144 -> 28;
                    case 145 -> 34;
                    case 146 -> 183;
                    case 147 -> 68;
                    case 148 -> 150;
                    case 149 -> 235;
                    case 150 -> 4;
                    case 151 -> 108;
                    case 152 -> 205;
                    case 153 -> 250;
                    case 154 -> 70;
                    case 155 -> 141;
                    case 156 -> 159;
                    case 157 -> 243;
                    case 158 -> 143;
                    case 159 -> 246;
                    case 160 -> 193;
                    case 161 -> 234;
                    case 162 -> 20;
                    case 163 -> 170;
                    case 164 -> 209;
                    case 165 -> 180;
                    case 166 -> 66;
                    case 167 -> 248;
                    case 168 -> 19;
                    case 169 -> 99;
                    case 170 -> 101;
                    case 171 -> 219;
                    case 172 -> 42;
                    case 173 -> 136;
                    case 174 -> 137;
                    case 175 -> 125;
                    case 176 -> 131;
                    case 177 -> 33;
                    case 178 -> 77;
                    case 179 -> 184;
                    case 180 -> 112;
                    case 181 -> 22;
                    case 182 -> 200;
                    case 183 -> 232;
                    case 184 -> 32;
                    case 185 -> 120;
                    case 186 -> 132;
                    case 187 -> 113;
                    case 188 -> 97;
                    case 189 -> 54;
                    case 190 -> 55;
                    case 191 -> 218;
                    case 192 -> 83;
                    case 193 -> 105;
                    case 194 -> 114;
                    case 195 -> 71;
                    case 196 -> 27;
                    case 197 -> 185;
                    case 198 -> 253;
                    case 199 -> 254;
                    case 200 -> 9;
                    case 201 -> 41;
                    case 202 -> 204;
                    case 203 -> 210;
                    case 204 -> 16;
                    case 205 -> 172;
                    case 206 -> 214;
                    case 207 -> 81;
                    case 208 -> 106;
                    case 209 -> 78;
                    case 210 -> 211;
                    case 211 -> 144;
                    case 212 -> 49;
                    case 213 -> 231;
                    case 214 -> 187;
                    case 215 -> 26;
                    case 216 -> 139;
                    case 217 -> 249;
                    case 218 -> 60;
                    case 219 -> 24;
                    case 220 -> 6;
                    case 221 -> 96;
                    case 222 -> 197;
                    case 223 -> 7;
                    case 224 -> 189;
                    case 225 -> 29;
                    case 226 -> 208;
                    case 227 -> 160;
                    case 228 -> 73;
                    case 229 -> 104;
                    case 230 -> 151;
                    case 231 -> 127;
                    case 232 -> 138;
                    case 233 -> 10;
                    case 234 -> 31;
                    case 235 -> 142;
                    case 236 -> 186;
                    case 237 -> 176;
                    case 238 -> 62;
                    case 239 -> 252;
                    case 240 -> 48;
                    case 241 -> 25;
                    case 242 -> 201;
                    case 243 -> 36;
                    case 244 -> 121;
                    case 245 -> 255;
                    case 246 -> 38;
                    case 247 -> 79;
                    case 248 -> 37;
                    case 249 -> 140;
                    case 250 -> 178;
                    case 251 -> 238;
                    case 252 -> 175;
                    case 253 -> 147;
                    case 254 -> 233;
                    default -> 171;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 125269131433716L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2115338730 - -((char)-30465), 2115338730 - (char)-10144, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 76861858360962L;
                    int n3 = SshAgentIpcService.E();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(876334020 + 29598, -876334020 + -24382, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 64744014704684L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00d8\u00de\u0014\f^\u0003<~\u00de";
                var4_3 = "\u00d8\u00de\u0014\f^\u0003<~\u00de".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 19;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 106;
                                break;
                            }
                            case 1: {
                                v11 = 43;
                                break;
                            }
                            case 2: {
                                v11 = 27;
                                break;
                            }
                            case 3: {
                                v11 = 38;
                                break;
                            }
                            case 4: {
                                v11 = 115;
                                break;
                            }
                            case 5: {
                                v11 = 82;
                                break;
                            }
                            default: {
                                v11 = 80;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF91E1) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 19;
                    case 1 -> 55;
                    case 2 -> 142;
                    case 3 -> 8;
                    case 4 -> 5;
                    case 5 -> 147;
                    case 6 -> 48;
                    case 7 -> 174;
                    case 8 -> 218;
                    case 9 -> 200;
                    case 10 -> 250;
                    case 11 -> 245;
                    case 12 -> 191;
                    case 13 -> 246;
                    case 14 -> 78;
                    case 15 -> 208;
                    case 16 -> 14;
                    case 17 -> 90;
                    case 18 -> 203;
                    case 19 -> 125;
                    case 20 -> 214;
                    case 21 -> 123;
                    case 22 -> 178;
                    case 23 -> 201;
                    case 24 -> 249;
                    case 25 -> 241;
                    case 26 -> 99;
                    case 27 -> 175;
                    case 28 -> 93;
                    case 29 -> 221;
                    case 30 -> 167;
                    case 31 -> 251;
                    case 32 -> 38;
                    case 33 -> 255;
                    case 34 -> 172;
                    case 35 -> 231;
                    case 36 -> 248;
                    case 37 -> 75;
                    case 38 -> 59;
                    case 39 -> 15;
                    case 40 -> 13;
                    case 41 -> 207;
                    case 42 -> 1;
                    case 43 -> 132;
                    case 44 -> 183;
                    case 45 -> 3;
                    case 46 -> 254;
                    case 47 -> 180;
                    case 48 -> 196;
                    case 49 -> 44;
                    case 50 -> 136;
                    case 51 -> 80;
                    case 52 -> 76;
                    case 53 -> 92;
                    case 54 -> 4;
                    case 55 -> 119;
                    case 56 -> 211;
                    case 57 -> 96;
                    case 58 -> 158;
                    case 59 -> 145;
                    case 60 -> 233;
                    case 61 -> 154;
                    case 62 -> 193;
                    case 63 -> 155;
                    case 64 -> 50;
                    case 65 -> 247;
                    case 66 -> 166;
                    case 67 -> 187;
                    case 68 -> 21;
                    case 69 -> 70;
                    case 70 -> 170;
                    case 71 -> 24;
                    case 72 -> 34;
                    case 73 -> 113;
                    case 74 -> 16;
                    case 75 -> 131;
                    case 76 -> 209;
                    case 77 -> 66;
                    case 78 -> 135;
                    case 79 -> 27;
                    case 80 -> 157;
                    case 81 -> 97;
                    case 82 -> 109;
                    case 83 -> 139;
                    case 84 -> 22;
                    case 85 -> 235;
                    case 86 -> 230;
                    case 87 -> 54;
                    case 88 -> 228;
                    case 89 -> 65;
                    case 90 -> 104;
                    case 91 -> 137;
                    case 92 -> 159;
                    case 93 -> 39;
                    case 94 -> 106;
                    case 95 -> 138;
                    case 96 -> 69;
                    case 97 -> 213;
                    case 98 -> 232;
                    case 99 -> 192;
                    case 100 -> 252;
                    case 101 -> 35;
                    case 102 -> 146;
                    case 103 -> 144;
                    case 104 -> 101;
                    case 105 -> 220;
                    case 106 -> 18;
                    case 107 -> 239;
                    case 108 -> 156;
                    case 109 -> 20;
                    case 110 -> 120;
                    case 111 -> 122;
                    case 112 -> 150;
                    case 113 -> 202;
                    case 114 -> 216;
                    case 115 -> 71;
                    case 116 -> 197;
                    case 117 -> 168;
                    case 118 -> 67;
                    case 119 -> 133;
                    case 120 -> 141;
                    case 121 -> 215;
                    case 122 -> 10;
                    case 123 -> 11;
                    case 124 -> 181;
                    case 125 -> 116;
                    case 126 -> 143;
                    case 127 -> 31;
                    case 128 -> 118;
                    case 129 -> 237;
                    case 130 -> 112;
                    case 131 -> 7;
                    case 132 -> 98;
                    case 133 -> 105;
                    case 134 -> 100;
                    case 135 -> 32;
                    case 136 -> 60;
                    case 137 -> 128;
                    case 138 -> 176;
                    case 139 -> 82;
                    case 140 -> 17;
                    case 141 -> 28;
                    case 142 -> 186;
                    case 143 -> 102;
                    case 144 -> 103;
                    case 145 -> 226;
                    case 146 -> 94;
                    case 147 -> 184;
                    case 148 -> 163;
                    case 149 -> 85;
                    case 150 -> 33;
                    case 151 -> 210;
                    case 152 -> 229;
                    case 153 -> 162;
                    case 154 -> 87;
                    case 155 -> 223;
                    case 156 -> 12;
                    case 157 -> 79;
                    case 158 -> 73;
                    case 159 -> 124;
                    case 160 -> 182;
                    case 161 -> 190;
                    case 162 -> 41;
                    case 163 -> 77;
                    case 164 -> 43;
                    case 165 -> 242;
                    case 166 -> 37;
                    case 167 -> 61;
                    case 168 -> 127;
                    case 169 -> 64;
                    case 170 -> 238;
                    case 171 -> 177;
                    case 172 -> 199;
                    case 173 -> 47;
                    case 174 -> 217;
                    case 175 -> 222;
                    case 176 -> 152;
                    case 177 -> 188;
                    case 178 -> 63;
                    case 179 -> 26;
                    case 180 -> 108;
                    case 181 -> 212;
                    case 182 -> 243;
                    case 183 -> 95;
                    case 184 -> 114;
                    case 185 -> 169;
                    case 186 -> 89;
                    case 187 -> 46;
                    case 188 -> 160;
                    case 189 -> 72;
                    case 190 -> 0;
                    case 191 -> 149;
                    case 192 -> 57;
                    case 193 -> 115;
                    case 194 -> 179;
                    case 195 -> 198;
                    case 196 -> 6;
                    case 197 -> 185;
                    case 198 -> 151;
                    case 199 -> 227;
                    case 200 -> 86;
                    case 201 -> 219;
                    case 202 -> 121;
                    case 203 -> 236;
                    case 204 -> 58;
                    case 205 -> 206;
                    case 206 -> 234;
                    case 207 -> 2;
                    case 208 -> 51;
                    case 209 -> 171;
                    case 210 -> 130;
                    case 211 -> 205;
                    case 212 -> 81;
                    case 213 -> 30;
                    case 214 -> 111;
                    case 215 -> 83;
                    case 216 -> 164;
                    case 217 -> 165;
                    case 218 -> 110;
                    case 219 -> 161;
                    case 220 -> 62;
                    case 221 -> 25;
                    case 222 -> 42;
                    case 223 -> 88;
                    case 224 -> 148;
                    case 225 -> 9;
                    case 226 -> 23;
                    case 227 -> 29;
                    case 228 -> 74;
                    case 229 -> 204;
                    case 230 -> 189;
                    case 231 -> 49;
                    case 232 -> 194;
                    case 233 -> 134;
                    case 234 -> 173;
                    case 235 -> 153;
                    case 236 -> 117;
                    case 237 -> 53;
                    case 238 -> 240;
                    case 239 -> 253;
                    case 240 -> 129;
                    case 241 -> 68;
                    case 242 -> 40;
                    case 243 -> 225;
                    case 244 -> 140;
                    case 245 -> 45;
                    case 246 -> 84;
                    case 247 -> 195;
                    case 248 -> 244;
                    case 249 -> 224;
                    case 250 -> 52;
                    case 251 -> 36;
                    case 252 -> 107;
                    case 253 -> 91;
                    case 254 -> 126;
                    default -> 56;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

