/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRemoveRedundantElseIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";

    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("trivialif.remove-redundant-else.display-name", new Object[0]);
        if (string == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("trivialif.remove-redundant-else.family-name", new Object[0]);
        if (string == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new RemoveRedundantElsePredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(3);
        }
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> JSRemoveRedundantElseIntention.doProcessIntention(element));
    }

    private static void doProcessIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(4);
        }
        JSIfStatement ifStatement = (JSIfStatement)element;
        JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
        JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
        assert (thenBranch != null);
        assert (elseBranch != null);
        String newIfText = IF_STATEMENT_PREFIX + Objects.requireNonNull(ifStatement.getCondition()).getText() + ")" + thenBranch.getText();
        JSIfStatement anchor = ifStatement;
        while (anchor.getParent() instanceof JSIfStatement) {
            anchor = anchor.getParent();
        }
        if (elseBranch instanceof JSBlockStatement) {
            int finalIndex;
            PsiElement[] children = elseBranch.getChildren();
            for (finalIndex = children.length - 2; finalIndex >= 0 && children[finalIndex] instanceof PsiWhiteSpace; --finalIndex) {
            }
            PsiElement parent = anchor.getParent();
            for (int i = 1; i <= finalIndex; ++i) {
                PsiElement psiElement = children[i];
                anchor = JSChangeUtil.doAddAfter((PsiElement)parent, (PsiElement)psiElement, (PsiElement)anchor);
            }
        } else {
            anchor = JSChangeUtil.doAddAfter((PsiElement)anchor.getParent(), (PsiElement)elseBranch, (PsiElement)anchor);
        }
        Document document = ifStatement.getContainingFile().getViewProvider().getDocument();
        boolean isTheOnlyStatement = anchor == ifStatement;
        JSIfStatement newIfStatement = (JSIfStatement)JSPsiElementFactory.createJSStatement((String)newIfText, (PsiElement)element, JSIfStatement.class);
        SmartPsiElementPointer anchorPointer = SmartPointerManager.createPointer((PsiElement)anchor);
        ifStatement = (JSIfStatement)ifStatement.replace((JSStatement)newIfStatement);
        if (document != null) {
            FormatFixer.create((PsiElement)ifStatement, (PsiElement)(isTheOnlyStatement ? ifStatement : (PsiElement)ObjectUtils.coalesce((Object)anchorPointer.getElement(), (Object)ifStatement)), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(7);
        }
        super.generatePreview(project, editor, psiFile);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF_NO_TRIM;
        if (intentionPreviewInfo == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(8);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doProcessIntention";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class RemoveRedundantElsePredicate
    implements JSElementPredicate {
        private RemoveRedundantElsePredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveRedundantElsePredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)element;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
            JSSourceElement thenBranch = (JSSourceElement)ifStatement.getThenBranch();
            if (elseBranch == null) {
                return false;
            }
            while (thenBranch instanceof JSBlockStatement) {
                Object[] thenStatements = ((JSBlockStatement)thenBranch).getStatementListItems();
                JSSourceElement lastStatement = (JSSourceElement)ArrayUtil.getLastElement((Object[])thenStatements);
                if (lastStatement instanceof JSFunctionExitPoint || lastStatement instanceof JSBreakStatement || lastStatement instanceof JSContinueStatement) {
                    return true;
                }
                thenBranch = lastStatement;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention$RemoveRedundantElsePredicate", "satisfiedBy"));
        }
    }
}

