/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.network;

import com.github.dockerjava.api.model.Network;
import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.action.networks.ConnectNetworkDialogKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldCellRenderer;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.docker.view.details.DockerAbstractDashboardTab;
import com.intellij.docker.view.details.DockerAbstractDashboardTabKt;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.docker.view.details.network.ContainerCell;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/view/details/network/DockerNetworkDashboardTab;", "Lcom/intellij/docker/view/details/DockerAbstractDashboardTab;", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "runtime", "<init>", "(Lcom/intellij/docker/view/details/DockerTabManager;Lcom/intellij/docker/runtimes/DockerNetworkRuntime;)V", "myContainersModel", "Ljavax/swing/DefaultListModel;", "Lcom/intellij/docker/view/details/network/ContainerCell;", "myLabelsModel", "Lkotlin/Pair;", "", "myIpamModel", "Lcom/github/dockerjava/api/model/Network$Ipam$Config;", "createScaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "onRefreshTab", "", "selected", "", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerNetworkDashboardTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerNetworkDashboardTab.kt\ncom/intellij/docker/view/details/network/DockerNetworkDashboardTab\n+ 2 DockerRuntimeContext.kt\ncom/intellij/docker/runtimes/DockerRuntimeContextKt\n+ 3 dockerUtils.kt\ncom/intellij/docker/utils/DockerUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n23#2:126\n99#3:127\n808#4,11:128\n1#5:139\n1#5:140\n*S KotlinDebug\n*F\n+ 1 DockerNetworkDashboardTab.kt\ncom/intellij/docker/view/details/network/DockerNetworkDashboardTab\n*L\n118#1:126\n118#1:127\n118#1:128,11\n118#1:139\n*E\n"})
public final class DockerNetworkDashboardTab
extends DockerAbstractDashboardTab<DockerNetworkRuntime> {
    @NotNull
    private final DefaultListModel<ContainerCell> myContainersModel;
    @NotNull
    private final DefaultListModel<Pair<String, String>> myLabelsModel;
    @NotNull
    private final DefaultListModel<Network.Ipam.Config> myIpamModel;

    public DockerNetworkDashboardTab(@NotNull DockerTabManager tabManager, @NotNull DockerNetworkRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        super(tabManager, runtime, null, 4, null);
        this.myContainersModel = new DefaultListModel();
        this.myLabelsModel = new DefaultListModel();
        this.myIpamModel = new DefaultListModel();
    }

    @Override
    @NotNull
    protected Scaffold createScaffold() {
        return new Scaffold((Function1<? super Scaffold, Unit>)((Function1)arg_0 -> DockerNetworkDashboardTab.createScaffold$lambda$14(this, arg_0)));
    }

    @Override
    protected void onRefreshTab(boolean selected) {
        Set set;
        Sequence sequence;
        Sequence sequence2;
        Object object;
        Object labels;
        Object object2 = ((DockerNetworkRuntime)this.getRuntime()).getNetwork().labels;
        if (object2 == null || (object2 = MapsKt.toList((Map)object2)) == null || (object2 = CollectionsKt.toSet((Iterable)((Iterable)object2))) == null) {
            object2 = labels = SetsKt.emptySet();
        }
        if ((object = ((DockerNetworkRuntime)this.getRuntime()).getNetwork().getIpam()) == null || (object = object.getConfig()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        Object ipam = object;
        Map map = ((DockerNetworkRuntime)this.getRuntime()).getNetwork().getContainers();
        Set containers2 = map != null && (sequence2 = MapsKt.asSequence((Map)map)) != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence2, arg_0 -> DockerNetworkDashboardTab.onRefreshTab$lambda$16(this, arg_0))) != null && (set = SequencesKt.toSet((Sequence)sequence)) != null ? set : SetsKt.emptySet();
        DockerUiUtilsKt.refreshIfNeeded(this.myContainersModel, containers2);
        DockerUiUtilsKt.refreshIfNeeded(this.myIpamModel, ipam);
        DockerUiUtilsKt.refreshIfNeeded(this.myLabelsModel, labels);
    }

    private static final Unit createScaffold$lambda$14$lambda$6$lambda$2$lambda$1$lambda$0(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DockerUiUtilsKt.dockerErrorNotification$default(it, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$6$lambda$2$lambda$1(DockerNetworkDashboardTab this$0) {
        String result2 = ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult(this$0.getProject(), ((DockerNetworkRuntime)this$0.getRuntime()).getContext(), ((DockerNetworkRuntime)this$0.getRuntime()).getNetwork());
        if (result2 != null) {
            InternalUtilsKt.exceptionallyAsyncOnEdt(DockerNetworkRuntime.connectContainer$default((DockerNetworkRuntime)this$0.getRuntime(), result2, null, 2, null), DockerNetworkDashboardTab::createScaffold$lambda$14$lambda$6$lambda$2$lambda$1$lambda$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$6$lambda$2(DockerNetworkDashboardTab this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.append(DockerBundle.message((String)"DockerNetworkDetails.ContainersEditor.title", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        DockerAbstractDashboardTabKt.appendStandardAddAction($this$textFragment, (Function0<Unit>)((Function0)() -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$6$lambda$2$lambda$1(this$0)));
        return Unit.INSTANCE;
    }

    private static final void createScaffold$lambda$14$lambda$6$lambda$5$lambda$3(ContainerCell $cell) {
        DockerUiUtilsKt.select($cell.getContainer());
    }

    private static final Unit createScaffold$lambda$14$lambda$6$lambda$5$lambda$4(DockerNetworkDashboardTab this$0, ContainerCell $cell) {
        ((DockerNetworkRuntime)this$0.getRuntime()).disconnectContainer($cell.getContainer().getId());
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$6$lambda$5(DockerNetworkDashboardTab this$0, ScaffoldCellRenderer scaffoldCellRenderer, ContainerCell cell2) {
        Intrinsics.checkNotNullParameter((Object)scaffoldCellRenderer, (String)"<this>");
        scaffoldCellRenderer.setIcon(cell2.getContainer().getStatus().getIcon());
        String string = cell2.getContainer().getContainerName();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"/")) == null) {
            string = "<unknown>";
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"LINK_PLAIN_ATTRIBUTES");
        scaffoldCellRenderer.append(string, simpleTextAttributes, () -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$6$lambda$5$lambda$3(cell2));
        scaffoldCellRenderer.append("  ");
        String string2 = cell2.getConfig().getIpv4Address();
        if (string2 == null) {
            string2 = cell2.getConfig().getIpv6Address();
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
        scaffoldCellRenderer.append(string3, simpleTextAttributes2);
        Icon icon = AllIcons.Actions.Cancel;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Cancel");
        String string4 = DockerBundle.message((String)"DockerNetworkDetails.DockerNetworkDashboardTab.disconnect", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        scaffoldCellRenderer.action(icon, string4, (Function0<Unit>)((Function0)() -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$6$lambda$5$lambda$4(this$0, cell2)));
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$6(DockerNetworkDashboardTab this$0, Scaffold.SegmentWithElements $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$6$lambda$2(this$0, arg_0)));
        $this$segment.setCellRenderer((arg_0, arg_1) -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$6$lambda$5(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$9$lambda$7(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.append(DockerBundle.message((String)"DockerRuntimeLabelsTab.tab.title", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$9$lambda$8(ScaffoldCellRenderer scaffoldCellRenderer, Pair it) {
        Intrinsics.checkNotNullParameter((Object)scaffoldCellRenderer, (String)"<this>");
        scaffoldCellRenderer.append(DockerUiUtilsKt.asNlsSafe((String)it.getFirst()));
        scaffoldCellRenderer.append(" = ");
        String string = DockerUiUtilsKt.asNlsSafe((String)it.getSecond());
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
        scaffoldCellRenderer.append(string, simpleTextAttributes);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$9(Scaffold.SegmentWithElements $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)DockerNetworkDashboardTab::createScaffold$lambda$14$lambda$9$lambda$7));
        $this$segment.setCellRenderer(DockerNetworkDashboardTab::createScaffold$lambda$14$lambda$9$lambda$8);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$13$lambda$10(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.append(DockerBundle.message((String)"DockerNetworkDetails.IpamPropertiesEditor.title", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$13$lambda$11(DockerNetworkDashboardTab this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.append(DockerBundle.message((String)"DockerNetworkDetails.DockerNetworkDashboardTab.driver", (Object[])new Object[0]) + ":", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        $this$textFragment.append(" " + ((DockerNetworkRuntime)this$0.getRuntime()).getNetwork().getDriver(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$13$lambda$12(ScaffoldCellRenderer scaffoldCellRenderer, Network.Ipam.Config it) {
        Intrinsics.checkNotNullParameter((Object)scaffoldCellRenderer, (String)"<this>");
        if (it.getSubnet() != null) {
            String string = DockerBundle.message((String)"DockerNetworkDetails.DockerNetworkDashboardTab.subnet", (Object[])new Object[0]) + ":";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
            scaffoldCellRenderer.append(string, simpleTextAttributes);
            scaffoldCellRenderer.append(" " + it.getSubnet());
            scaffoldCellRenderer.append("   ");
        }
        if (it.getGateway() != null) {
            String string = DockerBundle.message((String)"DockerNetworkDetails.DockerNetworkDashboardTab.gateway", (Object[])new Object[0]) + ":";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
            scaffoldCellRenderer.append(string, simpleTextAttributes);
            scaffoldCellRenderer.append(" " + it.getGateway());
            scaffoldCellRenderer.append("   ");
        }
        if (it.getIpRange() != null) {
            String string = DockerBundle.message((String)"DockerNetworkDetails.DockerNetworkDashboardTab.ip.range", (Object[])new Object[0]) + ":";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
            scaffoldCellRenderer.append(string, simpleTextAttributes);
            scaffoldCellRenderer.append(" " + it.getIpRange());
            scaffoldCellRenderer.append("   ");
        }
        if (it.getNetworkID() != null) {
            String string = DockerBundle.message((String)"DockerNetworkDetails.DockerNetworkDashboardTab.network", (Object[])new Object[0]) + ":";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
            scaffoldCellRenderer.append(string, simpleTextAttributes);
            scaffoldCellRenderer.append(" " + it.getNetworkID());
        }
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14$lambda$13(DockerNetworkDashboardTab this$0, Scaffold.SegmentWithElements $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)DockerNetworkDashboardTab::createScaffold$lambda$14$lambda$13$lambda$10));
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$13$lambda$11(this$0, arg_0)));
        $this$segment.setCellRenderer(DockerNetworkDashboardTab::createScaffold$lambda$14$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$14(DockerNetworkDashboardTab this$0, Scaffold $this$Scaffold) {
        Intrinsics.checkNotNullParameter((Object)$this$Scaffold, (String)"$this$Scaffold");
        $this$Scaffold.segment((ListModel)this$0.myContainersModel, arg_0 -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$6(this$0, arg_0));
        $this$Scaffold.segment((ListModel)this$0.myLabelsModel, DockerNetworkDashboardTab::createScaffold$lambda$14$lambda$9);
        $this$Scaffold.segment((ListModel)this$0.myIpamModel, arg_0 -> DockerNetworkDashboardTab.createScaffold$lambda$14$lambda$13(this$0, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ContainerCell onRefreshTab$lambda$16(DockerNetworkDashboardTab this$0, Map.Entry entry) {
        ContainerCell containerCell;
        Object v0;
        Network.ContainerNetworkConfig config2;
        block4: {
            void $this$filterIsInstanceTo$iv$iv$iv$iv;
            void $this$findRuntimeById$iv$iv;
            void $this$findRuntimeById$iv;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String id = (String)entry.getKey();
            config2 = (Network.ContainerNetworkConfig)entry.getValue();
            DockerRuntimeContext dockerRuntimeContext = ((DockerNetworkRuntime)this$0.getRuntime()).getContext();
            Intrinsics.checkNotNull((Object)id);
            String id$iv = id;
            boolean $i$f$findRuntimeById = false;
            DockerRuntimesManager dockerRuntimesManager = $this$findRuntimeById$iv.getRuntimesManager();
            String id$iv$iv = id$iv;
            boolean $i$f$findRuntimeById2 = false;
            Iterable $this$filterIsInstance$iv$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus($this$findRuntimeById$iv$iv.getContainers().values(), (Iterable)$this$findRuntimeById$iv$iv.getImages().values()), (Iterable)$this$findRuntimeById$iv$iv.getNetworks().values()), (Iterable)$this$findRuntimeById$iv$iv.getVolumes().values());
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv$iv) {
                if (!(element$iv$iv$iv$iv instanceof DockerApplicationRuntime)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv$iv$iv;
            for (Object e : iterable2) {
                DockerPhysicalRuntime it$iv$iv = (DockerPhysicalRuntime)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it$iv$iv.getId(), (Object)id$iv$iv)) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)((DockerPhysicalRuntime)v0);
        if (dockerApplicationRuntime != null) {
            DockerApplicationRuntime runtime = dockerApplicationRuntime;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)config2);
            containerCell = new ContainerCell(runtime, config2);
        } else {
            containerCell = null;
        }
        return containerCell;
    }
}

