/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica.model;

import com.intellij.database.dialects.vertica.model.VertRoutine;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/vertica/model/VertModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "handleJdbcComment", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "comment", "unescape", "kotlin.jvm.PlatformType", "text", "intellij.database.dialects.vertica"})
public final class VertModelHelper
extends ModelHelper {
    @NotNull
    public static final VertModelHelper INSTANCE = new VertModelHelper();

    private VertModelHelper() {
    }

    @Nullable
    public String handleJdbcComment(@NotNull BasicModNamedElement obj, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof VertRoutine) {
            int libIdx;
            String cls = "class ";
            String inLib = " in library ";
            if (comment != null && StringsKt.startsWith((String)comment, (String)cls, (boolean)true) && (libIdx = StringsKt.indexOf$default((CharSequence)comment, (String)inLib, (int)0, (boolean)true, (int)2, null)) != -1) {
                VertRoutine vertRoutine = (VertRoutine)obj;
                String string = comment.substring(libIdx + inLib.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                vertRoutine.setLibraryName(this.unescape(string));
                VertRoutine vertRoutine2 = (VertRoutine)obj;
                String string2 = comment.substring(cls.length(), libIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                vertRoutine2.setClassName(this.unescape(string2));
                return null;
            }
            ((VertRoutine)obj).setLibraryName(null);
            ((VertRoutine)obj).setClassName(null);
            return comment;
        }
        return super.handleJdbcComment(obj, comment);
    }

    private final String unescape(String text) {
        String string;
        if (StringsKt.startsWith$default((String)text, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"'", (boolean)false, (int)2, null)) {
            String string2 = text.substring(1, StringsKt.getLastIndex((CharSequence)text));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = SqlStringLiteralManipulator.unescapeSqlStringCharacters((String)string2, (SqlStringLiteralManipulator.LiteralType)SqlStringLiteralManipulator.LiteralType.QUOTED);
        } else {
            string = text;
        }
        return string;
    }
}

