/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.LocationPresentation;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DbElementTreeElement
extends PsiTreeElementBase<DbElement>
implements LocationPresentation,
WeighedItem {
    DbElementTreeElement(DbElement element) {
        super((PsiElement)element);
    }

    public void navigate(boolean requestFocus) {
        DbElement element = (DbElement)this.getElement();
        if (element == null) {
            return;
        }
        DatabaseView.select((PsiElement)element, requestFocus);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> list = Collections.emptyList();
        if (list == null) {
            DbElementTreeElement.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public String getPresentableText() {
        DbElement element = (DbElement)this.getElement();
        return element == null ? null : DbPresentationCore.getPresentableName((DasObject)element, (boolean)true);
    }

    public Icon getIcon(boolean open) {
        DbElement element = (DbElement)this.getElement();
        return element == null ? null : DbPresentationCore.getIcon((DasObject)element);
    }

    public int getWeight() {
        DbElement element = (DbElement)this.getElement();
        return element == null ? 0 : DbPresentationCore.getWeight((Object)element, (boolean)true);
    }

    public String getLocationString() {
        DbElement element = (DbElement)this.getElement();
        if (element == null) {
            return null;
        }
        return element instanceof DasTypedObject ? ((DasTypedObject)element).getDasType().getSpecification() : "";
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    public String getLocationPrefix() {
        return " ";
    }

    public String getLocationSuffix() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DbElementTreeElement", "getChildrenBase"));
    }
}

