/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSshPanel;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabasePasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.HardViewport;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshSslPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final DataSourceConfigurable myDialog;
    private JBScrollPane myRoot;
    private JBCheckBox myUseSSLJBCheckBox;
    private JPanel mySslPanel;
    private LinkLabel<?> mySslCopyFrom;
    private TextFieldWithBrowseButton myCaCertFileField;
    private JBLabel myCACertLabel;
    private TextFieldWithBrowseButton myClientCertFileField;
    private JBLabel myClientCertFileLabel;
    private TextFieldWithBrowseButton myClientKeyFileField;
    private JBLabel myClientKeyFileLabel;
    private DataSourceSshPanel mySshPanel;
    private ComboBox<JdbcSettings.SslMode> myModeBox;
    private SslPassphraseComponent myPassphrase;
    private JBCheckBox myIDEStoreBox;
    private JBCheckBox myJavaStoreBox;
    private JBCheckBox mySystemStoreBox;

    public DataSourceSshSslPanel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataSourceConfigurable dialog) {
        if (project == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(1);
        }
        if (dialog == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myDialog = dialog;
        this.$$$setupUI$$$();
        this.myModeBox.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(JdbcSettings.SslMode.values())));
        this.myModeBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdbcSettings.SslMode>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdbcSettings.SslMode> list, JdbcSettings.SslMode value, int index, boolean selected, boolean hasFocus) {
                SimpleTextAttributes attrs;
                JdbcHelper helper;
                Object[] supportedModes;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean isSupported = (supportedModes = (helper = DbImplUtilCore.getJdbcHelper((Dbms)DataSourceSshSslPanel.this.myDataSource.getDbms())).supportedSslModes()) != null && ArrayUtil.contains((Object)value, (Object[])supportedModes);
                SimpleTextAttributes simpleTextAttributes = attrs = isSupported && DataSourceSshSslPanel.this.myModeBox.isEnabled() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                if (value == JdbcSettings.SslMode.REQUIRE) {
                    this.append(DatabaseBundle.message((String)"ssl.mode.require", (Object[])new Object[0]), attrs);
                } else if (value == JdbcSettings.SslMode.VERIFY_CA) {
                    this.append(DatabaseBundle.message((String)"ssl.mode.verify.ca", (Object[])new Object[0]), attrs);
                } else if (value == JdbcSettings.SslMode.VERIFY_FULL) {
                    this.append(DatabaseBundle.message((String)"ssl.mode.full", (Object[])new Object[0]), attrs);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/DataSourceSshSslPanel$1", "customizeCellRenderer"));
            }
        });
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        this.reset(this.myDataSource, true);
        this.myUseSSLJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshSslPanel.this.updateSslPanel();
            }
        });
        this.addActionListener(DatabaseBundle.message((String)"ssl.choose.ca", (Object[])new Object[0]), this.myCaCertFileField);
        this.addActionListener(DatabaseBundle.message((String)"ssl.choose.cert", (Object[])new Object[0]), this.myClientCertFileField);
        this.addActionListener(DatabaseBundle.message((String)"ssl.choose.key", (Object[])new Object[0]), this.myClientKeyFileField);
        this.updateSslPanel();
        this.myCACertLabel.setLabelFor((Component)this.myCaCertFileField.getTextField());
        this.myClientCertFileLabel.setLabelFor((Component)this.myClientCertFileField.getTextField());
        this.myClientKeyFileLabel.setLabelFor((Component)this.myClientKeyFileField.getTextField());
    }

    public void updateSslPanel() {
        UIUtil.setEnabled((Component)this.mySslPanel, (boolean)this.myUseSSLJBCheckBox.isSelected(), (boolean)true);
        this.mySslCopyFrom.setVisible(this.myUseSSLJBCheckBox.isSelected());
    }

    private void addActionListener(@NlsContexts.DialogTitle String title, TextFieldWithBrowseButton field) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, true, false, false).withTitle(title);
        field.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener((ComponentWithBrowseButton)field, null, descriptor2, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                String text = TEXT_FIELD_WHOLE_TEXT.getText((Component)component);
                return StringUtil.isEmpty((String)text) ? DataSourceSshSslPanel.this.getDefaultText() : text;
            }

            public void setText(JTextField component, @NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                TEXT_FIELD_WHOLE_TEXT.setText((Component)component, text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSshSslPanel$3", "setText"));
            }
        }));
    }

    private String getDefaultText() {
        String text = this.myCaCertFileField.getText();
        if (StringUtil.isEmpty((String)text)) {
            text = this.myClientCertFileField.getText();
        }
        if (StringUtil.isEmpty((String)text)) {
            text = this.myClientKeyFileField.getText();
        }
        return text;
    }

    @NotNull
    protected JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRoot;
        if (jBScrollPane == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(3);
        }
        return jBScrollPane;
    }

    private void createUIComponents() {
        this.myRoot = new HardViewport.ScrollPane();
        this.myPassphrase = new SslPassphraseComponent(this.myDialog.getSecretService(), this.myDataSource);
        this.mySshPanel = new DataSourceSshPanel(this.myProject, this.myDataSource, this.myDialog){

            @Override
            @Nullable
            protected HostPort getActualHostPort() {
                String url = DataSourceSshSslPanel.this.myDialog.getUrl();
                DatabaseDriver driver = DataSourceSshSslPanel.this.myDialog.getDriver();
                return driver == null ? null : JdbcUrlParserUtil.extractFirstHostPort((Collection)driver.getJDBCUrlParsers(), (String)url, null);
            }
        };
        this.mySslCopyFrom = DataSourceSshPanel.createLabel(this.myProject, (Condition<LocalDataSource>)((Condition)ds -> ds != this.myDataSource && ds.getSslCfg() != null), (Consumer<? super LocalDataSource>)((Consumer)dataSource -> {
            DataSourceSslConfiguration ssl = dataSource.getSslCfg();
            if (ssl == null) {
                return;
            }
            this.setupFromSslCfg((LocalDataSource)dataSource, true);
        }), DatabaseBundle.message((String)"DataSourceSshSslPanel.no.data.sources.with.ssl", (Object[])new Object[0]));
    }

    private void setupFromSslCfg(@NotNull LocalDataSource ds, boolean resetCredentials) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(4);
        }
        DataSourceSslConfiguration ssl = ds.getSslCfg();
        this.myPassphrase.reset(ssl, resetCredentials);
        this.myUseSSLJBCheckBox.setSelected(ssl != null && ssl.myEnabled);
        this.myIDEStoreBox.setSelected(ssl == null || ssl.myUseIdeStore);
        this.myJavaStoreBox.setSelected(ssl == null || ssl.myUseJavaStore);
        this.mySystemStoreBox.setSelected(ssl == null || ssl.myUseSystemStore);
        if (ssl == null) {
            return;
        }
        this.myCaCertFileField.setText(ssl.myCaCertPath);
        this.myClientCertFileField.setText(ssl.myClientCertPath);
        this.myClientKeyFileField.setText(ssl.myClientKeyPath);
        this.myModeBox.setSelectedItem((Object)ssl.myMode);
    }

    public void reset(@NotNull LocalDataSource ds, boolean resetCredentials) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(5);
        }
        this.mySshPanel.reset(ds);
        this.setupFromSslCfg(ds, resetCredentials);
    }

    public void saveData(@NotNull LocalDataSource ds, boolean enforceCredentials) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(6);
        }
        this.mySshPanel.saveData(ds, enforceCredentials);
        DataSourceSslConfiguration newSsl = new DataSourceSslConfiguration(this.getUseSsl(), this.getMode());
        newSsl.myCaCertPath = this.getCaCertFilePath();
        newSsl.myClientCertPath = this.getClientCertFilePath();
        newSsl.myClientKeyPath = this.getClientKeyFilePath();
        newSsl.myUseIdeStore = this.myIDEStoreBox.isSelected();
        newSsl.myUseJavaStore = this.myJavaStoreBox.isSelected();
        newSsl.myUseSystemStore = this.mySystemStoreBox.isSelected();
        if (ds.getSslCfg() != null || !newSsl.isEmpty()) {
            ds.setSslCfg(newSsl.isEmpty() ? null : newSsl);
            this.myPassphrase.save(ds, newSsl, enforceCredentials);
        }
    }

    @NotNull
    public String getCaCertFilePath() {
        String string = this.myCaCertFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getClientCertFilePath() {
        String string = this.myClientCertFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getClientKeyFilePath() {
        String string = this.myClientKeyFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean getUseSsl() {
        return this.myUseSSLJBCheckBox.isSelected();
    }

    @NotNull
    public JdbcSettings.SslMode getMode() {
        JdbcSettings.SslMode sslMode = (JdbcSettings.SslMode)ObjectUtils.notNull((Object)((JdbcSettings.SslMode)this.myModeBox.getSelectedItem()), (Object)JdbcSettings.SslMode.VERIFY_CA);
        if (sslMode == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(10);
        }
        return sslMode;
    }

    @NotNull
    public DataSourceSshPanel getSshPanel() {
        DataSourceSshPanel dataSourceSshPanel = this.mySshPanel;
        if (dataSourceSshPanel == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(11);
        }
        return dataSourceSshPanel;
    }

    public void reloadCredentials() {
        this.myPassphrase.myPasswordField.changedInStorage();
    }

    public boolean isSslPassphraseChanged() {
        return this.myPassphrase.myPasswordField.isModified();
    }

    public void onApply() {
        this.myPassphrase.reset(this.myDataSource.getSslCfg(), true);
    }

    public void hidePassword() {
        this.myPassphrase.myPasswordField.moveToStorage();
    }

    public void addSshSslMoreActions(DefaultActionGroup actions) {
        class CBAction
        extends ToggleAction {
            private final JCheckBox myBox;

            CBAction(String text, JCheckBox box) {
                super(text);
                this.myBox = box;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    CBAction.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    CBAction.$$$reportNull$$$0(1);
                }
                return this.myBox.isSelected();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    CBAction.$$$reportNull$$$0(2);
                }
                this.myBox.setSelected(true);
                DataSourceSshSslPanel.this.myDialog.selectSslPanel();
                ApplicationManager.getApplication().invokeLater(this.myBox::requestFocus);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshSslPanel$1CBAction";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshSslPanel$1CBAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }
        actions.add((AnAction)new CBAction(DatabaseBundle.message((String)"action.configure.ssh.tunnel.text", (Object[])new Object[0]), this.mySshPanel.getUseSshCheckBox()));
        actions.add((AnAction)new CBAction(DatabaseBundle.message((String)"action.configure.ssl.text", (Object[])new Object[0]), (JCheckBox)this.myUseSSLJBCheckBox));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JBCheckBox jBCheckBox4;
        this.createUIComponents();
        JBScrollPane jBScrollPane = this.myRoot;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        TitledSeparator titledSeparator = new TitledSeparator();
        jPanel2.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 4, 0, 1, 3, 0, null, null, null, 0, true));
        this.myUseSSLJBCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.use.ssl.label"));
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.mySslPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myCACertLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.ca.label"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myClientCertFileLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.cert.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myCaCertFileField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        this.myClientCertFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        this.myClientKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        this.myClientKeyFileLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.key.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.ssl.mode.label"));
        jPanel.add((Component)jBLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myModeBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(5, 1, 1, 3, 8, 0, 2, 0, null, null, null));
        SslPassphraseComponent sslPassphraseComponent = this.myPassphrase;
        jPanel.add((Component)sslPassphraseComponent, new GridConstraints(4, 0, 1, 4, 0, 3, 7, 0, null, null, null, 0, true));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("DataSourceSshPanel.use.truststore.label"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myIDEStoreBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("DataSourceSshPanel.ide.label"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJavaStoreBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("DataSourceSshPanel.java.label"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySystemStoreBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("DataSourceSshPanel.system.label"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        LinkLabel<?> linkLabel = this.mySslCopyFrom;
        this.$$$loadLabelText$$$((JLabel)linkLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("DataSourceSshSslPanel.link.copy.from"));
        linkLabel.setVerticalAlignment(1);
        jPanel2.add((Component)linkLabel, new GridConstraints(2, 1, 1, 3, 4, 0, 0, 0, null, null, null, 0, true));
        DataSourceSshPanel dataSourceSshPanel = this.mySshPanel;
        JComponent jComponent = dataSourceSshPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 4, 0, 3, 7, 0, null, null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshSslPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshSslPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaCertFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientCertFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientKeyFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupFromSslCfg";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static class SslPassphraseComponent
    extends JPanel {
        private final PasswordStorageComponent myPasswordStorage;
        private final DatabasePasswordField myPasswordField;

        public SslPassphraseComponent(@NotNull DatabaseCredentials local, final @NotNull LocalDataSource dataSource) {
            if (local == null) {
                SslPassphraseComponent.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                SslPassphraseComponent.$$$reportNull$$$0(1);
            }
            super((LayoutManager)new GridLayoutManager(1, 4));
            this.myPasswordStorage = new PasswordStorageComponent();
            this.myPasswordField = new DatabasePasswordField(local, (DatabaseConnectionPoint)dataSource){

                protected LocalDataSource getActualTarget() {
                    LocalDataSource copy = dataSource.copy(true);
                    copy.setPasswordStorage(myPasswordStorage.getStorage());
                    return copy;
                }

                @Override
                @Nullable
                protected OneTimeString extractPassword(@NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionPoint point) {
                    if (credentials == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (point == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return credentials.getSslPassphrase((DasDataSource)point.getDataSource());
                }

                @Override
                protected void setPassword(@NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config, @Nullable OneTimeString password) {
                    if (credentials == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (config == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    credentials.setSslPassphrase((DasDataSource)config.getDataSource(), password);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "credentials";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "point";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "config";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshSslPanel$SslPassphraseComponent$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extractPassword";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setPassword";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            JBLabel phrLbl = new JBLabel(DatabaseBundle.message((String)"data.source.key.phr.label", (Object[])new Object[0]));
            phrLbl.setLabelFor((Component)this.myPasswordField.getComponent());
            this.add((Component)phrLbl, DatabaseUIUtils.createLabelConstraints(0, 0, phrLbl.getPreferredSize().width));
            this.add((Component)this.myPasswordField.getComponent(), DatabaseUIUtils.createSimpleConstraints(0, 1, 1));
            JBLabel saveLbl = new JBLabel(DatabaseBundle.message((String)"database.auth.password.storage.label", (Object[])new Object[0]));
            saveLbl.setLabelFor(this.myPasswordStorage.getComponent());
            this.add((Component)saveLbl, DatabaseUIUtils.createLabelConstraints(0, 2, saveLbl.getPreferredSize().width));
            this.add(this.myPasswordStorage.getComponent(), DatabaseUIUtils.createConstraints(0, 3, 1, 0, 1, -2, false));
        }

        public void save(@NotNull LocalDataSource ds, @NotNull DataSourceSslConfiguration ssl, boolean enforceCredentials) {
            if (ds == null) {
                SslPassphraseComponent.$$$reportNull$$$0(2);
            }
            if (ssl == null) {
                SslPassphraseComponent.$$$reportNull$$$0(3);
            }
            ssl.myPasswordStorage = this.myPasswordStorage.getStorage();
            if (enforceCredentials) {
                this.myPasswordField.save((DatabaseConnectionConfig)ds);
            }
        }

        public void reset(@Nullable DataSourceSslConfiguration ssl, boolean resetCredentials) {
            this.myPasswordStorage.setPasswordStorage(ssl == null ? LocalDataSource.Storage.PERSIST : ssl.myPasswordStorage);
            if (resetCredentials) {
                this.myPasswordField.setPassword(null);
            }
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myPasswordField.getComponent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "local";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ds";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ssl";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshSslPanel$SslPassphraseComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

