/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSessionTemplatePanel;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.util.DbUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSessionTemplatesPanel {
    private final Project myProject;
    private final DatabaseCredentials myCredentials;
    private final Splitter myComponent;
    private final JComponent myWrapperPanel;
    private final CollectionListModel<TemplateWrapper> myTemplatesModel;
    private final JBList<TemplateWrapper> myTemplates;
    private TemplateWrapper myActive;
    private final LocalDataSource myDataSource;
    private final Supplier<LocalDataSource> myCurrentDataSource;
    private final DataSourceTestConnectionManager myTester;

    public DataSourceSessionTemplatesPanel(@NotNull Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource, @NotNull Supplier<LocalDataSource> currentDataSource, @NotNull DataSourceTestConnectionManager tester) {
        if (project == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(0);
        }
        if (credentials == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(2);
        }
        if (currentDataSource == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(3);
        }
        if (tester == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myCredentials = credentials;
        this.myDataSource = dataSource;
        this.myCurrentDataSource = currentDataSource;
        this.myTester = tester;
        this.myComponent = new Splitter(false, 0.3f);
        this.myComponent.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
        this.myTemplatesModel = new CollectionListModel<TemplateWrapper>(new TemplateWrapper[0]){

            public void addRow() {
                DataSourceSessionTemplate template = new DataSourceSessionTemplate(DataSourceSessionTemplatesPanel.this.myDataSource);
                Set allNames = ContainerUtil.map2Set((Collection)DataSourceSessionTemplatesPanel.this.myTemplatesModel.getItems(), w -> w.template.getTemplateName());
                template.setTemplateName(DbUtil.generateUniqueName((String)"Template", (Set)allNames));
                this.add(DataSourceSessionTemplatesPanel.this.wrapTemplate(template));
            }
        };
        this.myTemplates = new JBList(this.myTemplatesModel);
        ClientProperty.put(this.myTemplates, (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        this.myTemplates.setEmptyText(DatabaseBundle.message((String)"status.text.no.templates.defined", (Object[])new Object[0]));
        this.myTemplates.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.myTemplates.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DataSourceSessionTemplatesPanel.getMyRenderer(DataSourceSessionTemplatesPanel.this.myTemplates.getCellRenderer()).computeIconHover(e);
                DataSourceSessionTemplatesPanel.this.myTemplates.repaint();
            }
        });
        this.myTemplates.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DataSourceSessionTemplatesPanel.this.handleListClicked(e);
            }
        });
        this.myComponent.setFirstComponent((JComponent)ToolbarDecorator.createDecorator(this.myTemplates).setAddAction(button -> {
            this.myTemplatesModel.addRow();
            this.myTemplates.setSelectedIndex(this.myTemplatesModel.getSize() - 1);
        }).addExtraActions(new AnAction[]{new TestConnectionButton()}).createPanel());
        this.myWrapperPanel = new JBPanelWithEmptyText((LayoutManager)new BorderLayout()).withEmptyText(DatabaseBundle.message((String)"select.template.to.edit", (Object[])new Object[0]));
        this.myComponent.setSecondComponent(this.myWrapperPanel);
        this.myTemplates.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.setActiveTemplate((TemplateWrapper)this.myTemplates.getSelectedValue());
        });
    }

    private void handleListClicked(MouseEvent e) {
        MyListCellRenderer renderer2 = DataSourceSessionTemplatesPanel.getMyRenderer(this.myTemplates.getCellRenderer());
        int idx = renderer2.computeIconHover(e);
        if (idx == -1) {
            return;
        }
        DataSourceTestConnectionManager.TestInfo info2 = this.myTester.getInfo(((TemplateWrapper)this.myTemplatesModel.getElementAt((int)idx)).template.getTemplateId());
        Rectangle bounds = renderer2.getBounds();
        Dimension ps = renderer2.getPreferredSize();
        Point calloutPoint = new Point(bounds.x + ps.width, bounds.y + bounds.height / 4);
        this.myTester.showDetails(new RelativePoint(this.myTemplates, calloutPoint), info2);
    }

    @NotNull
    private TemplateWrapper wrapTemplate(DataSourceSessionTemplate template) {
        return new TemplateWrapper(template, () -> this.findCurrentTemplate(template), this::onTitleChanged);
    }

    @NotNull
    private DataSourceSessionTemplate findCurrentTemplate(DataSourceSessionTemplate template) {
        LocalDataSource currentDs = this.myCurrentDataSource.get();
        DataSourceSessionTemplate cur = (DataSourceSessionTemplate)ContainerUtil.find((Iterable)currentDs.getSessionTemplates(), t -> t.getTemplateId().equals(template.getTemplateId()));
        DataSourceSessionTemplate dataSourceSessionTemplate = cur == null ? template : cur;
        if (dataSourceSessionTemplate == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(5);
        }
        return dataSourceSessionTemplate;
    }

    private void setActiveTemplate(@Nullable TemplateWrapper item) {
        if (item == this.myActive) {
            return;
        }
        this.myWrapperPanel.removeAll();
        this.myActive = item;
        if (item != null) {
            this.myWrapperPanel.add((Component)item.getPanel().getComponent(), "Center");
        }
        this.myWrapperPanel.revalidate();
        this.myWrapperPanel.repaint();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void onTitleChanged(@NotNull TemplateWrapper w) {
        if (w == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(6);
        }
        this.myTemplatesModel.contentsChanged((Object)w);
    }

    public void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(7);
        }
        this.myTemplatesModel.replaceAll(ContainerUtil.map((Collection)dataSource.getSessionTemplates(), this::wrapTemplate));
    }

    public void save(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(8);
        }
        HashMap<String, DataSourceSessionTemplate> prev2 = new HashMap<String, DataSourceSessionTemplate>();
        for (DataSourceSessionTemplate template : dataSource.getSessionTemplates()) {
            prev2.put(template.getTemplateId(), template);
        }
        dataSource.setSessionTemplates(ContainerUtil.map((Collection)this.myTemplatesModel.getItems(), w -> {
            DataSourceSessionTemplate template = (DataSourceSessionTemplate)prev2.get(w.template.getTemplateId());
            if (template == null) {
                template = new DataSourceSessionTemplate(dataSource, w.template.getTemplateId());
            }
            w.getPanel().save(template);
            return template;
        }));
    }

    @Nullable
    public String getSessionName(@NotNull String id) {
        TemplateWrapper wrapper;
        if (id == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(9);
        }
        return (wrapper = (TemplateWrapper)ContainerUtil.find((Iterable)this.myTemplatesModel.getItems(), t -> t.template.getTemplateId().equals(id))) == null ? null : wrapper.getTitle();
    }

    @NotNull
    public List<String> getSessionIds() {
        List list = ContainerUtil.map((Collection)this.myTemplatesModel.getItems(), t -> t.template.getTemplateId());
        if (list == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void onModelChanged(final Runnable r) {
        this.myTemplatesModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                r.run();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                r.run();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                r.run();
            }
        });
    }

    public void hidePassword() {
        for (TemplateWrapper item : this.myTemplatesModel.getItems()) {
            if (item.myPanel == null) continue;
            item.myPanel.hidePassword();
        }
    }

    public void reloadCredentials() {
        for (TemplateWrapper item : this.myTemplatesModel.getItems()) {
            if (item.myPanel == null) continue;
            item.myPanel.reloadCredentials();
        }
    }

    public void update(@NotNull DataSourceTestConnectionManager.TestInfo info2) {
        if (info2 == null) {
            DataSourceSessionTemplatesPanel.$$$reportNull$$$0(11);
        }
        this.myTemplates.repaint();
    }

    public static MyListCellRenderer getMyRenderer(ListCellRenderer<? super TemplateWrapper> rr) {
        ListCellRenderer my = rr instanceof ExpandedItemListCellRendererWrapper ? ((ExpandedItemListCellRendererWrapper)rr).getWrappee() : rr;
        return (MyListCellRenderer)((Object)my);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tester";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findCurrentTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTitleChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSessionName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10 -> new IllegalStateException(string);
        };
    }

    private class TemplateWrapper {
        @NotNull
        public final DataSourceSessionTemplate template;
        private DataSourceSessionTemplatePanel myPanel;
        private final Supplier<DataSourceSessionTemplate> myCurrentTemplate;
        private final Consumer<TemplateWrapper> myTitleChanged;

        private TemplateWrapper(@NotNull DataSourceSessionTemplate template, @NotNull Supplier<DataSourceSessionTemplate> currentTemplate, Consumer<TemplateWrapper> onTitleChanged) {
            if (template == null) {
                TemplateWrapper.$$$reportNull$$$0(0);
            }
            if (currentTemplate == null) {
                TemplateWrapper.$$$reportNull$$$0(1);
            }
            if (onTitleChanged == null) {
                TemplateWrapper.$$$reportNull$$$0(2);
            }
            this.template = template;
            this.myCurrentTemplate = currentTemplate;
            this.myTitleChanged = onTitleChanged;
        }

        @Nls
        public String getTitle() {
            return this.myPanel == null ? DataSourceSessionTemplatePanel.getTitle(this.template) : this.myPanel.getTitle();
        }

        @NotNull
        public DataSourceSessionTemplatePanel getPanel() {
            if (this.myPanel == null) {
                this.myPanel = new DataSourceSessionTemplatePanel(DataSourceSessionTemplatesPanel.this.myProject, DataSourceSessionTemplatesPanel.this.myCredentials, this.template, this.myCurrentTemplate, () -> this.myTitleChanged.accept(this));
                this.myPanel.reset(this.template);
            }
            DataSourceSessionTemplatePanel dataSourceSessionTemplatePanel = this.myPanel;
            if (dataSourceSessionTemplatePanel == null) {
                TemplateWrapper.$$$reportNull$$$0(3);
            }
            return dataSourceSessionTemplatePanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentTemplate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onTitleChanged";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel$TemplateWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel$TemplateWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<TemplateWrapper> {
        private int hoveredIconIdx = -1;

        private MyListCellRenderer() {
        }

        private int computeIconHover(MouseEvent e) {
            this.hoveredIconIdx = -1;
            Point point = e.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(point, DataSourceSessionTemplatesPanel.this.myTemplates);
            int idx = DataSourceSessionTemplatesPanel.this.myTemplates.locationToIndex(point);
            if (idx == -1) {
                return -1;
            }
            Rectangle bounds = DataSourceSessionTemplatesPanel.this.myTemplates.getCellBounds(idx, idx);
            if (!bounds.contains(point)) {
                return -1;
            }
            TemplateWrapper item = (TemplateWrapper)DataSourceSessionTemplatesPanel.this.myTemplatesModel.getElementAt(idx);
            DataSourceTestConnectionManager.TestInfo info2 = DataSourceSessionTemplatesPanel.this.myTester.getInfo(item.template.getTemplateId());
            if (info2.getStatus() == null && info2.getJob() == null) {
                return -1;
            }
            Component component = this.getListCellRendererComponent((JList)DataSourceSessionTemplatesPanel.this.myTemplates, item, idx, true, true);
            component.setBounds(bounds);
            int frag = this.findFragmentAt(point.x - bounds.x);
            if (frag != -2) {
                return -1;
            }
            this.hoveredIconIdx = idx;
            return this.hoveredIconIdx;
        }

        protected void customizeCellRenderer(@NotNull JList list, TemplateWrapper value, int index, boolean selected, boolean hasFocus) {
            String title;
            if (list == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            String string = title = value == null ? "" : value.getTitle();
            if (StringUtil.isEmpty((String)title)) {
                this.append(DatabaseBundle.message((String)"label.unnamed.object", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                this.append(title);
            }
            if (value != null) {
                DataSourceTestConnectionManager.TestInfo info2 = DataSourceSessionTemplatesPanel.this.myTester.getInfo(value.template.getTemplateId());
                this.setIconOnTheRight(true);
                this.setIcon(info2.getIcon());
                this.setTransparentIconBackground(index == this.hoveredIconIdx && index != -1);
            }
        }

        protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
            if (g == null) {
                MyListCellRenderer.$$$reportNull$$$0(1);
            }
            if (icon == null) {
                MyListCellRenderer.$$$reportNull$$$0(2);
            }
            if (this.isTransparentIconBackground()) {
                g.setColor(JBUI.CurrentTheme.ActionButton.hoverBackground());
                int height = this.getHeight();
                int d = height - icon.getIconHeight();
                g.fillRect(offset + this.getIpad().left, d / 2, icon.getIconWidth(), height - d);
            }
            super.doPaintIcon(g, icon, offset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel$MyListCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doPaintIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TestConnectionButton
    extends DumbAwareAction {
        TestConnectionButton() {
            super(DatabaseBundle.message((String)"DataSourceTestConnectionPanel.test.connection", (Object[])new Object[0]), null, AllIcons.Nodes.PluginRestart);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                TestConnectionButton.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TestConnectionButton.$$$reportNull$$$0(1);
            }
            List<TemplateWrapper> value = this.getTemplates();
            e.getPresentation().setEnabled(!value.isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TestConnectionButton.$$$reportNull$$$0(2);
            }
            DataSourceSessionTemplatesPanel.this.myTester.testConnectionAsync(ContainerUtil.map(this.getTemplates(), t -> t.template.getTemplateId()), true);
        }

        private List<TemplateWrapper> getTemplates() {
            return DataSourceSessionTemplatesPanel.this.myTemplates.getSelectedValuesList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel$TestConnectionButton";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatesPanel$TestConnectionButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

