/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabasePluginId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DatabaseKeymapExtension
implements KeymapExtension {
    private static final String DB_KEYMAP_GROUP = "Database.KeymapGroup";
    private static final String DB_KEYMAP_HIDDEN_GROUP = "Database.KeymapGroup.Hidden";
    private static final String IDE_PLUGIN_ID = "com.intellij.database.ide";

    DatabaseKeymapExtension() {
    }

    @NotNull
    public KeymapGroup createGroup(Condition<? super AnAction> filtered, @Nullable Project project) {
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(DatabaseBundle.message((String)"group.database.text", (Object[])new Object[0]));
        for (AnAction action : ActionsTreeUtil.getActions((String)DB_KEYMAP_GROUP)) {
            ActionsTreeUtil.addAction((KeymapGroup)result, (AnAction)action, filtered, (boolean)false);
        }
        Group group = DatabaseKeymapExtension.createAllActionsGroup(filtered);
        if (group.getSize() > 0) {
            result.addGroup((KeymapGroup)group);
        }
        if (result instanceof Group) {
            ((Group)result).normalizeSeparators();
        }
        KeymapGroup keymapGroup = result;
        if (keymapGroup == null) {
            DatabaseKeymapExtension.$$$reportNull$$$0(0);
        }
        return keymapGroup;
    }

    public boolean skipPluginGroup(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            DatabaseKeymapExtension.$$$reportNull$$$0(1);
        }
        return pluginId.equals((Object)DatabasePluginId.get()) || pluginId.getIdString().equals(IDE_PLUGIN_ID);
    }

    @NotNull
    private static Group createAllActionsGroup(Condition<? super AnAction> filtered) {
        ActionManagerImpl actionManager = (ActionManagerImpl)ActionManagerEx.getInstanceEx();
        Group group = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), null, () -> AllIcons.Nodes.KeymapOther);
        PluginId ideId = PluginId.findId((String)IDE_PLUGIN_ID);
        ((StreamEx)((StreamEx)StreamEx.of((Object[])actionManager.getPluginActions(DatabasePluginId.get())).append((Object[])(ideId == null ? ArrayUtil.EMPTY_STRING_ARRAY : actionManager.getPluginActions(ideId))).sorted(Comparator.comparing(ActionsTreeUtil::getTextToCompare))).filter(actionId -> {
            boolean isHidden = actionId.equals(DB_KEYMAP_GROUP) || actionId.equals(DB_KEYMAP_HIDDEN_GROUP);
            boolean hasParent = !actionManager.getParentGroupIds(actionId).isEmpty();
            return !isHidden && !hasParent;
        })).forEachOrdered(actionId -> {
            AnAction action = actionManager.getActionOrStub(actionId);
            if (action != null) {
                ActionsTreeUtil.addAction((KeymapGroup)group, (AnAction)action, (Condition)filtered);
            }
        });
        Group group2 = group;
        if (group2 == null) {
            DatabaseKeymapExtension.$$$reportNull$$$0(2);
        }
        return group2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseKeymapExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseKeymapExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAllActionsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipPluginGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

