/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecma6.JSNamedTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportType
extends JSNamedType
implements JSEvaluableType,
JSTypeWithDeclarations {
    private final String myTypeText;

    public JSImportType(String typeText, @NotNull JSTypeSource source, @NotNull JSTypeContext jsTypeContext) {
        if (source == null) {
            JSImportType.$$$reportNull$$$0(0);
        }
        if (jsTypeContext == null) {
            JSImportType.$$$reportNull$$$0(1);
        }
        super(source, jsTypeContext);
        this.myTypeText = typeText;
    }

    JSImportType(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSImportType.$$$reportNull$$$0(2);
        }
        if (serialized == null) {
            JSImportType.$$$reportNull$$$0(3);
        }
        super(source, serialized);
        this.myTypeText = JSTypeSerializer.readString(serialized);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSImportType.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myTypeText, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSImportType.$$$reportNull$$$0(5);
        }
        return new JSImportType(this.myTypeText, source, this.getTypeContext());
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSImportType.$$$reportNull$$$0(6);
        }
        return super.isEquivalentToWithSameClass(type2, context2, allowResolve) && this.myTypeText.equals(((JSImportType)type2).myTypeText) && Objects.equals(this.getContainingFile(), ((JSImportType)type2).getContainingFile());
    }

    @Nullable
    private PsiFile getContainingFile() {
        return this.getSourceElement() != null ? this.getSourceElement().getContainingFile() : null;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSImportType.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            JSImportType.$$$reportNull$$$0(8);
        }
        boolean isStatic = this.getTypeContext() == JSTypeContext.STATIC;
        builder2.append((isStatic ? "typeof " : "") + this.myTypeText);
    }

    @Override
    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        Collection<? extends PsiElement> elements;
        if (context2 == null) {
            JSImportType.$$$reportNull$$$0(9);
        }
        if ((elements = this.resolveElements()).isEmpty()) {
            return JSAnyType.get(this.getSource());
        }
        return this.convertImportType(elements);
    }

    @NotNull
    private Collection<? extends PsiElement> resolveElements() {
        PsiElement element2 = this.getSourceElement();
        if (element2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                JSImportType.$$$reportNull$$$0(10);
            }
            return list;
        }
        JSImportHandler handler = JSDialectSpecificHandlersFactory.forElement(element2).getImportHandler();
        JSTypeResolveResult result2 = handler.resolveMainElementName(this.myTypeText, element2, this.getJSContext());
        Collection<? extends PsiElement> collection = result2.getElements();
        if (collection == null) {
            JSImportType.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    private JSType convertImportType(Collection<? extends PsiElement> declarations) {
        SmartList types = new SmartList();
        boolean isStatic = this.getJSContext() == JSContext.STATIC;
        HashSet<String> qNameTypes = new HashSet<String>();
        for (PsiElement psiElement : declarations) {
            if (psiElement instanceof JSNamedTypeDeclaration) {
                JSType type2;
                JSNamedTypeDeclaration namedTypeDeclaration = (JSNamedTypeDeclaration)psiElement;
                JSType jSType = type2 = isStatic ? namedTypeDeclaration.getStaticJSType() : namedTypeDeclaration.getJSType();
                if (type2 instanceof JSNamedType && !qNameTypes.add(type2.getTypeText())) continue;
                types.add(type2);
                continue;
            }
            JSType type2 = JSResolveUtil.getElementJSType(psiElement);
            JSType resultType = this.getJSContext() == JSContext.INSTANCE && type2 != null && (!(type2 instanceof JSNamespace) || ((JSNamespace)type2).getJSContext() != JSContext.INSTANCE) ? new JSApplyNewType(type2, type2.getSource()) : (this.getJSContext() == JSContext.STATIC && type2 != null && this.isTypeScript() ? JSImportType.removeTypeAliasesAndInterfacesFromRecord(type2.substitute()) : type2);
            ContainerUtil.addIfNotNull((Collection)types, (Object)resultType);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType((Collection<? extends JSType>)types, this.getSource());
        if (jSType == null) {
            JSImportType.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    private static JSType removeTypeAliasesAndInterfacesFromRecord(JSType type2) {
        if (type2 instanceof JSRecordType) {
            List<JSRecordType.TypeMember> filteredMembers = ((JSRecordType)type2).getTypeMembers().stream().filter(m -> !JSImportType.isTypeAliasOrInterface(m)).toList();
            return new JSRecordTypeImpl(type2.getSource(), filteredMembers);
        }
        return type2;
    }

    private static boolean isTypeAliasOrInterface(JSRecordType.TypeMember member) {
        List<PsiElement> src = member.getMemberSource().getAllSourceElements();
        return !src.isEmpty() && ContainerUtil.and(src, memberType -> memberType instanceof TypeScriptTypeAlias || memberType instanceof TypeScriptInterface);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(new Object[]{this.myTypeText, this.getTypeContext(), this.getContainingFile()});
    }

    @NotNull
    public String getSimpleText() {
        String string = this.myTypeText;
        if (string == null) {
            JSImportType.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        return new ArrayList<PsiElement>(this.resolveElements());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsTypeContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSImportType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSImportType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertImportType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

