/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagReferencesHolderImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocTagNamepathImpl
extends JSDocTagReferencesHolderImpl
implements JSDocTagNamepath {
    public JSDocTagNamepathImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    protected PsiReference @NotNull [] createRefs() {
        PsiElement parent = this.getParent();
        JSDocTagDefinition definition = null;
        if (parent instanceof JSDocTag) {
            definition = ((JSDocTag)parent).getTagDefinition();
        } else if (parent instanceof JSDocInlineTag) {
            definition = ((JSDocInlineTag)parent).getTagDefinition();
        }
        if (definition != null) {
            String text = this.getText();
            boolean isEnclosed = JSDocTagNamepathImpl.indexOfOptionalDelimiter(text) == 0 || JSDocTagNamepathImpl.isWithinBackticksOrBraces(text);
            int equals = text.indexOf(61);
            if (equals < 0) {
                equals = text.length();
            }
            text = isEnclosed ? text.substring(1, Math.min(equals, text.length() - 1)) : text.substring(0, equals);
            PsiReference[] psiReferenceArray = this.createReferencesFromText(StringUtil.trimTrailing((String)text, (char)'.'), isEnclosed ? 1 : 0, definition, true, JSDocTagNamepathImpl.isSeeTagWithHardNamepathReference(text, definition));
            if (psiReferenceArray == null) {
                JSDocTagNamepathImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTagNamepath(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public String getNamepathText() {
        Object result2 = this.getNamepathPrefixForConfigTag();
        String text = this.getTextWithoutLeadingAsterisks();
        int optionalDelimiter = JSDocTagNamepathImpl.indexOfOptionalDelimiter(text);
        boolean isEnclosed = JSDocTagNamepathImpl.isWithinBackticksOrBraces(text);
        int equals = text.indexOf(61);
        result2 = equals > 0 ? (String)result2 + text.substring(isEnclosed || optionalDelimiter >= 0 ? 1 : 0, equals).trim() : (optionalDelimiter >= 0 ? (String)result2 + text.substring(0, optionalDelimiter) + text.substring(optionalDelimiter + 1, text.length() - 1).trim() : (isEnclosed ? (String)result2 + text.substring(1, text.length() - 1).trim() : (String)result2 + text));
        String string = StringUtil.trimTrailing((String)result2, (char)'.');
        if (string == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isOptional() {
        JSDocTag nextTag = JSDocumentationUtils.getNextJSDocTag((PsiElement)this);
        if (nextTag != null && nextTag.is(JSDocBlockTags.OPTIONAL)) {
            return true;
        }
        String text = this.getTextWithoutLeadingAsterisks();
        return JSDocTagNamepathImpl.indexOfOptionalDelimiter(text) >= 0 || text.contains("=");
    }

    @Override
    public boolean isRest() {
        return this.getText().endsWith("...");
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        String text = this.getTextWithoutLeadingAsterisks();
        int equals = text.indexOf(61);
        if (equals > 0) {
            if (JSDocTagNamepathImpl.indexOfOptionalDelimiter(text) >= 0 || JSDocTagNamepathImpl.isWithinBackticksOrBraces(text)) {
                return text.substring(equals + 1, text.length() - 1).trim();
            }
            return text.substring(equals + 1).trim();
        }
        return null;
    }

    @NotNull
    private String getNamepathPrefixForConfigTag() {
        JSDocTag tag = JSDocumentationUtils.getPreviousParamTagForConfigTag((JSDocTag)ObjectUtils.tryCast((Object)this.getParent(), JSDocTag.class));
        if (tag != null) {
            String namepath = tag.getNamepathText();
            return namepath != null ? namepath + "." : "";
        }
        return "";
    }

    private static boolean isSeeTagWithHardNamepathReference(String text, JSDocTagDefinition definition) {
        if (definition != JSDocBlockTags.SEE) {
            return false;
        }
        if (text.indexOf(35) != -1) {
            return true;
        }
        int dotPos = text.lastIndexOf(46);
        return dotPos != -1 && dotPos + 1 < text.length() && Character.isUpperCase(text.charAt(dotPos + 1));
    }

    private static boolean isWithinBackticksOrBraces(@NotNull String text) {
        if (text == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(4);
        }
        return text.startsWith("`") && text.endsWith("`") || text.startsWith("{") && text.endsWith("}");
    }

    private static int indexOfOptionalDelimiter(@NotNull String text) {
        int index;
        if (text == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(5);
        }
        if ((index = text.indexOf(91)) >= 0) {
            return text.endsWith("]") ? index : -1;
        }
        index = text.indexOf(40);
        if (index == 0) {
            return text.endsWith(")") ? index : -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagNamepathImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefs";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagNamepathImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamepathText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBackticksOrBraces";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexOfOptionalDelimiter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

