/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.javascript.JSParameterInfoHandlerKt;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSClassHighlightingHelper;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSTypeHighlightingHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 v2\u00020\u0001:\u0002uvB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000eH\u0004J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u000eJ!\u0010\u0013\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\"\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\u0016H\u0004J>\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\bH\u0004J\u001a\u0010&\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J \u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0004J4\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJF\u00102\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J,\u00104\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010(\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J \u00105\u001a\u0002062\u0006\u0010$\u001a\u00020)2\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000bH\u0004J \u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020;2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0004J2\u0010<\u001a\u00020,2\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010=\u001a\u0004\u0018\u00010\u0018H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020/0?2\u0006\u0010@\u001a\u00020)H\u0004J\u0010\u0010A\u001a\u0002012\u0006\u0010@\u001a\u00020)H\u0004J:\u0010B\u001a\u0004\u0018\u00010\u00182\u0006\u0010C\u001a\u00020\u001c2\b\u0010=\u001a\u0004\u0018\u00010\u00182\b\u0010D\u001a\u0004\u0018\u00010\u00182\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010\t\u001a\u00020\bH\u0014J\u0010\u0010E\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u001cH\u0014J\u0010\u0010F\u001a\u0002062\u0006\u0010:\u001a\u00020;H\u0014J \u0010G\u001a\u0004\u0018\u00010\u00052\u0006\u0010H\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010I\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u000eH\u0014J$\u0010J\u001a\u0004\u0018\u00010\u00052\b\u0010K\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J4\u0010L\u001a\u0004\u0018\u00010\u00182\u0006\u0010$\u001a\u00020)2\u0006\u0010M\u001a\u00020\u000b2\b\u0010N\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\bH\u0004J4\u0010O\u001a\u0004\u0018\u00010\u00052\b\u0010P\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\bH\u0004J\u001c\u0010S\u001a\u0004\u0018\u00010\u00182\b\u0010P\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J$\u0010T\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\n\u0010U\u001a\u00060!j\u0002`\"2\u0006\u00108\u001a\u00020\u000bH\u0004J\u001a\u0010V\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020)2\b\u0010K\u001a\u0004\u0018\u00010\bH\u0014J\u001c\u0010W\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020Y2\n\u0010U\u001a\u00060!j\u0002`\"H\u0014J\"\u0010Z\u001a\u0004\u0018\u00010\u00052\u0006\u0010X\u001a\u00020Y2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0014J\u001c\u0010_\u001a\u00020\u001a2\u0006\u0010[\u001a\u00020\\2\n\u0010U\u001a\u00060!j\u0002`\"H\u0014J\u0012\u0010`\u001a\u0004\u0018\u00010\u00182\u0006\u0010a\u001a\u00020bH\u0014J\u0018\u0010c\u001a\u00020\u001f2\u0006\u0010d\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\bH\u0014J&\u0010e\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020\b2\b\u0010f\u001a\u0004\u0018\u00010\u00052\n\u0010 \u001a\u00060!j\u0002`\"H\u0004J.\u0010g\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\b\u0010h\u001a\u0004\u0018\u00010\u00052\n\u0010U\u001a\u00060!j\u0002`\"H\u0014J\u001a\u0010i\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\r2\b\u0010h\u001a\u0004\u0018\u00010\u0005H\u0004J\u0018\u0010j\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0014J\u0010\u0010m\u001a\u00020\u00052\u0006\u0010a\u001a\u00020nH\u0014J\u001c\u0010o\u001a\u00020\u001a2\u0006\u0010a\u001a\u00020n2\n\u0010U\u001a\u00060!j\u0002`\"H\u0014J2\u0010p\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010r\u001a\u0002062\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u001a\u0010s\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\bH\u0014J\u0017\u0010t\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010k\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bk\u0010l\u00a8\u0006w"}, d2={"Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder;", "", "<init>", "()V", "getQuickNavigateInfoForNavigationElement", "", "Lcom/intellij/openapi/util/NlsSafe;", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "jsDoc", "", "getContainerClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "Lcom/intellij/psi/PsiNamedElement;", "hasContainerDeclaration", "getContainerIcon", "clazz", "getContainerDefinition", "getQuickNavigateInfo", "Lorg/jetbrains/annotations/Nls;", "createForProperty", "Lcom/intellij/lang/javascript/psi/JSProperty;", "getPropertyType", "Lcom/intellij/lang/javascript/psi/JSType;", "appendTypeWithSeparatorForOwner", "", "typeOwner", "Lcom/intellij/lang/javascript/psi/JSElement;", "toUse", "substitutor", "Lcom/intellij/lang/javascript/psi/types/JSTypeSubstitutor;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "createForFunction", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "getNarrowedType", "getFunctionNameWithHtml", "functionItem", "Lcom/intellij/lang/javascript/psi/JSFunctionItem;", "getQNameSeparator", "getFunctionDefinitionWithHighlighting", "", "parameters", "", "Lcom/intellij/lang/javascript/documentation/JSDocParameterInfoPrinter;", "returnInfo", "Lcom/intellij/lang/javascript/documentation/JSDocBuilderSimpleInfo;", "getFunctionDefinition", "escapedName", "expandParameters", "getFunctionKind", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "isGetterOrSetter", "shouldAppendKeyword", "createForVariableOrField", "variableOrField", "Lcom/intellij/lang/javascript/psi/JSFieldVariable;", "createTypePart", "declaredType", "mapParametersToInfos", "", "parsedFunction", "mapReturnTypeToInfo", "appendOptionality", "variableLikeElement", "narrowedType", "isGuessedOptional", "getFieldOrVariableKind", "createForJSClass", "jsClass", "getParentContainer", "getParentInfo", "parent", "getReturnTypeForQuickNavigate", "set", "returnType", "getPresentableTypeText", "rawType", "context", "location", "getTypeWithAppliedSubstitutor", "appendFunctionAttributes", "result", "shouldAppendFunctionKeyword", "appendAttrList", "owner", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeListOwner;", "formatVisibility", "attributeList", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList;", "type", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;", "appendPlainModifierList", "getVariableOrFieldType", "variable", "Lcom/intellij/lang/javascript/psi/JSTypeDeclarationOwner;", "getTypeSubstitutor", "el", "appendType", "typeText", "appendClassAttributes", "packageOrModule", "getClassQualifiedName", "getClassGenerics", "isIncludeObjectInExtendsList", "()Z", "getVarPrefix", "Lcom/intellij/lang/javascript/psi/JSVariable;", "appendVariableInitializer", "createQuickNavigateForJSElement", "declaration", "kind", "getJSElementType", "getDocumentationFromLanguageService", "ObjectKind", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSQuickNavigateBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSQuickNavigateBuilder.kt\ncom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1152:1\n1#2:1153\n11228#3:1154\n11563#3,3:1155\n*S KotlinDebug\n*F\n+ 1 JSQuickNavigateBuilder.kt\ncom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder\n*L\n546#1:1154\n546#1:1155,3\n*E\n"})
public class JSQuickNavigateBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int INITIALIZER_MAX_LENGTH = 50;
    public static final int TYPE_MAX_LENGTH = 2500;

    @Nullable
    public String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element2, @NotNull PsiElement originalElement, boolean jsDoc) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Ref.ObjectRef originalElement2 = new Ref.ObjectRef();
        originalElement2.element = originalElement;
        PsiElement psiElement = JSDocumentationUtils.getOriginalElementOrParentIfLeaf((PsiElement)originalElement2.element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOriginalElementOrParentIfLeaf(...)");
        originalElement2.element = psiElement;
        return (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)originalElement2.element, () -> JSQuickNavigateBuilder.getQuickNavigateInfoForNavigationElement$lambda$1(element2, this, originalElement2, jsDoc));
    }

    private final JSClass getContainerClass(PsiNamedElement element2) {
        PsiElement parent;
        if (DialectDetector.isActionScript((PsiElement)element2)) {
            return null;
        }
        if (!(element2 instanceof JSFieldVariable) && !(element2 instanceof JSFunction)) {
            return null;
        }
        PsiElement psiElement = this.getParentContainer(element2);
        if (psiElement == null) {
            psiElement = JSResolveUtil.findParent((PsiElement)element2);
        }
        return (parent = psiElement) instanceof JSClass ? (JSClass)parent : null;
    }

    protected final boolean hasContainerDeclaration(@NotNull PsiNamedElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getContainerClass(element2) != null;
    }

    private final String getContainerIcon(JSClass clazz) {
        return clazz instanceof TypeScriptEnum ? "AllIcons.Nodes.Enum" : (clazz.isInterface() ? "AllIcons.Nodes.Interface" : "AllIcons.Nodes.Class");
    }

    @Nullable
    public final String getContainerDefinition(@NotNull PsiNamedElement element2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof JSElement)) {
            return null;
        }
        JSClass jSClass = this.getContainerClass(element2);
        if (jSClass == null) {
            return null;
        }
        JSClass parent = jSClass;
        String string = this.getParentInfo(parent, element2, this.getTypeSubstitutor((JSElement)element2, (PsiElement)element2));
        if (string == null) {
            return null;
        }
        String label = string;
        JSQuickNavigateBuilder $this$getContainerDefinition_u24lambda_u242 = this;
        boolean $i$a$-run-JSQuickNavigateBuilder$getContainerDefinition$ownerLink$22 = false;
        StringBuilder builder2 = new StringBuilder();
        DocumentationManagerUtil.createHyperlink((StringBuilder)builder2, (String)parent.getJSType().getTypeText(), (String)label, (boolean)false);
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"run(...)");
        String ownerLink = string2;
        String ownerIcon = this.getContainerIcon(parent);
        HtmlChunk[] $i$a$-run-JSQuickNavigateBuilder$getContainerDefinition$ownerLink$22 = new HtmlChunk[]{HtmlChunk.tag((String)"icon").attr("src", ownerIcon), HtmlChunk.nbsp(), HtmlChunk.raw((String)ownerLink)};
        HtmlChunk.Element element3 = DocumentationMarkup.BOTTOM_ELEMENT.children($i$a$-run-JSQuickNavigateBuilder$getContainerDefinition$ownerLink$22);
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"children(...)");
        HtmlChunk.Element html = element3;
        StringBuilder p0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        html.appendTo(p0);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getQuickNavigateInfo(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        PsiElement element3 = element2;
        if (originalElement == null) {
            return null;
        }
        if (element3 instanceof JSOffsetBasedImplicitElement) {
            element3 = ((JSOffsetBasedImplicitElement)element3).getElementAtOffset();
        }
        if (element3 == null) return null;
        Project project = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        PsiElement psiElement = element3.getNavigationElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
        String string = this.getQuickNavigateInfoForNavigationElement(psiElement, originalElement, false);
        return string;
    }

    @Nullable
    protected final String createForProperty(@NotNull JSProperty element2, @NotNull PsiElement originalElement, boolean jsDoc) {
        ObjectKind kind;
        JSQualifiedNamedElement parent;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        String name = JSPsiImplUtils.getNameOrComputedPropertyName(element2, true);
        if (name == null) {
            return null;
        }
        name = JSDocumentationBuilder.ensureBracketsForQuotedName(name, '\"');
        JSQualifiedNamedElement jSQualifiedNamedElement = parent = element2 == JSDocumentationUtils.getOriginalElementOrParentIfLeaf(originalElement) ? null : JSQuickNavigateBuilder.Companion.getPropertyParent(element2);
        String qName = JSQuickNavigateBuilder.Companion.formatMemberAccess(jSQualifiedNamedElement != null ? jSQualifiedNamedElement.getQualifiedName() : null, name, ".");
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor(element2, originalElement);
        JSType declaredType = this.getPropertyType(element2);
        CharSequence typePart = this.createTypePart(element2, originalElement, jsDoc, substitutor, declaredType);
        String result2 = JSQuickNavigateBuilder.Companion.buildHtmlForProperty(element2, qName, jsDoc ? (CharSequence)"" : typePart) + (jsDoc ? typePart : (CharSequence)"");
        ObjectKind objectKind = kind = element2.getValue() instanceof JSFunctionExpression ? ObjectKind.FUNCTION : ObjectKind.PROPERTY;
        return jsDoc ? result2 : JSQuickNavigateBuilder.buildResult(kind, result2, (PsiElement)element2, originalElement);
    }

    @Nullable
    protected final JSType getPropertyType(@NotNull JSProperty element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return JSTypeUtils.widenLiteralTypes(element2.getJSType());
    }

    protected void appendTypeWithSeparatorForOwner(@NotNull JSElement typeOwner, @Nullable JSType toUse, @NotNull JSTypeSubstitutor substitutor, @NotNull StringBuilder builder2, @NotNull PsiElement originalElement, boolean jsDoc) {
        String callTypeText;
        String variableOrFieldTypeText;
        Intrinsics.checkNotNullParameter((Object)typeOwner, (String)"typeOwner");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        JSType toUse2 = toUse;
        JSType callSignatureType = JSQuickNavigateBuilder.Companion.getCallSignatureTypeFromCallSite(toUse2, originalElement);
        if (callSignatureType != null) {
            if (toUse2 instanceof JSGenericTypeImpl) {
                toUse2 = ((JSGenericTypeImpl)toUse2).getType();
            }
            if (!(toUse2 instanceof JSTypeImpl)) {
                toUse2 = callSignatureType;
                callSignatureType = null;
            }
        }
        if ((variableOrFieldTypeText = this.getPresentableTypeText(toUse2, substitutor, jsDoc, (PsiElement)typeOwner, originalElement)) != null) {
            this.appendType((PsiElement)typeOwner, StringUtil.shortenTextWithEllipsis((String)variableOrFieldTypeText, (int)2500, (int)10), builder2);
        }
        if (callSignatureType != null && (callTypeText = this.getPresentableTypeText(callSignatureType, substitutor, jsDoc, (PsiElement)typeOwner, originalElement)) != null) {
            builder2.append("\n");
            builder2.append(StringUtil.shortenTextWithEllipsis((String)callTypeText, (int)2500, (int)10));
        }
    }

    @Nullable
    protected final String createForFunction(@NotNull JSFunction function, @NotNull PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        List<JSDocParameterInfoPrinter> newParameters = this.mapParametersToInfos(function);
        JSDocBuilderSimpleInfo newReturnInfo = this.mapReturnTypeToInfo(function);
        return ((Object)this.getFunctionDefinitionWithHighlighting(function, (Collection<? extends JSDocParameterInfoPrinter>)newParameters, newReturnInfo, originalElement, false)).toString();
    }

    @Nullable
    protected JSType getNarrowedType(@NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        return null;
    }

    @NotNull
    protected String getFunctionNameWithHtml(@NotNull JSFunctionItem functionItem, @NotNull JSTypeSubstitutor substitutor, boolean jsDoc) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)functionItem, (String)"functionItem");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        boolean useParentDeclaration = !jsDoc || !this.hasContainerDeclaration(functionItem);
        PsiElement parent = useParentDeclaration ? JSResolveUtil.findParent((PsiElement)functionItem) : null;
        String namespace = this.getParentInfo(parent, functionItem, substitutor);
        String functionName = JSPsiImplUtils.findFunctionName(functionItem);
        if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            String unqualifiedFunctionName = functionName;
            JSExpression definition = ((JSAssignmentExpression)parent).getLOperand();
            if (definition instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)definition).getExpression()) != null) {
                JSQualifiedName qName;
                functionName = null;
                if (expression instanceof JSReferenceExpression && (qName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression)) != null) {
                    functionName = qName.getQualifiedName();
                }
                if (functionName == null) {
                    functionName = expression.getText();
                }
                if (namespace != null && Intrinsics.areEqual((Object)functionName, (Object)(namespace + "." + unqualifiedFunctionName))) {
                    namespace = null;
                }
            }
        }
        if (functionName == null) {
            functionName = "";
        }
        return !((charSequence = (CharSequence)namespace) == null || charSequence.length() == 0) ? namespace + this.getQNameSeparator((PsiElement)functionItem) + functionName : functionName;
    }

    @NotNull
    protected final String getQNameSeparator(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return ".";
    }

    @NotNull
    public final CharSequence getFunctionDefinitionWithHighlighting(@NotNull JSFunctionItem functionItem, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters2, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, boolean jsDoc) {
        Intrinsics.checkNotNullParameter((Object)functionItem, (String)"functionItem");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)returnInfo, (String)"returnInfo");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor(functionItem, originalElement);
        String escapedName = this.getFunctionNameWithHtml(functionItem, substitutor, jsDoc);
        return this.getFunctionDefinition(functionItem, escapedName, substitutor, parameters2, returnInfo, originalElement, jsDoc);
    }

    @NotNull
    protected CharSequence getFunctionDefinition(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters2, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, boolean jsDoc) {
        Intrinsics.checkNotNullParameter((Object)functionItem, (String)"functionItem");
        Intrinsics.checkNotNullParameter((Object)escapedName, (String)"escapedName");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)returnInfo, (String)"returnInfo");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Collection<? extends JSDocParameterInfoPrinter> parameters3 = parameters2;
        StringBuilder currentBuilder = new StringBuilder();
        currentBuilder.append("(");
        parameters3 = jsDoc ? parameters3 : this.expandParameters(functionItem, parameters3, substitutor);
        PsiElement parent = JSResolveUtil.findParent((PsiElement)functionItem);
        boolean shouldAppendFunctionKeyword = this.shouldAppendFunctionKeyword(functionItem, parent);
        StringBuilder modifiers = new StringBuilder();
        this.appendFunctionAttributes(functionItem, modifiers, shouldAppendFunctionKeyword);
        if (functionItem.isGetProperty()) {
            modifiers.append("get ");
        }
        if (functionItem.isSetProperty()) {
            modifiers.append("set ");
        }
        List placeholders = new ArrayList();
        int lastParameterIndex = parameters3.size() - 1;
        Iterator iterator = ((Iterable)parameters3).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JSParameterItem key;
            boolean lastArg;
            int index = n++;
            JSDocParameterInfoPrinter parameterInfo = (JSDocParameterInfoPrinter)iterator.next();
            boolean firstArg = index == 0;
            boolean bl = lastArg = index == lastParameterIndex;
            if (jsDoc) {
                if (firstArg) {
                    currentBuilder.append("\n");
                }
                StringUtil.repeatSymbol((Appendable)currentBuilder, (char)' ', (int)4);
            } else if (!firstArg) {
                currentBuilder.append(", ");
            }
            Intrinsics.checkNotNullExpressionValue((Object)parameterInfo.getParameterItem(), (String)"getParameterItem(...)");
            currentBuilder.append(JSParameterInfoHandlerKt.getSignatureForParameter(key, substitutor, (Function1<? super JSType, String>)((Function1)arg_0 -> JSQuickNavigateBuilder.getFunctionDefinition$lambda$3(this, substitutor, parameterInfo, placeholders, arg_0))));
            if (!jsDoc) continue;
            if (!lastArg || !DialectDetector.isActionScript((PsiElement)functionItem)) {
                currentBuilder.append(",");
            }
            currentBuilder.append("\n");
        }
        currentBuilder.append(")");
        StringBuilder returnTypeBuilder = new StringBuilder();
        if (returnInfo.hasType()) {
            currentBuilder.append(": ");
            JSType narrowedGetterType = functionItem.isGetProperty() ? this.getNarrowedType(originalElement, substitutor) : null;
            JSType returnType2 = this.getReturnTypeForQuickNavigate(functionItem, functionItem.isSetProperty(), returnInfo.type, substitutor, originalElement);
            JSType type2 = this.appendOptionality(functionItem, returnType2, narrowedGetterType, returnTypeBuilder, originalElement);
            if (!functionItem.isGetProperty()) {
                type2 = returnType2;
            }
            JSHtmlHighlightingUtil.TextPlaceholder textPlaceholder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(type2, returnInfo.hasFiredEvents, "$$Type$$Unique");
            Intrinsics.checkNotNullExpressionValue((Object)textPlaceholder, (String)"getTypeWithLinksPlaceholder(...)");
            JSHtmlHighlightingUtil.TextPlaceholder placeholder = textPlaceholder;
            ContainerUtil.addIfNotNull((Collection)placeholders, (Object)placeholder);
            currentBuilder.append(placeholder.getHolderText());
        }
        String s = "" + JSHtmlHighlightingUtil.getFunctionHtmlHighlighting(functionItem, escapedName, shouldAppendFunctionKeyword, modifiers, currentBuilder, placeholders) + returnTypeBuilder;
        if (jsDoc) {
            return s;
        }
        return JSQuickNavigateBuilder.buildResult(this.getFunctionKind(functionItem, JSPsiImplUtils.isGetterOrSetter(functionItem), shouldAppendFunctionKeyword), s, (PsiElement)functionItem, originalElement);
    }

    @NotNull
    protected Collection<JSDocParameterInfoPrinter> expandParameters(@NotNull JSFunctionItem functionItem, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters2, @NotNull JSTypeSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter((Object)functionItem, (String)"functionItem");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        return parameters2;
    }

    @NotNull
    protected final ObjectKind getFunctionKind(@NotNull JSFunctionItem function, boolean isGetterOrSetter, boolean shouldAppendKeyword) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (isGetterOrSetter) {
            return ObjectKind.PROPERTY;
        }
        if (function instanceof JSFunction && ((JSFunction)function).isConstructor()) {
            return ObjectKind.SIMPLE_DECLARATION;
        }
        PsiElement it = function.getParent();
        boolean bl = false;
        boolean bl2 = it instanceof JSClass || it instanceof TypeScriptObjectType;
        if (bl2 && !DialectDetector.isActionScript((PsiElement)function)) {
            return ObjectKind.METHOD;
        }
        return shouldAppendKeyword ? ObjectKind.SIMPLE_DECLARATION : ObjectKind.FUNCTION;
    }

    @NotNull
    protected final String createForVariableOrField(@NotNull JSFieldVariable variableOrField, @NotNull PsiElement originalElement, boolean jsDoc) {
        String prefix;
        Intrinsics.checkNotNullParameter((Object)variableOrField, (String)"variableOrField");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variableOrField);
        StringBuilder modifiers = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor(variableOrField, originalElement);
        this.appendAttrList(variableOrField, modifiers);
        boolean hasVarPrefix = false;
        if (variableOrField instanceof JSVariable && !(((CharSequence)(prefix = this.getVarPrefix((JSVariable)variableOrField))).length() == 0)) {
            hasVarPrefix = true;
            modifiers.append(prefix);
        }
        boolean useParentDeclaration = !jsDoc || !this.hasContainerDeclaration(variableOrField);
        String parentInfo = useParentDeclaration ? this.getParentInfo(parent, variableOrField, substitutor) : null;
        String string = JSDocumentationBuilder.getNameForDocumentation(variableOrField);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameForDocumentation(...)");
        String name = string;
        String qName = JSQuickNavigateBuilder.Companion.formatMemberAccess(parentInfo, name, this.getQNameSeparator((PsiElement)variableOrField));
        JSType declaredType = this.getVariableOrFieldType(variableOrField);
        CharSequence typeAndInitializer = this.createTypePart(variableOrField, originalElement, jsDoc, substitutor, declaredType);
        String textWithHighlighting = Companion.buildHtmlForVariableOrField((PsiElement)variableOrField, modifiers, qName, hasVarPrefix, jsDoc ? (CharSequence)"" : typeAndInitializer);
        if (jsDoc) {
            return textWithHighlighting + typeAndInitializer;
        }
        ObjectKind kind = this.getFieldOrVariableKind(variableOrField);
        return JSQuickNavigateBuilder.buildResult(kind, textWithHighlighting, (PsiElement)variableOrField, originalElement);
    }

    private final CharSequence createTypePart(JSElement element2, PsiElement originalElement, boolean jsDoc, JSTypeSubstitutor substitutor, JSType declaredType) {
        StringBuilder typePart = new StringBuilder();
        JSType narrowedType = this.getNarrowedType(originalElement, substitutor);
        JSType type2 = this.appendOptionality(element2, declaredType, narrowedType, typePart, originalElement);
        this.appendTypeWithSeparatorForOwner(element2, type2, substitutor, typePart, originalElement, jsDoc);
        if (element2 instanceof JSVariable && ((JSVariable)element2).hasInitializer() && !jsDoc) {
            this.appendVariableInitializer((JSVariable)element2, typePart);
        }
        return typePart;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<JSDocParameterInfoPrinter> mapParametersToInfos(@NotNull JSFunctionItem parsedFunction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parsedFunction, (String)"parsedFunction");
        JSParameterItem[] jSParameterItemArray = parsedFunction.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jSParameterItemArray, (String)"getParameters(...)");
        Object[] $this$map$iv = jSParameterItemArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JSParameterItem jSParameterItem = (JSParameterItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JSDocParameterInfoPrinter((JSParameterItem)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final JSDocBuilderSimpleInfo mapReturnTypeToInfo(@NotNull JSFunctionItem parsedFunction) {
        Intrinsics.checkNotNullParameter((Object)parsedFunction, (String)"parsedFunction");
        JSDocBuilderSimpleInfo newReturnInfo = new JSDocBuilderSimpleInfo();
        newReturnInfo.setJSType(parsedFunction.getReturnType());
        return newReturnInfo;
    }

    @Nullable
    protected JSType appendOptionality(@NotNull JSElement variableLikeElement, @Nullable JSType declaredType, @Nullable JSType narrowedType, @NotNull StringBuilder builder2, @NotNull PsiElement originalElement) {
        JSType toUse;
        Intrinsics.checkNotNullParameter((Object)variableLikeElement, (String)"variableLikeElement");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        JSType jSType = narrowedType;
        if (jSType == null) {
            jSType = toUse = declaredType;
        }
        if (variableLikeElement instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)variableLikeElement)).isOptional() || this.isGuessedOptional(variableLikeElement)) {
            builder2.append("?");
            if (!(narrowedType == null || declaredType instanceof JSUnionType && TypeScriptTypeRelations.isUnionWithUndefinedType(declaredType))) {
                toUse = JSCompositeTypeFactory.optimizeTypeIfComposite(narrowedType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
            }
        }
        return toUse;
    }

    protected boolean isGuessedOptional(@NotNull JSElement variableLikeElement) {
        Intrinsics.checkNotNullParameter((Object)variableLikeElement, (String)"variableLikeElement");
        return false;
    }

    @NotNull
    protected ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        Intrinsics.checkNotNullParameter((Object)variableOrField, (String)"variableOrField");
        return variableOrField instanceof JSParameter ? ObjectKind.PARAMETER : ObjectKind.SIMPLE_DECLARATION;
    }

    @Nullable
    public final String createForJSClass(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, boolean jsDoc) {
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        String qName = jsClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        StringBuilder attributesAndKeyword = new StringBuilder();
        String string = StringUtil.getPackageName((String)qName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        this.appendClassAttributes(jsClass, originalElement, packageName, attributesAndKeyword);
        qName = this.getClassQualifiedName(jsClass, packageName);
        String generics = this.getClassGenerics(jsClass, originalElement);
        JSHtmlHighlightingUtil.TextPlaceholder extendsImplementsPlaceholder = JSClassHighlightingHelper.getExtendsImplementsPlaceholder(jsClass, packageName, this.isIncludeObjectInExtendsList());
        String htmlForClass = JSQuickNavigateBuilder.Companion.buildHtmlForClass(jsClass, attributesAndKeyword, qName, generics, extendsImplementsPlaceholder);
        return jsDoc ? htmlForClass : JSQuickNavigateBuilder.buildResult(ObjectKind.SIMPLE_DECLARATION, htmlForClass, jsClass, originalElement);
    }

    @Nullable
    protected PsiElement getParentContainer(@NotNull PsiNamedElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    @Nullable
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element2, @NotNull JSTypeSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        if (parent instanceof JSClass) {
            return StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
        }
        return "";
    }

    @Nullable
    protected final JSType getReturnTypeForQuickNavigate(@NotNull JSFunctionItem function, boolean set, @Nullable JSType returnType2, @NotNull JSTypeSubstitutor substitutor, @NotNull PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        if (!set) {
            JSType type2 = returnType2;
            if (type2 instanceof JSFunctionReturnWrapperType) {
                type2 = ((JSFunctionReturnWrapperType)type2).substitute(originalElement);
            }
            if (!JSFormatUtil.isPossiblyPresentableType(type2, (PsiElement)function, true)) {
                return null;
            }
            return this.getTypeWithAppliedSubstitutor(type2, substitutor);
        }
        JSParameterItem[] jSParameterItemArray = function.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jSParameterItemArray, (String)"getParameters(...)");
        JSParameterItem[] parameters2 = jSParameterItemArray;
        if (parameters2.length > 0) {
            return this.getTypeWithAppliedSubstitutor(parameters2[0].getInferredType(), substitutor);
        }
        return null;
    }

    @Nullable
    protected final String getPresentableTypeText(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor, boolean jsDoc, @NotNull PsiElement context2, @NotNull PsiElement location) {
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        JSType type2 = this.getTypeWithAppliedSubstitutor(rawType, substitutor);
        if (type2 == null) {
            return null;
        }
        if (jsDoc) {
            JSType expandedType = JSQuickNavigateBuilder.Companion.expandTypeForPresentation(type2, false, location);
            return JSTypeHighlightingHelper.getTypeBody(expandedType, context2);
        }
        if (type2.isJavaScript() && type2 instanceof JSEvaluableOnlyType) {
            return null;
        }
        type2 = JSQuickNavigateBuilder.Companion.expandTypeForPresentation(type2, false, location);
        return type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
    }

    @Nullable
    protected final JSType getTypeWithAppliedSubstitutor(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        return JSTypeUtils.applyGenericArguments(JSTypeUtils.applyCompositeMapping(rawType, (Function<? super JSType, ? extends JSType>)((Function)arg_0 -> JSQuickNavigateBuilder.getTypeWithAppliedSubstitutor$lambda$7(JSQuickNavigateBuilder::getTypeWithAppliedSubstitutor$lambda$6, arg_0))), substitutor);
    }

    protected final void appendFunctionAttributes(@NotNull JSFunctionItem functionItem, @NotNull StringBuilder result2, boolean shouldAppendKeyword) {
        Intrinsics.checkNotNullParameter((Object)functionItem, (String)"functionItem");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (functionItem instanceof JSFunction) {
            this.appendAttrList((JSAttributeListOwner)((Object)functionItem), result2);
            if (shouldAppendKeyword) {
                result2.append(((JSFunction)functionItem).getKind() == JSFunction.FunctionKind.DECORATOR ? "decorator @" : "function ");
            }
        } else if (shouldAppendKeyword) {
            result2.append("function ");
        }
    }

    protected boolean shouldAppendFunctionKeyword(@NotNull JSFunctionItem function, @Nullable PsiElement parent) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (JSPsiImplUtils.isGetterOrSetter(function)) {
            return false;
        }
        if (function instanceof JSFunctionProperty || function instanceof TypeScriptFunctionSignature || function instanceof TypeScriptFunctionType) {
            return false;
        }
        return !(parent instanceof JSClass);
    }

    protected void appendAttrList(@NotNull JSAttributeListOwner owner, @NotNull StringBuilder result2) {
        JSElement exportScope;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList == null) {
            return;
        }
        JSAttributeList.AccessType accessType = attributeList.getAccessType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)accessType), (String)"getAccessType(...)");
        JSAttributeList.AccessType type2 = accessType;
        String visibilityOrExportPart = null;
        JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
        if (jsClass != null) {
            visibilityOrExportPart = this.formatVisibility(owner, attributeList, type2);
        } else if (owner instanceof JSQualifiedNamedElement && ((exportScope = ES6PsiUtil.getExportScope((PsiElement)owner)) instanceof TypeScriptModule || ES6PsiUtil.isExternalModule((PsiElement)exportScope))) {
            if (((JSQualifiedNamedElement)((Object)owner)).isExported()) {
                visibilityOrExportPart = "export";
            } else if (ES6ImportHandler.isExportedWithDefault((PsiElement)owner)) {
                visibilityOrExportPart = "export default";
            }
        }
        if (visibilityOrExportPart != null) {
            result2.append(visibilityOrExportPart);
            result2.append(" ");
        }
        this.appendPlainModifierList(attributeList, result2);
    }

    @Nullable
    protected String formatVisibility(@NotNull JSAttributeListOwner owner, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.AccessType type2) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)attributeList, (String)"attributeList");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return JSFormatUtil.formatVisibility(type2, (PsiElement)owner);
    }

    protected void appendPlainModifierList(@NotNull JSAttributeList attributeList, @NotNull StringBuilder result2) {
        Intrinsics.checkNotNullParameter((Object)attributeList, (String)"attributeList");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.ASYNC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.STATIC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.GENERATOR);
    }

    @Nullable
    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)variable);
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement el, @NotNull PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeSubstitutor, (String)"EMPTY");
        return jSTypeSubstitutor;
    }

    protected final void appendType(@NotNull PsiElement context2, @Nullable String typeText, @NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        CharSequence charSequence = typeText;
        if (!(charSequence == null || charSequence.length() == 0)) {
            builder2.append(JSSymbolPresentationProvider.getDefaultTypeSeparator(context2)).append(typeText);
        }
    }

    protected void appendClassAttributes(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.appendAttrList(jsClass, result2);
        result2.append(jsClass.isInterface() ? "interface " : "class ");
    }

    @NotNull
    protected final String getClassQualifiedName(@NotNull JSClass jsClass, @Nullable String packageOrModule) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        CharSequence charSequence = packageOrModule;
        if (!(charSequence == null || charSequence.length() == 0)) {
            object = packageOrModule + "." + jsClass.getName();
        } else {
            String string = jsClass.getName();
            object = string;
            Intrinsics.checkNotNull((Object)string);
        }
        return object;
    }

    @NotNull
    protected String getClassGenerics(@NotNull JSClass jsClass, @NotNull PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        return "";
    }

    protected boolean isIncludeObjectInExtendsList() {
        return false;
    }

    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        JSVarStatement.VarKeyword keyword;
        JSVarStatement statement;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        JSVarStatement jSVarStatement = statement = variable.getStatement();
        JSVarStatement.VarKeyword varKeyword = keyword = jSVarStatement != null ? jSVarStatement.getVarKeyword() : null;
        return varKeyword != null ? varKeyword.getText() + " " : "";
    }

    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        JSExpression initializer;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Object initializerText = variable.getLiteralOrReferenceInitializerText();
        if (initializerText == null && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            if (((String)initializerText).length() > 50) {
                String string = ((String)initializerText).substring(0, 50);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                initializerText = string + " ...";
            }
            result2.append(" = ").append((String)initializerText);
        }
    }

    @Nullable
    protected final String createQuickNavigateForJSElement(@NotNull JSElement element2, @NotNull PsiElement originalElement, @NotNull String declaration, @NotNull ObjectKind kind, boolean jsDoc) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        String qName = element2 instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element2).getQualifiedName() : element2.getName();
        CharSequence charSequence = qName;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder attributesAndDeclaration = new StringBuilder();
        if (element2 instanceof JSAttributeListOwner) {
            this.appendAttrList((JSAttributeListOwner)element2, attributesAndDeclaration);
        }
        attributesAndDeclaration.append(declaration);
        Object result2 = JSQuickNavigateBuilder.Companion.buildHtmlForJSElement(element2, attributesAndDeclaration, qName, !(((CharSequence)declaration).length() == 0));
        JSType declared = this.getJSElementType(element2, originalElement);
        if (declared != null) {
            JSTypeSubstitutor substitutor = this.getTypeSubstitutor(element2, originalElement);
            JSType narrowedType = this.getNarrowedType(originalElement, substitutor);
            StringBuilder builder2 = new StringBuilder();
            JSType type2 = this.appendOptionality(element2, declared, narrowedType, builder2, originalElement);
            this.appendTypeWithSeparatorForOwner(element2, type2, substitutor, builder2, originalElement, true);
            result2 = (String)result2 + builder2;
        }
        return jsDoc ? result2 : JSQuickNavigateBuilder.buildResult(kind, (String)result2, (PsiElement)element2, originalElement);
    }

    @Nullable
    protected JSType getJSElementType(@NotNull JSElement element2, @NotNull PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        if (element2 instanceof JSTypeOwner) {
            return ((JSTypeOwner)((Object)element2)).getJSType();
        }
        if (element2 instanceof ES6ImportedBinding) {
            PsiElement el;
            ResolveResult[] resolveResultArray = ((ES6ImportedBinding)element2).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult[] results = resolveResultArray;
            if (results.length == 1 && (el = results[0].getElement()) instanceof JSExpression) {
                return JSResolveUtil.getElementJSType(el);
            }
        }
        return null;
    }

    @Nullable
    public String getDocumentationFromLanguageService(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    private static final String getQuickNavigateInfoForNavigationElement$lambda$1(PsiElement $element, JSQuickNavigateBuilder this$0, Ref.ObjectRef $originalElement, boolean $jsDoc) {
        Object object;
        PsiElement psiElement = $element;
        if (psiElement instanceof JSFunction) {
            object = this$0.createForFunction((JSFunction)$element, (PsiElement)$originalElement.element);
        } else if (psiElement instanceof JSClass) {
            object = this$0.createForJSClass((JSClass)$element, (PsiElement)$originalElement.element, $jsDoc);
        } else if (psiElement instanceof JSFieldVariable) {
            object = this$0.createForVariableOrField((JSFieldVariable)$element, (PsiElement)$originalElement.element, $jsDoc);
        } else if (psiElement instanceof JSProperty) {
            object = this$0.createForProperty((JSProperty)$element, (PsiElement)$originalElement.element, $jsDoc);
        } else if (psiElement instanceof JSImplicitElement) {
            object = this$0.createQuickNavigateForJSElement((JSElement)$element, (PsiElement)$originalElement.element, "", ObjectKind.SIMPLE_DECLARATION, $jsDoc);
        } else if (psiElement instanceof XmlToken) {
            object = JSQuickNavigateBuilder.Companion.checkAndGetXmlAttributeQuickNavigate($element);
            if (object == null) {
                JSQuickNavigateBuilder $this$getQuickNavigateInfoForNavigationElement_u24lambda_u241_u24lambda_u240 = this$0;
                boolean bl = false;
                JSTagContextBuilder builder2 = new JSTagContextBuilder($element, "XmlTag");
                object = StringUtil.unquoteString((String)$element.getText()) + ":" + builder2.typeName;
            }
        } else {
            object = null;
        }
        return object;
    }

    private static final String getFunctionDefinition$lambda$3(JSQuickNavigateBuilder this$0, JSTypeSubstitutor $substitutor, JSDocParameterInfoPrinter $parameterInfo, List $placeholders, JSType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JSType t = it;
        if (!t.isSourceStrict()) {
            t = null;
        }
        t = this$0.getTypeWithAppliedSubstitutor(t, $substitutor);
        JSHtmlHighlightingUtil.TextPlaceholder textPlaceholder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(t, $parameterInfo.myBuilder.hasFiredEvents, "$$Type$$Parameter" + this$0.hashCode());
        Intrinsics.checkNotNullExpressionValue((Object)textPlaceholder, (String)"getTypeWithLinksPlaceholder(...)");
        JSHtmlHighlightingUtil.TextPlaceholder holder = textPlaceholder;
        $placeholders.add(holder);
        return ((Object)holder.getHolderText()).toString();
    }

    private static final JSType getTypeWithAppliedSubstitutor$lambda$6(JSType el) {
        return JSArrayType.GenericArrayBuilder.asArrayIfGenericType(JSCompositeTypeFactory.optimizeTypeIfComposite(el));
    }

    private static final JSType getTypeWithAppliedSubstitutor$lambda$7(Function1 $tmp0, Object p0) {
        return (JSType)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final String buildHtmlForFunction(@NotNull PsiElement context2, @NotNull CharSequence modifiers, @NotNull CharSequence qName, boolean hasFunctionKeyword, @NotNull CharSequence parametersWithReturnType) {
        return Companion.buildHtmlForFunction(context2, modifiers, qName, hasFunctionKeyword, parametersWithReturnType);
    }

    @JvmStatic
    @NotNull
    protected static final String buildResult(@NotNull ObjectKind kind, @NotNull String objectText, @NotNull PsiElement element2, @NotNull PsiElement originalElement) {
        return Companion.buildResult(kind, objectText, element2, originalElement);
    }

    @JvmStatic
    @NotNull
    public static final String buildHtmlForVariableOrField(@NotNull PsiElement owner, @NotNull CharSequence modifiers, @NotNull CharSequence escapedName, boolean hasVarPrefix, @NotNull CharSequence typeAndInitializer) {
        return Companion.buildHtmlForVariableOrField(owner, modifiers, escapedName, hasVarPrefix, typeAndInitializer);
    }

    @JvmStatic
    @NotNull
    public static final String getQuickNavigateHtmlHighlighting(@NotNull PsiElement owner, @NotNull CharSequence escapedName, @NotNull String prefixToExclude, @NotNull String finalText, @Nullable TextRange toHighlight) {
        return Companion.getQuickNavigateHtmlHighlighting(owner, escapedName, prefixToExclude, finalText, toHighlight);
    }

    @JvmStatic
    protected static final void appendModifierWithSpace(@NotNull StringBuilder result2, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        Companion.appendModifierWithSpace(result2, attributeList, modifier);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0004J0\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\rH\u0007J(\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0005J\"\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0002J0\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\rH\u0007J2\u0010*\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\b\u0010-\u001a\u0004\u0018\u00010.H\u0007J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0002J0\u00101\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0015H\u0002J\"\u00109\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00172\b\u0010;\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u0010<\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010;\u001a\u0004\u0018\u00010\u0015H\u0002J$\u0010=\u001a\u00020>2\n\u0010?\u001a\u00060@j\u0002`A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0005J(\u0010F\u001a\u00020\b2\u0006\u0010\t\u001a\u00020G2\u0006\u0010H\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010I\u001a\u00020\u0017H\u0002J \u0010J\u001a\u00070\b\u00a2\u0006\u0002\bK2\u0006\u0010\t\u001a\u00020\u00152\u000b\u0010L\u001a\u00070\b\u00a2\u0006\u0002\bKR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$Companion;", "", "<init>", "()V", "INITIALIZER_MAX_LENGTH", "", "TYPE_MAX_LENGTH", "buildHtmlForProperty", "", "element", "Lcom/intellij/lang/javascript/psi/JSProperty;", "qName", "typePart", "", "getPropertyParent", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "property", "getCallSignatureTypeFromCallSite", "Lcom/intellij/lang/javascript/psi/JSType;", "type", "context", "Lcom/intellij/psi/PsiElement;", "isFileNameRequired", "", "originalElement", "buildHtmlForFunction", "modifiers", "hasFunctionKeyword", "parametersWithReturnType", "buildResult", "kind", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "objectText", "formatMemberAccess", "parentQualifier", "unescapedName", "separator", "buildHtmlForVariableOrField", "owner", "escapedName", "hasVarPrefix", "typeAndInitializer", "getQuickNavigateHtmlHighlighting", "prefixToExclude", "finalText", "toHighlight", "Lcom/intellij/openapi/util/TextRange;", "buildAdditionalInformationText", "text", "buildHtmlForClass", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "attributesAndKeyword", "generics", "extendsImplementsPlaceholder", "Lcom/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$TextPlaceholder;", "checkAndGetXmlAttributeQuickNavigate", "expandTypeForPresentation", "nested", "location", "simplifyGenericArguments", "appendModifierWithSpace", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "attributeList", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList;", "modifier", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$ModifierType;", "buildHtmlForJSElement", "Lcom/intellij/lang/javascript/psi/JSElement;", "prefix", "hasDeclaration", "buildHtmlForName", "Lcom/intellij/openapi/util/NlsSafe;", "name", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJSQuickNavigateBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSQuickNavigateBuilder.kt\ncom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1152:1\n1617#2,9:1153\n1869#2:1162\n1870#2:1164\n1626#2:1165\n1563#2:1166\n1634#2,3:1167\n1#3:1163\n*S KotlinDebug\n*F\n+ 1 JSQuickNavigateBuilder.kt\ncom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$Companion\n*L\n934#1:1153,9\n934#1:1162\n934#1:1164\n934#1:1165\n1114#1:1166\n1114#1:1167,3\n934#1:1163\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String buildHtmlForProperty(JSProperty element2, String qName, CharSequence typePart) {
            return this.buildHtmlForVariableOrField((PsiElement)element2, "", qName, false, typePart);
        }

        private final JSQualifiedNamedElement getPropertyParent(JSProperty property) {
            PsiElement literalContainer;
            PsiElement parent = property.getParent();
            if (parent instanceof JSObjectLiteralExpression && (literalContainer = ((JSObjectLiteralExpression)parent).getParent()) instanceof JSVariable) {
                return (JSQualifiedNamedElement)literalContainer;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final JSType getCallSignatureTypeFromCallSite(JSType type2, PsiElement context2) {
            boolean isNew;
            JSType expanded;
            JSCallExpression callExpression;
            PsiElement currentContext = context2 instanceof JSExpression ? context2 : context2.getContext();
            PsiElement callCandidate = currentContext != null && !(currentContext instanceof JSCallExpression) ? currentContext.getContext() : null;
            JSCallExpression jSCallExpression = callExpression = callCandidate instanceof JSCallExpression ? (JSCallExpression)callCandidate : null;
            if (type2 != null && callExpression != null && TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, currentContext), isNew = callExpression.isNewExpression())) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List<JSRecordType.CallSignature> list = expanded.asRecordType().getCallSignatures();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCallSignatures(...)");
                Iterable iterable = list;
                boolean $i$f$mapNotNull = false;
                void var11_10 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    JSFunctionType it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    JSRecordType.CallSignature sig = (JSRecordType.CallSignature)element$iv$iv;
                    boolean bl2 = false;
                    if ((isNew != sig.hasNew() ? null : sig.getFunctionType()) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List functionTypes = (List)destination$iv$iv;
                List<JSTypeSignatureChooser.FunctionTypeWithKind> overloads = new JSTypeSignatureChooser(callExpression).chooseOverload(functionTypes, OverloadStrictness.UNIQUE);
                if (!overloads.isEmpty()) {
                    return overloads.get(0).getJsFunction();
                }
            }
            return null;
        }

        protected final boolean isFileNameRequired(@NotNull PsiElement element2, @NotNull PsiElement originalElement) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
            return elementFile == null || !Intrinsics.areEqual((Object)elementFile, (Object)originalFile);
        }

        @JvmStatic
        @NotNull
        public final String buildHtmlForFunction(@NotNull PsiElement context2, @NotNull CharSequence modifiers, @NotNull CharSequence qName, boolean hasFunctionKeyword, @NotNull CharSequence parametersWithReturnType) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)parametersWithReturnType, (String)"parametersWithReturnType");
            String prefix = hasFunctionKeyword ? "" : "class Foo { ";
            String finalText = prefix + modifiers + "$$Name$$" + parametersWithReturnType;
            int beforeNameLength = prefix.length() + modifiers.length();
            TextRange toHighlight = new TextRange(beforeNameLength, beforeNameLength + 8);
            return this.getQuickNavigateHtmlHighlighting(context2, qName, prefix, finalText, toHighlight);
        }

        @JvmStatic
        @NotNull
        protected final String buildResult(@NotNull ObjectKind kind, @NotNull String objectText, @NotNull PsiElement element2, @NotNull PsiElement originalElement) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)objectText, (String)"objectText");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            boolean needFileName = this.isFileNameRequired(element2, originalElement);
            if (!needFileName) {
                return kind.toPrefix() + objectText;
            }
            PsiFile psiFile = element2.getContainingFile();
            String fileNameText = "(" + psiFile.getName() + ")";
            String kindText = kind.toPrefix();
            return kindText + objectText + this.buildAdditionalInformationText(fileNameText);
        }

        private final String formatMemberAccess(String parentQualifier, String unescapedName, String separator) {
            Object qName = "";
            CharSequence charSequence = parentQualifier;
            if (!(charSequence == null || charSequence.length() == 0)) {
                qName = parentQualifier;
                if (!StringUtil.startsWithChar((CharSequence)unescapedName, (char)'[')) {
                    qName = (String)qName + separator;
                }
            }
            qName = (String)qName + XmlStringUtil.escapeString((String)unescapedName);
            return qName;
        }

        @JvmStatic
        @NotNull
        public final String buildHtmlForVariableOrField(@NotNull PsiElement owner, @NotNull CharSequence modifiers, @NotNull CharSequence escapedName, boolean hasVarPrefix, @NotNull CharSequence typeAndInitializer) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
            Intrinsics.checkNotNullParameter((Object)escapedName, (String)"escapedName");
            Intrinsics.checkNotNullParameter((Object)typeAndInitializer, (String)"typeAndInitializer");
            String prefix = hasVarPrefix ? "" : (owner instanceof JSParameter ? "function f( " : "class { ");
            String finalText = prefix + modifiers + "$$Name$$" + StringUtil.shortenTextWithEllipsis((String)((Object)typeAndInitializer).toString(), (int)2500, (int)20);
            int modifiersWithPrefixLength = modifiers.length() + prefix.length();
            TextRange toHighlight = new TextRange(modifiersWithPrefixLength, modifiersWithPrefixLength + 8);
            return this.getQuickNavigateHtmlHighlighting(owner, escapedName, prefix, finalText, toHighlight);
        }

        @JvmStatic
        @NotNull
        public final String getQuickNavigateHtmlHighlighting(@NotNull PsiElement owner, @NotNull CharSequence escapedName, @NotNull String prefixToExclude, @NotNull String finalText, @Nullable TextRange toHighlight) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)escapedName, (String)"escapedName");
            Intrinsics.checkNotNullParameter((Object)prefixToExclude, (String)"prefixToExclude");
            Intrinsics.checkNotNullParameter((Object)finalText, (String)"finalText");
            CharSequence html = JSHtmlHighlightingUtil.tryGetHtmlHighlighting(owner, finalText, toHighlight, prefixToExclude.length(), finalText.length());
            CharSequence charSequence = html;
            if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null || (charSequence = StringsKt.replace$default((String)charSequence, (String)"font-style:italic;", (String)"", (boolean)false, (int)4, null)) == null) {
                String string = finalText.substring(prefixToExclude.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                charSequence = XmlStringUtil.escapeString((String)string, (boolean)false);
            }
            CharSequence result2 = charSequence;
            Intrinsics.checkNotNull((Object)result2);
            return StringsKt.replace$default((String)result2, (String)"$$Name$$", (String)((Object)escapedName).toString(), (boolean)false, (int)4, null);
        }

        private final String buildAdditionalInformationText(String text) {
            if (((CharSequence)text).length() == 0) {
                return "";
            }
            Color color = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getDefaultAttributes().getForegroundColor();
            StringBuilder result2 = new StringBuilder();
            result2.append(" <span");
            result2.append(" style=\"");
            Font font = StartupUiUtil.getLabelFont();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                result2.append("font-size:").append(font.getSize()).append("pt").append(";");
            }
            if (color != null) {
                result2.append("color:").append(ColorUtil.toHex((Color)color)).append(";");
            }
            result2.append("\">");
            result2.append(text);
            result2.append("</span>");
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String buildHtmlForClass(JSClass jsClass, CharSequence attributesAndKeyword, String qName, String generics, JSHtmlHighlightingUtil.TextPlaceholder extendsImplementsPlaceholder) {
            String finalText = attributesAndKeyword + "$$Name$$" + generics + extendsImplementsPlaceholder.getHolderText();
            TextRange range = new TextRange(attributesAndKeyword.length(), attributesAndKeyword.length() + 8);
            String html = this.getQuickNavigateHtmlHighlighting(jsClass, qName, "", finalText, range);
            return ((Object)extendsImplementsPlaceholder.restoreText(html)).toString();
        }

        private final String checkAndGetXmlAttributeQuickNavigate(PsiElement element2) {
            PsiElement psiElement;
            PsiElement parent = element2.getParent();
            Object object = parent instanceof XmlAttribute ? (XmlAttribute)parent : (parent instanceof XmlAttributeValue ? ((psiElement = ((XmlAttributeValue)parent).getParent()) instanceof XmlAttribute ? (XmlAttribute)psiElement : null) : null);
            XmlAttribute xmlAttribute = object;
            if (xmlAttribute == null) {
                return null;
            }
            String string = xmlAttribute.getValue();
            if (string == null) {
                string = "";
            }
            String string2 = StringUtil.unquoteString((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteString(...)");
            String value = string2;
            return xmlAttribute.getName() + " " + value;
        }

        private final JSType expandTypeForPresentation(JSType type2, boolean nested, PsiElement location) {
            if (type2 instanceof JSEvaluableType || type2 instanceof JSUnionOrIntersectionType || type2 instanceof JSGenericTypeImpl || type2 instanceof JSTypeImpl && ((JSTypeImpl)type2).getJSTypedef() instanceof JSEvaluableType) {
                JSType jSType;
                JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, location);
                if (nested) {
                    Intrinsics.checkNotNull((Object)expanded);
                    jSType = expanded;
                } else {
                    Intrinsics.checkNotNull((Object)expanded);
                    jSType = this.simplifyGenericArguments(expanded, location);
                }
                return jSType;
            }
            return type2;
        }

        /*
         * WARNING - void declaration
         */
        private final JSType simplifyGenericArguments(JSType type2, PsiElement location) {
            if (type2 instanceof JSGenericTypeImpl) {
                void $this$mapTo$iv$iv;
                List<JSType> list = ((JSGenericTypeImpl)type2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSType jSType = (JSType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(Companion.expandTypeForPresentation((JSType)it, true, location));
                }
                List nested = (List)destination$iv$iv;
                return new JSGenericTypeImpl(((JSGenericTypeImpl)type2).getSource(), ((JSGenericTypeImpl)type2).getType(), nested);
            }
            return type2;
        }

        @JvmStatic
        protected final void appendModifierWithSpace(@NotNull StringBuilder result2, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)attributeList, (String)"attributeList");
            Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
            if (attributeList.hasModifier(modifier)) {
                result2.append(modifier.keyword).append(" ");
            }
        }

        private final String buildHtmlForJSElement(JSElement element2, CharSequence prefix, String qName, boolean hasDeclaration) {
            if (hasDeclaration) {
                String finalText = prefix + "$$Name$$";
                TextRange range = new TextRange(prefix.length(), prefix.length() + 8);
                return this.getQuickNavigateHtmlHighlighting((PsiElement)element2, qName, "", finalText, range);
            }
            return prefix + this.buildHtmlForName((PsiElement)element2, qName);
        }

        @NotNull
        public final String buildHtmlForName(@NotNull PsiElement element2, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = JSHtmlHighlightingUtil.tryGetHtmlHighlightingForName(element2, name);
            if (string == null) {
                String string2 = XmlStringUtil.escapeString((String)name, (boolean)false);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeString(...)");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u000eH\u0016j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "", "<init>", "(Ljava/lang/String;I)V", "SIMPLE_DECLARATION", "PROPERTY", "PARAMETER", "FUNCTION", "METHOD", "IMPORT_SPECIFIER", "IMPORT_DEFAULT", "IMPORT_ALL", "EXPORT", "toPrefix", "", "toJSDocPrefix", "intellij.javascript.impl"})
    public static final abstract class ObjectKind
    extends Enum<ObjectKind> {
        public static final /* enum */ ObjectKind SIMPLE_DECLARATION = new SIMPLE_DECLARATION("SIMPLE_DECLARATION", 0);
        public static final /* enum */ ObjectKind PROPERTY = new PROPERTY("PROPERTY", 1);
        public static final /* enum */ ObjectKind PARAMETER = new PARAMETER("PARAMETER", 2);
        public static final /* enum */ ObjectKind FUNCTION = new FUNCTION("FUNCTION", 3);
        public static final /* enum */ ObjectKind METHOD = new METHOD("METHOD", 4);
        public static final /* enum */ ObjectKind IMPORT_SPECIFIER = new IMPORT_SPECIFIER("IMPORT_SPECIFIER", 5);
        public static final /* enum */ ObjectKind IMPORT_DEFAULT = new IMPORT_DEFAULT("IMPORT_DEFAULT", 6);
        public static final /* enum */ ObjectKind IMPORT_ALL = new IMPORT_ALL("IMPORT_ALL", 7);
        public static final /* enum */ ObjectKind EXPORT = new EXPORT("EXPORT", 8);
        private static final /* synthetic */ ObjectKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ObjectKind() {
        }

        @NotNull
        public abstract String toPrefix();

        @NotNull
        public String toJSDocPrefix() {
            return "";
        }

        public static ObjectKind[] values() {
            return (ObjectKind[])$VALUES.clone();
        }

        public static ObjectKind valueOf(String value) {
            return Enum.valueOf(ObjectKind.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectKind> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ ObjectKind(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = objectKindArray = new ObjectKind[]{ObjectKind.SIMPLE_DECLARATION, ObjectKind.PROPERTY, ObjectKind.PARAMETER, ObjectKind.FUNCTION, ObjectKind.METHOD, ObjectKind.IMPORT_SPECIFIER, ObjectKind.IMPORT_DEFAULT, ObjectKind.IMPORT_ALL, ObjectKind.EXPORT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.EXPORT", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class EXPORT
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            EXPORT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(export element) ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.FUNCTION", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class FUNCTION
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            FUNCTION() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(function) ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.IMPORT_ALL", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class IMPORT_ALL
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            IMPORT_ALL() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(namespace import) ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.IMPORT_DEFAULT", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "toJSDocPrefix", "intellij.javascript.impl"})
        static final class IMPORT_DEFAULT
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            IMPORT_DEFAULT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(default import) ";
            }

            @Override
            @NotNull
            public String toJSDocPrefix() {
                return "import ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.IMPORT_SPECIFIER", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "toJSDocPrefix", "intellij.javascript.impl"})
        static final class IMPORT_SPECIFIER
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            IMPORT_SPECIFIER() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(named import) ";
            }

            @Override
            @NotNull
            public String toJSDocPrefix() {
                return "import ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.METHOD", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class METHOD
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            METHOD() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(method) ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.PARAMETER", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class PARAMETER
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            PARAMETER() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(parameter) ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.PROPERTY", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class PROPERTY
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            PROPERTY() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "(property) ";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION", "Lcom/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind;", "toPrefix", "", "intellij.javascript.impl"})
        static final class SIMPLE_DECLARATION
        extends ObjectKind {
            /*
             * WARNING - void declaration
             */
            SIMPLE_DECLARATION() {
                void var1_1;
            }

            @Override
            @NotNull
            public String toPrefix() {
                return "";
            }
        }
    }
}

