/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest.config;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u0010\u0010\u001a\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/javascript/testing/vitest/config/VitestConfig;", "", "<init>", "()V", "VITEST_CONFIG", "", "VITE_CONFIG", "CONFIG_FILE_NAMES_WITHOUT_EXT", "", "EXTENSIONS", "VITEST_CONFIG_TS_NAME", "VITEST_CONFIG_NAMES", "", "DEFAULT_CONFIG_NAMES", "TEST_PROPERTY_NAME", "generate", "namesWithoutExt", "findDefaultConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "listPossibleConfigFilesInProject", "project", "Lcom/intellij/openapi/project/Project;", "isVitestConfigFile", "", "file", "isConfigFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "isConfigFileName", "name", "findAncestorTestConfigProperty", "Lcom/intellij/lang/javascript/psi/JSProperty;", "element", "Lcom/intellij/psi/PsiElement;", "isTestProperty", "testProperty", "checkPropertyName", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nVitestConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestConfig.kt\ncom/intellij/javascript/testing/vitest/config/VitestConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1460#2,2:62\n1563#2:64\n1634#2,3:65\n1462#2,3:68\n*S KotlinDebug\n*F\n+ 1 VitestConfig.kt\ncom/intellij/javascript/testing/vitest/config/VitestConfig\n*L\n24#1:62,2\n24#1:64\n24#1:65,3\n24#1:68,3\n*E\n"})
public final class VitestConfig {
    @NotNull
    public static final VitestConfig INSTANCE = new VitestConfig();
    @NotNull
    public static final String VITEST_CONFIG = "vitest.config";
    @NotNull
    public static final String VITE_CONFIG = "vite.config";
    @NotNull
    private static final List<String> CONFIG_FILE_NAMES_WITHOUT_EXT;
    @NotNull
    private static final List<String> EXTENSIONS;
    @NotNull
    private static final String VITEST_CONFIG_TS_NAME = "vitest.config.ts";
    @NotNull
    private static final Set<String> VITEST_CONFIG_NAMES;
    @NotNull
    private static final Set<String> DEFAULT_CONFIG_NAMES;
    @NotNull
    public static final String TEST_PROPERTY_NAME = "test";

    private VitestConfig() {
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> generate(List<String> namesWithoutExt) {
        void var3_3;
        void $this$flatMapTo$iv;
        Iterable iterable = namesWithoutExt;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            String nameWithoutExt = (String)element$iv;
            boolean bl = false;
            Iterable $this$map$iv = EXTENSIONS;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(nameWithoutExt + (String)it);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var3_3;
    }

    @Nullable
    public final VirtualFile findDefaultConfigFile(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Stream stream = DEFAULT_CONFIG_NAMES.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream), arg_0 -> VitestConfig.findDefaultConfigFile$lambda$2(dir, arg_0)), VitestConfig::findDefaultConfigFile$lambda$3));
    }

    @NotNull
    public final List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getContentScope(...)");
        GlobalSearchScope contentScope = globalSearchScope;
        Collection collection = FilenameIndex.getVirtualFilesByName((String)VITEST_CONFIG_TS_NAME, (GlobalSearchScope)contentScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final boolean isVitestConfigFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return VITEST_CONFIG_NAMES.contains(file.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConfigFile(@Nullable VirtualFile file) {
        if (file == null) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.isConfigFileName(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConfigFile(@Nullable PsiFile psiFile) {
        if (psiFile == null) return false;
        String string = psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.isConfigFileName(string)) return false;
        return true;
    }

    private final boolean isConfigFileName(String name) {
        return DEFAULT_CONFIG_NAMES.contains(name);
    }

    @Nullable
    public final JSProperty findAncestorTestConfigProperty(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        JSProperty property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, JSProperty.class, (boolean)false);
        while (property != null && !this.isTestProperty(property, true)) {
            property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)property), JSProperty.class, (boolean)true);
        }
        return property;
    }

    public final boolean isTestProperty(@NotNull JSProperty testProperty, boolean checkPropertyName) {
        Intrinsics.checkNotNullParameter((Object)testProperty, (String)"testProperty");
        if (checkPropertyName && !Intrinsics.areEqual((Object)testProperty.getName(), (Object)TEST_PROPERTY_NAME)) {
            return false;
        }
        PsiElement psiElement = testProperty.getParent();
        JSObjectLiteralExpression jSObjectLiteralExpression = psiElement instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)psiElement : null;
        if (jSObjectLiteralExpression == null) {
            return false;
        }
        JSObjectLiteralExpression objExpr = jSObjectLiteralExpression;
        PsiElement psiElement2 = objExpr.getParent();
        JSArgumentList jSArgumentList = psiElement2 instanceof JSArgumentList ? (JSArgumentList)psiElement2 : null;
        if (jSArgumentList == null) {
            return false;
        }
        JSArgumentList argList = jSArgumentList;
        Object object = argList.getParent();
        JSCallExpression jSCallExpression = object instanceof JSCallExpression ? (JSCallExpression)object : null;
        if (jSCallExpression == null) {
            return false;
        }
        JSCallExpression callExpr = jSCallExpression;
        object = callExpr.getMethodExpression();
        JSReferenceExpression jSReferenceExpression = object instanceof JSReferenceExpression ? (JSReferenceExpression)object : null;
        return Intrinsics.areEqual((Object)(jSReferenceExpression != null ? jSReferenceExpression.getReferenceName() : null), (Object)"defineConfig");
    }

    private static final VirtualFile findDefaultConfigFile$lambda$2(VirtualFile $dir, String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $dir.findChild(name);
    }

    private static final boolean findDefaultConfigFile$lambda$3(VirtualFile file) {
        return file != null && !file.isDirectory();
    }

    static {
        Object[] objectArray = new String[]{VITEST_CONFIG, VITE_CONFIG};
        CONFIG_FILE_NAMES_WITHOUT_EXT = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{".ts", ".js", ".mjs", ".mts"};
        EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        VITEST_CONFIG_NAMES = INSTANCE.generate(CollectionsKt.listOf((Object)VITEST_CONFIG));
        DEFAULT_CONFIG_NAMES = INSTANCE.generate(CONFIG_FILE_NAMES_WITHOUT_EXT);
    }
}

