/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.notifications;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.JBColor;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/ui/notifications/KubernetesSuggestClusterConfigurationPanel;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isKubernetesRelatedFile", "", "SubscriptionService", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesSuggestClusterConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSuggestClusterConfigurationPanel.kt\ncom/intellij/kubernetes/ui/notifications/KubernetesSuggestClusterConfigurationPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,96:1\n30#2,2:97\n30#2,2:99\n*S KotlinDebug\n*F\n+ 1 KubernetesSuggestClusterConfigurationPanel.kt\ncom/intellij/kubernetes/ui/notifications/KubernetesSuggestClusterConfigurationPanel\n*L\n37#1:97,2\n44#1:99,2\n*E\n"})
public final class KubernetesSuggestClusterConfigurationPanel
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SubscriptionService> serviceClass$iv = SubscriptionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((SubscriptionService)object).getApiInitJob().isActive()) {
            return null;
        }
        if (PropertiesComponent.getInstance((Project)project).isTrueValue("KUBERNETES_SUPPRESS_CONFIG_CLUSTER_SUGGESTION")) {
            return null;
        }
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        if (!this.isKubernetesRelatedFile(file, project)) {
            return null;
        }
        KubernetesApiProviderInterface kubernetesApiProvider = KubernetesApiProvider.Companion.getInstance(project);
        if (Intrinsics.areEqual((Object)kubernetesApiProvider.getKubeconfigFilesState(), (Object)KubernetesApiProviderInterface.KubeconfigState.Companion.getNOT_INITIALISED())) {
            ComponentManager $this$service$iv2 = (ComponentManager)project;
            boolean $i$f$service2 = false;
            Class<SubscriptionService> serviceClass$iv2 = SubscriptionService.class;
            Object object2 = $this$service$iv2.getService(serviceClass$iv2);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
            }
            ((SubscriptionService)object2).getApiInitJob().start();
            return null;
        }
        if (kubernetesApiProvider.getKubeconfigFilesState().getErrorMessage() != null) {
            return null;
        }
        if (!kubernetesApiProvider.getApiModels().isEmpty()) {
            return null;
        }
        return arg_0 -> KubernetesSuggestClusterConfigurationPanel.collectNotificationData$lambda$2(project, arg_0);
    }

    private final boolean isKubernetesRelatedFile(VirtualFile file, Project project) {
        if (UtilsKt.isPlainKubernetesFile(file, project)) {
            return true;
        }
        if (KubeConfig.isKubeConfig((VirtualFile)file, (Project)project)) {
            return true;
        }
        if (Chart.Companion.isChartDefinitionYaml(file)) {
            return true;
        }
        if (Chart.Companion.isChartsTemplateFile(file)) {
            return true;
        }
        return KubernetesUtilKt.isKustomizationVirtualFile(file);
    }

    private static final void collectNotificationData$lambda$2$lambda$1$lambda$0(Project $project) {
        PropertiesComponent.getInstance((Project)$project).setValue("KUBERNETES_SUPPRESS_CONFIG_CLUSTER_SUGGESTION", true);
        EditorNotifications.getInstance((Project)$project).updateAllNotifications();
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$2(Project $project, FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u242_u24lambda_u241 = editorNotificationPanel = new EditorNotificationPanel(JBColor.PanelBackground, EditorNotificationPanel.Status.Info);
        boolean bl = false;
        $this$collectNotificationData_u24lambda_u242_u24lambda_u241.setText(KubernetesBundle.message((String)"KubernetesSuggestClusterConfigurationPanel.text", (Object[])new Object[0]));
        $this$collectNotificationData_u24lambda_u242_u24lambda_u241.createActionLabel(KubernetesBundle.message((String)"KubernetesSuggestClusterConfigurationPanel.add.cluster", (Object[])new Object[0]), "Kubernetes.AddContexts");
        $this$collectNotificationData_u24lambda_u242_u24lambda_u241.createActionLabel(KubernetesBundle.message((String)"KubernetesSuggestClusterConfigurationPanel.dismiss", (Object[])new Object[0]), () -> KubernetesSuggestClusterConfigurationPanel.collectNotificationData$lambda$2$lambda$1$lambda$0($project));
        return editorNotificationPanel;
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/ui/notifications/KubernetesSuggestClusterConfigurationPanel$SubscriptionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "apiInitJob", "Lkotlinx/coroutines/Job;", "getApiInitJob", "()Lkotlinx/coroutines/Job;", "intellij.clouds.kubernetes.backend"})
    private static final class SubscriptionService {
        @NotNull
        private final Project project;
        @NotNull
        private final Job apiInitJob;

        public SubscriptionService(@NotNull Project project, @NotNull CoroutineScope scope2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            this.project = project;
            KubernetesApiProviderInterface provider = KubernetesApiProvider.Companion.getInstance(this.project);
            BuildersKt.launch$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(provider, this, null){
                int label;
                final /* synthetic */ KubernetesApiProviderInterface $provider;
                final /* synthetic */ SubscriptionService this$0;
                {
                    this.$provider = $provider;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Flow[] flowArray = new Flow[]{this.$provider.getApiModelAdded(), this.$provider.getApiModelRemoved()};
                            this.label = 1;
                            Object object2 = FlowKt.merge((Flow[])flowArray).collect(new FlowCollector(){

                                public final Object emit(KubernetesApiModelInterface it, Continuation<? super Unit> $completion) {
                                    EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.apiInitJob = (Job)BuildersKt.async$default((CoroutineScope)scope2, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ SubscriptionService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            kubernetesApiProvider = KubernetesApiProvider.Companion.getInstance(SubscriptionService.access$getProject$p(this.this$0));
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)kubernetesApiProvider);
                            this.label = 1;
                            v0 = kubernetesApiProvider.awaitStateConfigured((Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            kubernetesApiProvider = (KubernetesApiProviderInterface)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            EditorNotifications.getInstance((Project)SubscriptionService.access$getProject$p(this.this$0)).updateAllNotifications();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @NotNull
        public final Job getApiInitJob() {
            return this.apiInitJob;
        }
    }
}

