/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.actions.KubernetesLogsPatterMatchingActionKt;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/logs/actions/TriStateToggle;", "Ljavax/swing/JPanel;", "pattern", "Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;", "initialState", "Lcom/intellij/kubernetes/logs/actions/TriStateToggle$State;", "<init>", "(Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;Lcom/intellij/kubernetes/logs/actions/TriStateToggle$State;)V", "getPattern", "()Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;", "textLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "iconLabel", "Lcom/intellij/ui/components/JBLabel;", "value", "state", "getState", "()Lcom/intellij/kubernetes/logs/actions/TriStateToggle$State;", "toggleState", "", "updateIcon", "Companion", "State", "intellij.clouds.kubernetes.backend"})
public final class TriStateToggle
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogCluster pattern;
    @NotNull
    private final SimpleColoredComponent textLabel;
    @NotNull
    private final JBLabel iconLabel;
    @NotNull
    private State state;
    @NotNull
    private static final Icon excludedIcon;

    public TriStateToggle(@NotNull LogCluster pattern, @NotNull State initialState) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)initialState), (String)"initialState");
        this.pattern = pattern;
        this.textLabel = new SimpleColoredComponent();
        KubernetesLogsPatterMatchingActionKt.access$addPrettyPatternText(this.textLabel, this.pattern);
        Object[] objectArray = new Object[]{this.pattern.sightings()};
        this.textLabel.append(KubernetesBundle.message((String)"k8s.logs..pattern.matching.matching.count.text", (Object[])objectArray), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        this.iconLabel = new JBLabel();
        this.state = initialState;
        this.setLayout(new BorderLayout());
        this.add((Component)this.iconLabel, "West");
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.add((Component)this.textLabel, "Center");
        this.updateIcon();
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.toggleState();
                this.updateIcon();
            }
        });
    }

    public /* synthetic */ TriStateToggle(LogCluster logCluster, State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            state = State.UNCHECKED;
        }
        this(logCluster, state);
    }

    @NotNull
    public final LogCluster getPattern() {
        return this.pattern;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    private final void toggleState() {
        this.state = switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1 -> State.CHECKED;
            case 2 -> State.EXCLUDED;
            case 3 -> State.UNCHECKED;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.firePropertyChange("state", null, (Object)this.state);
    }

    private final void updateIcon() {
        this.iconLabel.setIcon(switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1 -> AllIcons.Diff.GutterCheckBox;
            case 2 -> AllIcons.Diff.GutterCheckBoxSelected;
            case 3 -> excludedIcon;
            default -> throw new NoWhenBranchMatchedException();
        });
        this.updateUI();
    }

    static {
        Icon icon = AllIcons.Diff.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Remove");
        excludedIcon = icon;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/logs/actions/TriStateToggle$Companion;", "", "<init>", "()V", "excludedIcon", "Ljavax/swing/Icon;", "getExcludedIcon", "()Ljavax/swing/Icon;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Icon getExcludedIcon() {
            return excludedIcon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/logs/actions/TriStateToggle$State;", "", "<init>", "(Ljava/lang/String;I)V", "UNCHECKED", "CHECKED", "EXCLUDED", "intellij.clouds.kubernetes.backend"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State UNCHECKED = new State();
        public static final /* enum */ State CHECKED = new State();
        public static final /* enum */ State EXCLUDED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.UNCHECKED, State.CHECKED, State.EXCLUDED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.UNCHECKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.CHECKED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.EXCLUDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

