/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.actions.KubernetesLogFilteringActionsKt;
import com.intellij.kubernetes.logs.ui.KubernetesJumpToTimestampComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.time.Instant;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/logs/actions/KubernetesJumpToTimestampAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes.backend"})
public final class KubernetesJumpToTimestampAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesContextLogsManager logsManager = KubernetesLogFilteringActionsKt.logManager(e);
        if (logsManager == null || logsManager.isStateManagerDisposed() || !logsManager.getApiModel().isConnected()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesContextLogsManager kubernetesContextLogsManager = KubernetesLogFilteringActionsKt.logManager(e);
        if (kubernetesContextLogsManager == null) {
            return;
        }
        KubernetesContextLogsManager logsManager = kubernetesContextLogsManager;
        KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logsManager.getApiModel().getProject(), (Object)"logs.jump.to.timestamp.action");
        KubernetesJumpToTimestampComponent jumpComponent = new KubernetesJumpToTimestampComponent(logsManager.getApiModel().getProject());
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jumpComponent.getPanel(), (JComponent)jumpComponent.getPanel()).setTitle("Jump to Timestamp").setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelKeyEnabled(true).setModalContext(false).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        jumpComponent.getPanel().addKeyListener(new KeyAdapter(popup){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    this.$popup.closeOk((InputEvent)e);
                }
            }
        });
        popup.addListener(new JBPopupListener(jumpComponent, logsManager){
            final /* synthetic */ KubernetesJumpToTimestampComponent $jumpComponent;
            final /* synthetic */ KubernetesContextLogsManager $logsManager;
            {
                this.$jumpComponent = $jumpComponent;
                this.$logsManager = $logsManager;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Instant selectedTimestamp = this.$jumpComponent.getSelectedTimestamp();
                if (selectedTimestamp != null) {
                    this.$logsManager.getStateManager$intellij_clouds_kubernetes_backend().getJumpToTimestampFlow$intellij_clouds_kubernetes_backend().tryEmit((Object)selectedTimestamp);
                }
            }
        });
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        }
    }
}

