/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.install;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.kubernetes.helm.install.HelmInstallAction;
import com.intellij.kubernetes.install.ArchDistribution;
import com.intellij.kubernetes.install.OSDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0000\u001a\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getHelmDownloadUrlAndChecksum", "Lkotlin/Pair;", "", "loadHelmDistributions", "", "Lcom/intellij/kubernetes/install/OSDistribution;", "intellij.clouds.kubernetes.backend"})
public final class HelmDistributionUtilsKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Pair<String, String> getHelmDownloadUrlAndChecksum() {
        OSDistribution osDistribution;
        Map<String, OSDistribution> distributions = HelmDistributionUtilsKt.loadHelmDistributions();
        OSDistribution oSDistribution = SystemInfoRt.isMac ? distributions.get("darwin") : (SystemInfoRt.isLinux ? distributions.get("linux") : (osDistribution = SystemInfoRt.isWindows ? distributions.get("win") : null));
        if (osDistribution == null) {
            LOG.error("Unable to find Helm distribution for platform: " + SystemInfoRt.OS_NAME);
            return null;
        }
        ArchDistribution archDistribution = CpuArch.isArm64() ? osDistribution.getArm64() : osDistribution.getAmd64();
        return TuplesKt.to((Object)archDistribution.getUrl(), (Object)archDistribution.getChecksum());
    }

    private static final Map<String, OSDistribution> loadHelmDistributions() {
        InputStream helmDistributionsJson = HelmInstallAction.class.getClassLoader().getResourceAsStream("helm-installation/helm-distributions.json");
        if (helmDistributionsJson == null) {
            LOG.error("Cannot load helm-installation/helm-distributions.json");
            return MapsKt.emptyMap();
        }
        Object object = new ObjectMapper().readValue((Reader)new InputStreamReader(helmDistributionsJson, Charsets.UTF_8), (TypeReference)new TypeReference<Map<String, ? extends OSDistribution>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (Map)object;
    }

    static {
        Logger logger = Logger.getInstance((String)"HelmDistributionUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

