/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.kubernetes.ExpiringLazy;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.helm.dependencies.dto.RepoChartDto;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fH\u0016J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/helm/RemoteHelmDependencyRepository;", "Lcom/intellij/kubernetes/helm/HelmDependencyRepository;", "project", "Lcom/intellij/openapi/project/Project;", "repoUrl", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "alias", "getAlias", "()Ljava/lang/String;", "specifiedUrl", "Lorg/jetbrains/annotations/NotNull;", "getSpecifiedUrl", "getDependencyCharts", "", "Lcom/intellij/kubernetes/helm/dependencies/dto/RepoChartDto;", "chartName", "getDependencyNames", "getOrFindUrl", "getOrFindName", "remoteRepoDto", "Lcom/intellij/kubernetes/helm/dependencies/dto/HubRepoDto;", "getRemoteRepoDto", "()Lcom/intellij/kubernetes/helm/dependencies/dto/HubRepoDto;", "remoteRepoDto$delegate", "Lcom/intellij/kubernetes/ExpiringLazy;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmDependencyRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmDependencyRepository.kt\ncom/intellij/kubernetes/helm/RemoteHelmDependencyRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n1#2:66\n30#3,2:67\n30#3,2:69\n30#3,2:71\n*S KotlinDebug\n*F\n+ 1 HelmDependencyRepository.kt\ncom/intellij/kubernetes/helm/RemoteHelmDependencyRepository\n*L\n41#1:67,2\n43#1:69,2\n54#1:71,2\n*E\n"})
public final class RemoteHelmDependencyRepository
implements HelmDependencyRepository {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @Nullable
    private final String alias;
    @Nullable
    private final String specifiedUrl;
    @NotNull
    private final ExpiringLazy remoteRepoDto$delegate;

    public RemoteHelmDependencyRepository(@NotNull Project project, @NotNull String repoUrl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        this.project = project;
        if (StringsKt.startsWith$default((String)repoUrl, (String)"alias:", (boolean)false, (int)2, null)) {
            String string2 = repoUrl.substring(6);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((CharSequence)repoUrl, (char)'@', (boolean)false, (int)2, null)) {
            String string3 = repoUrl.substring(1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        this.alias = string;
        this.specifiedUrl = this.getAlias() == null ? StringUtil.trimEnd((String)repoUrl, (char)'/') : null;
        this.remoteRepoDto$delegate = MiscUtilKt.expiringLazy((long)100L, () -> RemoteHelmDependencyRepository.remoteRepoDto_delegate$lambda$4(this));
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Nullable
    public String getSpecifiedUrl() {
        return this.specifiedUrl;
    }

    @Override
    @Nullable
    public Collection<RepoChartDto> getDependencyCharts(@NotNull String chartName) {
        Collection<RepoChartDto> collection;
        Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
        String string = this.getOrFindUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<HelmIndex> serviceClass$iv = HelmIndex.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            collection = ((HelmIndex)object).getChartsFromRepo(chartName, it);
        } else {
            collection = null;
        }
        return collection;
    }

    @Override
    @Nullable
    public Collection<String> getDependencyNames() {
        Collection<String> collection;
        String string = this.getOrFindUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<HelmIndex> serviceClass$iv = HelmIndex.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            collection = ((HelmIndex)object).getChartNamesFromRepo(it);
        } else {
            collection = null;
        }
        return collection;
    }

    @Nullable
    public final String getOrFindUrl() {
        HubRepoDto hubRepoDto = this.getRemoteRepoDto();
        return hubRepoDto != null ? hubRepoDto.getUrl() : null;
    }

    @Nullable
    public final String getOrFindName() {
        HubRepoDto hubRepoDto = this.getRemoteRepoDto();
        return hubRepoDto != null ? hubRepoDto.getName() : null;
    }

    @Nullable
    public final HubRepoDto getRemoteRepoDto() {
        return (HubRepoDto)MiscUtilKt.getValue((ExpiringLazy)this.remoteRepoDto$delegate, (Object)this, $$delegatedProperties[0]);
    }

    private static final boolean remoteRepoDto_delegate$lambda$4$lambda$2(RemoteHelmDependencyRepository this$0, HubRepoDto repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return Intrinsics.areEqual((Object)repo.getName(), (Object)this$0.getAlias());
    }

    private static final boolean remoteRepoDto_delegate$lambda$4$lambda$3(RemoteHelmDependencyRepository this$0, HubRepoDto repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return Intrinsics.areEqual((Object)repo.getUrl(), (Object)this$0.getSpecifiedUrl());
    }

    private static final HubRepoDto remoteRepoDto_delegate$lambda$4(RemoteHelmDependencyRepository this$0) {
        HubRepoDto hubRepoDto;
        Function1 predicate = this$0.getAlias() != null ? arg_0 -> RemoteHelmDependencyRepository.remoteRepoDto_delegate$lambda$4$lambda$2(this$0, arg_0) : arg_0 -> RemoteHelmDependencyRepository.remoteRepoDto_delegate$lambda$4$lambda$3(this$0, arg_0);
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<HelmIndex> serviceClass$iv = HelmIndex.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Collection<HubRepoDto> collection = ((HelmIndex)object).getAddedRepos();
        if (collection != null) {
            Object v2;
            block4: {
                Iterable iterable = collection;
                for (Object t : iterable) {
                    if (!((Boolean)predicate.invoke(t)).booleanValue()) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            hubRepoDto = v2;
        } else {
            hubRepoDto = null;
        }
        return hubRepoDto;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(RemoteHelmDependencyRepository.class, "remoteRepoDto", "getRemoteRepoDto()Lcom/intellij/kubernetes/helm/dependencies/dto/HubRepoDto;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

