/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.debug.KubectlDebugParameters;
import com.intellij.kubernetes.debug.KubectlDebugUtilsKt;
import com.intellij.kubernetes.debug.KubectlDebugWithSpecifiedParamsAction;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001f\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0017\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/debug/KubectlDebugWithBusyboxMultipleTargetsActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabledAndVisible", "", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubectlDebugWithBusyboxMultipleTargetsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubectlDebugWithBusyboxMultipleTargetsActionGroup.kt\ncom/intellij/kubernetes/debug/KubectlDebugWithBusyboxMultipleTargetsActionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,63:1\n1617#2,9:64\n1869#2:73\n1870#2:77\n1626#2:78\n14#3:74\n14#3:75\n1#4:76\n37#5:79\n36#5,3:80\n*S KotlinDebug\n*F\n+ 1 KubectlDebugWithBusyboxMultipleTargetsActionGroup.kt\ncom/intellij/kubernetes/debug/KubectlDebugWithBusyboxMultipleTargetsActionGroup\n*L\n43#1:64,9\n43#1:73\n43#1:77\n43#1:78\n45#1:74\n49#1:75\n43#1:76\n60#1:79\n60#1:80,3\n*E\n"})
public final class KubectlDebugWithBusyboxMultipleTargetsActionGroup
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!KubectlDebugUtilsKt.isKubectlDebugSupportEnabled()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(e));
    }

    private final boolean isEnabledAndVisible(AnActionEvent e) {
        if (KubernetesModelBasedDumbAwareActionKt.getApiModel((AnActionEvent)e) == null) {
            return false;
        }
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(e);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        return selectedPod2 != null && selectedContainer == null && KubectlDebugUtilsKt.getContainersExceptEphemeral(selectedPod2).size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        if (e == null) {
            return new AnAction[0];
        }
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesModelBasedDumbAwareActionKt.getApiModel((AnActionEvent)e);
        if (kubernetesApiModelInterface == null) {
            return new AnAction[0];
        }
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        V1Pod selectedPod2 = (V1Pod)KubectlDebugUtilsKt.getSelectedPodAndContainer(e).component1();
        if (selectedPod2 == null) {
            return new AnAction[0];
        }
        Iterable iterable = KubectlDebugUtilsKt.getContainersExceptEphemeral(selectedPod2);
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KubectlDebugWithSpecifiedParamsAction kubectlDebugWithSpecifiedParamsAction;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            V1Container it = (V1Container)element$iv$iv;
            boolean bl2 = false;
            Object object = selectedPod2.getMetadata();
            if (object == null || (object = object.getName()) == null) {
                KubectlDebugWithBusyboxMultipleTargetsActionGroup $this$getChildren_u24lambda_u242_u24lambda_u240 = this;
                boolean bl3 = false;
                $i$f$logger = false;
                Logger logger = Logger.getInstance(KubectlDebugWithSpecifiedParamsAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Selected pod name is not presented. pod: " + selectedPod2);
                kubectlDebugWithSpecifiedParamsAction = null;
            } else {
                Object podName = object;
                if (it.getName() == null) {
                    KubectlDebugWithBusyboxMultipleTargetsActionGroup $this$getChildren_u24lambda_u242_u24lambda_u241 = this;
                    boolean bl4 = false;
                    $i$f$logger = false;
                    Logger logger = Logger.getInstance(KubectlDebugWithSpecifiedParamsAction.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Container name is null or empty. container: " + it);
                    kubectlDebugWithSpecifiedParamsAction = null;
                } else {
                    String containerName;
                    KubectlDebugParameters debugParameters = new KubectlDebugParameters(apiModel2.getNamespace(), (String)podName, containerName, "busybox", "");
                    kubectlDebugWithSpecifiedParamsAction = new KubectlDebugWithSpecifiedParamsAction(apiModel2, debugParameters, containerName);
                }
            }
            if (kubectlDebugWithSpecifiedParamsAction == null) continue;
            KubectlDebugWithSpecifiedParamsAction it$iv$iv = kubectlDebugWithSpecifiedParamsAction;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }
}

