/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.terraform.template.lexer.TerraformTemplateLexer;
import com.intellij.terraform.template.psi.TftplDataLanguageSegmentImpl;
import com.intellij.terraform.template.psi.TftplFile;
import com.intellij.terraform.template.psi.TftplHilBasedParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hil.HILElementType;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.HILTokenType;
import org.intellij.terraform.hil.psi.template.TftplLanguage;
import org.intellij.terraform.hil.psi.template.TftplTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/terraform/template/psi/TftplParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "TFTPL_FILE", "Lcom/intellij/psi/tree/IFileElementType;", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getStringLiteralElements", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "intellij.terraform.template"})
public final class TftplParserDefinition
implements ParserDefinition {
    @NotNull
    private final IFileElementType TFTPL_FILE = new IFileElementType("TFTPL_FILE", (Language)TftplLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new TerraformTemplateLexer();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return (PsiParser)new TftplHilBasedParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return this.TFTPL_FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new TftplFile(viewProvider);
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)TftplTokenTypes.DATA_LANGUAGE_TOKEN_UNPARSED)) {
            psiElement = new TftplDataLanguageSegmentImpl(node);
        } else if (iElementType instanceof HILElementType) {
            PsiElement psiElement2 = HILElementTypes.Factory.createElement((ASTNode)node);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createElement(...)");
        } else if (iElementType instanceof HILTokenType) {
            PsiElement psiElement3 = HILElementTypes.Factory.createElement((ASTNode)node);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"createElement(...)");
        } else {
            psiElement = (PsiElement)new ASTWrapperPsiElement(node);
        }
        return psiElement;
    }
}

