/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template.model;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.terraform.template.HclFileReference;
import com.intellij.terraform.template.model.TftplVariable;
import com.intellij.terraform.template.model.TftplVariableType;
import com.intellij.terraform.template.psi.TftplFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLMethodCallExpression;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLSelectExpression;
import org.intellij.terraform.hil.psi.ForCondition;
import org.intellij.terraform.hil.psi.ForVariable;
import org.intellij.terraform.hil.psi.ILSelectFromScopeReferenceProvider;
import org.intellij.terraform.hil.psi.ILTemplateForBlockExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.intellij.terraform.opentofu.OpenTofuFileType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00012\u0006\u0010\u0015\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00012\u0006\u0010\u0017\u001a\u00020\u001aH\u0002\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"collectAvailableVariables", "Lkotlin/sequences/Sequence;", "Lcom/intellij/terraform/template/model/TftplVariable;", "currentNode", "Lcom/intellij/psi/PsiElement;", "collectLocalVariables", "isLoopCollection", "", "collectCallSiteVariables", "findTemplateUsage", "Lorg/intellij/terraform/hcl/psi/HCLMethodCallExpression;", "templateFile", "Lcom/intellij/psi/PsiFile;", "getOrComputeSearchScope", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "computeSearchScope", "collectVariablesFromTemplateFunctionParameters", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "templateFunctionCall", "collectVariablesFromReference", "templateVariables", "Lorg/intellij/terraform/hcl/psi/HCLSelectExpression;", "collectVariablesFromObject", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "EXPECTED_VARIABLES_PARAMETER_INDEX", "", "VARIABLE_ID", "", "DEFAULT_VARIABLE_VALUE_FIELD", "TEMPLATEFILE_FUNCTION_NAME", "intellij.terraform.template"})
@SourceDebugExtension(value={"SMAP\nTemplateFuncVariableCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateFuncVariableCollector.kt\ncom/intellij/terraform/template/model/TemplateFuncVariableCollectorKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n80#2:138\n67#2:140\n66#2,2:145\n1#3:139\n1563#4:141\n1634#4,3:142\n*S KotlinDebug\n*F\n+ 1 TemplateFuncVariableCollector.kt\ncom/intellij/terraform/template/model/TemplateFuncVariableCollectorKt\n*L\n52#1:138\n117#1:140\n81#1:145,2\n56#1:141\n56#1:142,3\n*E\n"})
public final class TemplateFuncVariableCollectorKt {
    private static final int EXPECTED_VARIABLES_PARAMETER_INDEX = 1;
    @NotNull
    private static final String VARIABLE_ID = "variable";
    @NotNull
    private static final String DEFAULT_VARIABLE_VALUE_FIELD = "default";
    @NotNull
    private static final String TEMPLATEFILE_FUNCTION_NAME = "templatefile";

    @RequiresReadLock
    @NotNull
    public static final Sequence<TftplVariable> collectAvailableVariables(@NotNull PsiElement currentNode) {
        Intrinsics.checkNotNullParameter((Object)currentNode, (String)"currentNode");
        return SequencesKt.plus(TemplateFuncVariableCollectorKt.collectLocalVariables(currentNode), TemplateFuncVariableCollectorKt.collectCallSiteVariables(currentNode));
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence<TftplVariable> collectLocalVariables(PsiElement currentNode) {
        void $this$parentsOfType$iv;
        if (!(currentNode.getContainingFile() instanceof TftplFile)) {
            return SequencesKt.emptySequence();
        }
        boolean amILoopVariable = TemplateFuncVariableCollectorKt.isLoopCollection(currentNode);
        PsiElement psiElement = currentNode;
        boolean withSelf$iv = false;
        boolean $i$f$parentsOfType = false;
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.filterIndexed((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, ILTemplateForBlockExpression.class, (boolean)withSelf$iv), (arg_0, arg_1) -> TemplateFuncVariableCollectorKt.collectLocalVariables$lambda$0(amILoopVariable, arg_0, arg_1)), TemplateFuncVariableCollectorKt::collectLocalVariables$lambda$2);
    }

    private static final boolean isLoopCollection(PsiElement currentNode) {
        return currentNode.getParent() instanceof ILVariable && currentNode.getParent().getParent() instanceof ForCondition;
    }

    private static final Sequence<TftplVariable> collectCallSiteVariables(PsiElement currentNode) {
        PsiFile psiFile = InjectedLanguageManager.getInstance((Project)currentNode.getProject()).getTopLevelFile(currentNode).getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile templateFile = psiFile;
        return SequencesKt.map((Sequence)SequencesKt.flatMap(TemplateFuncVariableCollectorKt.findTemplateUsage(templateFile), TemplateFuncVariableCollectorKt::collectCallSiteVariables$lambda$3), TemplateFuncVariableCollectorKt::collectCallSiteVariables$lambda$4);
    }

    @NotNull
    public static final Sequence<HCLMethodCallExpression> findTemplateUsage(@NotNull PsiFile templateFile) {
        List<VirtualFile> list;
        Intrinsics.checkNotNullParameter((Object)templateFile, (String)"templateFile");
        Project project = templateFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<VirtualFile> it = list = TemplateFuncVariableCollectorKt.getOrComputeSearchScope(project);
        boolean bl = false;
        List<Object> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<VirtualFile> searchCandidates = list2;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)templateFile.getProject(), (Collection)searchCandidates);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        GlobalSearchScope narrowedSearchScope = globalSearchScope;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)ReferencesSearch.search((PsiElement)((PsiElement)templateFile.getOriginalFile()), (SearchScope)((SearchScope)narrowedSearchScope), (boolean)false).filtering(arg_0 -> TemplateFuncVariableCollectorKt.findTemplateUsage$lambda$7(TemplateFuncVariableCollectorKt::findTemplateUsage$lambda$6, arg_0)).findAll()), TemplateFuncVariableCollectorKt::findTemplateUsage$lambda$8);
    }

    private static final List<VirtualFile> getOrComputeSearchScope(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> TemplateFuncVariableCollectorKt.getOrComputeSearchScope$lambda$9(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private static final List<VirtualFile> computeSearchScope(Project project) {
        FileType[] fileTypeArray = new FileType[]{TerraformFileType.INSTANCE, OpenTofuFileType.INSTANCE};
        VirtualFile[] virtualFileArray = CacheManager.getInstance((Project)project).getVirtualFilesWithWord(TEMPLATEFILE_FUNCTION_NAME, (short)1, GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)project), (FileType[])fileTypeArray), true);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getVirtualFilesWithWord(...)");
        return ArraysKt.toList((Object[])virtualFileArray);
    }

    private static final Sequence<HCLProperty> collectVariablesFromTemplateFunctionParameters(HCLMethodCallExpression templateFunctionCall) {
        List list = templateFunctionCall.getParameterList().getElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"<get-elements>(...)");
        List providedParameters = list;
        if (providedParameters.size() <= 1) {
            return SequencesKt.emptySequence();
        }
        HCLExpression templateVariables = (HCLExpression)providedParameters.get(1);
        return templateVariables instanceof HCLSelectExpression ? TemplateFuncVariableCollectorKt.collectVariablesFromReference((HCLSelectExpression)templateVariables) : (templateVariables instanceof HCLObject ? TemplateFuncVariableCollectorKt.collectVariablesFromObject((HCLObject)templateVariables) : SequencesKt.emptySequence());
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence<HCLProperty> collectVariablesFromReference(HCLSelectExpression templateVariables) {
        PsiReference psiReference;
        HCLExpression hCLExpression;
        block8: {
            block7: {
                void $this$parentOfType$iv;
                hCLExpression = templateVariables.getField();
                PsiReference psiReference2 = hCLExpression != null ? hCLExpression.getReference() : null;
                ILSelectFromScopeReferenceProvider.VariableReference variableReference = psiReference2 instanceof ILSelectFromScopeReferenceProvider.VariableReference ? (ILSelectFromScopeReferenceProvider.VariableReference)psiReference2 : null;
                if (variableReference == null) {
                    return SequencesKt.emptySequence();
                }
                ILSelectFromScopeReferenceProvider.VariableReference maybeVariableReference = variableReference;
                psiReference2 = maybeVariableReference.resolve();
                if (psiReference2 == null) break block7;
                psiReference = psiReference2;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                hCLExpression = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HCLBlock.class, (boolean)false);
                if (hCLExpression != null) break block8;
            }
            return SequencesKt.emptySequence();
        }
        HCLExpression maybeVariableDeclaration = hCLExpression;
        HCLElement[] hCLElementArray = maybeVariableDeclaration.getNameElements();
        Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
        HCLElement hCLElement = (HCLElement)ArraysKt.firstOrNull((Object[])hCLElementArray);
        if (!Intrinsics.areEqual((Object)(hCLElement != null ? hCLElement.getText() : null), (Object)VARIABLE_ID)) {
            return SequencesKt.emptySequence();
        }
        hCLExpression = maybeVariableDeclaration.getObject();
        if (hCLExpression == null || (psiReference = hCLExpression.findProperty(DEFAULT_VARIABLE_VALUE_FIELD)) == null) {
            return SequencesKt.emptySequence();
        }
        PsiReference defaultPropertyValue = psiReference;
        HCLExpression hCLExpression2 = defaultPropertyValue.getValue();
        HCLObject hCLObject = hCLExpression2 instanceof HCLObject ? (HCLObject)hCLExpression2 : null;
        if (hCLObject == null) {
            return SequencesKt.emptySequence();
        }
        HCLObject propertyValueAsObject = hCLObject;
        return TemplateFuncVariableCollectorKt.collectVariablesFromObject(propertyValueAsObject);
    }

    private static final Sequence<HCLProperty> collectVariablesFromObject(HCLObject templateVariables) {
        List list = templateVariables.getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final boolean collectLocalVariables$lambda$0(boolean $amILoopVariable, int index, ILTemplateForBlockExpression iLTemplateForBlockExpression) {
        Intrinsics.checkNotNullParameter((Object)iLTemplateForBlockExpression, (String)"<unused var>");
        return !$amILoopVariable || index != 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable collectLocalVariables$lambda$2(ILTemplateForBlockExpression forExpression) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)forExpression, (String)"forExpression");
        List list = forExpression.getLoopVariables();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLoopVariables(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void variable;
            ForVariable forVariable = (ForVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = variable.getText();
            if (string == null) {
                string = "";
            }
            Intrinsics.checkNotNull((Object)variable);
            collection.add(new TftplVariable(string, TftplVariableType.LOOP_VARIABLE, (PsiElement)variable));
        }
        return (List)destination$iv$iv;
    }

    private static final Sequence collectCallSiteVariables$lambda$3(HCLMethodCallExpression templateFunctionCall) {
        Intrinsics.checkNotNullParameter((Object)templateFunctionCall, (String)"templateFunctionCall");
        return TemplateFuncVariableCollectorKt.collectVariablesFromTemplateFunctionParameters(templateFunctionCall);
    }

    private static final TftplVariable collectCallSiteVariables$lambda$4(HCLProperty variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)VARIABLE_ID);
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new TftplVariable(string, TftplVariableType.EXTERNAL_VARIABLE, (PsiElement)variable);
    }

    private static final boolean findTemplateUsage$lambda$6(PsiReference reference) {
        return reference instanceof HclFileReference;
    }

    private static final boolean findTemplateUsage$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final HCLMethodCallExpression findTemplateUsage$lambda$8(PsiReference reference) {
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement $this$parentOfType_u24default$iv = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return (HCLMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLMethodCallExpression.class, (boolean)true);
    }

    private static final CachedValueProvider.Result getOrComputeSearchScope$lambda$9(Project $project) {
        Object[] objectArray = new Object[]{PsiModificationTracker.getInstance((Project)$project).forLanguage((Language)TerraformLanguage.INSTANCE)};
        return CachedValueProvider.Result.create(TemplateFuncVariableCollectorKt.computeSearchScope($project), (Object[])objectArray);
    }
}

