/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template.editor;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.terraform.template.TftplBundle;
import com.intellij.terraform.template.TftplFileViewProviderKt;
import com.intellij.terraform.template.psi.TftplDataLanguageSegment;
import com.intellij.terraform.template.psi.TftplVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/terraform/template/editor/TfUnselectedDataLanguageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.terraform.template"})
public final class TfUnselectedDataLanguageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        VirtualFile virtualFile = holder.getFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Language dataLanguage = TftplFileViewProviderKt.doComputeTemplateDataLanguage(virtualFile, project);
        if (!Intrinsics.areEqual((Object)dataLanguage, (Object)PlainTextLanguage.INSTANCE)) {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        } else {
            psiElementVisitor = (PsiElementVisitor)new TftplVisitor(holder){
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.$holder = $holder;
                }

                public void visitDataLanguageSegment(TftplDataLanguageSegment segment) {
                    Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                    this.$holder.registerProblem((PsiElement)segment, TftplBundle.INSTANCE.message("inspection.unselected.data.language.name", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                }
            };
        }
        return psiElementVisitor;
    }
}

