/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.KubernetesPodConsolePanel;
import com.intellij.kubernetes.view.ui.KubernetesPodForwardingPortsPanelKt;
import com.intellij.kubernetes.view.ui.KubernetesPodShellPanel;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Pod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesPodContent;", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "Lio/kubernetes/client/openapi/models/V1Pod;", "pod", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Pod;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "createConsolePanel", "Lcom/intellij/kubernetes/view/ui/KubernetesPodConsolePanel;", "container", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "createShellPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesPodShellPanel;", "intellij.clouds.kubernetes"})
public final class KubernetesPodContent
extends KubernetesResourceContent<V1Pod> {
    public KubernetesPodContent(@NotNull V1Pod pod, @NotNull KubernetesApiModelInterface apiModel, @NotNull Disposable parentDisposable, @NotNull KubernetesResourceMapper<V1Pod, ?> mapper, @Nullable ActionGroup toolbarActionGroup) {
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super((KubernetesObject)pod, parentDisposable, apiModel, mapper, toolbarActionGroup);
        KubernetesPodForwardingPortsPanelKt.installPortForwardingTabsSupport(this, (KubernetesObject)pod);
    }

    @RequiresEdt
    @NotNull
    public final KubernetesPodConsolePanel createConsolePanel(@NotNull KubernetesContainerObject container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KubernetesPodConsolePanel panel2 = new KubernetesPodConsolePanel(container, this, this.getProject());
        Object[] objectArray = new Object[]{container.getName()};
        this.addConsoleTab(container, panel2, KubernetesBundle.message("KubernetesPodContent.console.title", objectArray));
        return panel2;
    }

    @RequiresEdt
    @NotNull
    public final KubernetesPodShellPanel createShellPanel(@NotNull KubernetesContainerObject container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KubernetesPodShellPanel panel2 = new KubernetesPodShellPanel(container, this, this.getProject());
        Object[] objectArray = new Object[]{container.getName()};
        this.addConsoleTab(container, panel2, KubernetesBundle.message("KubernetesPodContent.shell.title", objectArray));
        return panel2;
    }
}

