/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesLogHandler;
import com.intellij.kubernetes.util.ConsoleUtilitiesKt;
import com.intellij.kubernetes.util.KubernetesCombinedDisposable;
import com.intellij.kubernetes.view.ui.KubernetesColoredConsoleView;
import com.intellij.kubernetes.view.ui.KubernetesConsolePanel;
import com.intellij.openapi.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesContextLogPanel;", "Lcom/intellij/kubernetes/view/ui/KubernetesConsolePanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "intellij.clouds.kubernetes"})
public final class KubernetesContextLogPanel
extends KubernetesConsolePanel {
    @NotNull
    private final KubernetesApiModelInterface apiModel;

    public KubernetesContextLogPanel(@NotNull Disposable parentDisposable, @NotNull KubernetesApiModelInterface apiModel) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        super(parentDisposable, (ConsoleView)new KubernetesColoredConsoleView(apiModel.getProject()), null, 4, null);
        this.apiModel = apiModel;
        final KubernetesCombinedDisposable combinedDisposable = new KubernetesCombinedDisposable((Disposable)this.apiModel, parentDisposable);
        this.apiModel.getProject().getMessageBus().connect((Disposable)this.apiModel).subscribe(KubernetesLogHandler.TOPIC, (Object)new KubernetesLogHandler(){

            @Override
            public void printNormal(KubernetesApiModelInterface apiModel, String message2) {
                Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                if (combinedDisposable.isDisposed()) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)this.getApiModel(), (Object)apiModel)) {
                    return;
                }
                ConsoleUtilitiesKt.printNormal(this.getConsole(), message2);
            }

            @Override
            public void printError(KubernetesApiModelInterface apiModel, String message2) {
                Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                if (combinedDisposable.isDisposed()) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)this.getApiModel(), (Object)apiModel)) {
                    return;
                }
                ConsoleUtilitiesKt.printError(this.getConsole(), message2);
            }

            @Override
            public void printSystem(KubernetesApiModelInterface apiModel, String message2) {
                Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                if (combinedDisposable.isDisposed()) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)this.getApiModel(), (Object)apiModel)) {
                    return;
                }
                ConsoleUtilitiesKt.printSystem(this.getConsole(), message2);
            }
        });
    }

    @NotNull
    public final KubernetesApiModelInterface getApiModel() {
        return this.apiModel;
    }
}

