/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiModelKt;
import com.intellij.kubernetes.util.HealthStatus;
import com.intellij.kubernetes.view.KubernetesRefreshable;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerContent;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerServiceViewDescriptorKt;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEphemeralContainerObjectImpl;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesInitContainerObjectImpl;
import com.intellij.kubernetes.view.ui.actions.KubernetesPodContainerActionBaseKt;
import com.intellij.kubernetes.view.ui.actions.ServiceObjectContainersLoader;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.ui.LayeredIcon;
import io.kubernetes.client.common.KubernetesObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\b\u0010$\u001a\u00020%H\u0016J\n\u0010&\u001a\u0004\u0018\u00010%H\u0016J\b\u0010'\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerServiceViewDescriptor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "Lcom/intellij/kubernetes/view/KubernetesRefreshable;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "resourceContainer", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/openapi/Disposable;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "currentContainer", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "resource", "getResource", "()Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "_presentation", "Lcom/intellij/navigation/ItemPresentation;", "content", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerContent;", "getContent", "()Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerContent;", "content$delegate", "Lkotlin/Lazy;", "getContentComponent", "Ljavax/swing/JComponent;", "getPresentation", "refresh", "", "computeIcon", "Ljavax/swing/Icon;", "newResource", "getPopupActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getToolbarActions", "getContainerActions", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.clouds.kubernetes"})
public final class KubernetesContainerServiceViewDescriptor
extends SimpleServiceViewDescriptor
implements KubernetesRefreshable<KubernetesContainerObject>,
UiDataProvider {
    @NotNull
    private final KubernetesApiModelInterface apiModel;
    @NotNull
    private final AtomicReference<KubernetesContainerObject> currentContainer;
    @NotNull
    private ItemPresentation _presentation;
    @NotNull
    private final Lazy content$delegate;

    public KubernetesContainerServiceViewDescriptor(@NotNull KubernetesContainerObject resourceContainer, @NotNull KubernetesApiModelInterface apiModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)resourceContainer, (String)"resourceContainer");
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(resourceContainer.getName(), null);
        this.apiModel = apiModel;
        this.currentContainer = new AtomicReference<KubernetesContainerObject>(resourceContainer);
        this._presentation = (ItemPresentation)new PresentationData(this.getResource().getName(), null, null, null);
        Icon finalIcon = this.computeIcon(this.getResource());
        this._presentation = (ItemPresentation)new PresentationData(this.getResource().getName(), null, finalIcon, null);
        this.content$delegate = LazyKt.lazy(() -> KubernetesContainerServiceViewDescriptor.content_delegate$lambda$0(this, parentDisposable));
    }

    @NotNull
    public final KubernetesApiModelInterface getApiModel() {
        return this.apiModel;
    }

    @NotNull
    public final KubernetesContainerObject getResource() {
        KubernetesContainerObject kubernetesContainerObject = this.currentContainer.get();
        Intrinsics.checkNotNullExpressionValue((Object)kubernetesContainerObject, (String)"get(...)");
        return kubernetesContainerObject;
    }

    @NotNull
    public final KubernetesContainerContent getContent() {
        Lazy lazy = this.content$delegate;
        return (KubernetesContainerContent)lazy.getValue();
    }

    @Nullable
    public JComponent getContentComponent() {
        return this.getContent().getComponent();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this._presentation;
    }

    @Override
    public void refresh(@NotNull KubernetesContainerObject resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.currentContainer.set(resource);
        Icon finalIcon = this.computeIcon(resource);
        this._presentation = (ItemPresentation)new PresentationData(resource.getName(), null, finalIcon, null);
        this.getContent().refresh((KubernetesObject)resource);
    }

    private final Icon computeIcon(KubernetesContainerObject newResource) {
        Lazy statusIcon = LazyKt.lazy(() -> KubernetesContainerServiceViewDescriptor.computeIcon$lambda$1(newResource));
        KubernetesContainerObject kubernetesContainerObject = newResource;
        Icon icon = kubernetesContainerObject instanceof KubernetesEphemeralContainerObjectImpl ? (this.getResource().isRunning() ? KubernetesIcons.EphemeralContainer : KubernetesIcons.EphemeralStoppedContainer) : (kubernetesContainerObject instanceof KubernetesInitContainerObjectImpl ? (Icon)LayeredIcon.Companion.layeredIcon(() -> KubernetesContainerServiceViewDescriptor.computeIcon$lambda$2(statusIcon)) : (Icon)statusIcon.getValue());
        Intrinsics.checkNotNull((Object)icon);
        Icon baseIcon = icon;
        HealthStatus healthStatus = KubernetesContainerServiceViewDescriptorKt.getHealthCheckStatus(newResource);
        Icon finalIcon = WhenMappings.$EnumSwitchMapping$0[healthStatus.ordinal()] == 1 ? (Icon)LayeredIcon.Companion.layeredIcon(() -> KubernetesContainerServiceViewDescriptor.computeIcon$lambda$3(baseIcon)) : baseIcon;
        return finalIcon;
    }

    @NotNull
    public ActionGroup getPopupActions() {
        return this.getContainerActions();
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        return this.getContainerActions();
    }

    private final ActionGroup getContainerActions() {
        AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.ContainerActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        return (ActionGroup)anAction;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(KubernetesPodContainerActionBaseKt.getKUBERNETES_SERVICE_CONTAINERS_LOADER(), (Object)new ServiceObjectContainersLoader(this){
            final /* synthetic */ KubernetesContainerServiceViewDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public Object getContainers(Continuation<? super List<? extends KubernetesContainerObject>> $completion) {
                return CollectionsKt.listOf((Object)this.this$0.getResource());
            }
        });
        sink.set(KubernetesApiModelKt.getKUBERNETES_API_MODEL(), (Object)this.apiModel);
    }

    private static final KubernetesContainerContent content_delegate$lambda$0(KubernetesContainerServiceViewDescriptor this$0, Disposable $parentDisposable) {
        return new KubernetesContainerContent(this$0.getResource(), this$0.apiModel, $parentDisposable, this$0.getContainerActions());
    }

    private static final Icon computeIcon$lambda$1(KubernetesContainerObject $newResource) {
        return $newResource.isRunning() ? KubernetesIcons.SingleRunningContainer : KubernetesIcons.SingleStoppedContainer;
    }

    private static final Icon[] computeIcon$lambda$2(Lazy $statusIcon) {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)$statusIcon.getValue(), (String)"<get-value>(...)");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.ProcessMark, (String)"ProcessMark");
        return iconArray;
    }

    private static final Icon[] computeIcon$lambda$3(Icon $baseIcon) {
        Icon[] iconArray = new Icon[2];
        iconArray[0] = $baseIcon;
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.WarningMark, (String)"WarningMark");
        return iconArray;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HealthStatus.values().length];
            try {
                nArray[HealthStatus.UNHEALTHY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

