/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.view.KubernetesResourceRefreshable;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.kubernetes.view.nodes.ContentServiceViewDescriptorBase;
import com.intellij.kubernetes.view.ui.actions.KubernetesNodeActionsKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import io.kubernetes.client.common.KubernetesObject;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0006\b\u0001\u0010\u0003 \u00012\b\u0012\u0004\u0012\u0002H\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005BH\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00028\u0000\u0012\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H$J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u001c\u0010\u000f\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0010\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/kubernetes/view/nodes/KubernetesServiceViewDescriptor;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "C", "Lcom/intellij/kubernetes/view/nodes/ContentServiceViewDescriptorBase;", "Lcom/intellij/kubernetes/view/KubernetesResourceRefreshable;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "icon", "Ljavax/swing/Icon;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resource", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lkotlinx/coroutines/CoroutineScope;Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)V", "getResource", "()Lio/kubernetes/client/common/KubernetesObject;", "setResource", "(Lio/kubernetes/client/common/KubernetesObject;)V", "Lio/kubernetes/client/common/KubernetesObject;", "getMapper", "()Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "refresh", "", "getToolbarActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getPopupActions", "createCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "shouldNavigate", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "intellij.clouds.kubernetes"})
public abstract class KubernetesServiceViewDescriptor<T extends KubernetesObject, C>
extends ContentServiceViewDescriptorBase<C>
implements KubernetesResourceRefreshable<T> {
    @NotNull
    private T resource;
    @NotNull
    private final KubernetesResourceMapper<T, ?> mapper;

    public KubernetesServiceViewDescriptor(@NotNull String name, @Nullable Icon icon, @NotNull KubernetesApiModelInterface apiModel, @NotNull CoroutineScope parentCoroutineScope, @NotNull T resource, @NotNull KubernetesResourceMapper<T, ?> mapper) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(name, icon, apiModel, parentCoroutineScope);
        this.resource = resource;
        this.mapper = mapper;
    }

    @NotNull
    public final T getResource() {
        return this.resource;
    }

    public final void setResource(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.resource = t;
    }

    @NotNull
    public final KubernetesResourceMapper<T, ?> getMapper() {
        return this.mapper;
    }

    @Override
    public void refresh(@NotNull T resource) {
        block1: {
            Intrinsics.checkNotNullParameter(resource, (String)"resource");
            this.resource = resource;
            if (!this.getContentInitializer().isInitialized()) break block1;
            Object object = this.getContentInitializer().getValue();
            KubernetesResourceRefreshable kubernetesResourceRefreshable = object instanceof KubernetesResourceRefreshable ? (KubernetesResourceRefreshable)object : null;
            if (kubernetesResourceRefreshable != null) {
                kubernetesResourceRefreshable.refresh(resource);
            }
        }
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        AnAction[] anActionArray = new AnAction[]{KubernetesNodeActionsKt.createResourceCommonActions(), Separator.create(), this.createCustomActions()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    public ActionGroup getPopupActions() {
        AnAction[] anActionArray = new AnAction[]{KubernetesNodeActionsKt.createResourceCommonActions(), Separator.create(), this.createCustomActions()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    protected abstract DefaultActionGroup createCustomActions();

    @Override
    protected boolean shouldNavigate(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return this.mapper.isAcceptedFor(this.resource, navigationData, (Function0<KubernetesApiModelInterface>)((Function0)() -> KubernetesServiceViewDescriptor.shouldNavigate$lambda$0(this)));
    }

    private static final KubernetesApiModelInterface shouldNavigate$lambda$0(KubernetesServiceViewDescriptor this$0) {
        return this$0.getApiModel();
    }
}

