/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class MultiIterator<E>
implements Iterator<E> {
    private final List<Iterator<E>> enumerations;
    private int currentIndex = 0;
    private E nextElement = null;

    MultiIterator(List<Iterator<E>> enumerations) {
        this.enumerations = new ArrayList<Iterator<Iterator<E>>>(enumerations);
        this.fetchNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public E next() {
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        E out = this.nextElement;
        this.fetchNextElement();
        return out;
    }

    @Override
    public void remove() {
    }

    private void fetchNextElement() {
        while (this.currentIndex < this.enumerations.size()) {
            Iterator<E> currentEnumerator = this.enumerations.get(this.currentIndex);
            if (currentEnumerator.hasNext()) {
                this.nextElement = currentEnumerator.next();
                return;
            }
            ++this.currentIndex;
        }
        this.nextElement = null;
    }
}

