/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.resolver;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.CssEmmetUtil;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetOptions;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefixInfo;
import com.intellij.codeInsight.template.emmet.nodes.CssPropertyEmmetNode;
import com.intellij.codeInsight.template.emmet.nodes.CssPropertyTemplateEmmetNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.resolver.CssEmmetFuzzySearcher;
import com.intellij.codeInsight.template.emmet.resolver.ValueInfo;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CssEmmetResolver {
    private static final Pattern COLOR_VALUE_PATTERN = Pattern.compile("^t|[0-9A-f]+(\\.\\d+)?");
    private static final Pattern SIMPLE_VALUE_PATTERN = Pattern.compile("^[0-9]*(\\.[0-9]+)?[A-z%]*");
    private static final Pattern KEYWORD_VALUE_PATTERN = Pattern.compile("^-?[0-9]*(\\.[0-9]+)?[A-z%.]*");
    private static final Pattern DOLLAR_WORDS_PATTERN = Pattern.compile("[^$]+");
    private static final Pattern AT_WORDS_PATTERN = Pattern.compile("[^@]+");
    private static final CssEmmetFuzzySearcher FUZZY_SEARCHER = new CssEmmetFuzzySearcher();

    @Nullable
    public ZenCodingNode expand(@NotNull String abbreviation, @Nullable TemplateImpl template, @NotNull CustomTemplateCallback callback) {
        if (abbreviation == null) {
            CssEmmetResolver.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            CssEmmetResolver.$$$reportNull$$$0(1);
        }
        boolean isImportant = false;
        if (StringUtil.endsWithChar((CharSequence)abbreviation, (char)':')) {
            return null;
        }
        while (StringUtil.endsWithChar((CharSequence)abbreviation, (char)'!')) {
            isImportant = true;
            abbreviation = abbreviation.substring(0, abbreviation.length() - 1);
        }
        CssPrefixInfo prefixInfo = this.extractPrefixes(abbreviation);
        ValueInfo valueInfo = new ValueInfo(prefixInfo.getPropertyName());
        if (template == null) {
            valueInfo = this.extractValues(prefixInfo.getPropertyName(), callback);
            template = callback.findApplicableTemplate(valueInfo.abbreviation);
        }
        if (valueInfo.abbreviation.isEmpty()) {
            return null;
        }
        CssEmmetOptions options = CssEmmetOptions.getInstance();
        if (template == null && options.isFuzzySearchEnabled()) {
            template = FUZZY_SEARCHER.findTemplateWithFuzzySearch(valueInfo.abbreviation, callback);
        }
        if (template == null && !options.isUnknownPropertiesExpansionEnabled() && !options.getPrefixes().containsKey((Object)valueInfo.abbreviation) && CssDescriptorsUtil.getPropertyDescriptors(valueInfo.abbreviation, callback.getContext()).isEmpty() && CssDescriptorsUtil.getPropertyDescriptors(abbreviation, callback.getContext()).isEmpty()) {
            return null;
        }
        if (template != null && !CssEmmetUtil.isSingleProperty(template)) {
            return null;
        }
        return template == null ? new CssPropertyEmmetNode(valueInfo.abbreviation, valueInfo.values, prefixInfo.getEnabledPrefixes(), isImportant) : new CssPropertyTemplateEmmetNode(template, valueInfo.values, prefixInfo.getEnabledPrefixes(), isImportant);
    }

    private ValueInfo extractValues(String abbreviation, CustomTemplateCallback callback) {
        String values = this.findValuesInAbbreviation(abbreviation, callback);
        if (values.isEmpty()) {
            return new ValueInfo(abbreviation, this.parseValues(values));
        }
        return new ValueInfo(abbreviation.substring(0, abbreviation.length() - values.length()).replace("-$", ""), this.parseValues(values));
    }

    public @Unmodifiable List<String> parseValues(String valuesString) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < valuesString.length()) {
            String value;
            char ch = valuesString.charAt(i);
            if (ch == '#' && valuesString.length() >= i + 1) {
                value = Strings.nullToEmpty((String)CssEmmetUtil.findPatternInSubstring(COLOR_VALUE_PATTERN, valuesString, i + 1));
                result.add("#" + value);
                i += value.length() + 1;
                continue;
            }
            if (ch == '$') {
                value = Strings.nullToEmpty((String)CssEmmetUtil.findPatternInSubstring(DOLLAR_WORDS_PATTERN, valuesString, i + 1));
                result.add("$" + value);
                i += value.length() + 1;
                continue;
            }
            if (ch == '@') {
                value = Strings.nullToEmpty((String)CssEmmetUtil.findPatternInSubstring(AT_WORDS_PATTERN, valuesString, i + 1));
                result.add("@" + value);
                i += value.length() + 1;
                continue;
            }
            if (ch == '-') {
                if (CssEmmetUtil.isValidKeyword((String)Iterables.getLast(result, (Object)"")) || i > 0 && CssEmmetUtil.isNumeric(valuesString.charAt(i - 1))) {
                    ++i;
                }
                if (i >= valuesString.length() || Strings.isNullOrEmpty((String)(value = CssEmmetUtil.findPatternInSubstring(KEYWORD_VALUE_PATTERN, valuesString, i)))) continue;
                result.add(value);
                i += value.length();
                continue;
            }
            value = CssEmmetUtil.findPatternInSubstring(SIMPLE_VALUE_PATTERN, valuesString, i);
            if (!Strings.isNullOrEmpty((String)value)) {
                result.add(value);
                i += value.length();
                continue;
            }
            ++i;
        }
        return ContainerUtil.map(result, CssEmmetUtil.PREPARE_VALUE);
    }

    public String findValuesInAbbreviation(String abbreviation, CustomTemplateCallback callback) {
        String lastPart;
        List parts;
        String value = "";
        for (int i = 0; i < abbreviation.length(); ++i) {
            boolean beforeNumeric;
            char ch = abbreviation.charAt(i);
            boolean bl = beforeNumeric = i + 1 < abbreviation.length() && CssEmmetUtil.isNumeric(abbreviation.charAt(i + 1));
            if (!CssEmmetUtil.isNumeric(ch) && ch != '#' && ch != '$' && ch != '@' && (ch != '-' || !beforeNumeric)) continue;
            value = abbreviation.substring(i);
            break;
        }
        String property = abbreviation.substring(0, abbreviation.length() - value.length());
        TemplateImpl template = callback.findApplicableTemplate(property);
        List keywords = Lists.reverse(new ArrayList());
        while (StringUtil.containsChar((String)property, (char)'-') && template == null && !(parts = StringUtil.split((String)property, (String)"-")).isEmpty() && CssEmmetUtil.isValidKeyword(lastPart = (String)ContainerUtil.getLastItem((List)parts))) {
            property = StringUtil.join(parts.subList(0, parts.size() - 1), (String)"-");
            keywords.add(lastPart);
            template = callback.findApplicableTemplate(property);
        }
        return StringUtil.join((Collection)Lists.reverse((List)keywords), (String)"-") + value;
    }

    public CssPrefixInfo extractPrefixes(String abbreviation) {
        int i;
        if (!StringUtil.startsWithChar((CharSequence)abbreviation, (char)'-')) {
            return new CssPrefixInfo(abbreviation, new CssPrefix[0]);
        }
        Set<CssPrefix> prefixes = EnumSet.noneOf(CssPrefix.class);
        for (i = 1; i < abbreviation.length(); ++i) {
            char ch = abbreviation.charAt(i);
            if (ch == '-') {
                ++i;
                break;
            }
            if (!CssEmmetUtil.KNOWN_PREFIXES.containsKey(Character.valueOf(ch))) {
                prefixes = CssEmmetUtil.ALL_PREFIXES;
                i = 1;
                break;
            }
            prefixes.add(CssEmmetUtil.KNOWN_PREFIXES.get(Character.valueOf(ch)));
        }
        if (i == abbreviation.length() - 1) {
            i = 1;
        }
        return new CssPrefixInfo(i < abbreviation.length() ? abbreviation.substring(i) : "", prefixes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "abbreviation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/emmet/resolver/CssEmmetResolver";
        objectArray[2] = "expand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

