/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.CommonBundle;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.xmlb.XmlSerializer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.TfCommand;
import org.intellij.terraform.runtime.TfToolCommandLineState;
import org.intellij.terraform.runtime.TfToolPathDetector;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005B7\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u000209H\u0002J\u0012\u0010<\u001a\u0002092\b\u0010=\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010>\u001a\u00020\u000bH\u0016J\u0012\u0010?\u001a\u0002092\b\u0010=\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010@\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010A\u001a\u0002092\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0CH\u0016J\u001c\u0010D\u001a\u0002092\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0CH\u0016J\b\u0010F\u001a\u00020\u001cH\u0016J\u0010\u0010G\u001a\u0002092\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u0002092\u0006\u0010H\u001a\u00020IH\u0016R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010%\"\u0004\b/\u0010'R\u0014\u00100\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010%\u00a8\u0006K"}, d2={"Lorg/intellij/terraform/runtime/TfToolsRunConfigurationBase;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "", "Lcom/intellij/execution/CommonProgramRunConfigurationParameters;", "Lcom/intellij/execution/EnvFilesOptions;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "envFilePaths", "", "toolType", "Lorg/intellij/terraform/install/TfToolType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;Ljava/util/List;Lorg/intellij/terraform/install/TfToolType;)V", "getEnvFilePaths", "()Ljava/util/List;", "setEnvFilePaths", "(Ljava/util/List;)V", "getToolType", "()Lorg/intellij/terraform/install/TfToolType;", "directory", "myEnvs", "", "passParentEnvs", "", "commandType", "Lorg/intellij/terraform/runtime/TfCommand;", "getCommandType$intellij_terraform", "()Lorg/intellij/terraform/runtime/TfCommand;", "setCommandType$intellij_terraform", "(Lorg/intellij/terraform/runtime/TfCommand;)V", "globalOptions", "getGlobalOptions$intellij_terraform", "()Ljava/lang/String;", "setGlobalOptions$intellij_terraform", "(Ljava/lang/String;)V", "passGlobalOptions", "getPassGlobalOptions$intellij_terraform", "()Z", "setPassGlobalOptions$intellij_terraform", "(Z)V", "programArguments", "getProgramArguments$intellij_terraform", "setProgramArguments$intellij_terraform", "toolPath", "getToolPath", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "checkConfiguration", "", "checkExecutableAndThrow", "checkWorkingDirAndThrow", "setProgramParameters", "value", "getProgramParameters", "setWorkingDirectory", "getWorkingDirectory", "setPassParentEnvs", "getEnvs", "", "setEnvs", "envs", "isPassParentEnvs", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfToolsRunConfigurationBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsRunConfigurationBase.kt\norg/intellij/terraform/runtime/TfToolsRunConfigurationBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n14#2:242\n1#3:243\n*S KotlinDebug\n*F\n+ 1 TfToolsRunConfigurationBase.kt\norg/intellij/terraform/runtime/TfToolsRunConfigurationBase\n*L\n63#1:242\n*E\n"})
public abstract class TfToolsRunConfigurationBase
extends RunConfigurationBase<Object>
implements CommonProgramRunConfigurationParameters,
EnvFilesOptions,
DumbAware {
    @NotNull
    private List<String> envFilePaths;
    @NotNull
    private final TfToolType toolType;
    @NotNull
    private String directory;
    @NotNull
    private final Map<String, String> myEnvs;
    private boolean passParentEnvs;
    @NotNull
    private TfCommand commandType;
    @NotNull
    private String globalOptions;
    private boolean passGlobalOptions;
    @NotNull
    private String programArguments;

    public TfToolsRunConfigurationBase(@NotNull Project project, @NotNull ConfigurationFactory factory, @Nullable String name, @NotNull List<String> envFilePaths, @NotNull TfToolType toolType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(envFilePaths, (String)"envFilePaths");
        Intrinsics.checkNotNullParameter((Object)((Object)toolType), (String)"toolType");
        super(project, factory, name);
        this.envFilePaths = envFilePaths;
        this.toolType = toolType;
        String string = project.getBasePath();
        if (string == null) {
            string = "";
        }
        this.directory = string;
        this.myEnvs = new LinkedHashMap();
        this.passParentEnvs = true;
        this.commandType = TfCommand.CUSTOM;
        this.globalOptions = "";
        this.programArguments = "";
    }

    @NotNull
    public List<String> getEnvFilePaths() {
        return this.envFilePaths;
    }

    public void setEnvFilePaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.envFilePaths = list;
    }

    @NotNull
    public final TfToolType getToolType() {
        return this.toolType;
    }

    @NotNull
    public final TfCommand getCommandType$intellij_terraform() {
        return this.commandType;
    }

    public final void setCommandType$intellij_terraform(@NotNull TfCommand tfCommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)tfCommand), (String)"<set-?>");
        this.commandType = tfCommand;
    }

    @NotNull
    public final String getGlobalOptions$intellij_terraform() {
        return this.globalOptions;
    }

    public final void setGlobalOptions$intellij_terraform(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.globalOptions = string;
    }

    public final boolean getPassGlobalOptions$intellij_terraform() {
        return this.passGlobalOptions;
    }

    public final void setPassGlobalOptions$intellij_terraform(boolean bl) {
        this.passGlobalOptions = bl;
    }

    @NotNull
    public final String getProgramArguments$intellij_terraform() {
        return this.programArguments;
    }

    public final void setProgramArguments$intellij_terraform(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.programArguments = string;
    }

    private final String getToolPath() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.toolType.getToolSettings(project).getToolPath();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        try {
            this.checkWorkingDirAndThrow();
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfToolsRunConfigurationBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Run configuration state failure for tool: " + this.toolType.getDisplayName() + " folder " + this.directory + ", command: " + this.commandType, (Throwable)e);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (RunProfileState)new TfToolCommandLineState(project, this, env, this.toolType);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.checkWorkingDirAndThrow();
        this.checkExecutableAndThrow();
    }

    private final void checkExecutableAndThrow() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TfToolPathDetector tfToolPathDetector = TfToolPathDetector.Companion.getInstance(project);
        Path path = Paths.get(this.getToolPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        if (!tfToolPathDetector.isExecutable(path)) {
            CharSequence charSequence;
            Object[] objectArray;
            String string = "run.configuration.terraform.path.incorrect";
            Object[] objectArray2 = objectArray = new Object[2];
            int n = 0;
            CharSequence charSequence2 = this.getToolPath();
            if (charSequence2.length() == 0) {
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                String string2 = string;
                boolean bl = false;
                String string3 = this.toolType.getExecutableName();
                string = string2;
                objectArray2 = objectArray3;
                n = n2;
                charSequence = string3;
            } else {
                charSequence = charSequence2;
            }
            objectArray2[n] = charSequence;
            objectArray[1] = this.toolType.getDisplayName();
            String string4 = CommonBundle.getErrorTitle();
            String string5 = HCLBundle.message(string, objectArray);
            RuntimeConfigurationException exception = new RuntimeConfigurationException(string5, string4);
            exception.setQuickFix(() -> TfToolsRunConfigurationBase.checkExecutableAndThrow$lambda$1(this));
            throw exception;
        }
    }

    private final void checkWorkingDirAndThrow() {
        block10: {
            String expandedWorkingDir;
            block9: {
                Object object;
                block8: {
                    block7: {
                        CharSequence charSequence = this.getWorkingDirectory();
                        if (charSequence == null || charSequence.length() == 0) {
                            RuntimeConfigurationException exception = new RuntimeConfigurationException(HCLBundle.message("run.configuration.no.working.directory.specified", new Object[0]));
                            exception.setQuickFix(() -> TfToolsRunConfigurationBase.checkWorkingDirAndThrow$lambda$2(this));
                            throw exception;
                        }
                        expandedWorkingDir = ProgramParametersUtil.expandPathAndMacros((String)this.getWorkingDirectory(), null, (Project)this.getProject());
                        object = expandedWorkingDir;
                        if (object == null) break block7;
                        String it = object;
                        boolean bl = false;
                        Path path = Paths.get(it, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        object = path;
                        if (path != null) break block8;
                    }
                    throw new RuntimeConfigurationException(HCLBundle.message("run.configuration.no.working.directory.specified", new Object[0]));
                }
                Object workDirPath = object;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists((Path)workDirPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block9;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory((Path)workDirPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block10;
            }
            Object[] objectArray = new Object[]{expandedWorkingDir};
            RuntimeConfigurationException exception = new RuntimeConfigurationException(HCLBundle.message("run.configuration.working.directory.doesnt.exist", objectArray));
            exception.setQuickFix(() -> TfToolsRunConfigurationBase.checkWorkingDirAndThrow$lambda$4(this));
            throw exception;
        }
    }

    public void setProgramParameters(@Nullable String value) {
    }

    @NotNull
    public String getProgramParameters() {
        Object[] objectArray = new String[]{this.passGlobalOptions ? this.globalOptions : "", this.commandType.getCommand(), this.programArguments};
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, TfToolsRunConfigurationBase::getProgramParameters$lambda$5, (int)30, null))).toString();
    }

    public void setWorkingDirectory(@Nullable String value) {
        String string = ExternalizablePath.urlValue((String)value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlValue(...)");
        this.directory = string;
    }

    @Nullable
    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.directory);
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.passParentEnvs = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    public boolean isPassParentEnvs() {
        return this.passParentEnvs;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
    }

    private static final void checkExecutableAndThrow$lambda$1(TfToolsRunConfigurationBase this$0) {
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{this$0.toolType.getDisplayName()};
        String string = HCLBundle.message("progress.title.detecting.terraform.executable", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ TfToolsRunConfigurationBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Project project = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        this.label = 1;
                        Object object2 = TfToolPathDetector.Companion.getInstance(project).detectAndVerifyTool(this.this$0.getToolType(), true, (Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final void checkWorkingDirAndThrow$lambda$2(TfToolsRunConfigurationBase this$0) {
        this$0.setWorkingDirectory(this$0.getProject().getBasePath());
    }

    private static final void checkWorkingDirAndThrow$lambda$4(TfToolsRunConfigurationBase this$0) {
        this$0.setWorkingDirectory(this$0.getProject().getBasePath());
    }

    private static final CharSequence getProgramParameters$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }
}

