/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.runtime.TfToolConfigurationTypeBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/runtime/TfRunManagerListener;", "Lcom/intellij/execution/RunManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "runConfigurationAdded", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationRemoved", "runConfigurationChanged", "updateIfTfCompatible", "refreshFileGutters", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfRunManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfRunManagerListener.kt\norg/intellij/terraform/runtime/TfRunManagerListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n11546#2,9:34\n13472#2:43\n13473#2:46\n11555#2:47\n1#3:44\n1#3:45\n1#3:58\n1617#4,9:48\n1869#4:57\n1870#4:59\n1626#4:60\n1869#4,2:61\n*S KotlinDebug\n*F\n+ 1 TfRunManagerListener.kt\norg/intellij/terraform/runtime/TfRunManagerListener\n*L\n29#1:34,9\n29#1:43\n29#1:46\n29#1:47\n29#1:45\n30#1:58\n30#1:48,9\n30#1:57\n30#1:59\n30#1:60\n31#1:61,2\n*E\n"})
final class TfRunManagerListener
implements RunManagerListener {
    @NotNull
    private final Project project;

    public TfRunManagerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.updateIfTfCompatible(settings);
    }

    public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.updateIfTfCompatible(settings);
    }

    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.updateIfTfCompatible(settings);
    }

    private final void updateIfTfCompatible(RunnerAndConfigurationSettings settings) {
        if (settings.getType() instanceof TfToolConfigurationTypeBase) {
            this.refreshFileGutters();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshFileGutters() {
        Object $this$mapNotNullTo$iv$iv;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        DaemonCodeAnalyzer daemonAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.project);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object $this$mapNotNull$iv = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            FileEditor it = (FileEditor)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() != null) {
                VirtualFile virtualFile;
                VirtualFile file = virtualFile;
                boolean bl3 = false;
                object2 = UtilKt.isTerraformCompatibleExtension(file.getExtension()) ? virtualFile : null;
            } else {
                object2 = null;
            }
            if (object2 == null) continue;
            VirtualFile it$iv$iv = object2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl5 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiFile it = (PsiFile)element$iv;
            boolean bl = false;
            daemonAnalyzer.restart(it);
        }
    }
}

