/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IconManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitAction;
import org.intellij.terraform.config.util.TfExecutorUtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.RootModulePath;
import org.intellij.terraform.runtime.TfRunBaseConfigAction;
import org.intellij.terraform.runtime.TfRunExistingConfigAction;
import org.intellij.terraform.runtime.TfToolConfigurationTypeBaseKt;
import org.intellij.terraform.runtime.TfToolsRunConfigurationBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/runtime/TfRunLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "leaf", "Lcom/intellij/psi/PsiElement;", "computeActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "toolType", "Lorg/intellij/terraform/install/TfToolType;", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;Lorg/intellij/terraform/install/TfToolType;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getRunTemplateActions", "(Lorg/intellij/terraform/install/TfToolType;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfRunLineMarkerContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfRunLineMarkerContributor.kt\norg/intellij/terraform/runtime/TfRunLineMarkerContributor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1310#2,2:85\n4135#2,11:87\n1563#3:98\n1634#3,3:99\n774#3:102\n865#3,2:103\n1563#3:105\n1634#3,3:106\n37#4:109\n36#4,3:110\n1#5:113\n*S KotlinDebug\n*F\n+ 1 TfRunLineMarkerContributor.kt\norg/intellij/terraform/runtime/TfRunLineMarkerContributor\n*L\n33#1:85,2\n62#1:87,11\n62#1:98\n62#1:99,3\n64#1:102\n64#1:103,2\n70#1:105\n70#1:106,3\n75#1:109\n75#1:110,3\n*E\n"})
public final class TfRunLineMarkerContributor
extends RunLineMarkerContributor
implements DumbAware {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement leaf) {
        Object object;
        HCLBlock block;
        PsiElement identifier;
        PsiFile psiFile;
        block9: {
            Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
            psiFile = leaf.getContainingFile();
            if (!UtilKt.isTerraformCompatiblePsiFile(psiFile)) {
                return null;
            }
            PsiElement psiElement = leaf.getParent();
            if (psiElement == null) {
                return null;
            }
            identifier = psiElement;
            PsiElement psiElement2 = identifier.getParent();
            HCLBlock hCLBlock = psiElement2 instanceof HCLBlock ? (HCLBlock)psiElement2 : null;
            if (hCLBlock == null) {
                return null;
            }
            block = hCLBlock;
            PsiElement[] psiElementArray = psiFile.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$firstOrNull$iv = psiElementArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof HCLBlock)) continue;
                object = element$iv;
                break block9;
            }
            object = null;
        }
        PsiElement psiElement = (PsiElement)object;
        if (psiElement == null) {
            return null;
        }
        PsiElement firstHCLBlock = psiElement;
        if (block != firstHCLBlock) {
            return null;
        }
        if (block.getNameIdentifier() != identifier) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TfToolType toolType = TfExecutorUtilKt.getApplicableToolType(virtualFile);
        Icon icon = null;
        Function<PsiElement, String> tooltipProvider = null;
        Project project = leaf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile2 = leaf.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        if (TfInitAction.Companion.isInitRequired(project, virtualFile2)) {
            IconManager iconManager = IconManager.Companion.getInstance();
            Icon[] iconArray = new Icon[2];
            Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.TestState.Run, (String)"Run");
            Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.WarningMark, (String)"WarningMark");
            icon = iconManager.createLayered(iconArray);
            tooltipProvider = TfRunLineMarkerContributor::getInfo$lambda$1;
        } else {
            Icon icon2 = AllIcons.RunConfigurations.TestState.Run;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Run");
            icon = icon2;
            tooltipProvider = arg_0 -> TfRunLineMarkerContributor.getInfo$lambda$2(toolType, arg_0);
        }
        return new RunLineMarkerContributor.Info(icon, this.computeActions(block, toolType), tooltipProvider);
    }

    /*
     * WARNING - void declaration
     */
    private final AnAction[] computeActions(HCLBlock block, TfToolType toolType) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Project project = block.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        AnAction[] templateActions = this.getRunTemplateActions(toolType);
        RootModulePath rootModule = TfRunBaseConfigAction.Companion.getRootModule(block);
        Object $this$filterIsInstance$iv = templateActions;
        boolean $i$f$filterIsInstance = false;
        AnAction[] anActionArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (TfRunBaseConfigAction element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TfRunBaseConfigAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            TfRunBaseConfigAction element$iv$iv;
            element$iv$iv = (TfRunBaseConfigAction)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((TfRunBaseConfigAction)((Object)it)).getConfigurationName$intellij_terraform(rootModule));
        }
        List templateConfigNames = (List)destination$iv$iv;
        RunManager runManager = RunManager.Companion.getInstance(project2);
        Iterable $this$filter$iv = runManager.getAllSettings();
        boolean $i$f$filter22 = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl = false;
            RunConfiguration runConfiguration = it.getConfiguration();
            TfToolsRunConfigurationBase configuration = runConfiguration instanceof TfToolsRunConfigurationBase ? (TfToolsRunConfigurationBase)runConfiguration : null;
            if (!(configuration != null && Intrinsics.areEqual((Object)configuration.getWorkingDirectory(), (Object)rootModule.getPath()) && !templateConfigNames.contains(configuration.getName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List existingConfigs = (List)destination$iv$iv2;
        List actions = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(templateActions, templateActions.length));
        Iterable $i$f$filter22 = existingConfigs;
        collection = actions;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RunnerAndConfigurationSettings bl = (RunnerAndConfigurationSettings)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl2 = false;
            collection2.add(new TfRunExistingConfigAction((RunnerAndConfigurationSettings)it));
        }
        collection.addAll((List)destination$iv$iv3);
        actions.add(new Separator());
        AnAction anAction = ActionManager.getInstance().getAction("editRunConfigurations");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        actions.add(anAction);
        Collection $this$toTypedArray$iv = actions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    private final AnAction[] getRunTemplateActions(TfToolType toolType) {
        AnAction[] group;
        AnAction[] anActionArray;
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction(TfToolConfigurationTypeBaseKt.tfRunConfigurationType(toolType).getActionGroupId());
        if (anAction != null) {
            AnAction it = anAction;
            boolean bl = false;
            anActionArray = (AnAction[])it;
        } else {
            anActionArray = null;
        }
        AnAction[] anActionArray2 = group = anActionArray;
        if (group == null || (anActionArray2 = anActionArray2.getChildren(actionManager)) == null) {
            anActionArray2 = new AnAction[]{};
        }
        return anActionArray2;
    }

    private static final String getInfo$lambda$1(PsiElement it) {
        return HCLBundle.message("not.initialized.inspection.error.message", new Object[0]);
    }

    private static final String getInfo$lambda$2(TfToolType $toolType, PsiElement it) {
        Object[] objectArray = new Object[]{$toolType.getDisplayName()};
        return HCLBundle.message("terraform.run.text", objectArray);
    }
}

