/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.util.TfExecutorUtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.RootModulePath;
import org.intellij.terraform.runtime.TfCommand;
import org.intellij.terraform.runtime.TfToolConfigurationTypeBase;
import org.intellij.terraform.runtime.TfToolConfigurationTypeBaseKt;
import org.intellij.terraform.runtime.TfToolsRunConfigurationBase;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0019\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0005!\"#$%\u00a8\u0006&"}, d2={"Lorg/intellij/terraform/runtime/TfRunBaseConfigAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "command", "Lorg/intellij/terraform/runtime/TfCommand;", "getCommand", "()Lorg/intellij/terraform/runtime/TfCommand;", "toolType", "Lorg/intellij/terraform/install/TfToolType;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createAndConfigureSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runManager", "Lcom/intellij/execution/RunManager;", "suggestName", "", "modulePath", "getConfigurationName", "Lorg/jetbrains/annotations/Nls;", "rootModule", "Lorg/intellij/terraform/runtime/RootModulePath;", "getConfigurationName$intellij_terraform", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Companion", "Lorg/intellij/terraform/runtime/ApplyAction;", "Lorg/intellij/terraform/runtime/DestroyAction;", "Lorg/intellij/terraform/runtime/InitAction;", "Lorg/intellij/terraform/runtime/PlanAction;", "Lorg/intellij/terraform/runtime/ValidateAction;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfRunBaseConfigAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfRunBaseConfigAction.kt\norg/intellij/terraform/runtime/TfRunBaseConfigAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,128:1\n1310#2,2:129\n1310#2,2:131\n*S KotlinDebug\n*F\n+ 1 TfRunBaseConfigAction.kt\norg/intellij/terraform/runtime/TfRunBaseConfigAction\n*L\n35#1:129,2\n49#1:131,2\n*E\n"})
public abstract class TfRunBaseConfigAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TfToolType toolType = TfToolType.TERRAFORM;

    private TfRunBaseConfigAction() {
    }

    @NotNull
    public abstract TfCommand getCommand();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        block4: {
            PsiElement psiElement;
            PsiElement[] psiFile;
            Project project;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                DataContext dataContext2 = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
                PsiElement[] psiElementArray = psiFile = (PsiElement[])CommonDataKeys.PSI_FILE.getData(dataContext2);
                if (psiFile != null && (psiElementArray = psiElementArray.getChildren()) != null) {
                    PsiElement[] $this$firstOrNull$iv = psiElementArray;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiElement element$iv;
                        PsiElement it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!(it instanceof HCLBlock)) continue;
                        psiElement = element$iv;
                        break block3;
                    }
                    psiElement = null;
                } else {
                    psiElement = null;
                }
            }
            PsiElement psiElement2 = psiElement;
            HCLBlock hclBlock = psiElement2 instanceof HCLBlock ? (HCLBlock)psiElement2 : null;
            e.getPresentation().setEnabledAndVisible(project != null && UtilKt.isTerraformCompatiblePsiFile((PsiFile)psiFile) && hclBlock != null);
            HCLBlock hCLBlock = hclBlock;
            if (hCLBlock == null) break block4;
            HCLBlock it = hCLBlock;
            boolean bl = false;
            e.getPresentation().setText(this.getConfigurationName$intellij_terraform(Companion.getRootModule(hclBlock)), false);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            this.toolType = TfExecutorUtilKt.getApplicableToolType(virtualFile);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        Project project;
        block6: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return;
            }
            project = project2;
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            if (!UtilKt.isTerraformCompatiblePsiFile(psiFile2)) {
                return;
            }
            PsiElement[] psiElementArray = psiFile2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$firstOrNull$iv = psiElementArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof HCLBlock)) continue;
                object = element$iv;
                break block6;
            }
            object = null;
        }
        Object object2 = object;
        HCLBlock hCLBlock = object2 instanceof HCLBlock ? (HCLBlock)object2 : null;
        if (hCLBlock == null) {
            return;
        }
        HCLBlock hclBlock = hCLBlock;
        RootModulePath rootModule = Companion.getRootModule(hclBlock);
        String configurationName = this.getConfigurationName$intellij_terraform(rootModule);
        RunManager runManager = RunManager.Companion.getInstance(project);
        RunnerAndConfigurationSettings existingConfiguration = runManager.findConfigurationByTypeAndName((ConfigurationType)TfToolConfigurationTypeBaseKt.tfRunConfigurationType(this.toolType), configurationName);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = existingConfiguration;
        if (runnerAndConfigurationSettings == null) {
            runnerAndConfigurationSettings = this.createAndConfigureSettings(runManager, configurationName, rootModule.getPath(), this.toolType);
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        runManager.setSelectedConfiguration(settings);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)settings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
    }

    private final RunnerAndConfigurationSettings createAndConfigureSettings(RunManager runManager, String suggestName, String modulePath, TfToolType toolType) {
        String configurationName = runManager.suggestUniqueName(suggestName, (ConfigurationType)TfToolConfigurationTypeBaseKt.tfRunConfigurationType(toolType));
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(configurationName, this.getConfigurationFactory(toolType));
        settings.setTemporary(true);
        RunConfiguration runConfiguration = settings.getConfiguration();
        TfToolsRunConfigurationBase tfToolsRunConfigurationBase = runConfiguration instanceof TfToolsRunConfigurationBase ? (TfToolsRunConfigurationBase)runConfiguration : null;
        if (tfToolsRunConfigurationBase != null) {
            TfToolsRunConfigurationBase it = tfToolsRunConfigurationBase;
            boolean bl = false;
            it.setWorkingDirectory(modulePath);
        }
        runManager.addConfiguration(settings);
        return settings;
    }

    @NotNull
    public final String getConfigurationName$intellij_terraform(@NotNull RootModulePath rootModule) {
        Intrinsics.checkNotNullParameter((Object)rootModule, (String)"rootModule");
        return HCLBundle.message("terraform.run.configuration." + this.getCommand().getCommand() + ".name.suffix", new Object[0]) + " " + rootModule.getName();
    }

    private final ConfigurationFactory getConfigurationFactory(TfToolType toolType) {
        TfToolConfigurationTypeBase configurationType = TfToolConfigurationTypeBaseKt.tfRunConfigurationType(toolType);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getCommand().ordinal()]) {
            case 1 -> configurationType.getInitFactory();
            case 2 -> configurationType.getValidateFactory();
            case 3 -> configurationType.getPlanFactory();
            case 4 -> configurationType.getApplyFactory();
            case 5 -> configurationType.getDestroyFactory();
            default -> configurationType.getBaseFactory();
        };
    }

    public /* synthetic */ TfRunBaseConfigAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/terraform/runtime/TfRunBaseConfigAction$Companion;", "", "<init>", "()V", "getRootModule", "Lorg/intellij/terraform/runtime/RootModulePath;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RootModulePath getRootModule(@NotNull HCLBlock block) {
            RootModulePath rootModulePath;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            PsiFileSystemItem moduleRoot = ExtensionsKt.getTerraformModule(block).getModuleRoot();
            if (moduleRoot.isDirectory()) {
                VirtualFile virtualFile = moduleRoot.getVirtualFile();
                String string = virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String string2 = virtualFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                rootModulePath = new RootModulePath(string, string2);
            } else {
                Project project = block.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                String string = project2.getBasePath();
                if (string == null) {
                    string = "";
                }
                String string3 = project2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                rootModulePath = new RootModulePath(string, string3);
            }
            return rootModulePath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TfCommand.values().length];
            try {
                nArray[TfCommand.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TfCommand.VALIDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TfCommand.PLAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TfCommand.APPLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TfCommand.DESTROY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

