/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.install;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.install.BinaryInstaller;
import org.intellij.terraform.install.TfToolsUtilKt;
import org.intellij.terraform.opentofu.runtime.OpenTofuProjectSettings;
import org.intellij.terraform.runtime.TfProjectSettings;
import org.intellij.terraform.runtime.TfToolSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u000b\u001a\u00020\u0003H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0004J\b\u0010\u0015\u001a\u00020\u0003H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/install/TfToolType;", "", "executableName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getExecutableName", "()Ljava/lang/String;", "TERRAFORM", "OPENTOFU", "getBinaryName", "getDownloadUrl", "downloadServerUrl", "getDownloadServerUrl", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "displayName", "getDisplayName", "getOSName", "getArchName", "intellij.terraform"})
public abstract class TfToolType
extends Enum<TfToolType> {
    @NotNull
    private final String executableName;
    public static final /* enum */ TfToolType TERRAFORM = new TERRAFORM("TERRAFORM", 0);
    public static final /* enum */ TfToolType OPENTOFU = new OPENTOFU("OPENTOFU", 1);
    private static final /* synthetic */ TfToolType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private TfToolType(String executableName) {
        this.executableName = executableName;
    }

    @NotNull
    public final String getExecutableName() {
        return this.executableName;
    }

    @NotNull
    public final String getBinaryName() {
        return TfToolsUtilKt.getBinaryName(this.executableName);
    }

    @NotNull
    public abstract String getDownloadUrl();

    @NotNull
    public abstract String getDownloadServerUrl();

    @NotNull
    public abstract TfToolSettings getToolSettings(@NotNull Project var1);

    @NotNull
    public abstract String getDisplayName();

    @Nullable
    protected final String getOSName() {
        return SystemInfoRt.isWindows ? "windows" : (SystemInfoRt.isLinux ? "linux" : (SystemInfoRt.isMac ? "darwin" : null));
    }

    @NotNull
    protected final String getArchName() {
        return CpuArch.isArm64() ? "arm64" : "amd64";
    }

    public static TfToolType[] values() {
        return (TfToolType[])$VALUES.clone();
    }

    public static TfToolType valueOf(String value) {
        return Enum.valueOf(TfToolType.class, value);
    }

    @NotNull
    public static EnumEntries<TfToolType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ TfToolType(String $enum$name, int $enum$ordinal, String executableName, DefaultConstructorMarker $constructor_marker) {
        this(executableName);
    }

    static {
        $VALUES = tfToolTypeArray = new TfToolType[]{TfToolType.TERRAFORM, TfToolType.OPENTOFU};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\r"}, d2={"org/intellij/terraform/install/TfToolType.OPENTOFU", "Lorg/intellij/terraform/install/TfToolType;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "getDownloadUrl", "downloadServerUrl", "getDownloadServerUrl", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfToolsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$OPENTOFU\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n30#2,2:139\n*S KotlinDebug\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$OPENTOFU\n*L\n61#1:139,2\n*E\n"})
    static final class OPENTOFU
    extends TfToolType {
        @NotNull
        private final String displayName;

        /*
         * WARNING - void declaration
         */
        OPENTOFU() {
            void var1_1;
            this.displayName = "OpenTofu";
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public String getDownloadUrl() {
            return this.getDownloadServerUrl();
        }

        @Override
        @NotNull
        public String getDownloadServerUrl() {
            return "";
        }

        @Override
        @NotNull
        public TfToolSettings getToolSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<OpenTofuProjectSettings> serviceClass$iv = OpenTofuProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TfToolSettings)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\u000f"}, d2={"org/intellij/terraform/install/TfToolType.TERRAFORM", "Lorg/intellij/terraform/install/TfToolType;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "getDownloadUrl", "downloadServerUrl", "getDownloadServerUrl", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "fetchLatestStableVersion", "apiUrl", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfToolsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$TERRAFORM\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n30#2,2:139\n14#3:141\n*S KotlinDebug\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$TERRAFORM\n*L\n36#1:139,2\n46#1:141\n*E\n"})
    static final class TERRAFORM
    extends TfToolType {
        @NotNull
        private final String displayName;

        /*
         * WARNING - void declaration
         */
        TERRAFORM() {
            void var1_1;
            this.displayName = "Terraform";
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public String getDownloadUrl() {
            String string = this.fetchLatestStableVersion("https://checkpoint-api.hashicorp.com/v1/check/terraform");
            if (string == null) {
                string = "1.10.0";
            }
            String latestStableVersion = string;
            return this.getDownloadServerUrl() + "/" + latestStableVersion + "/terraform_" + latestStableVersion + "_" + this.getOSName() + "_" + this.getArchName() + ".zip";
        }

        @Override
        @NotNull
        public String getDownloadServerUrl() {
            return "https://releases.hashicorp.com/terraform";
        }

        @Override
        @NotNull
        public TfToolSettings getToolSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TfProjectSettings> serviceClass$iv = TfProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TfToolSettings)object;
        }

        private final String fetchLatestStableVersion(String apiUrl) {
            String string;
            try {
                String string2 = HttpRequests.request((String)apiUrl).readString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                String response = string2;
                JsonNode jsonNode = new ObjectMapper().readTree(response);
                Object object = jsonNode.get("current_version");
                string = object != null && (object = object.asText()) != null ? StringsKt.removePrefix((String)object, (CharSequence)"v") : null;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BinaryInstaller.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to fetch the latest stable Terraform version", (Throwable)e);
                string = null;
            }
            return string;
        }
    }
}

