/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.terraform.hil.psi.ILExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/hil/refactoring/ILRefactoringUtil;", "", "<init>", "()V", "getSelectedExpression", "Lorg/intellij/terraform/hil/psi/ILExpression;", "element1", "Lcom/intellij/psi/PsiElement;", "element2", "getOccurrences", "", "pattern", "context", "deleteNonLetterFromString", "", "string", "generateNames", "", "name", "generateNamesByType", "toUnderscoreCase", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nILRefactoringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ILRefactoringUtil.kt\norg/intellij/terraform/hil/refactoring/ILRefactoringUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1563#2:126\n1634#2,3:127\n*S KotlinDebug\n*F\n+ 1 ILRefactoringUtil.kt\norg/intellij/terraform/hil/refactoring/ILRefactoringUtil\n*L\n71#1:126\n71#1:127,3\n*E\n"})
public final class ILRefactoringUtil {
    @NotNull
    public static final ILRefactoringUtil INSTANCE = new ILRefactoringUtil();

    private ILRefactoringUtil() {
    }

    @Nullable
    public final ILExpression getSelectedExpression(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element1, (String)"element1");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element2");
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent != null && !(parent instanceof ILExpression)) {
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, ILExpression.class);
        }
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof ILExpression)) {
            return null;
        }
        if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)parent) && element2 == PsiTreeUtil.getDeepestLast((PsiElement)parent)) {
            return (ILExpression)parent;
        }
        return null;
    }

    @NotNull
    public final List<PsiElement> getOccurrences(@NotNull PsiElement pattern, @Nullable PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (context == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        context.acceptChildren((PsiElementVisitor)new PsiRecursiveVisitor(pattern, occurrences){
            final /* synthetic */ PsiElement $pattern;
            final /* synthetic */ ArrayList<PsiElement> $occurrences;
            {
                this.$pattern = $pattern;
                this.$occurrences = $occurrences;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)this.$pattern)) {
                    this.$occurrences.add(element);
                    return;
                }
                super.visitElement(element);
            }
        });
        return occurrences;
    }

    private final String deleteNonLetterFromString(String string) {
        Pattern pattern = Pattern.compile("[^a-zA-Z_]+");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.replaceAll("_");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceAll(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> generateNames(@NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name2 = name;
        String string = StringUtil.unquoteString((String)StringsKt.replace$default((String)name2, (char)'.', (char)'_', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        String string2 = StringUtil.decapitalize((String)this.deleteNonLetterFromString(string));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decapitalize(...)");
        name2 = string2;
        name2 = StringsKt.removePrefix((String)StringsKt.removePrefix((String)name2, (CharSequence)"get"), (CharSequence)"is");
        char[] cArray = new char[]{'_'};
        name2 = StringsKt.trim((String)name2, (char[])cArray);
        int length = name2.length();
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        int i = Math.max(0, length - 25);
        int n = length - 1;
        if (i <= n) {
            while (true) {
                if (Character.isLetter(name2.charAt(i)) && (i == 0 || name2.charAt(i - 1) == '_' || Character.isLowerCase(name2.charAt(i - 1)) && Character.isUpperCase(name2.charAt(i)))) {
                    String string3 = name2.substring(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    possibleNames.add(StringUtil.decapitalize((String)string3));
                }
                if (i == n) break;
                ++i;
            }
        }
        List reversed = CollectionsKt.reversed((Iterable)possibleNames);
        Iterable $this$map$iv = reversed;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string4;
            void it;
            String string5 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name1 = it;
            if (StringsKt.indexOf$default((CharSequence)name1, (char)'_', (int)0, (boolean)false, (int)6, null) == -1) {
                string4 = name1;
            } else {
                String string6 = StringUtil.capitalizeWords((String)name1, (String)"_", (boolean)true, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"capitalizeWords(...)");
                name1 = string6;
                CharSequence charSequence = name1;
                Regex regex = new Regex("_");
                String string7 = "";
                String string8 = StringUtil.decapitalize((String)regex.replace(charSequence, string7));
                string4 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"decapitalize(...)");
            }
            collection.add(string4);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Collection<String> generateNamesByType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name2 = name;
        String string = StringUtil.decapitalize((String)this.deleteNonLetterFromString(StringsKt.replace$default((String)name2, (char)'.', (char)'_', (boolean)false, (int)4, null)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decapitalize(...)");
        name2 = string;
        name2 = this.toUnderscoreCase(name2);
        Object[] objectArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)name2.substring(0, 1), (String)"substring(...)");
        objectArray[1] = name2;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String toUnderscoreCase(String name) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int length = name.length();
        int n = length - 1;
        if (i <= n) {
            while (true) {
                char ch;
                StringBuilder stringBuilder = (ch = name.charAt(i)) != '-' ? buffer.append(Character.toLowerCase(ch)) : buffer.append("_");
                if (Character.isLetterOrDigit(ch)) {
                    char chNext;
                    if (Character.isUpperCase(ch)) {
                        if (i + 2 < length) {
                            chNext = name.charAt(i + 1);
                            char chNextNext = name.charAt(i + 2);
                            if (Character.isUpperCase(chNext) && Character.isLowerCase(chNextNext)) {
                                buffer.append('_');
                            }
                        }
                    } else if ((Character.isLowerCase(ch) || Character.isDigit(ch)) && i + 1 < length && Character.isUpperCase(chNext = name.charAt(i + 1))) {
                        buffer.append('_');
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

