/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLPsiUtilKt;
import org.intellij.terraform.hil.psi.ILElementVisitor;
import org.intellij.terraform.hil.psi.ILSelectExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/inspection/HILMissingSelfInContextInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MyEV", "intellij.terraform"})
public final class HILMissingSelfInContextInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        return UtilKt.isTerraformCompatiblePsiFile(topLevelFile);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/inspection/HILMissingSelfInContextInspection$MyEV;", "Lorg/intellij/terraform/hil/psi/ILElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/hil/inspection/HILMissingSelfInContextInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitILVariable", "", "element", "Lorg/intellij/terraform/hil/psi/ILVariable;", "intellij.terraform"})
    public final class MyEV
    extends ILElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitILVariable(@NotNull ILVariable element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ProgressIndicatorProvider.checkCanceled();
            if (!Intrinsics.areEqual((Object)element.getName(), (Object)"self")) {
                return;
            }
            HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(element);
            if (hCLElement == null) {
                return;
            }
            HCLElement host = hCLElement;
            PsiElement psiElement = element.getParent();
            ILSelectExpression iLSelectExpression = psiElement instanceof ILSelectExpression ? (ILSelectExpression)psiElement : null;
            if (iLSelectExpression == null) {
                return;
            }
            ILSelectExpression parent = iLSelectExpression;
            if (parent.getFrom() != element) {
                return;
            }
            if (HCLPsiUtilKt.getProvisionerOfResource(host) != null) {
                return;
            }
            if (HCLPsiUtilKt.getConnectionOfResource(host) != null) {
                return;
            }
            this.holder.registerProblem((PsiElement)element, HCLBundle.message("hil.scope.not.available.in.context.inspection.illegal.self.use.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
        }
    }
}

