/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hil.HILFileType;
import org.intellij.terraform.hil.psi.ILBinaryAdditionExpression;
import org.intellij.terraform.hil.psi.ILElementVisitor;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILExpressionHolder;
import org.intellij.terraform.hil.psi.ILIndexSelectExpression;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.intellij.terraform.hil.psi.ILSelectExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0003\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/hil/inspection/HILConvertToHCLInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MyEV", "ConvertToHCLFix", "Companion", "intellij.terraform"})
public final class HILConvertToHCLInspection
extends LocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file) || Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)HCLLanguage.INSTANCE));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$Companion;", "", "<init>", "()V", "isConvertible", "", "root", "Lorg/intellij/terraform/hil/psi/ILExpressionHolder;", "convert", "", "", "e", "Lcom/intellij/psi/PsiElement;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "findConvertibleInjections", "o", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "consumer", "Ljava/util/function/BiConsumer;", "Lcom/intellij/openapi/util/TextRange;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILConvertToHCLInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILConvertToHCLInspection.kt\norg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1761#2,3:273\n*S KotlinDebug\n*F\n+ 1 HILConvertToHCLInspection.kt\norg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$Companion\n*L\n258#1:273,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isConvertible(ILExpressionHolder root) {
            if (root.getExpression() == null) {
                return false;
            }
            Ref.BooleanRef convertible = new Ref.BooleanRef();
            convertible.element = true;
            root.acceptChildren(new ILElementVisitor(convertible){
                final /* synthetic */ Ref.BooleanRef $convertible;
                {
                    this.$convertible = $convertible;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    ProgressIndicatorProvider.checkCanceled();
                    if (this.$convertible.element) {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }

                public void visitILExpressionHolder(ILExpressionHolder o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    this.$convertible.element = false;
                }

                public void visitILBinaryAdditionExpression(ILBinaryAdditionExpression o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    ILExpression iLExpression = o.getLeftOperand();
                    Intrinsics.checkNotNullExpressionValue((Object)iLExpression, (String)"<get-leftOperand>(...)");
                    ILExpression left = iLExpression;
                    ILExpression iLExpression2 = o.getLeftOperand();
                    Intrinsics.checkNotNullExpressionValue((Object)iLExpression2, (String)"<get-leftOperand>(...)");
                    ILExpression right = iLExpression2;
                    Type lType = ExtensionsKt.getType(left);
                    Type rType = ExtensionsKt.getType(right);
                    if (Intrinsics.areEqual((Object)lType, (Object)Types.INSTANCE.getString())) {
                        this.$convertible.element = false;
                        return;
                    }
                    if (Intrinsics.areEqual((Object)rType, (Object)Types.INSTANCE.getString())) {
                        this.$convertible.element = false;
                        return;
                    }
                    super.visitILBinaryAdditionExpression(o);
                }

                public void visitILSelectExpression(ILSelectExpression o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    ILExpression field = o.getField();
                    if (field instanceof ILLiteralExpression) {
                        String string = ((ILLiteralExpression)field).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"${", (boolean)false, (int)2, null)) {
                            this.$convertible.element = false;
                            return;
                        }
                    } else {
                        if (field instanceof ILExpressionHolder) {
                            this.$convertible.element = false;
                            return;
                        }
                        if (field instanceof ILVariable) {
                            String text = ((ILVariable)field).getText();
                            Intrinsics.checkNotNull((Object)text);
                            if (Character.isDigit(StringsKt.first((CharSequence)text))) {
                                this.$convertible.element = false;
                                return;
                            }
                        }
                    }
                    super.visitILSelectExpression(o);
                }
            });
            return convertible.element;
        }

        private final String convert(ILExpressionHolder root) {
            StringBuilder sb = new StringBuilder();
            this.convert(root, sb);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void convert(PsiElement e, StringBuilder sb) {
            PsiElement psiElement = e;
            if (psiElement instanceof ILIndexSelectExpression) {
                ILExpression iLExpression = ((ILIndexSelectExpression)e).getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)iLExpression, (String)"<get-from>(...)");
                this.convert(iLExpression, sb);
                sb.append('[');
                ILExpression iLExpression2 = ((ILIndexSelectExpression)e).getField();
                Intrinsics.checkNotNull((Object)iLExpression2);
                this.convert(iLExpression2, sb);
                sb.append(']');
                return;
            }
            if (psiElement instanceof ILSelectExpression) {
                ILExpression field = ((ILSelectExpression)e).getField();
                ILExpression iLExpression = ((ILSelectExpression)e).getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)iLExpression, (String)"<get-from>(...)");
                this.convert(iLExpression, sb);
                if (field instanceof ILLiteralExpression && ((ILLiteralExpression)field).getNumber() != null) {
                    sb.append('[').append(((ILLiteralExpression)field).getText()).append(']');
                    return;
                }
                sb.append('.');
                ILExpression iLExpression3 = ((ILSelectExpression)e).getField();
                Intrinsics.checkNotNull((Object)iLExpression3);
                this.convert(iLExpression3, sb);
                return;
            }
            if (psiElement instanceof ILExpressionHolder) {
                ILExpression iLExpression = ((ILExpressionHolder)e).getExpression();
                Intrinsics.checkNotNull((Object)iLExpression);
                this.convert(iLExpression, sb);
                return;
            }
            if (psiElement instanceof LeafPsiElement) {
                sb.append(((LeafPsiElement)e).getText());
                return;
            }
            if (psiElement instanceof CompositePsiElement) {
                for (PsiElement it : ((CompositePsiElement)e).getChildren()) {
                    this.convert(it, sb);
                }
                return;
            }
            sb.append(e.getText());
        }

        private final void findConvertibleInjections(HCLStringLiteral o, BiConsumer<TextRange, ILExpressionHolder> consumer) {
            boolean bl;
            block4: {
                List<com.intellij.openapi.util.Pair<TextRange, String>> list = o.getTextFragments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTextFragments(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        com.intellij.openapi.util.Pair it = (com.intellij.openapi.util.Pair)element$iv;
                        boolean bl2 = false;
                        Object object = it.second;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                        if (!StringsKt.startsWith$default((String)((String)object), (String)"%{", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            InjectedLanguageManager.getInstance((Project)o.getProject()).enumerate((PsiElement)o, (arg_0, arg_1) -> Companion.findConvertibleInjections$lambda$1(consumer, arg_0, arg_1));
        }

        private static final void findConvertibleInjections$lambda$1(BiConsumer $consumer, PsiFile injectedPsi, List places) {
            PsiElement root;
            Intrinsics.checkNotNullParameter((Object)injectedPsi, (String)"injectedPsi");
            Intrinsics.checkNotNullParameter((Object)places, (String)"places");
            ProgressIndicatorProvider.checkCanceled();
            if (Intrinsics.areEqual((Object)injectedPsi.getFileType(), (Object)((Object)HILFileType.INSTANCE)) && Intrinsics.areEqual((Object)(root = injectedPsi.getFirstChild()), (Object)injectedPsi.getLastChild()) && root instanceof ILExpressionHolder && places.size() == 1 && Companion.isConvertible((ILExpressionHolder)root)) {
                $consumer.accept(((PsiLanguageInjectionHost.Shred)CollectionsKt.first((List)places)).getRangeInsideHost(), root);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J3\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002J=\u0010\u0018\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lorg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$ConvertToHCLFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInspection/BatchQuickFix;", "e", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;)V", "getText", "", "getFamilyName", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "applyFix", "descriptors", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "psiElementsToIgnore", "", "refreshViews", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/codeInspection/CommonProblemDescriptor;Ljava/util/List;Ljava/lang/Runnable;)V", "Companion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILConvertToHCLInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILConvertToHCLInspection.kt\norg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$ConvertToHCLFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n4135#2,11:273\n1563#3:284\n1634#3,3:285\n1869#3,2:288\n*S KotlinDebug\n*F\n+ 1 HILConvertToHCLInspection.kt\norg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$ConvertToHCLFix\n*L\n92#1:273,11\n92#1:284\n92#1:285,3\n98#1:288,2\n*E\n"})
    public static final class ConvertToHCLFix
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements BatchQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public ConvertToHCLFix(@NotNull HCLStringLiteral e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super((PsiElement)e);
        }

        @NotNull
        public String getText() {
            String string = HCLBundle.message("hil.convert.to.hcl.inspection.convert.to.hcl2.quick.fix.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            Object[] objectArray = new Language[]{HCLLanguage.INSTANCE, TerraformLanguage.INSTANCE};
            if (!CollectionsKt.listOf((Object[])objectArray).contains(psiFile.getLanguage())) {
                return false;
            }
            return super.isAvailable(project, psiFile, startElement, endElement);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                return;
            }
            HCLStringLiteral hCLStringLiteral = startElement instanceof HCLStringLiteral ? (HCLStringLiteral)startElement : null;
            if (hCLStringLiteral == null) {
                return;
            }
            HCLStringLiteral literal = hCLStringLiteral;
            HCLExpression newValue = Companion.getReplacementValue(project, literal);
            WriteCommandAction.writeCommandAction((Project)project).withName(this.getText()).withGroupId(this.getFamilyName()).run(() -> ConvertToHCLFix.invoke$lambda$0(project, psiFile, literal, newValue));
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
                Intrinsics.checkNotNullParameter(psiElementsToIgnore, (String)"psiElementsToIgnore");
                ArrayList targets = new ArrayList();
                for (CommonProblemDescriptor descriptor : descriptors) {
                    void $this$mapTo$iv$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    QuickFix[] $this$filterIsInstance$iv;
                    if (descriptor.getFixes() == null) continue;
                    boolean $i$f$filterIsInstance = false;
                    QuickFix[] quickFixArray = $this$filterIsInstance$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ConvertToHCLFix)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ConvertToHCLFix convertToHCLFix = (ConvertToHCLFix)((Object)item$iv$iv);
                        Collection collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(it.getStartElement());
                    }
                    ArrayList cfr_ignored_0 = (ArrayList)CollectionsKt.filterIsInstanceTo((Iterable)((List)destination$iv$iv2), (Collection)targets, HCLStringLiteral.class);
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)targets)) {
                    return;
                }
                DocumentUtil.writeInRunUndoTransparentAction(() -> ConvertToHCLFix.applyFix$lambda$3(targets, project));
                psiElementsToIgnore.addAll(targets);
                Runnable runnable = refreshViews;
                if (runnable == null) break block4;
                runnable.run();
            }
        }

        private static final void invoke$lambda$0(Project $project, PsiFile $psiFile, HCLStringLiteral $literal, HCLExpression $newValue) {
            ConvertToHCLFix.Companion.replace($project, $psiFile, $literal, $newValue);
        }

        private static final void applyFix$lambda$3(ArrayList $targets, Project $project) {
            Iterable $this$forEach$iv = $targets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HCLStringLiteral it = (HCLStringLiteral)element$iv;
                boolean bl = false;
                HCLExpression replacement = Companion.getReplacementValue($project, it);
                PsiFile psiFile = it.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                ConvertToHCLFix.Companion.replace($project, psiFile, it, replacement);
            }
        }

        @JvmStatic
        @NotNull
        public static final HCLExpression getReplacementValue(@NotNull Project project, @NotNull HCLStringLiteral literal) {
            return Companion.getReplacementValue(project, literal);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$ConvertToHCLFix$Companion;", "", "<init>", "()V", "getReplacementText", "", "element", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "getReplacementValue", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "project", "Lcom/intellij/openapi/project/Project;", "literal", "replace", "", "file", "Lcom/intellij/psi/PsiFile;", "replacement", "intellij.terraform"})
        public static final class Companion {
            private Companion() {
            }

            private final String getReplacementText(HCLStringLiteral element) {
                SmartList injections = new SmartList();
                HILConvertToHCLInspection.Companion.findConvertibleInjections(element, (arg_0, arg_1) -> Companion.getReplacementText$lambda$0(injections, arg_0, arg_1));
                CollectionsKt.sortWith((List)((List)injections), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((TextRange)it.getFirst()).getStartOffset());
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextRange)it.getFirst()).getStartOffset()));
                    }
                });
                String initialText = element.getText();
                SmartList parts = new SmartList();
                int offset = 1;
                Iterator iterator = injections.iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Pair injection = (Pair)e;
                    TextRange range = (TextRange)injection.getFirst();
                    if (range.getStartOffset() > offset) {
                        Intrinsics.checkNotNull((Object)initialText);
                        String string = initialText.substring(offset, range.getStartOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        parts.add((Object)("\"" + string + "\""));
                    }
                    parts.add(injection.getSecond());
                    offset = range.getEndOffset();
                }
                if (offset < initialText.length() - 1) {
                    Intrinsics.checkNotNull((Object)initialText);
                    String string = initialText.substring(offset, initialText.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    parts.add((Object)("\"" + string + "\""));
                }
                if (parts.size() == 1 && HCLPsiUtil.INSTANCE.isPropertyKey(element) && (HCLPsiUtil.INSTANCE.isUnderPropertyUnderPropertyWithObjectValue(element) || HCLPsiUtil.INSTANCE.isUnderPropertyInsideObjectArgument(element))) {
                    return "(" + CollectionsKt.first((List)((List)parts)) + ")";
                }
                return CollectionsKt.joinToString$default((Iterable)((Iterable)parts), (CharSequence)" + ", null, null, (int)0, null, null, (int)62, null);
            }

            @JvmStatic
            @NotNull
            public final HCLExpression getReplacementValue(@NotNull Project project, @NotNull HCLStringLiteral literal) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                return new TfElementGenerator(project).createValue(this.getReplacementText(literal));
            }

            private final void replace(Project project, PsiFile file, HCLExpression element, HCLExpression replacement) {
                CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> Companion.replace$lambda$2(element, replacement, file));
            }

            private static final void getReplacementText$lambda$0(SmartList $injections, TextRange range, ILExpressionHolder il) {
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter((Object)il, (String)"il");
                $injections.add((Object)TuplesKt.to((Object)range, (Object)HILConvertToHCLInspection.Companion.convert(il)));
            }

            private static final void replace$lambda$2(HCLExpression $element, HCLExpression $replacement, PsiFile $file) {
                $element.replace($replacement);
                $file.subtreeChanged();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/hil/inspection/HILConvertToHCLInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitStringLiteral", "", "o", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILConvertToHCLInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILConvertToHCLInspection.kt\norg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$MyEV\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1761#2,3:273\n*S KotlinDebug\n*F\n+ 1 HILConvertToHCLInspection.kt\norg/intellij/terraform/hil/inspection/HILConvertToHCLInspection$MyEV\n*L\n51#1:273,3\n*E\n"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitStringLiteral(@NotNull HCLStringLiteral o) {
            boolean bl;
            block8: {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                String string = o.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"${", (boolean)false, (int)2, null)) {
                    return;
                }
                List<com.intellij.openapi.util.Pair<TextRange, String>> list = o.getTextFragments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTextFragments(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        com.intellij.openapi.util.Pair it = (com.intellij.openapi.util.Pair)element$iv;
                        boolean bl2 = false;
                        Object object = it.second;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                        if (!StringsKt.startsWith$default((String)((String)object), (String)"%{", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            Module module = ExtensionsKt.getTerraformModule(o);
            if (!module.isHCL2Supported()) {
                return;
            }
            SmartList convertible = new SmartList();
            Companion.findConvertibleInjections(o, (arg_0, arg_1) -> MyEV.visitStringLiteral$lambda$1(convertible, arg_0, arg_1));
            if (convertible.size() != 1) {
                return;
            }
            if (((TextRange)CollectionsKt.first((List)((List)convertible))).getLength() != o.getTextLength() - 2) {
                return;
            }
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertToHCLFix(o)};
            this.holder.registerProblem((PsiElement)o, HCLBundle.message("hil.convert.to.hcl.inspection.interpolation.could.be.replaced.with.hcl2.message", new Object[0]), ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
        }

        private static final void visitStringLiteral$lambda$1(SmartList $convertible, TextRange range, ILExpressionHolder iLExpressionHolder) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)iLExpressionHolder, (String)"<unused var>");
            $convertible.add((Object)range);
        }
    }
}

