/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.codeinsight;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.psi.ILSelectExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/intellij/terraform/hil/codeinsight/ScopeSelectInsertHandler;", "Lcom/intellij/codeInsight/completion/BasicInsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "scheduleBasicCompletion", "intellij.terraform"})
public final class ScopeSelectInsertHandler
extends BasicInsertHandler<LookupElement> {
    @NotNull
    public static final ScopeSelectInsertHandler INSTANCE = new ScopeSelectInsertHandler();

    private ScopeSelectInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        Project project = editor2.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        PsiElement psiElement = file.findElementAt(context.getStartOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement e = psiElement;
        PsiElement element = null;
        ASTNode aSTNode = e.getNode();
        element = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)HILElementTypes.ID) ? e.getParent() : e;
        if (!(element instanceof ILVariable)) {
            return;
        }
        PsiElement parent = ((ILVariable)element).getParent();
        if (parent instanceof ILSelectExpression) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)" .", (char)context.getCompletionChar(), (boolean)false, (int)2, null)) {
            context.setAddCompletionChar(false);
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)".");
        this.scheduleBasicCompletion(context);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
    }

    private final void scheduleBasicCompletion(InsertionContext context) {
        context.setLaterRunnable(() -> ScopeSelectInsertHandler.scheduleBasicCompletion$lambda$0(context));
    }

    private static final void scheduleBasicCompletion$lambda$0(InsertionContext $context) {
        if ($context.getProject().isDisposed() || $context.getEditor().isDisposed()) {
            return;
        }
        new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion($context.getProject(), $context.getEditor());
    }
}

