/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.codeinsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.config.codeinsight.TfCompletionUtil;
import org.intellij.terraform.config.codeinsight.TfConfigCompletionContributor;
import org.intellij.terraform.config.codeinsight.TfLookupElementRenderer;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.ContainerType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ObjectType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.TupleType;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.TypeModel;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLForIntro;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLPsiUtilKt;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hcl.psi.common.Identifier;
import org.intellij.terraform.hcl.psi.common.LiteralExpression;
import org.intellij.terraform.hcl.psi.common.SelectExpression;
import org.intellij.terraform.hil.HILImportBlockUtilsKt;
import org.intellij.terraform.hil.HILLanguage;
import org.intellij.terraform.hil.HilContainingBlockType;
import org.intellij.terraform.hil.codeinsight.ForEachIteratorCompletionProvider;
import org.intellij.terraform.hil.codeinsight.HILCompletionContributor$SelectCompletionProvider$collectTypeVariants$;
import org.intellij.terraform.hil.codeinsight.HILCompletionContributorKt;
import org.intellij.terraform.hil.codeinsight.VariableTypeCompletionProvider;
import org.intellij.terraform.hil.patterns.HILPatterns;
import org.intellij.terraform.hil.psi.FakeTypeProperty;
import org.intellij.terraform.hil.psi.ForVariableCompletion;
import org.intellij.terraform.hil.psi.ILSelectFromSomethingReferenceProviderKt;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.intellij.terraform.opentofu.codeinsight.EncryptionMethodsCompletionProvider;
import org.intellij.terraform.opentofu.codeinsight.KeyProvidersCompletionProvider;
import org.intellij.terraform.opentofu.codeinsight.OpenTofuCompletionUtilKt;
import org.intellij.terraform.opentofu.patterns.OpenTofuPatterns;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u000f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "scopeProviders", "", "", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "beforeCompletion", "", "context", "Lcom/intellij/codeInsight/completion/CompletionInitializationContext;", "SelectFromScopeCompletionProvider", "KnownScopeCompletionProvider", "VariableCompletionProvider", "SelfCompletionProvider", "PathCompletionProvider", "CountCompletionProvider", "TfCompletionProvider", "LocalsCompletionProvider", "ModuleCompletionProvider", "DataSourceCompletionProvider", "EphemeralResourceProvider", "MethodsCompletionProvider", "SelectCompletionProvider", "ResourceTypesCompletionProvider", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n1208#2,2:525\n1236#2,4:527\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor\n*L\n75#1:525,2\n75#1:527,4\n*E\n"})
public class HILCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, SelectFromScopeCompletionProvider> scopeProviders;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public HILCompletionContributor() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object = new SelectFromScopeCompletionProvider[]{CountCompletionProvider.INSTANCE, DataSourceCompletionProvider.INSTANCE, EphemeralResourceProvider.INSTANCE, LocalsCompletionProvider.INSTANCE, ModuleCompletionProvider.INSTANCE, PathCompletionProvider.INSTANCE, SelfCompletionProvider.INSTANCE, TfCompletionProvider.INSTANCE, VariableCompletionProvider.INSTANCE, KeyProvidersCompletionProvider.INSTANCE, EncryptionMethodsCompletionProvider.INSTANCE};
        object = CollectionsKt.listOf((Object[])object);
        HILCompletionContributor hILCompletionContributor = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SelectFromScopeCompletionProvider selectFromScopeCompletionProvider = (SelectFromScopeCompletionProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getScope(), element$iv$iv);
        }
        hILCompletionContributor.scopeProviders = destination$iv$iv;
        this.extend(CompletionType.BASIC, (ElementPattern)HILPatterns.INSTANCE.getMethodPosition(), MethodsCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HILPatterns.INSTANCE.getMethodPosition(), ResourceTypesCompletionProvider.INSTANCE);
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement();
        Intrinsics.checkNotNullExpressionValue((Object)capture, (String)"psiElement(...)");
        object = new Language[]{HILLanguage.INSTANCE, HCLLanguage.INSTANCE};
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)HILCompletionContributorKt.withLanguages((PsiElementPattern)capture, (Language[])object).withParent(Identifier.class)).withSuperParent(2, (ElementPattern)HILPatterns.INSTANCE.getIlseFromKnownScope()), new KnownScopeCompletionProvider());
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement();
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        object = new Language[]{HILLanguage.INSTANCE, HCLLanguage.INSTANCE};
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)HILCompletionContributorKt.withLanguages((PsiElementPattern)capture2, (Language[])object).withParent(Identifier.class)).withSuperParent(2, (ElementPattern)HILPatterns.INSTANCE.getIlseNotFromKnownScope()), SelectCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HILPatterns.INSTANCE.getVariableTypePosition(), VariableTypeCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HILPatterns.INSTANCE.getForEachIteratorPosition(), ForEachIteratorCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HILPatterns.INSTANCE.getInsideForExpressionBody(), ForVariableCompletion.INSTANCE);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)context.getDummyIdentifier(), (Object)"IntellijIdeaRulezzz")) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    static {
        Logger logger = Logger.getInstance(HILCompletionContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$CountCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    private static final class CountCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final CountCompletionProvider INSTANCE = new CountCompletionProvider();

        private CountCompletionProvider() {
            super("count");
        }

        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (HCLPsiUtilKt.getContainingResourceOrDataSourceOrModule(ILExpressionBaseKt.getHCLHost(variable)) == null) {
                return;
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"index"));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$DataSourceCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$DataSourceCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,524:1\n1617#2,9:525\n1869#2:534\n1870#2:536\n1626#2:537\n1563#2:538\n1634#2,3:539\n1#3:535\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$DataSourceCompletionProvider\n*L\n211#1:525,9\n211#1:534\n211#1:536\n211#1:537\n212#1:538\n212#1:539,3\n211#1:535\n*E\n"})
    private static final class DataSourceCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final DataSourceCompletionProvider INSTANCE = new DataSourceCompletionProvider();

        private DataSourceCompletionProvider() {
            super("data");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Module module = HCLPsiUtilKt.getTerraformModule(variable);
            if (module == null) {
                return;
            }
            Module module2 = module;
            List dataSources = Module.getDefinedDataSources$default(module2, null, null, 3, null);
            Iterable $this$mapNotNull$iv = dataSources;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                HCLBlock it = (HCLBlock)element$iv$iv;
                boolean bl2 = false;
                if (UtilKt.getNameElementUnquoted(it, 1) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            SortedSet types = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            $this$mapNotNull$iv = types;
            CompletionResultSet completionResultSet = result;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it));
            }
            completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$EphemeralResourceProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$EphemeralResourceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,524:1\n1617#2,9:525\n1869#2:534\n1870#2:536\n1626#2:537\n1563#2:538\n1634#2,3:539\n1#3:535\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$EphemeralResourceProvider\n*L\n226#1:525,9\n226#1:534\n226#1:536\n226#1:537\n227#1:538\n227#1:539,3\n226#1:535\n*E\n"})
    private static final class EphemeralResourceProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final EphemeralResourceProvider INSTANCE = new EphemeralResourceProvider();

        private EphemeralResourceProvider() {
            super("ephemeral");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Module module = HCLPsiUtilKt.getTerraformModule(variable);
            if (module == null) {
                return;
            }
            Module module2 = module;
            List ephemeraResources = Module.getDefinedEphemeralResources$default(module2, null, null, 3, null);
            Iterable $this$mapNotNull$iv = ephemeraResources;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                HCLBlock it = (HCLBlock)element$iv$iv;
                boolean bl2 = false;
                if (UtilKt.getNameElementUnquoted(it, 1) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            SortedSet types = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            $this$mapNotNull$iv = types;
            CompletionResultSet completionResultSet = result;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it));
            }
            completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$KnownScopeCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "(Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor;)V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$KnownScopeCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,524:1\n61#2,5:525\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$KnownScopeCompletionProvider\n*L\n112#1:525,5\n*E\n"})
    public final class KnownScopeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            PsiElement psiElement2 = position.getParent();
            Identifier identifier = psiElement2 instanceof Identifier ? (Identifier)psiElement2 : null;
            if (identifier == null) {
                return;
            }
            Identifier parent = identifier;
            PsiElement psiElement3 = parent.getParent();
            SelectExpression selectExpression = psiElement3 instanceof SelectExpression ? (SelectExpression)psiElement3 : null;
            if (selectExpression == null) {
                return;
            }
            SelectExpression pp = selectExpression;
            Object t = pp.getFrom();
            Identifier identifier2 = t instanceof Identifier ? (Identifier)t : null;
            if (identifier2 == null) {
                return;
            }
            Identifier from = identifier2;
            SelectFromScopeCompletionProvider selectFromScopeCompletionProvider = (SelectFromScopeCompletionProvider)HILCompletionContributor.this.scopeProviders.get(from.getName());
            if (selectFromScopeCompletionProvider == null) {
                return;
            }
            SelectFromScopeCompletionProvider provider = selectFromScopeCompletionProvider;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("HIL.SelectFromScopeCompletionProvider(" + from.getName() + "){position=" + position + ", parent=" + parent + ", pp=" + pp + "}", e$iv);
            }
            provider.doAddCompletions(parent, parameters, context, result);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$LocalsCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    private static final class LocalsCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final LocalsCompletionProvider INSTANCE = new LocalsCompletionProvider();

        private LocalsCompletionProvider() {
            super("local");
        }

        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            List<String> variables = HCLPsiUtilKt.getDefinedLocalsInModule(variable);
            for (String v : variables) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)v));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$MethodsCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$MethodsCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n61#2,5:525\n1563#3:530\n1634#3,3:531\n1563#3:534\n1634#3,3:535\n1563#3:538\n1634#3,3:539\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$MethodsCompletionProvider\n*L\n236#1:525,5\n273#1:530\n273#1:531,3\n274#1:534\n274#1:535,3\n276#1:538\n276#1:539,3\n*E\n"})
    private static final class MethodsCompletionProvider
    extends TfConfigCompletionContributor.TfCompletionProvider {
        @NotNull
        public static final MethodsCompletionProvider INSTANCE = new MethodsCompletionProvider();

        private MethodsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Object it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            PsiElement psiElement2 = position.getParent();
            BaseExpression baseExpression = psiElement2 instanceof BaseExpression ? (BaseExpression)psiElement2 : null;
            if (baseExpression == null) {
                return;
            }
            BaseExpression parent = baseExpression;
            PsiElement leftNWS = HCLPsiUtil.getPrevSiblingNonWhiteSpace(position);
            Logger $this$debug_u24default$iv = LOG;
            Class[] e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("HIL.MethodsCompletionProvider{position=" + position + ", parent=" + parent + ", left=" + position.getPrevSibling() + ", lnws=" + leftNWS + "}", (Throwable)e$iv);
            }
            e$iv = new Class[]{HCLBlock.class};
            HCLProperty property = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)parent, HCLProperty.class, (boolean)false, (Class[])e$iv);
            HCLBlock block = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, HCLBlock.class);
            if (property != null && Intrinsics.areEqual((Object)property.getNameIdentifier(), (Object)parent)) {
                return;
            }
            if (block != null && property != null) {
                boolean isRootBlock = TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)block);
                HCLBlock hCLBlock = isRootBlock ? block : (HCLBlock)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, HCLBlock.class);
                String type = hCLBlock != null ? UtilKt.getNameElementUnquoted(hCLBlock, 0) : null;
                PsiElement psiElement3 = property.getParent();
                if ((psiElement3 != null ? psiElement3.getParent() : null) != block && property.getParent() instanceof HCLObject && property.getParent().getParent() instanceof HCLProperty) {
                    PsiElement psiElement4 = property.getParent().getParent();
                    Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
                    property = (HCLProperty)psiElement4;
                }
                if (!isRootBlock && Intrinsics.areEqual((Object)block.getFullName(), (Object)"providers") && Intrinsics.areEqual((Object)type, (Object)"module")) {
                    return;
                }
                if (this.needCompletionForBlock(block, property, type)) {
                    return;
                }
            }
            TypeModel model = TypeModelProvider.Companion.getModel(parent);
            Iterable type = model.getFunctions();
            logger = result;
            boolean $i$f$map = false;
            void var12_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TfFunction tfFunction = (TfFunction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TfCompletionUtil.INSTANCE.createFunction((TfFunction)it));
            }
            logger.addAllElements((Iterable)((List)destination$iv$iv));
            $this$map$iv = model.getProviderDefinedFunctions();
            logger = result;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TfFunction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TfCompletionUtil.INSTANCE.createFunction((TfFunction)it));
            }
            logger.addAllElements((Iterable)((List)destination$iv$iv));
            $this$map$iv = TfCompletionUtil.INSTANCE.getGlobalScopes();
            logger = result;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(TfCompletionUtil.INSTANCE.createScopeLookup((String)it));
            }
            logger.addAllElements((Iterable)((List)destination$iv$iv));
            if (HCLPsiUtilKt.getHclBlockForSelfContext(parent) != null) {
                result.addElement((LookupElement)TfCompletionUtil.INSTANCE.createScopeLookup("self"));
            }
            HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(parent);
            if (hCLElement == null) {
                return;
            }
            HCLElement host = hCLElement;
            HCLBlock resourceOrDataSource = HCLPsiUtilKt.getContainingResourceOrDataSourceOrModule(host);
            if (resourceOrDataSource != null) {
                HCLObject hCLObject = resourceOrDataSource.getObject();
                if ((hCLObject != null ? hCLObject.findProperty("for_each") : null) != null) {
                    result.addElement((LookupElement)TfCompletionUtil.INSTANCE.createScopeLookup("each"));
                }
                HCLObject hCLObject2 = resourceOrDataSource.getObject();
                if ((hCLObject2 != null ? hCLObject2.findProperty("count") : null) != null) {
                    result.addElement((LookupElement)TfCompletionUtil.INSTANCE.createScopeLookup("count"));
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$ModuleCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    private static final class ModuleCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final ModuleCompletionProvider INSTANCE = new ModuleCompletionProvider();

        private ModuleCompletionProvider() {
            super("module");
        }

        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Module module = HCLPsiUtilKt.getTerraformModule(variable);
            if (module == null) {
                return;
            }
            Module module2 = module;
            List modules = Module.getDefinedModules$default(module2, null, 1, null);
            for (HCLBlock m : modules) {
                String name = UtilKt.getNameElementUnquoted(m, 1);
                if (name == null) continue;
                result.addElement((LookupElement)LookupElementBuilder.create((String)name));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$PathCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "PATH_REFERENCES", "Ljava/util/TreeSet;", "", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$PathCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n1563#2:525\n1634#2,3:526\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$PathCompletionProvider\n*L\n152#1:525\n152#1:526,3\n*E\n"})
    private static final class PathCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final PathCompletionProvider INSTANCE = new PathCompletionProvider();
        @NotNull
        private static final TreeSet<String> PATH_REFERENCES;

        private PathCompletionProvider() {
            super("path");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Iterable iterable = PATH_REFERENCES;
            CompletionResultSet completionResultSet = result;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it));
            }
            completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
        }

        static {
            Object[] objectArray = new String[]{"root", "module", "cwd"};
            PATH_REFERENCES = SetsKt.sortedSetOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$ResourceTypesCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$ResourceTypesCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,524:1\n61#2,5:525\n1617#3,9:530\n1869#3:539\n1870#3:541\n1626#3:542\n1563#3:543\n1634#3,3:544\n1#4:540\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$ResourceTypesCompletionProvider\n*L\n480#1:525,5\n507#1:530,9\n507#1:539\n507#1:541\n507#1:542\n508#1:543\n508#1:544,3\n507#1:540\n*E\n"})
    private static final class ResourceTypesCompletionProvider
    extends TfConfigCompletionContributor.TfCompletionProvider {
        @NotNull
        public static final ResourceTypesCompletionProvider INSTANCE = new ResourceTypesCompletionProvider();

        private ResourceTypesCompletionProvider() {
        }

        /*
         * WARNING - void declaration
         */
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            PsiElement psiElement2 = position.getParent();
            BaseExpression baseExpression = psiElement2 instanceof BaseExpression ? (BaseExpression)psiElement2 : null;
            if (baseExpression == null) {
                return;
            }
            BaseExpression parent = baseExpression;
            PsiElement leftNWS = HCLPsiUtil.getPrevSiblingNonWhiteSpace(position);
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug22 = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("HIL.ResourceTypesCompletionProvider{position=" + position + ", parent=" + parent + ", left=" + position.getPrevSibling() + ", lnws=" + leftNWS + "}", e$iv);
            }
            HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(parent);
            if (hCLElement == null) {
                return;
            }
            HCLElement host = hCLElement;
            Class[] $i$f$debug22 = new Class[]{HCLBlock.class};
            HCLProperty property = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)parent, HCLProperty.class, (boolean)false, (Class[])$i$f$debug22);
            HCLBlock block = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, HCLBlock.class);
            if (property != null && Intrinsics.areEqual((Object)property.getNameIdentifier(), (Object)parent)) {
                return;
            }
            if (block != null && property != null) {
                String type = UtilKt.getNameElementUnquoted(block, 0);
                boolean isRootBlock = TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)block);
                PsiElement psiElement3 = property.getParent();
                if ((psiElement3 != null ? psiElement3.getParent() : null) != block) {
                    if (property.getParent() instanceof HCLObject && property.getParent().getParent() instanceof HCLProperty) {
                        PsiElement psiElement4 = property.getParent().getParent();
                        Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
                        HCLProperty outerProp = (HCLProperty)psiElement4;
                        if (Intrinsics.areEqual((Object)outerProp.getName(), (Object)"providers") && Intrinsics.areEqual((Object)type, (Object)"module") && isRootBlock) {
                            return;
                        }
                    }
                } else if (this.needCompletionForBlock(block, property, type)) {
                    return;
                }
            }
            Module module = ExtensionsKt.getTerraformModule(host);
            List resources = Module.getDefinedResources$default(module, null, null, 3, null);
            Iterable $this$mapNotNull$iv = resources;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                HCLBlock it = (HCLBlock)element$iv$iv;
                boolean bl2 = false;
                if (UtilKt.getNameElementUnquoted(it, 1) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            SortedSet types = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            $this$mapNotNull$iv = types;
            logger = result;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it));
            }
            logger.addAllElements((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J<\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J8\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00122\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u001ej\b\u0012\u0004\u0012\u00020\u000e`\u001fH\u0002J(\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u001ej\b\u0012\u0004\u0012\u00020\u000e`\u001fH\u0002J*\u0010#\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010%2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u001ej\b\u0012\u0004\u0012\u00020\u000e`\u001fH\u0002\u00a8\u0006&"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "collectVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "r", "Lcom/intellij/psi/PsiElement;", "iteratorResolve", "", "depth", "", "isEachValueProperty", "contextType", "Lorg/intellij/terraform/hil/HilContainingBlockType;", "collectVariantsSelectAware", "value", "getBlockProperties", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "isEachValueProp", "found", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "handleHCLObject", "objectProperty", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "collectTypeVariants", "type", "Lorg/intellij/terraform/config/model/Type;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,524:1\n1617#2,9:525\n1869#2:534\n1870#2:536\n1626#2:537\n1563#2:538\n1634#2,3:539\n1617#2,9:542\n1869#2:551\n1870#2:553\n1626#2:554\n1563#2:555\n1634#2,3:556\n1617#2,9:559\n1869#2:568\n1870#2:570\n1626#2:571\n1563#2:572\n1634#2,3:573\n1374#2:577\n1460#2,5:578\n1869#2:583\n1617#2,9:584\n1869#2:593\n1870#2:595\n1626#2:596\n1870#2:597\n1563#2:598\n1634#2,3:599\n1374#2:602\n1460#2,5:603\n1563#2:608\n1634#2,3:609\n774#2:615\n865#2,2:616\n1374#2:618\n1460#2,5:619\n1563#2:627\n1634#2,3:628\n1563#2:631\n1634#2,3:632\n1563#2:635\n1634#2,3:636\n1563#2:646\n1634#2,3:647\n1563#2:650\n1634#2,3:651\n774#2:654\n865#2,2:655\n1563#2:657\n1634#2,3:658\n1625#2:661\n1869#2:662\n1870#2:664\n1626#2:665\n1625#2:666\n1869#2:667\n1870#2:669\n1626#2:670\n1634#2,3:671\n1634#2,3:674\n1634#2,3:678\n1634#2,3:681\n1#3:535\n1#3:552\n1#3:569\n1#3:576\n1#3:594\n1#3:663\n1#3:668\n10135#4:612\n10557#4,2:613\n10559#4,3:624\n488#5,7:639\n477#6:677\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectCompletionProvider\n*L\n321#1:525,9\n321#1:534\n321#1:536\n321#1:537\n321#1:538\n321#1:539,3\n325#1:542,9\n325#1:551\n325#1:553\n325#1:554\n325#1:555\n325#1:556,3\n337#1:559,9\n337#1:568\n337#1:570\n337#1:571\n337#1:572\n337#1:573,3\n355#1:577\n355#1:578,5\n371#1:583\n372#1:584,9\n372#1:593\n372#1:595\n372#1:596\n371#1:597\n376#1:598\n376#1:599,3\n379#1:602\n379#1:603,5\n383#1:608\n383#1:609,3\n402#1:615\n402#1:616,2\n402#1:618\n402#1:619,5\n423#1:627\n423#1:628,3\n426#1:631\n426#1:632,3\n429#1:635\n429#1:636,3\n443#1:646\n443#1:647,3\n446#1:650\n446#1:651,3\n446#1:654\n446#1:655,2\n446#1:657\n446#1:658,3\n452#1:661\n452#1:662\n452#1:664\n452#1:665\n453#1:666\n453#1:667\n453#1:669\n453#1:670\n454#1:671,3\n459#1:674,3\n462#1:678,3\n468#1:681,3\n321#1:535\n325#1:552\n337#1:569\n372#1:594\n452#1:663\n453#1:668\n401#1:612\n401#1:613,2\n401#1:624,3\n441#1:639,7\n462#1:677\n*E\n"})
    private static final class SelectCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NotNull
        public static final SelectCompletionProvider INSTANCE = new SelectCompletionProvider();

        private SelectCompletionProvider() {
        }

        /*
         * WARNING - void declaration
         */
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            PsiElement psiElement2 = position.getParent();
            BaseExpression baseExpression = psiElement2 instanceof BaseExpression ? (BaseExpression)psiElement2 : null;
            if (baseExpression == null) {
                return;
            }
            BaseExpression element = baseExpression;
            if (!(element instanceof Identifier) && !(element instanceof LiteralExpression)) {
                return;
            }
            HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(element);
            if (hCLElement == null) {
                return;
            }
            HCLElement host = hCLElement;
            PsiElement psiElement3 = element.getParent();
            SelectExpression selectExpression = psiElement3 instanceof SelectExpression ? (SelectExpression)psiElement3 : null;
            if (selectExpression == null) {
                return;
            }
            SelectExpression parent = selectExpression;
            BaseExpression baseExpression2 = ILSelectFromSomethingReferenceProviderKt.getGoodLeftElement$default(parent, element, false, 4, null);
            if (baseExpression2 == null) {
                return;
            }
            BaseExpression expression = baseExpression2;
            boolean isEachValueProperty = Intrinsics.areEqual((Object)expression.getParent().getText(), (Object)"each.value");
            HilContainingBlockType contextType = HILImportBlockUtilsKt.guessContainingBlockType(expression);
            Object[] references = HCLPsiUtil.INSTANCE.getReferencesSelectAware(expression);
            if (!(references.length == 0)) {
                List collectedTargets = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)ArraysKt.asSequence((Object[])references), SelectCompletionProvider::addCompletions$lambda$0), arg_0 -> SelectCompletionProvider.addCompletions$lambda$1(isEachValueProperty, contextType, arg_0)));
                if (!((Collection)collectedTargets).isEmpty()) {
                    result.addAllElements((Iterable)collectedTargets);
                }
                return;
            }
            if (expression instanceof Identifier) {
                Object it;
                Collection collection;
                void $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Iterable $this$map$iv;
                boolean $i$f$map;
                String it$iv$iv;
                boolean bl;
                HCLBlock it2;
                boolean bl2;
                Object element$iv$iv;
                boolean $i$f$forEach;
                Iterator $this$forEach$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                boolean $i$f$mapNotNullTo;
                Collection destination$iv$iv;
                Iterable $this$mapNotNull$iv;
                boolean $i$f$mapNotNull;
                CompletionResultSet completionResultSet;
                Module module = ExtensionsKt.getTerraformModule(host);
                if (HILPatterns.INSTANCE.getIlseDataSource().accepts((Object)parent)) {
                    List<HCLBlock> dataSources = module.getDefinedDataSources(((Identifier)expression).getName(), null);
                    Iterable iterable = dataSources;
                    completionResultSet = result;
                    $i$f$mapNotNull = false;
                    void var16_19 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    Object object = $this$forEach$iv$iv$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = object.next();
                        bl2 = false;
                        it2 = (HCLBlock)element$iv$iv;
                        boolean bl3 = false;
                        if (UtilKt.getNameElementUnquoted(it2, 2) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        object = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(LookupElementBuilder.create(it));
                    }
                    completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
                }
                if (HILPatterns.INSTANCE.getIlseEphemeralResource().accepts((Object)parent)) {
                    List<HCLBlock> ephemeraResources = module.getDefinedEphemeralResources(((Identifier)expression).getName(), null);
                    $this$map$iv = ephemeraResources;
                    completionResultSet = result;
                    $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = it.next();
                        bl2 = false;
                        it2 = (HCLBlock)element$iv$iv;
                        boolean bl5 = false;
                        if (UtilKt.getNameElementUnquoted(it2, 2) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl6 = false;
                        collection.add(LookupElementBuilder.create((String)it));
                    }
                    completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
                } else if (OpenTofuPatterns.INSTANCE.getIlseOpenTofuKeyProvider$intellij_terraform().accepts((Object)parent)) {
                    List keyProviderIds = SequencesKt.toList(OpenTofuCompletionUtilKt.findEncryptionBlocksIdsByType(parent, ((Identifier)expression).getName(), OpenTofuPatterns.INSTANCE.getKeyProviderBlock()));
                    result.addAllElements((Iterable)keyProviderIds);
                } else if (OpenTofuPatterns.INSTANCE.getIlseOpenTofuEncryptionMethod$intellij_terraform().accepts((Object)parent)) {
                    List encryptionMethods = SequencesKt.toList(OpenTofuCompletionUtilKt.findEncryptionBlocksIdsByType(parent, ((Identifier)expression).getName(), OpenTofuPatterns.INSTANCE.getEncryptionMethodBlock()));
                    result.addAllElements((Iterable)encryptionMethods);
                } else {
                    List<HCLBlock> resources = module.getDefinedResources(((Identifier)expression).getName(), null);
                    $this$map$iv = resources;
                    completionResultSet = result;
                    $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = it.next();
                        bl2 = false;
                        it2 = (HCLBlock)element$iv$iv;
                        boolean bl7 = false;
                        if (UtilKt.getNameElementUnquoted(it2, 2) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl8 = false;
                        collection.add(LookupElementBuilder.create((String)it));
                    }
                    completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<LookupElement> collectVariants(PsiElement r, boolean iteratorResolve, int depth, boolean isEachValueProperty, HilContainingBlockType contextType) {
            PsiElement psiElement = r;
            if (psiElement instanceof HCLBlock) {
                ArrayList<LookupElement> arrayList;
                ArrayList<LookupElement> it = arrayList = new ArrayList<LookupElement>();
                boolean bl = false;
                INSTANCE.getBlockProperties((HCLBlock)r, contextType, isEachValueProperty, it);
                return arrayList;
            }
            if (psiElement instanceof FakeTypeProperty) {
                ArrayList<LookupElement> arrayList;
                ArrayList<LookupElement> it = arrayList = new ArrayList<LookupElement>();
                boolean bl = false;
                INSTANCE.collectTypeVariants(((FakeTypeProperty)r).getType(), it);
                return arrayList;
            }
            if (psiElement instanceof HCLProperty) {
                HCLExpression value = ((HCLProperty)r).getValue();
                if (value instanceof HCLArray) {
                    void $this$flatMapTo$iv$iv;
                    List<HCLExpression> list = ((HCLArray)value).getElements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
                    Iterable $this$flatMap$iv = CollectionsKt.reversed((Iterable)list);
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        HCLExpression it = (HCLExpression)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = SelectCompletionProvider.collectVariants$default(INSTANCE, it, false, depth, isEachValueProperty, null, 16, null);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                if (value instanceof HCLObject) {
                    if (depth > 0) {
                        return SelectCompletionProvider.collectVariants$default(this, value, iteratorResolve, depth, isEachValueProperty, null, 16, null);
                    }
                    return CollectionsKt.emptyList();
                }
                return this.collectVariantsSelectAware(value, iteratorResolve, depth, isEachValueProperty);
            }
            if (psiElement instanceof HCLObject) {
                void $this$mapTo$iv$iv;
                Object list$iv$iv;
                Iterable $this$flatMap$iv;
                void it;
                Collection collection;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                ArrayList arrayList;
                ArrayList value;
                ArrayList found = value = new ArrayList();
                boolean bl = false;
                if (isEachValueProperty) {
                    List<HCLProperty> list = ((HCLObject)r).getPropertyList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
                    properties = list;
                    Iterable $this$forEach$iv = properties;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$mapNotNullTo$iv$iv;
                        HCLProperty property = (HCLProperty)element$iv;
                        boolean bl2 = false;
                        var17_46 = property.getValue();
                        Object object = var17_46 instanceof HCLObject ? (HCLObject)var17_46 : null;
                        if (object == null || (object = object.getPropertyList()) == null) continue;
                        Iterable $this$mapNotNull$iv = (Iterable)object;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            LookupElementBuilder it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl3 = false;
                            HCLProperty it2 = (HCLProperty)element$iv$iv;
                            boolean bl4 = false;
                            if (LookupElementBuilder.create((String)it2.getName()) == null) continue;
                            boolean bl5 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List it3 = (List)destination$iv$iv2;
                        boolean bl6 = false;
                        found.addAll(it3);
                    }
                } else if (!iteratorResolve) {
                    void $this$mapTo$iv$iv2;
                    List<HCLProperty> list = ((HCLObject)r).getPropertyList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
                    properties = list;
                    arrayList = found;
                    boolean $i$f$map = false;
                    Iterable $i$f$forEach = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        var17_46 = (HCLProperty)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl7 = false;
                        collection.add(LookupElementBuilder.create((String)it.getName()));
                    }
                    arrayList.addAll((List)destination$iv$iv);
                } else if (depth > 0) {
                    void $this$flatMapTo$iv$iv;
                    List<HCLProperty> list = ((HCLObject)r).getPropertyList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
                    $this$map$iv = list;
                    arrayList = found;
                    boolean $i$f$flatMap = false;
                    Iterable $this$mapTo$iv$iv2 = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        HCLProperty hclProperty = (HCLProperty)element$iv$iv;
                        boolean bl8 = false;
                        list$iv$iv = SelectCompletionProvider.collectVariants$default(INSTANCE, hclProperty, false, depth - 1, false, null, 24, null);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    arrayList.addAll((List)destination$iv$iv);
                }
                List<HCLBlock> list = ((HCLObject)r).getBlockList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getBlockList(...)");
                $this$flatMap$iv = list;
                arrayList = found;
                boolean $i$f$map = false;
                Iterable $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    list$iv$iv = (HCLBlock)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl9 = false;
                    Intrinsics.checkNotNull((Object)it);
                    String string = UtilKt.getNameElementUnquoted((HCLBlock)it, 0);
                    Intrinsics.checkNotNull((Object)string);
                    collection.add(LookupElementBuilder.create((String)string));
                }
                arrayList.addAll((List)destination$iv$iv);
                return value;
            }
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement rParent = r.getParent();
            if (rParent instanceof HCLForIntro && !Intrinsics.areEqual((Object)((HCLForIntro)rParent).getContainer(), (Object)r)) {
                return SelectCompletionProvider.collectVariants$default(this, ((HCLForIntro)rParent).getContainer(), true, depth, isEachValueProperty, null, 16, null);
            }
            return this.collectVariantsSelectAware(r, iteratorResolve, depth, isEachValueProperty);
        }

        static /* synthetic */ List collectVariants$default(SelectCompletionProvider selectCompletionProvider, PsiElement psiElement, boolean bl, int n, boolean bl2, HilContainingBlockType hilContainingBlockType, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x10) != 0) {
                hilContainingBlockType = HilContainingBlockType.UNSPECIFIED;
            }
            return selectCompletionProvider.collectVariants(psiElement, bl, n, bl2, hilContainingBlockType);
        }

        /*
         * WARNING - void declaration
         */
        private final List<LookupElement> collectVariantsSelectAware(PsiElement value, boolean iteratorResolve, int depth, boolean isEachValueProperty) {
            void $this$flatMapTo$iv$iv;
            PsiReference[] $this$flatMap$iv = HCLPsiUtil.INSTANCE.getReferencesSelectAware(value);
            boolean $i$f$flatMap = false;
            PsiReference[] psiReferenceArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$flatMapTo$iv$iv2;
                void $this$flatMap$iv2;
                PsiElement it;
                void $this$filterTo$iv$iv;
                void element$iv$iv;
                void ref = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable $this$filter$iv = (Iterable)ILSelectFromSomethingReferenceProviderKt.resolve((PsiReference)ref, false, false);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (PsiElement)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)value))) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$flatMap2 = false;
                $this$filterTo$iv$iv = $this$flatMap$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    it = (PsiElement)element$iv$iv2;
                    boolean bl3 = false;
                    Iterable list$iv$iv = SelectCompletionProvider.collectVariants$default(INSTANCE, it, iteratorResolve, depth, isEachValueProperty, null, 16, null);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void getBlockProperties(HCLBlock r, HilContainingBlockType contextType, boolean isEachValueProp, ArrayList<LookupElement> found) {
            List<HCLProperty> pl;
            Collection collection;
            void $this$map$iv;
            if (TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)r)) {
                Variable variable = new Variable(r);
                HCLExpression defaultMap = variable.getDefault();
                if (defaultMap instanceof HCLObject && !isEachValueProp) {
                    this.handleHCLObject((HCLObject)defaultMap, found);
                }
                this.collectTypeVariants(variable.getType(), found);
                return;
            }
            if (TfPsiPatterns.INSTANCE.getModuleRootBlock().accepts((Object)r)) {
                Module module = Module.Companion.getAsModuleBlock(r);
                if (module != null) {
                    void $this$mapTo$iv$iv;
                    Collection collection2;
                    Iterable $this$map$iv2;
                    List suitableBlocks = switch (WhenMappings.$EnumSwitchMapping$0[contextType.ordinal()]) {
                        case 1 -> {
                            HCLBlock resourceDeclaration;
                            Iterable $this$mapTo$iv$iv;
                            $this$map$iv2 = Module.getDefinedResources$default(module, null, null, 3, null);
                            boolean $i$f$map = false;
                            Iterable var11_18 = $this$map$iv2;
                            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                HCLBlock var16_38 = (HCLBlock)item$iv$iv;
                                collection2 = destination$iv$iv;
                                boolean $i$a$-map-HILCompletionContributor$SelectCompletionProvider$getBlockProperties$suitableBlocks$1 = false;
                                collection2.add(HILImportBlockUtilsKt.getResourceTypeAndName(resourceDeclaration));
                            }
                            yield (List)destination$iv$iv;
                        }
                        case 2 -> {
                            HCLBlock resourceDeclaration;
                            $this$map$iv2 = module.getDefinedOutputs();
                            boolean $i$f$map = false;
                            Iterable $this$mapTo$iv$iv = $this$map$iv2;
                            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                resourceDeclaration = (HCLBlock)item$iv$iv;
                                collection2 = destination$iv$iv;
                                boolean $i$a$-map-HILCompletionContributor$SelectCompletionProvider$getBlockProperties$suitableBlocks$2 = false;
                                collection2.add(it.getName());
                            }
                            yield (List)destination$iv$iv;
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    Iterable $this$map$iv3 = suitableBlocks;
                    boolean $i$f$map = false;
                    $this$map$iv2 = $this$map$iv3;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(LookupElementBuilder.create((String)it));
                    }
                    CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)found);
                }
                return;
            }
            if (TfPsiPatterns.INSTANCE.getOutputRootBlock().accepts((Object)r)) {
                HCLExpression outputValue;
                HCLElement hCLElement = r.getObject();
                HCLExpression hCLExpression = hCLElement != null && (hCLElement = hCLElement.findProperty(TypeModel.Companion.getValueProperty().getName())) != null ? hCLElement.getValue() : (outputValue = null);
                if (outputValue instanceof HCLObject) {
                    this.handleHCLObject((HCLObject)outputValue, found);
                }
                this.collectTypeVariants(ExtensionsKt.getType(outputValue), found);
                return;
            }
            Map<String, PropertyOrBlockType> $this$filterKeys$iv = TfModelHelper.INSTANCE.getBlockProperties(r);
            boolean $i$f$filterKeys22 = false;
            LinkedHashMap<String, PropertyOrBlockType> result$iv = new LinkedHashMap<String, PropertyOrBlockType>();
            for (Map.Entry<String, PropertyOrBlockType> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)"__has_dynamic_attributes"))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map properties = result$iv;
            Set done = CollectionsKt.toSet((Iterable)properties.keySet());
            Iterable $i$f$filterKeys22 = properties.values();
            ArrayList<LookupElement> arrayList = found;
            boolean $i$f$map2 = false;
            Iterator<Map.Entry<String, PropertyOrBlockType>> $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl = $this$mapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object item$iv$iv = bl.next();
                PropertyOrBlockType it = (PropertyOrBlockType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(LookupElementBuilder.create((String)it.getName()).withRenderer((LookupElementRenderer)new TfLookupElementRenderer()));
            }
            arrayList.addAll((List)destination$iv$iv);
            HCLObject hCLObject = r.getObject();
            List<HCLProperty> list = pl = hCLObject != null ? hCLObject.getPropertyList() : null;
            if (pl != null) {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv4;
                Iterable $i$f$map2 = pl;
                arrayList = found;
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv4;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    HCLProperty bl2 = (HCLProperty)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(it.getName());
                }
                $this$map$iv4 = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv2 = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!done.contains(it))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                $i$f$map3 = false;
                $this$filterTo$iv$iv = $this$map$iv4;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    String it = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(LookupElementBuilder.create((String)it));
                }
                arrayList.addAll((List)destination$iv$iv2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleHCLObject(HCLObject objectProperty, ArrayList<LookupElement> found) {
            void $this$mapTo$iv;
            String it$iv;
            boolean bl;
            HCLElement it;
            boolean bl2;
            Object element$iv;
            Object element$iv$iv;
            Iterable $this$mapNotNullTo$iv;
            HashSet names = new HashSet();
            List<HCLProperty> list = objectProperty.getPropertyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
            Iterable iterable = list;
            Collection destination$iv = names;
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv.iterator();
            while (object.hasNext()) {
                element$iv = element$iv$iv = object.next();
                bl2 = false;
                it = (HCLProperty)element$iv;
                boolean bl3 = false;
                if (it.getName() == null) continue;
                bl = false;
                destination$iv.add(it$iv);
            }
            List<HCLBlock> list2 = objectProperty.getBlockList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getBlockList(...)");
            $this$mapNotNullTo$iv = list2;
            destination$iv = names;
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            object = $this$forEach$iv$iv.iterator();
            while (object.hasNext()) {
                element$iv = element$iv$iv = object.next();
                bl2 = false;
                it = (HCLBlock)element$iv;
                boolean bl4 = false;
                if (it.getName() == null) continue;
                bl = false;
                destination$iv.add(it$iv);
            }
            $this$mapNotNullTo$iv = names;
            destination$iv = found;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it2;
                object = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl5 = false;
                collection.add(LookupElementBuilder.create((String)it2));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void collectTypeVariants(Type type, ArrayList<LookupElement> found) {
            block5: {
                block6: {
                    void $this$mapTo$iv;
                    block4: {
                        void $this$mapTo$iv2;
                        if (!(type instanceof ObjectType)) break block4;
                        Map<String, Type> map = ((ObjectType)type).getElements();
                        if (map == null || (map = map.keySet()) == null) break block5;
                        Iterable iterable = (Iterable)((Object)map);
                        Collection destination$iv = found;
                        boolean $i$f$mapTo = false;
                        for (Object item$iv : $this$mapTo$iv2) {
                            void it;
                            String string = (String)item$iv;
                            Collection collection = destination$iv;
                            boolean bl = false;
                            collection.add(LookupElementBuilder.create((String)it));
                        }
                        ArrayList cfr_ignored_0 = (ArrayList)destination$iv;
                        break block5;
                    }
                    if (!(type instanceof TupleType)) break block6;
                    Object $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)((TupleType)type).getElements()));
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)SelectCompletionProvider$collectTypeVariants$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    $this$filterIsInstance$iv = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)sequence, SelectCompletionProvider::collectTypeVariants$lambda$33), SelectCompletionProvider::collectTypeVariants$lambda$34));
                    Collection destination$iv = found;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        String string = (String)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        collection.add(LookupElementBuilder.create((String)it));
                    }
                    break block5;
                }
                if (!(type instanceof ContainerType) || !(((ContainerType)type).getElements() instanceof ObjectType)) break block5;
                Map<String, Type> map = ((ObjectType)((ContainerType)type).getElements()).getElements();
                if (map != null && (map = map.keySet()) != null) {
                    void $this$mapTo$iv;
                    Iterable $i$f$mapTo = (Iterable)((Object)map);
                    Collection destination$iv = found;
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        String it = (String)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        collection.add(LookupElementBuilder.create((String)it));
                    }
                    ArrayList cfr_ignored_1 = (ArrayList)destination$iv;
                }
            }
        }

        private static final Iterable addCompletions$lambda$0(PsiReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            return (Iterable)ILSelectFromSomethingReferenceProviderKt.resolve(reference, true, false);
        }

        private static final Iterable addCompletions$lambda$1(boolean $isEachValueProperty, HilContainingBlockType $contextType, PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.collectVariants(it, false, 2, $isEachValueProperty, $contextType);
        }

        private static final Map collectTypeVariants$lambda$33(ObjectType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getElements();
        }

        private static final Iterable collectTypeVariants$lambda$34(Map it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.keySet();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HilContainingBlockType.values().length];
                try {
                    nArray[HilContainingBlockType.IMPORT_OR_MOVED_BLOCK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HilContainingBlockType.UNSPECIFIED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "", "scope", "", "<init>", "(Ljava/lang/String;)V", "getScope", "()Ljava/lang/String;", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    public static abstract class SelectFromScopeCompletionProvider {
        @NotNull
        private final String scope;

        public SelectFromScopeCompletionProvider(@NotNull String scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        public abstract void doAddCompletions(@NotNull Identifier var1, @NotNull CompletionParameters var2, @NotNull ProcessingContext var3, @NotNull CompletionResultSet var4);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelfCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelfCompletionProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n536#2:525\n521#2,6:526\n1563#3:532\n1634#3,3:533\n*S KotlinDebug\n*F\n+ 1 HILCompletionContributor.kt\norg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelfCompletionProvider\n*L\n137#1:525\n137#1:526,6\n141#1:532\n141#1:533,3\n*E\n"})
    private static final class SelfCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final SelfCompletionProvider INSTANCE = new SelfCompletionProvider();

        private SelfCompletionProvider() {
            super("self");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            HCLBlock hCLBlock = HCLPsiUtilKt.getHclBlockForSelfContext(variable);
            if (hCLBlock == null) {
                return;
            }
            HCLBlock resource = hCLBlock;
            Object $this$filter$iv = TfModelHelper.INSTANCE.getBlockProperties(resource);
            boolean $i$f$filter = false;
            Map<String, PropertyOrBlockType> map = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                it = element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getKey(), (Object)"__has_dynamic_attributes") && ((PropertyOrBlockType)it.getValue()).getComputed())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map properties = destination$iv$iv;
            $this$filter$iv = properties.keySet();
            CompletionResultSet completionResultSet = result;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)((Object)item$iv$iv);
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(LookupElementBuilder.create((String)it));
            }
            completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$TfCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    private static final class TfCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final TfCompletionProvider INSTANCE = new TfCompletionProvider();

        private TfCompletionProvider() {
            super("terraform");
        }

        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            result.addElement((LookupElement)LookupElementBuilder.create((String)"workspace"));
            if (HCLPsiUtilKt.getContainingResourceOrDataSource(ILExpressionBaseKt.getHCLHost(variable)) == null) {
                return;
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"env"));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$VariableCompletionProvider;", "Lorg/intellij/terraform/hil/codeinsight/HILCompletionContributor$SelectFromScopeCompletionProvider;", "<init>", "()V", "doAddCompletions", "", "variable", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    private static final class VariableCompletionProvider
    extends SelectFromScopeCompletionProvider {
        @NotNull
        public static final VariableCompletionProvider INSTANCE = new VariableCompletionProvider();

        private VariableCompletionProvider() {
            super("var");
        }

        @Override
        public void doAddCompletions(@NotNull Identifier variable, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            List<Variable> variables = HCLPsiUtilKt.getLocalDefinedVariables(variable);
            for (Variable v : variables) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)v.getName()));
            }
        }
    }
}

