/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.impl.HCLPsiImplUtils;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.HILLanguage;
import org.intellij.terraform.hil.HILLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/ILLanguageInjector;", "Lcom/intellij/psi/LanguageInjector;", "<init>", "()V", "getLanguagesToInject", "", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "places", "Lcom/intellij/psi/InjectedLanguagePlaces;", "Type", "Companion", "intellij.terraform"})
public final class ILLanguageInjector
implements LanguageInjector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces places) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)places, (String)"places");
        org.intellij.terraform.hil.ILLanguageInjector$Companion.getLanguagesToInject$default(Companion, host, places, null, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ(\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/intellij/terraform/hil/ILLanguageInjector$Companion;", "", "<init>", "()V", "getLanguagesToInject", "", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "places", "Lcom/intellij/psi/InjectedLanguagePlaces;", "type", "Lorg/intellij/terraform/hil/ILLanguageInjector$Type;", "getStringLiteralInjections", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "getHCLHeredocContentInjections", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "getILRangesInText", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/util/TextRange;", "Lkotlin/collections/ArrayList;", "text", "", "interpolationType", "getDeepestNonNegative", "", "stack", "Lit/unimi/dsi/fastutil/ints/IntList;", "findInterpolationStart", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nILLanguageInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ILLanguageInjector.kt\norg/intellij/terraform/hil/ILLanguageInjector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1761#2,3:162\n1761#2,3:165\n1761#2,3:168\n1761#2,3:171\n1761#2,3:174\n*S KotlinDebug\n*F\n+ 1 ILLanguageInjector.kt\norg/intellij/terraform/hil/ILLanguageInjector$Companion\n*L\n49#1:162,3\n53#1:165,3\n66#1:168,3\n70#1:171,3\n80#1:174,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces places, @NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)places, (String)"places");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (!(host instanceof HCLStringLiteral) && !(host instanceof HCLHeredocContent)) {
                return;
            }
            PsiFile file = ((PsiElement)host).getContainingFile();
            if (!(file instanceof HCLFile) || !((HCLFile)file).isInterpolationsAllowed()) {
                return;
            }
            if (TfPsiPatterns.INSTANCE.getTerraformVariablesFile().accepts((Object)file)) {
                return;
            }
            if (host instanceof HCLStringLiteral) {
                this.getStringLiteralInjections((HCLStringLiteral)host, places, type);
                return;
            }
            if (host instanceof HCLHeredocContent) {
                this.getHCLHeredocContentInjections((HCLHeredocContent)host, places, type);
                return;
            }
        }

        public static /* synthetic */ void getLanguagesToInject$default(Companion companion, PsiLanguageInjectionHost psiLanguageInjectionHost, InjectedLanguagePlaces injectedLanguagePlaces, Type type, int n, Object object) {
            if ((n & 4) != 0) {
                type = Type.ANY;
            }
            companion.getLanguagesToInject(psiLanguageInjectionHost, injectedLanguagePlaces, type);
        }

        public final void getStringLiteralInjections(@NotNull HCLStringLiteral host, @NotNull InjectedLanguagePlaces places, @NotNull Type type) {
            boolean bl;
            block10: {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)places, (String)"places");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                if (!host.textContains('{')) {
                    return;
                }
                String text = host.getText();
                Iterable $this$any$iv = type.getPrefixes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)text);
                        if (!StringsKt.contains$default((CharSequence)text, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return;
            }
            for (Pair<TextRange, String> pair : host.getTextFragments()) {
                Iterator<TextRange> iterator;
                boolean bl3;
                String fragment;
                block11: {
                    fragment = (String)pair.second;
                    Iterable $this$any$iv = type.getPrefixes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)fragment);
                            if (!StringsKt.startsWith$default((String)fragment, (String)it, (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                Intrinsics.checkNotNull((Object)fragment);
                ArrayList<TextRange> ranges = this.getILRangesInText(fragment, type);
                Intrinsics.checkNotNullExpressionValue(ranges.iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    TextRange rng;
                    TextRange range;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)range.shiftRight(((TextRange)pair.first).getStartOffset()), (String)"shiftRight(...)");
                    places.addPlace((Language)HILLanguage.INSTANCE, rng, null, null);
                }
            }
        }

        public static /* synthetic */ void getStringLiteralInjections$default(Companion companion, HCLStringLiteral hCLStringLiteral, InjectedLanguagePlaces injectedLanguagePlaces, Type type, int n, Object object) {
            if ((n & 4) != 0) {
                type = Type.ANY;
            }
            companion.getStringLiteralInjections(hCLStringLiteral, injectedLanguagePlaces, type);
        }

        public final void getHCLHeredocContentInjections(@NotNull HCLHeredocContent host, @NotNull InjectedLanguagePlaces places, @NotNull Type type) {
            boolean bl;
            block11: {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)places, (String)"places");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                if (host.getLinesCount() == 0) {
                    return;
                }
                List lines = HCLPsiImplUtils.getLinesInternal$default(HCLPsiImplUtils.INSTANCE, host, 0, false, 6, null);
                if (lines.isEmpty()) {
                    return;
                }
                Iterable $this$any$iv = type.getPrefixes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = host.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return;
            }
            for (Pair<TextRange, String> pair : host.getTextFragments()) {
                Iterator<TextRange> iterator;
                boolean bl3;
                String fragment;
                block12: {
                    fragment = (String)pair.second;
                    Iterable $this$any$iv = type.getPrefixes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)fragment);
                            if (!StringsKt.startsWith$default((String)fragment, (String)it, (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block12;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                Intrinsics.checkNotNull((Object)fragment);
                ArrayList<TextRange> ranges = this.getILRangesInText(fragment, type);
                Intrinsics.checkNotNullExpressionValue(ranges.iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    TextRange rng;
                    TextRange range;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)range.shiftRight(((TextRange)pair.first).getStartOffset()), (String)"shiftRight(...)");
                    places.addPlace((Language)HILLanguage.INSTANCE, rng, null, null);
                }
            }
        }

        public static /* synthetic */ void getHCLHeredocContentInjections$default(Companion companion, HCLHeredocContent hCLHeredocContent, InjectedLanguagePlaces injectedLanguagePlaces, Type type, int n, Object object) {
            if ((n & 4) != 0) {
                type = Type.ANY;
            }
            companion.getHCLHeredocContentInjections(hCLHeredocContent, injectedLanguagePlaces, type);
        }

        @NotNull
        public final ArrayList<TextRange> getILRangesInText(@NotNull String text, @NotNull Type interpolationType) {
            boolean bl;
            block18: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)((Object)interpolationType), (String)"interpolationType");
                Iterable $this$any$iv = interpolationType.getPrefixes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)text, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return new ArrayList<TextRange>();
            }
            int skip = this.findInterpolationStart(text, interpolationType);
            if (skip == -1) {
                return new ArrayList<TextRange>();
            }
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            block1: while (skip < text.length()) {
                HILLexer lexer = new HILLexer();
                lexer.start(text, skip, text.length());
                IntArrayList stack = new IntArrayList(4);
                while (true) {
                    IElementType iElementType;
                    if (Intrinsics.areEqual((Object)(iElementType = lexer.getTokenType()), (Object)HILElementTypes.INTERPOLATION_START) || Intrinsics.areEqual((Object)iElementType, (Object)HILElementTypes.TEMPLATE_START)) {
                        stack.push(lexer.getTokenStart());
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)HILElementTypes.L_CURLY)) {
                        stack.push(-1);
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)HILElementTypes.R_CURLY)) {
                        if (stack.isEmpty()) {
                            skip = lexer.getTokenStart() + 1;
                            continue block1;
                        }
                        start = stack.popInt();
                        if (start != -1 && this.getDeepestNonNegative((IntList)stack) == -1) {
                            ranges.add(new TextRange(start, lexer.getTokenEnd()));
                            skip = lexer.getTokenEnd();
                            continue block1;
                        }
                    } else {
                        if (iElementType == null) {
                            if (lexer.getTokenEnd() >= text.length()) {
                                start = this.getDeepestNonNegative((IntList)stack);
                                if (start == -1) break block1;
                                ranges.add(new TextRange(start, Math.min(lexer.getTokenEnd(), text.length())));
                                break block1;
                            }
                            skip = lexer.getTokenStart() + 1;
                            continue block1;
                        }
                        if (stack.isEmpty()) {
                            skip = lexer.getTokenStart() + 1;
                            continue block1;
                        }
                    }
                    lexer.advance();
                }
            }
            return ranges;
        }

        public static /* synthetic */ ArrayList getILRangesInText$default(Companion companion, String string, Type type, int n, Object object) {
            if ((n & 2) != 0) {
                type = Type.ANY;
            }
            return companion.getILRangesInText(string, type);
        }

        private final int getDeepestNonNegative(IntList stack) {
            int n = stack.size();
            for (int i = 0; i < n; ++i) {
                int element = stack.getInt(i);
                if (element < 0) continue;
                return element;
            }
            return -1;
        }

        private final int findInterpolationStart(String text, Type type) {
            int index = -1;
            while ((index = StringsKt.indexOfAny$default((CharSequence)text, (Collection)CollectionsKt.toList((Iterable)type.getPrefixes()), (int)(index + 1), (boolean)false, (int)4, null)) > 0 && text.charAt(index - 1) == text.charAt(index)) {
            }
            return index;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0012\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/ILLanguageInjector$Type;", "", "prefixes", "", "", "<init>", "(Ljava/lang/String;ILjava/util/Set;)V", "", "(Ljava/lang/String;I[Ljava/lang/String;)V", "getPrefixes", "()Ljava/util/Set;", "INTERPOLATION", "TEMPLATE", "ANY", "intellij.terraform"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final Set<String> prefixes;
        public static final /* enum */ Type INTERPOLATION;
        public static final /* enum */ Type TEMPLATE;
        public static final /* enum */ Type ANY;
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(Set<String> prefixes) {
            this.prefixes = prefixes;
        }

        @NotNull
        public final Set<String> getPrefixes() {
            return this.prefixes;
        }

        private Type(String ... prefixes) {
            this(ArraysKt.toSet((Object[])prefixes));
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            String[] stringArray = new String[]{"${"};
            INTERPOLATION = new Type(stringArray);
            stringArray = new String[]{"%{"};
            TEMPLATE = new Type(stringArray);
            stringArray = new String[]{"${", "%{"};
            ANY = new Type(stringArray);
            $VALUES = typeArray = new Type[]{Type.INTERPOLATION, Type.TEMPLATE, Type.ANY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

