/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.terraform.hil.HILElementType;
import org.intellij.terraform.hil.HILTokenType;
import org.intellij.terraform.hil.psi.impl.BadTagImpl;
import org.intellij.terraform.hil.psi.impl.ElseConditionImpl;
import org.intellij.terraform.hil.psi.impl.EndForImpl;
import org.intellij.terraform.hil.psi.impl.EndIfImpl;
import org.intellij.terraform.hil.psi.impl.ForConditionImpl;
import org.intellij.terraform.hil.psi.impl.ForVariableImpl;
import org.intellij.terraform.hil.psi.impl.ILArrayImpl;
import org.intellij.terraform.hil.psi.impl.ILBinaryAdditionExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILBinaryAndExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILBinaryEqualityExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILBinaryMultiplyExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILBinaryOrExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILBinaryRelationalExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILCollectionValueImpl;
import org.intellij.terraform.hil.psi.impl.ILConditionalExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILDefinedMethodExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILExpressionHolderImpl;
import org.intellij.terraform.hil.psi.impl.ILIndexSelectExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILLiteralExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILMethodCallExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILObjectImpl;
import org.intellij.terraform.hil.psi.impl.ILParameterListImpl;
import org.intellij.terraform.hil.psi.impl.ILParenthesizedExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILPropertyImpl;
import org.intellij.terraform.hil.psi.impl.ILSelectExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILTemplateBlockBodyImpl;
import org.intellij.terraform.hil.psi.impl.ILTemplateForBlockExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILTemplateHolderImpl;
import org.intellij.terraform.hil.psi.impl.ILTemplateIfBlockExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILUnaryExpressionImpl;
import org.intellij.terraform.hil.psi.impl.ILVariableImpl;
import org.intellij.terraform.hil.psi.impl.IfConditionImpl;

public interface HILElementTypes {
    public static final IElementType BAD_TAG = new HILElementType("BAD_TAG");
    public static final IElementType ELSE_CONDITION = new HILElementType("ELSE_CONDITION");
    public static final IElementType END_FOR = new HILElementType("END_FOR");
    public static final IElementType END_IF = new HILElementType("END_IF");
    public static final IElementType FOR_CONDITION = new HILElementType("FOR_CONDITION");
    public static final IElementType FOR_VARIABLE = new HILElementType("FOR_VARIABLE");
    public static final IElementType IF_CONDITION = new HILElementType("IF_CONDITION");
    public static final IElementType IL_ARRAY = new HILElementType("IL_ARRAY");
    public static final IElementType IL_BINARY_ADDITION_EXPRESSION = new HILElementType("IL_BINARY_ADDITION_EXPRESSION");
    public static final IElementType IL_BINARY_AND_EXPRESSION = new HILElementType("IL_BINARY_AND_EXPRESSION");
    public static final IElementType IL_BINARY_EQUALITY_EXPRESSION = new HILElementType("IL_BINARY_EQUALITY_EXPRESSION");
    public static final IElementType IL_BINARY_MULTIPLY_EXPRESSION = new HILElementType("IL_BINARY_MULTIPLY_EXPRESSION");
    public static final IElementType IL_BINARY_OR_EXPRESSION = new HILElementType("IL_BINARY_OR_EXPRESSION");
    public static final IElementType IL_BINARY_RELATIONAL_EXPRESSION = new HILElementType("IL_BINARY_RELATIONAL_EXPRESSION");
    public static final IElementType IL_COLLECTION_VALUE = new HILElementType("IL_COLLECTION_VALUE");
    public static final IElementType IL_CONDITIONAL_EXPRESSION = new HILElementType("IL_CONDITIONAL_EXPRESSION");
    public static final IElementType IL_DEFINED_METHOD_EXPRESSION = new HILElementType("IL_DEFINED_METHOD_EXPRESSION");
    public static final IElementType IL_EXPRESSION = new HILElementType("IL_EXPRESSION");
    public static final IElementType IL_EXPRESSION_HOLDER = new HILElementType("IL_EXPRESSION_HOLDER");
    public static final IElementType IL_INDEX_SELECT_EXPRESSION = new HILElementType("IL_INDEX_SELECT_EXPRESSION");
    public static final IElementType IL_LITERAL_EXPRESSION = new HILElementType("IL_LITERAL_EXPRESSION");
    public static final IElementType IL_METHOD_CALL_EXPRESSION = new HILElementType("IL_METHOD_CALL_EXPRESSION");
    public static final IElementType IL_OBJECT = new HILElementType("IL_OBJECT");
    public static final IElementType IL_PARAMETER_LIST = new HILElementType("IL_PARAMETER_LIST");
    public static final IElementType IL_PARENTHESIZED_EXPRESSION = new HILElementType("IL_PARENTHESIZED_EXPRESSION");
    public static final IElementType IL_PROPERTY = new HILElementType("IL_PROPERTY");
    public static final IElementType IL_SELECT_EXPRESSION = new HILElementType("IL_SELECT_EXPRESSION");
    public static final IElementType IL_SIMPLE_EXPRESSION = new HILElementType("IL_SIMPLE_EXPRESSION");
    public static final IElementType IL_TEMPLATE_BLOCK_BODY = new HILElementType("IL_TEMPLATE_BLOCK_BODY");
    public static final IElementType IL_TEMPLATE_FOR_BLOCK_EXPRESSION = new HILElementType("IL_TEMPLATE_FOR_BLOCK_EXPRESSION");
    public static final IElementType IL_TEMPLATE_HOLDER = new HILElementType("IL_TEMPLATE_HOLDER");
    public static final IElementType IL_TEMPLATE_IF_BLOCK_EXPRESSION = new HILElementType("IL_TEMPLATE_IF_BLOCK_EXPRESSION");
    public static final IElementType IL_UNARY_EXPRESSION = new HILElementType("IL_UNARY_EXPRESSION");
    public static final IElementType IL_VARIABLE = new HILElementType("IL_VARIABLE");
    public static final IElementType COLON_COLON = new HILTokenType("::");
    public static final IElementType COMMA = new HILTokenType(",");
    public static final IElementType DOLLAR = new HILTokenType("$");
    public static final IElementType DOUBLE_QUOTED_STRING = new HILTokenType("DOUBLE_QUOTED_STRING");
    public static final IElementType ELSE_KEYWORD = new HILTokenType("else");
    public static final IElementType ENDFOR_KEYWORD = new HILTokenType("endfor");
    public static final IElementType ENDIF_KEYWORD = new HILTokenType("endif");
    public static final IElementType EQUALS = new HILTokenType("=");
    public static final IElementType FALSE = new HILTokenType("false");
    public static final IElementType FOR_KEYWORD = new HILTokenType("for");
    public static final IElementType ID = new HILTokenType("ID");
    public static final IElementType IF_KEYWORD = new HILTokenType("if");
    public static final IElementType INTERPOLATION_START = new HILTokenType("${");
    public static final IElementType IN_KEYWORD = new HILTokenType("in");
    public static final IElementType L_BRACKET = new HILTokenType("[");
    public static final IElementType L_CURLY = new HILTokenType("{");
    public static final IElementType L_PAREN = new HILTokenType("(");
    public static final IElementType NULL = new HILTokenType("null");
    public static final IElementType NUMBER = new HILTokenType("NUMBER");
    public static final IElementType OP_AND_AND = new HILTokenType("&&");
    public static final IElementType OP_COLON = new HILTokenType(":");
    public static final IElementType OP_DIV = new HILTokenType("/");
    public static final IElementType OP_DOT = new HILTokenType(".");
    public static final IElementType OP_ELLIPSIS = new HILTokenType("...");
    public static final IElementType OP_EQUAL = new HILTokenType("==");
    public static final IElementType OP_GREATER = new HILTokenType(">");
    public static final IElementType OP_GREATER_OR_EQUAL = new HILTokenType(">=");
    public static final IElementType OP_LESS = new HILTokenType("<");
    public static final IElementType OP_LESS_OR_EQUAL = new HILTokenType("<=");
    public static final IElementType OP_MINUS = new HILTokenType("-");
    public static final IElementType OP_MOD = new HILTokenType("%");
    public static final IElementType OP_MUL = new HILTokenType("*");
    public static final IElementType OP_NOT = new HILTokenType("!");
    public static final IElementType OP_NOT_EQUAL = new HILTokenType("!=");
    public static final IElementType OP_OR_OR = new HILTokenType("||");
    public static final IElementType OP_PLUS = new HILTokenType("+");
    public static final IElementType OP_QUEST = new HILTokenType("?");
    public static final IElementType R_BRACKET = new HILTokenType("]");
    public static final IElementType R_CURLY = new HILTokenType("}");
    public static final IElementType R_PAREN = new HILTokenType(")");
    public static final IElementType TEMPLATE_START = new HILTokenType("TEMPLATE_START");
    public static final IElementType TILDA = new HILTokenType("~");
    public static final IElementType TRUE = new HILTokenType("true");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == BAD_TAG) {
                return new BadTagImpl(node);
            }
            if (type == ELSE_CONDITION) {
                return new ElseConditionImpl(node);
            }
            if (type == END_FOR) {
                return new EndForImpl(node);
            }
            if (type == END_IF) {
                return new EndIfImpl(node);
            }
            if (type == FOR_CONDITION) {
                return new ForConditionImpl(node);
            }
            if (type == FOR_VARIABLE) {
                return new ForVariableImpl(node);
            }
            if (type == IF_CONDITION) {
                return new IfConditionImpl(node);
            }
            if (type == IL_ARRAY) {
                return new ILArrayImpl(node);
            }
            if (type == IL_BINARY_ADDITION_EXPRESSION) {
                return new ILBinaryAdditionExpressionImpl(node);
            }
            if (type == IL_BINARY_AND_EXPRESSION) {
                return new ILBinaryAndExpressionImpl(node);
            }
            if (type == IL_BINARY_EQUALITY_EXPRESSION) {
                return new ILBinaryEqualityExpressionImpl(node);
            }
            if (type == IL_BINARY_MULTIPLY_EXPRESSION) {
                return new ILBinaryMultiplyExpressionImpl(node);
            }
            if (type == IL_BINARY_OR_EXPRESSION) {
                return new ILBinaryOrExpressionImpl(node);
            }
            if (type == IL_BINARY_RELATIONAL_EXPRESSION) {
                return new ILBinaryRelationalExpressionImpl(node);
            }
            if (type == IL_COLLECTION_VALUE) {
                return new ILCollectionValueImpl(node);
            }
            if (type == IL_CONDITIONAL_EXPRESSION) {
                return new ILConditionalExpressionImpl(node);
            }
            if (type == IL_DEFINED_METHOD_EXPRESSION) {
                return new ILDefinedMethodExpressionImpl(node);
            }
            if (type == IL_EXPRESSION_HOLDER) {
                return new ILExpressionHolderImpl(node);
            }
            if (type == IL_INDEX_SELECT_EXPRESSION) {
                return new ILIndexSelectExpressionImpl(node);
            }
            if (type == IL_LITERAL_EXPRESSION) {
                return new ILLiteralExpressionImpl(node);
            }
            if (type == IL_METHOD_CALL_EXPRESSION) {
                return new ILMethodCallExpressionImpl(node);
            }
            if (type == IL_OBJECT) {
                return new ILObjectImpl(node);
            }
            if (type == IL_PARAMETER_LIST) {
                return new ILParameterListImpl(node);
            }
            if (type == IL_PARENTHESIZED_EXPRESSION) {
                return new ILParenthesizedExpressionImpl(node);
            }
            if (type == IL_PROPERTY) {
                return new ILPropertyImpl(node);
            }
            if (type == IL_SELECT_EXPRESSION) {
                return new ILSelectExpressionImpl(node);
            }
            if (type == IL_TEMPLATE_BLOCK_BODY) {
                return new ILTemplateBlockBodyImpl(node);
            }
            if (type == IL_TEMPLATE_FOR_BLOCK_EXPRESSION) {
                return new ILTemplateForBlockExpressionImpl(node);
            }
            if (type == IL_TEMPLATE_HOLDER) {
                return new ILTemplateHolderImpl(node);
            }
            if (type == IL_TEMPLATE_IF_BLOCK_EXPRESSION) {
                return new ILTemplateIfBlockExpressionImpl(node);
            }
            if (type == IL_UNARY_EXPRESSION) {
                return new ILUnaryExpressionImpl(node);
            }
            if (type == IL_VARIABLE) {
                return new ILVariableImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

