/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class JavaUtil {
    private static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("HCL string fragments");
    public static final String ourEscapesTable = "\"\"\\\\b\bf\fn\nr\rt\tv\u000ba\u0007";
    public static final String ourEscapedSymbols = "\"\\\b\f\n\r\t\u000b\u0007";

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull HCLStringLiteral literal) {
        List<Pair<TextRange, String>> result;
        if (literal == null) {
            JavaUtil.$$$reportNull$$$0(0);
        }
        if ((result = (List<Pair<TextRange, String>>)literal.getFirstChild().getUserData(STRING_FRAGMENTS)) != null) {
            List<Pair<TextRange, String>> list = result;
            if (list == null) {
                JavaUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        result = JavaUtil.doGetTextFragments(literal.getText(), UtilKt.isInHCLFileWithInterpolations(literal), true);
        literal.getFirstChild().putUserData(STRING_FRAGMENTS, result);
        List<Pair<TextRange, String>> list = result;
        if (list == null) {
            JavaUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull HCLHeredocContent content) {
        if (content == null) {
            JavaUtil.$$$reportNull$$$0(3);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)content, () -> {
            List<Pair<TextRange, String>> result = JavaUtil.doGetTextFragments(content.getText(), UtilKt.isInHCLFileWithInterpolations(content), false);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{content});
        });
        if (list == null) {
            JavaUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public static List<Pair<TextRange, String>> doGetTextFragments(@NotNull String text, boolean interpolations, boolean quotes) {
        int contentEnd;
        int pos;
        if (text == null) {
            JavaUtil.$$$reportNull$$$0(5);
        }
        SmartList result = new SmartList();
        int length = text.length();
        int unescapedSequenceStart = pos = quotes ? 1 : 0;
        int braces = 0;
        while (pos < length) {
            char c = text.charAt(pos);
            if (!(!interpolations || c != '$' && c != '%' || pos + 1 >= length || text.charAt(pos + 1) != '{' || pos != 0 && text.charAt(pos - 1) == c)) {
                if (unescapedSequenceStart != pos) {
                    result.add(Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                }
                unescapedSequenceStart = pos;
                pos += 2;
                ++braces;
                boolean inString = false;
                while (pos < length && braces > 0) {
                    char c2 = text.charAt(pos);
                    if (!inString && c2 == '{') {
                        ++braces;
                    } else if (!inString && c2 == '}') {
                        --braces;
                    } else if (c2 == '\"' && (pos == 0 || text.charAt(pos - 1) != '\\')) {
                        inString = !inString;
                    }
                    ++pos;
                }
                result.add(Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                unescapedSequenceStart = pos;
                continue;
            }
            if (c == '\\') {
                if (unescapedSequenceStart != pos) {
                    result.add(Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                }
                if (pos == length - 1) {
                    result.add(Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                    break;
                }
                char next = text.charAt(pos + 1);
                switch (next) {
                    case '\"': 
                    case '\\': 
                    case 'a': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        int idx = ourEscapesTable.indexOf(next);
                        result.add(Pair.create((Object)new TextRange(pos, pos + 2), (Object)ourEscapesTable.substring(idx + 1, idx + 2)));
                        pos += 2;
                        break;
                    }
                    case 'u': {
                        int i;
                        for (i = pos + 2; i < pos + 6 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                        }
                        result.add(Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                        pos = i;
                        break;
                    }
                    case 'U': {
                        int i;
                        for (i = pos + 2; i < pos + 10 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                        }
                        result.add(Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                        pos = i;
                        break;
                    }
                    case 'X': {
                        int i;
                        for (i = pos + 2; i < pos + 4 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                        }
                        result.add(Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                        pos = i;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int i;
                        for (i = pos + 1; i < pos + 4 && i != length && StringUtil.isOctalDigit((char)text.charAt(i)); ++i) {
                        }
                        result.add(Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                        pos = i;
                        break;
                    }
                    default: {
                        result.add(Pair.create((Object)new TextRange(pos, pos + 2), (Object)text.substring(pos, pos + 2)));
                        pos += 2;
                    }
                }
                unescapedSequenceStart = pos;
                continue;
            }
            ++pos;
        }
        int n = contentEnd = quotes && text.charAt(0) == text.charAt(length - 1) ? length - 1 : length;
        if (unescapedSequenceStart < contentEnd) {
            result.add(Pair.create((Object)new TextRange(unescapedSequenceStart, contentEnd), (Object)text.substring(unescapedSequenceStart, contentEnd)));
        }
        List<Pair<TextRange, String>> list = Collections.unmodifiableList(result);
        if (list == null) {
            JavaUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/terraform/hcl/psi/impl/JavaUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/terraform/hcl/psi/impl/JavaUtil";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFragments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetTextFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextFragments";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetTextFragments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

