/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.impl.HCLStringLiteralMixin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\u001c\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLStringLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lorg/intellij/terraform/hcl/psi/impl/HCLStringLiteralMixin;", "host", "interpolations", "", "<init>", "(Lorg/intellij/terraform/hcl/psi/impl/HCLStringLiteralMixin;Z)V", "getInterpolations", "()Z", "outSourceOffsets", "", "isOneLine", "decode", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "Companion", "intellij.terraform"})
public final class HCLStringLiteralTextEscaper
extends LiteralTextEscaper<HCLStringLiteralMixin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean interpolations;
    @Nullable
    private int[] outSourceOffsets;

    public HCLStringLiteralTextEscaper(@NotNull HCLStringLiteralMixin host, boolean interpolations) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super((PsiLanguageInjectionHost)host);
        this.interpolations = interpolations;
    }

    public /* synthetic */ HCLStringLiteralTextEscaper(HCLStringLiteralMixin hCLStringLiteralMixin, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = UtilKt.isInHCLFileWithInterpolations(hCLStringLiteralMixin);
        }
        this(hCLStringLiteralMixin, bl);
    }

    public final boolean getInterpolations() {
        return this.interpolations;
    }

    public boolean isOneLine() {
        return false;
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        String string = rangeInsideHost.substring(((HCLStringLiteralMixin)this.myHost).getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String subText = string;
        int[] array = new int[subText.length() + 1];
        boolean success = Companion.parseStringCharacters(subText, outChars, array, this.interpolations);
        this.outSourceOffsets = array;
        return success;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        if (this.outSourceOffsets == null) {
            throw new IllegalStateException("#decode was not called");
        }
        int[] offsets = this.outSourceOffsets;
        int n = result = offsetInDecoded < offsets.length ? offsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return RangesKt.coerceAtMost((int)result, (int)rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        if (((HCLStringLiteralMixin)this.myHost).getTextLength() <= 1) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }
        TextRange textRange = TextRange.create((int)1, (int)(((HCLStringLiteralMixin)this.myHost).getTextLength() - 1));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLStringLiteralTextEscaper$Companion;", "", "<init>", "()V", "parseStringCharacters", "", "chars", "", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sourceOffsets", "", "interpolations", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets, boolean interpolations) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
            boolean bl2 = bl = sourceOffsets == null || sourceOffsets.length == chars.length() + 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (StringsKt.indexOf$default((CharSequence)chars, (char)'\\', (int)0, (boolean)false, (int)6, null) < 0) {
                outChars.append(chars);
                if (sourceOffsets != null) {
                    int n = sourceOffsets.length;
                    for (int i = 0; i < n; ++i) {
                        sourceOffsets[i] = i;
                    }
                }
                return true;
            }
            int index = 0;
            int outOffset = outChars.length();
            int braces = 0;
            while (index < chars.length()) {
                char c;
                char c2 = chars.charAt(index++);
                if (sourceOffsets != null) {
                    sourceOffsets[outChars.length() - outOffset] = index - 1;
                    sourceOffsets[outChars.length() + 1 - outOffset] = index;
                }
                if (interpolations && braces == 0 && c2 == '$' && index < chars.length() && chars.charAt(index) == '{') {
                    outChars.append(c2);
                    c2 = chars.charAt(index++);
                    if (sourceOffsets != null) {
                        sourceOffsets[outChars.length() - outOffset] = index - 1;
                        sourceOffsets[outChars.length() + 1 - outOffset] = index;
                    }
                    outChars.append(c2);
                    ++braces;
                    continue;
                }
                if (braces > 0) {
                    switch (c2) {
                        case '{': {
                            ++braces;
                            break;
                        }
                        case '}': {
                            --braces;
                        }
                    }
                    outChars.append(c2);
                    continue;
                }
                if (c2 != '\\') {
                    outChars.append(c2);
                    continue;
                }
                if (index == chars.length()) {
                    return false;
                }
                if ((c = (c2 = chars.charAt(index++))) == 'a') {
                    v1 = outChars.append('\u0007');
                } else if (c == 'b') {
                    v1 = outChars.append('\b');
                } else if (c == 'f') {
                    v1 = outChars.append('\f');
                } else if (c == 'n') {
                    v1 = outChars.append('\n');
                } else if (c == 't') {
                    v1 = outChars.append('\t');
                } else if (c == 'r') {
                    v1 = outChars.append('\r');
                } else if (c == 'v') {
                    v1 = outChars.append('\u000b');
                } else if (c == '\\') {
                    v1 = outChars.append('\\');
                } else if (c == '\"') {
                    v1 = outChars.append('\"');
                } else {
                    boolean bl3 = '0' <= c ? c < '8' : false;
                    if (bl3) {
                        char startC = c2;
                        int v = c2 - 48;
                        if (index < chars.length()) {
                            boolean bl4 = '0' <= (c2 = chars.charAt(index++)) ? c2 < '8' : false;
                            if (bl4) {
                                v <<= 3;
                                v += c2 - 48;
                                if (Intrinsics.compare((int)startC, (int)51) <= 0 && index < chars.length()) {
                                    boolean bl5 = '0' <= (c2 = chars.charAt(index++)) ? c2 < '8' : false;
                                    if (bl5) {
                                        v <<= 3;
                                        v += c2 - 48;
                                    } else {
                                        --index;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        v1 = outChars.append((char)v);
                    } else if (c == 'X') {
                        if (index + 2 <= chars.length()) {
                            try {
                                String string = chars.substring(index, index + 2);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                int code = Integer.parseInt(string, 16);
                                switch (code) {
                                    case 10: 
                                    case 13: {
                                        return false;
                                    }
                                }
                                c2 = chars.charAt(index);
                                switch (c2) {
                                    case '+': 
                                    case '-': {
                                        return false;
                                    }
                                }
                                outChars.append((char)code);
                                index += 2;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        v1 = Unit.INSTANCE;
                    } else if (c == 'u') {
                        if (index + 4 <= chars.length()) {
                            try {
                                String string = chars.substring(index, index + 4);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                int code = Integer.parseInt(string, 16);
                                switch (code) {
                                    case 10: 
                                    case 13: {
                                        return false;
                                    }
                                }
                                c2 = chars.charAt(index);
                                switch (c2) {
                                    case '+': 
                                    case '-': {
                                        return false;
                                    }
                                }
                                outChars.append((char)code);
                                index += 4;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        v1 = Unit.INSTANCE;
                    } else if (c == 'U') {
                        if (index + 8 <= chars.length()) {
                            try {
                                String string = chars.substring(index, index + 8);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                long code = Long.parseLong(string, 16);
                                if (code == 10L || code == 13L) {
                                    return false;
                                }
                                c2 = chars.charAt(index);
                                switch (c2) {
                                    case '+': 
                                    case '-': {
                                        return false;
                                    }
                                }
                                outChars.append((char)code);
                                index += 8;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        v1 = Unit.INSTANCE;
                    } else {
                        return false;
                    }
                }
                if (sourceOffsets == null) continue;
                sourceOffsets[outChars.length() - outOffset] = index;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

