/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hil.ILLanguageInjector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bJ \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002J4\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00052\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLQuoter;", "", "<init>", "()V", "unquote", "", "text", "supportInterpolations", "", "safe", "escape", "unescapeStringCharacters", "s", "escapeStringCharacters", "escapeInterpolation", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "OCTAL_REGEX", "Lkotlin/text/Regex;", "length", "", "intellij.terraform"})
public final class HCLQuoter {
    @NotNull
    public static final HCLQuoter INSTANCE = new HCLQuoter();
    @NotNull
    private static final Regex OCTAL_REGEX = new Regex("[0-7]{3}");

    private HCLQuoter() {
    }

    @NotNull
    public final String unquote(@NotNull String text, boolean supportInterpolations, boolean safe) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String stripQuotes = HCLPsiUtil.stripQuotes(text);
        return this.unescapeStringCharacters(stripQuotes, supportInterpolations, safe);
    }

    public static /* synthetic */ String unquote$default(HCLQuoter hCLQuoter, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return hCLQuoter.unquote(string, bl, bl2);
    }

    @NotNull
    public final String escape(@NotNull String text, boolean supportInterpolations) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.escapeStringCharacters(text, supportInterpolations);
    }

    public static /* synthetic */ String escape$default(HCLQuoter hCLQuoter, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return hCLQuoter.escape(string, bl);
    }

    private final String unescapeStringCharacters(String s, boolean supportInterpolations, boolean safe) {
        StringBuilder buffer = new StringBuilder(s.length());
        this.unescapeStringCharacters(s.length(), s, buffer, supportInterpolations, safe);
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String escapeStringCharacters(String s, boolean supportInterpolations) {
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        if (supportInterpolations && (StringsKt.contains$default((CharSequence)s, (CharSequence)"${", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%{", (boolean)false, (int)2, null))) {
            ArrayList ranges = ILLanguageInjector.Companion.getILRangesInText$default(ILLanguageInjector.Companion, s, null, 2, null);
            int last = 0;
            Iterator iterator = ranges.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                TextRange range = (TextRange)e;
                if (last < range.getStartOffset()) {
                    String sub;
                    Intrinsics.checkNotNullExpressionValue((Object)s.substring(last, range.getStartOffset()), (String)"substring(...)");
                    StringUtil.escapeStringCharacters((int)sub.length(), (String)sub, (String)"\"\\\b\f\n\r\t\u000b\u0007", (boolean)true, (StringBuilder)buffer);
                }
                String string = range.substring(s);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.escapeInterpolation(string, buffer);
                last = range.getEndOffset();
            }
            if (last < length) {
                String string = s.substring(last, length);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String sub = string;
                StringUtil.escapeStringCharacters((int)sub.length(), (String)sub, (String)"\"\\\b\f\n\r\t\u000b\u0007", (boolean)true, (StringBuilder)buffer);
            }
        } else {
            StringBuilder stringBuilder = StringUtil.escapeStringCharacters((int)length, (String)s, (String)"\"\\\b\f\n\r\t\u000b\u0007", (boolean)true, (StringBuilder)buffer);
            Intrinsics.checkNotNull((Object)stringBuilder);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void escapeInterpolation(String s, StringBuilder buffer) {
        if (!StringsKt.contains$default((CharSequence)s, (char)'\\', (boolean)false, (int)2, null)) {
            buffer.append(s);
            return;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void unescapeStringCharacters(int length, String s, StringBuilder buffer, boolean supportInterpolations, boolean safe) {
        boolean escaped = false;
        int idx = 0;
        while (idx < length) {
            char ch = s.charAt(idx);
            if (!(escaped || !supportInterpolations || ch != '$' && ch != '%' || idx + 1 >= length || s.charAt(idx + 1) != '{' || idx != 0 && s.charAt(idx - 1) == ch)) {
                idx += 2;
                buffer.append(ch).append('{');
                int braces = 1;
                while (idx < length && braces > 0) {
                    char ch2 = s.charAt(idx);
                    switch (ch2) {
                        case '\\': {
                            if (idx + 1 >= length || s.charAt(idx + 1) != '\\') break;
                            ++idx;
                            break;
                        }
                        case '{': {
                            ++braces;
                            break;
                        }
                        case '}': {
                            --braces;
                        }
                    }
                    buffer.append(ch2);
                    ++idx;
                }
                continue;
            }
            if (ch == '\n') {
                if (!safe) throw new Exception("Illegal character: \\n");
                buffer.append(ch);
            }
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                } else {
                    buffer.append(ch);
                }
            } else {
                char c = ch;
                if (c == 'a') {
                    v0 = buffer.append('\u0007');
                } else if (c == 'b') {
                    v0 = buffer.append('\b');
                } else if (c == 'f') {
                    v0 = buffer.append('\f');
                } else if (c == 'n') {
                    v0 = buffer.append('\n');
                } else if (c == 't') {
                    v0 = buffer.append('\t');
                } else if (c == 'r') {
                    v0 = buffer.append('\r');
                } else if (c == 'v') {
                    v0 = buffer.append('\u000b');
                } else if (c == '\\') {
                    v0 = buffer.append('\\');
                } else if (c == '\"') {
                    v0 = buffer.append('\"');
                } else if (c == 'u') {
                    if (idx + 4 < length) {
                        int code = 0;
                        try {
                            String string = s.substring(idx + 1, idx + 5);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            code = Integer.parseInt(string, 16);
                            idx += 4;
                            var11_17 = buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            if (!safe) {
                                throw e;
                            }
                            var11_17 = buffer.append('\\').append(ch);
                        }
                        v0 = var11_17;
                    } else {
                        if (!safe) throw new Exception("Illegal character: unfinished \\u");
                        v0 = buffer.append('\\').append(ch);
                    }
                } else if (c == 'U') {
                    if (idx + 8 < length) {
                        StringBuilder code22;
                        try {
                            String string = s.substring(idx + 1, idx + 9);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            long code22 = Long.parseLong(string, 16);
                            idx += 8;
                            code22 = buffer.append((char)code22);
                        }
                        catch (NumberFormatException e) {
                            if (!safe) {
                                throw e;
                            }
                            code22 = buffer.append('\\').append(ch);
                        }
                        v0 = code22;
                    } else {
                        if (!safe) throw new Exception("Illegal character: unfinished \\U");
                        v0 = buffer.append('\\').append(ch);
                    }
                } else if (c == 'X') {
                    if (idx + 2 < length) {
                        StringBuilder code32;
                        try {
                            String string = s.substring(idx + 1, idx + 3);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            int code32 = Integer.parseInt(string, 16);
                            idx += 2;
                            code32 = buffer.append((char)code32);
                        }
                        catch (NumberFormatException e) {
                            if (!safe) {
                                throw e;
                            }
                            code32 = buffer.append('\\').append(ch);
                        }
                        v0 = code32;
                    } else {
                        if (!safe) throw new Exception("Illegal character: unfinished \\U");
                        v0 = buffer.append('\\').append(ch);
                    }
                } else {
                    boolean bl = '0' <= c ? c < '8' : false;
                    if (bl) {
                        if (idx + 2 < length) {
                            String sub;
                            Intrinsics.checkNotNullExpressionValue((Object)s.substring(idx, idx + 3), (String)"substring(...)");
                            CharSequence e = sub;
                            if (OCTAL_REGEX.matches(e)) {
                                try {
                                    int code = Integer.parseInt(sub, 8);
                                    idx += 2;
                                    var11_17 = buffer.append((char)code);
                                }
                                catch (NumberFormatException e2) {
                                    if (!safe) {
                                        throw e2;
                                    }
                                    var11_17 = buffer.append('\\').append(ch);
                                }
                                v0 = var11_17;
                            } else {
                                if (!safe) throw new Exception("Illegal character: incorrect octal: " + sub);
                                v0 = buffer.append('\\').append(ch);
                            }
                        } else {
                            if (!safe) throw new Exception("Illegal character: unfinished octal");
                            v0 = buffer.append('\\').append(ch);
                        }
                    } else {
                        if (!safe) throw new Exception("Illegal character: " + ch);
                        v0 = buffer.append('\\').append(ch);
                    }
                }
                escaped = false;
            }
            ++idx;
        }
        if (!escaped) return;
        if (!safe) throw new Exception("Illegal character: unfinished escaping");
        buffer.append('\\');
    }
}

