/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLPropertyNameReference;", "Lcom/intellij/psi/PsiReference;", "myProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLProperty;)V", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "resolve", "getCanonicalText", "", "handleElementRename", "newElementName", "bindToElement", "element", "isReferenceTo", "", "getVariants", "", "", "()[Ljava/lang/Object;", "isSoft", "intellij.terraform"})
public final class HCLPropertyNameReference
implements PsiReference {
    @NotNull
    private final HCLProperty myProperty;

    public HCLPropertyNameReference(@NotNull HCLProperty myProperty) {
        Intrinsics.checkNotNullParameter((Object)myProperty, (String)"myProperty");
        this.myProperty = myProperty;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myProperty;
    }

    @NotNull
    public TextRange getRangeInElement() {
        HCLExpression hCLExpression = this.myProperty.getNameElement();
        Intrinsics.checkNotNullExpressionValue((Object)hCLExpression, (String)"getNameElement(...)");
        HCLExpression nameElement = hCLExpression;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)nameElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return textRange;
    }

    @NotNull
    public PsiElement resolve() {
        return this.myProperty;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myProperty.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.myProperty.setName(newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"setName(...)");
        return psiElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof HCLProperty)) {
            return false;
        }
        PsiElement selfResolve = this.resolve();
        return Intrinsics.areEqual((Object)((HCLProperty)element).getName(), (Object)this.getCanonicalText()) && !Intrinsics.areEqual((Object)selfResolve, (Object)element);
    }

    @NotNull
    public Object[] getVariants() {
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }
}

