/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.SearchScope;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.hcl.psi.HCLElementGenerator;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.impl.HCLValueWithReferencesMixin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLIdentifierMixin;", "Lorg/intellij/terraform/hcl/psi/impl/HCLValueWithReferencesMixin;", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "setName", "Lcom/intellij/psi/PsiElement;", "s", "", "getName", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "Companion", "intellij.terraform"})
public abstract class HCLIdentifierMixin
extends HCLValueWithReferencesMixin
implements HCLIdentifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Pattern IDENTIFIER_PATTERN;

    public HCLIdentifierMixin(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Nullable
    public PsiElement setName(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (IDENTIFIER_PATTERN.matcher(s).matches()) {
            ASTNode aSTNode = this.getNode().getFirstChildNode();
            Intrinsics.checkNotNull((Object)aSTNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafElement");
            ((LeafElement)aSTNode).replaceWithText(s);
            return this;
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HCLElementGenerator.createStringLiteral$default(new HCLElementGenerator(project), s, null, 2, null);
    }

    @Nullable
    public String getName() {
        return this.getId();
    }

    @NotNull
    public SearchScope getUseScope() {
        return (SearchScope)ExtensionsKt.getTerraformSearchScope(this);
    }

    static {
        Pattern pattern = Pattern.compile("[a-zA-Z\\.\\-_][0-9a-zA-Z\\.\\-_]*");
        Intrinsics.checkNotNull((Object)pattern);
        IDENTIFIER_PATTERN = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLIdentifierMixin$Companion;", "", "<init>", "()V", "IDENTIFIER_PATTERN", "Ljava/util/regex/Pattern;", "getIDENTIFIER_PATTERN", "()Ljava/util/regex/Pattern;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getIDENTIFIER_PATTERN() {
            return IDENTIFIER_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

