/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/ElementChangeUtil;", "", "<init>", "()V", "doNameReplacement", "", "elementDecl", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "identifier", "Lcom/intellij/psi/PsiElement;", "name", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "doNameReplacement$intellij_terraform", "isInProjectContent", "", "project", "Lcom/intellij/openapi/project/Project;", "vfile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.terraform"})
public final class ElementChangeUtil {
    @NotNull
    public static final ElementChangeUtil INSTANCE = new ElementChangeUtil();

    private ElementChangeUtil() {
    }

    public final void doNameReplacement$intellij_terraform(@NotNull PsiNameIdentifierOwner elementDecl, @NotNull PsiElement identifier, @NotNull String name, @NotNull IElementType elementType) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)elementDecl, (String)"elementDecl");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        if (!elementDecl.isWritable()) {
            throw new IncorrectOperationException("Cannot rename " + elementDecl.getClass().getName() + ": element non-writable");
        }
        Project project = elementDecl.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!this.isInProjectContent(project, elementDecl.getContainingFile().getVirtualFile())) {
            throw new IncorrectOperationException("Cannot rename " + elementDecl.getClass().getName() + ": element not in project content");
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)identifier);
        if (manipulator != null) {
            manipulator.handleContentChange(identifier, name);
            return;
        }
        PsiElement replacement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)((ASTNode)Factory.createSingleLeafElement((IElementType)elementType, (CharSequence)name, null, (PsiManager)elementDecl.getManager())));
        if (replacement != null) {
            identifier.replace(replacement);
        }
    }

    private final boolean isInProjectContent(Project project, VirtualFile vfile) {
        return vfile == null || ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(vfile) != null;
    }
}

